use Evo::Base -strict;
use Test::More tests => 3;
use Evo;

my $m = Evo::Manager->new;
$m->{name} = "Foo";

my @passed;
$m->asap(
  sub {
    push @passed, 1;
    $m->asap(sub { push @passed, 3 }, sub { push @passed, 4 });
  },
  sub { push @passed, 2 }
);

$m->asap(
  sub {

    # new, so blocking
    Evo::Manager->new->asap(sub { push @passed, 5 });
    push @passed, 6;
  }
);
is_deeply \@passed, [1, 2, 3, 4, 5, 6], 'right order';


my $res;
$m->asap(
  sub {
    $m->asap(
      sub {
        $m->dsl_call(
          {foo => 'bar'},
          sub {
            $m->asap(sub { $res = 'ok' });
          }
        );
      }
    );
  }
);
ok $res;

my @states = ();
my $stash = {state => 'nb'};
Evo::asap {
  push @states, $stash->{state};
  local $stash->{state} = 'blocking?';
  Evo::asap { push @states, $stash->{state}; };
};
is_deeply \@states, ['nb', 'nb'];

done_testing;
