/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is included that follows the "include" declaration
** in the input grammar file. */
#include <stdio.h>
#line 53 "parse.y"

#include "sqliteInt.h"

/*
** An instance of this structure holds information about the
** LIMIT clause of a SELECT statement.
*/
struct LimitVal {
  Expr *pLimit;    /* The LIMIT expression.  NULL if there is no limit */
  Expr *pOffset;   /* The OFFSET expression.  NULL if there is none */
};

/*
** An instance of this structure is used to store the LIKE,
** GLOB, NOT LIKE, and NOT GLOB operators.
*/
struct LikeOp {
  Token eOperator;  /* "like" or "glob" or "regexp" */
  int not;         /* True if the NOT keyword is present */
};

/*
** An instance of the following structure describes the event of a
** TRIGGER.  "a" is the event type, one of TK_UPDATE, TK_INSERT,
** TK_DELETE, or TK_INSTEAD.  If the event is of the form
**
**      UPDATE ON (a,b,c)
**
** Then the "b" IdList records the list "a,b,c".
*/
struct TrigEvent { int a; IdList * b; };

/*
** An instance of this structure holds the ATTACH key and the key type.
*/
struct AttachKey { int type;  Token key; };

#line 46 "parse.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite3ParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite3ParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    sqlite3ParserARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite3ParserARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite3ParserARG_STORE     Code to store %extra_argument into yypParser
**    sqlite3ParserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 251
#define YYACTIONTYPE unsigned short int
#define YYWILDCARD 64
#define sqlite3ParserTOKENTYPE Token
typedef union {
  int yyinit;
  sqlite3ParserTOKENTYPE yy0;
  struct LimitVal yy64;
  Expr* yy122;
  Select* yy159;
  IdList* yy180;
  struct {int value; int mask;} yy207;
  struct LikeOp yy318;
  TriggerStep* yy327;
  SrcList* yy347;
  int yy392;
  struct TrigEvent yy410;
  ExprList* yy442;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define sqlite3ParserARG_SDECL Parse *pParse;
#define sqlite3ParserARG_PDECL ,Parse *pParse
#define sqlite3ParserARG_FETCH Parse *pParse = yypParser->pParse
#define sqlite3ParserARG_STORE yypParser->pParse = pParse
#define YYNSTATE 610
#define YYNRULE 319
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* The yyzerominor constant is used to initialize instances of
** YYMINORTYPE objects to zero. */
static const YYMINORTYPE yyzerominor = { 0 };


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   304,   74,  581,   83,  164,  205,  281,  543,   86,   86,
 /*    10 */    86,   86,  587,   96,   96,   96,   96,   93,   93,   94,
 /*    20 */    94,   94,   91,  227,  492,  359,  206,  308,  532,  524,
 /*    30 */    88,   96,   96,   96,   96,   93,   93,   94,   94,   94,
 /*    40 */    91,  227,  322,  350,  589,  326,   92,   82,  309,  518,
 /*    50 */   516,  522,  522,   95,   95,   86,   86,   86,   86,  525,
 /*    60 */    96,   96,   96,   96,   93,   93,   94,   94,   94,   91,
 /*    70 */   227,  304,  552,  308,  543,  446,  553,   63,   96,   96,
 /*    80 */    96,   96,   93,   93,   94,   94,   94,   91,  227,  589,
 /*    90 */   301,  589,  179,  492,  453,  206,  445,  230,  269,  532,
 /*   100 */   524,  494,  564,   77,  114,  289,  340,  290,  325,  170,
 /*   110 */   436,  588,  585,  437,  401,  437,  262,   92,   82,  309,
 /*   120 */   518,  516,  522,  522,   95,   95,   86,   86,   86,   86,
 /*   130 */   466,   96,   96,   96,   96,   93,   93,   94,   94,   94,
 /*   140 */    91,  227,  304,  230,  345,  357,  494,  219,  321,  176,
 /*   150 */   114,  289,  340,  290,  325,  170,  588,  585,  588,  585,
 /*   160 */   171,  357,  262,  371,  378,  383,  555,  556,  551,   50,
 /*   170 */   532,  524,  434,  464,  388,   93,   93,   94,   94,   94,
 /*   180 */    91,  227,  586,  489,  551,   43,  592,  649,   92,   82,
 /*   190 */   309,  518,  516,  522,  522,   95,   95,   86,   86,   86,
 /*   200 */    86,  481,   96,   96,   96,   96,   93,   93,   94,   94,
 /*   210 */    94,   91,  227,  450,  304,  153,  480,  540,  607,   74,
 /*   220 */   263,   83,  164,  402,  234,  238,  332,  596,  416,  357,
 /*   230 */   319,  357,  233,  490,  229,  315,  505,  504,  559,  182,
 /*   240 */   188,  158,  532,  524,   94,   94,   94,   91,  227,  538,
 /*   250 */   538,  538,  551,   40,  551,   49,  239,  558,  557,   90,
 /*   260 */    92,   82,  309,  518,  516,  522,  522,   95,   95,   86,
 /*   270 */    86,   86,   86,  550,   96,   96,   96,   96,   93,   93,
 /*   280 */    94,   94,   94,   91,  227,  171,  304,  397,  371,  378,
 /*   290 */   383,   61,  353,  222,  451,  387,  331,  379,  226,  388,
 /*   300 */   423,  348,  357,  171,  566,   22,  371,  378,  383,  560,
 /*   310 */   447,  163,  191,  464,  532,  524,  165,  388,  554,  226,
 /*   320 */   231,  339,  505,  504,  373,  551,   49,   56,  151,  410,
 /*   330 */   240,   76,   92,   82,  309,  518,  516,  522,  522,   95,
 /*   340 */    95,   86,   86,   86,   86,  550,   96,   96,   96,   96,
 /*   350 */    93,   93,   94,   94,   94,   91,  227,  304,  204,  357,
 /*   360 */   565,  473,  109,  402,  234,  238,  357,  331,  154,  436,
 /*   370 */   357,  306,  341,  357,  229,   74,  262,   83,  164,  531,
 /*   380 */   530,  474,  551,   28,  226,  532,  524,  546,  606,  551,
 /*   390 */    49,  525,  550,  551,   51,  568,  551,   42,  159,  490,
 /*   400 */   527,  526,  550,   92,   82,  309,  518,  516,  522,  522,
 /*   410 */    95,   95,   86,   86,   86,   86,  376,   96,   96,   96,
 /*   420 */    96,   93,   93,   94,   94,   94,   91,  227,  304,  528,
 /*   430 */   479,  334,  550,   17,  488,  559,  357,  278,  391,  357,
 /*   440 */   284,  451,   23,  472,  157,  158,  589,   74,  264,   83,
 /*   450 */   164,  406,   22,  204,  558,  229,  532,  524,   60,  551,
 /*   460 */    40,  318,  551,   43,  930,  130,  609,    2,  394,  346,
 /*   470 */   272,  511,  511,  573,   92,   82,  309,  518,  516,  522,
 /*   480 */   522,   95,   95,   86,   86,   86,   86,  550,   96,   96,
 /*   490 */    96,   96,   93,   93,   94,   94,   94,   91,  227,  304,
 /*   500 */   217,  604,  920,  286,  920,  592,  141,  142,  311,  459,
 /*   510 */   249,  376,  242,  588,  585,  403,  226,  589,  357,  510,
 /*   520 */   481,  589,  346,  256,  511,  511,  236,  532,  524,  413,
 /*   530 */   424,  604,  921,  396,  921,  480,  420,  338,  324,  119,
 /*   540 */     1,  551,   31,  599,  589,   92,   82,  309,  518,  516,
 /*   550 */   522,  522,   95,   95,   86,   86,   86,   86,  357,   96,
 /*   560 */    96,   96,   96,   93,   93,   94,   94,   94,   91,  227,
 /*   570 */   304,  276,  307,  599,  429,  589,  475,  355,  161,  605,
 /*   580 */   606,  551,   16,  399,  588,  585,  442,  349,  588,  585,
 /*   590 */   441,  277,  543,  281,  346,  451,  511,  511,  532,  524,
 /*   600 */   551,    3,  229,  459,  386,  590,   22,  346,  281,  511,
 /*   610 */   511,  588,  585,  223,  458,  381,   92,   82,  309,  518,
 /*   620 */   516,  522,  522,   95,   95,   86,   86,   86,   86,  221,
 /*   630 */    96,   96,   96,   96,   93,   93,   94,   94,   94,   91,
 /*   640 */   227,  304,  588,  585,  323,  454,  385,  392,  357,  169,
 /*   650 */   357,  400,  357,  205,  357,  543,  357,   20,  357,  543,
 /*   660 */   357,  543,  357,  589,  346,  521,  511,  511,  542,  532,
 /*   670 */   524,  551,  111,  551,   33,  551,   24,  551,   34,  551,
 /*   680 */   112,  551,   37,  551,   98,  551,   54,   92,   82,  309,
 /*   690 */   518,  516,  522,  522,   95,   95,   86,   86,   86,   86,
 /*   700 */   357,   96,   96,   96,   96,   93,   93,   94,   94,   94,
 /*   710 */    91,  227,  304,  357,  506,  357,  421,  598,  302,  357,
 /*   720 */   208,  357,  543,  551,   52,  357,  282,  357,  543,  357,
 /*   730 */   588,  585,  357,  610,  600,  360,  551,  113,  551,   35,
 /*   740 */   532,  524,  551,   55,  551,   25,   91,  227,  551,   29,
 /*   750 */   551,   41,  551,   39,  550,  551,   10,  287,   92,   82,
 /*   760 */   309,  518,  516,  522,  522,   95,   95,   86,   86,   86,
 /*   770 */    86,  357,   96,   96,   96,   96,   93,   93,   94,   94,
 /*   780 */    94,   91,  227,  304,  357,  460,  357,  582,  579,  578,
 /*   790 */   357,  595,  357,  303,  551,   26,  357,  439,  440,  357,
 /*   800 */   343,  357,  374,  357,  201,  211,  166,  551,   46,  551,
 /*   810 */    30,  532,  524,  551,   32,  551,   48,  276,  276,  551,
 /*   820 */    47,  276,  551,  103,  551,  108,  551,   97,  426,   92,
 /*   830 */    82,  309,  518,  516,  522,  522,   95,   95,   86,   86,
 /*   840 */    86,   86,  357,   96,   96,   96,   96,   93,   93,   94,
 /*   850 */    94,   94,   91,  227,  304,  357,  471,  357,  169,  512,
 /*   860 */   517,  357,  459,  362,  357,  551,  102,  357,  225,  509,
 /*   870 */   357,   21,  357,  356,  357,  490,  601,    2,  551,  100,
 /*   880 */   551,   99,  532,  524,  551,   38,  374,  551,   45,   18,
 /*   890 */   551,  110,  296,  551,   44,  551,   36,  551,   27,  196,
 /*   900 */    92,   81,  309,  518,  516,  522,  522,   95,   95,   86,
 /*   910 */    86,   86,   86,  404,   96,   96,   96,   96,   93,   93,
 /*   920 */    94,   94,   94,   91,  227,  304,  513,  357,  190,  167,
 /*   930 */   155,  161,  288,  550,  297,  281,  461,  320,  494,  219,
 /*   940 */     8,  285,  276,  169,  600,  360,  409,  407,  498,  498,
 /*   950 */   551,   53,  218,  532,  524,  169,  459,  276,  525,  525,
 /*   960 */   266,  276,  550,  550,  550,  368,  281,  276,  487,  602,
 /*   970 */   191,  314,   82,  309,  518,  516,  522,  522,   95,   95,
 /*   980 */    86,   86,   86,   86,  214,   96,   96,   96,   96,   93,
 /*   990 */    93,   94,   94,   94,   91,  227,  304,  274,  228,  523,
 /*  1000 */   276,  336,  310,  520,  456,  495,  470,   70,  552,  246,
 /*  1010 */   603,   19,  553,  146,  165,  469,  455,  199,  169,  295,
 /*  1020 */   545,   62,   70,   80,  532,  524,  227,  452,  237,  149,
 /*  1030 */   293,  369,  412,  414,  449,  572,  351,  539,  570,  294,
 /*  1040 */   260,  370,  271,  853,  309,  518,  516,  522,  522,   95,
 /*  1050 */    95,   86,   86,   86,   86,  462,   96,   96,   96,   96,
 /*  1060 */    93,   93,   94,   94,   94,   91,  227,   71,  352,  306,
 /*  1070 */     4,  162,  435,  247,  316,  583,  438,  496,  478,   71,
 /*  1080 */   352,  279,    4,  344,  292,  243,  316,  375,  395,  465,
 /*  1090 */   258,  501,  337,  536,  533,  344,  499,  541,  493,  147,
 /*  1100 */   267,  330,  298,  549,  497,  483,  259,  424,  569,  116,
 /*  1110 */   571,  489,  203,  330,   57,  195,  580,   78,   78,  367,
 /*  1120 */   363,  115,  463,  489,  425,  500,  229,  187,  432,  508,
 /*  1130 */   241,   84,   73,  476,  576,  128,    5,  364,  125,  575,
 /*  1140 */    72,  354,  358,   84,   73,  540,  390,  123,  327,  329,
 /*  1150 */   574,  591,   72,  354,  358,  193,  126,  540,  448,  107,
 /*  1160 */   172,  393,  200,  342,  268,  245,  248,  251,  183,  273,
 /*  1170 */   529,  104,  143,  257,  313,  229,   58,  538,  538,  538,
 /*  1180 */   535,  534,   12,   59,  168,  312,  235,  563,  561,  538,
 /*  1190 */   538,  538,  535,  534,   12,  261,   87,    7,   71,  352,
 /*  1200 */   213,    4,   67,  333,  594,  316,   69,  185,  250,  464,
 /*  1210 */    79,  431,  244,  175,  344,  270,  202,  366,  482,  135,
 /*  1220 */   265,  174,  275,  122,  489,  427,  548,  428,  133,  577,
 /*  1230 */   299,  215,  330,  347,  467,  181,  300,  415,  224,  216,
 /*  1240 */   433,  417,  489,  194,  152,  150,  412,  408,  398,  411,
 /*  1250 */   207,  291,  418,  405,  450,  173,  105,  422,  540,  384,
 /*  1260 */   254,  238,   84,   73,  584,  305,   75,  101,  232,  317,
 /*  1270 */   229,   72,  354,  358,  210,  118,  540,  280,  129,  132,
 /*  1280 */   335,  593,  544,  485,  184,  253,  562,  209,  136,  380,
 /*  1290 */   538,  538,  538,  160,  377,  145,  547,  650,  468,  127,
 /*  1300 */    13,  382,   15,  514,  502,  389,  144,  444,  538,  538,
 /*  1310 */   538,  535,  534,   12,  191,  255,  486,   66,  443,  430,
 /*  1320 */   131,  121,  137,  106,  519,   65,   89,  192,  608,  252,
 /*  1330 */   283,  419,  134,  597,  457,   85,  372,  156,  140,  120,
 /*  1340 */   148,  503,   64,  567,  212,    6,  186,  537,  189,  177,
 /*  1350 */   365,  328,  651,  491,  507,    9,  197,  477,   14,  293,
 /*  1360 */   484,   68,  220,  138,  117,  178,  180,  139,   11,  198,
 /*  1370 */   515,  124,  931,  931,  931,  931,  931,  931,  931,  931,
 /*  1380 */   931,  361,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    19,  221,  222,  223,  224,   24,  150,   26,   74,   75,
 /*    10 */    76,   77,  150,   79,   80,   81,   82,   83,   84,   85,
 /*    20 */    86,   87,   88,   89,  165,  166,  167,   19,   47,   48,
 /*    30 */    78,   79,   80,   81,   82,   83,   84,   85,   86,   87,
 /*    40 */    88,   89,  186,   19,   26,   85,   65,   66,   67,   68,
 /*    50 */    69,   70,   71,   72,   73,   74,   75,   76,   77,  165,
 /*    60 */    79,   80,   81,   82,   83,   84,   85,   86,   87,   88,
 /*    70 */    89,   19,  112,   19,   93,   34,  116,   25,   79,   80,
 /*    80 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   26,
 /*    90 */   162,   26,   22,  165,  166,  167,   55,   89,  204,   47,
 /*   100 */    48,   83,  172,   51,   96,   97,   98,   99,  100,  101,
 /*   110 */   180,   93,   94,  104,  105,  106,  108,   65,   66,   67,
 /*   120 */    68,   69,   70,   71,   72,   73,   74,   75,   76,   77,
 /*   130 */    11,   79,   80,   81,   82,   83,   84,   85,   86,   87,
 /*   140 */    88,   89,   19,   89,  120,  150,   83,   84,  107,   95,
 /*   150 */    96,   97,   98,   99,  100,  101,   93,   94,   93,   94,
 /*   160 */    95,  150,  108,   98,   99,  100,  103,  104,  173,  174,
 /*   170 */    47,   48,  150,   54,  109,   83,   84,   85,   86,   87,
 /*   180 */    88,   89,  150,   63,  173,  174,   12,  117,   65,   66,
 /*   190 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   200 */    77,   27,   79,   80,   81,   82,   83,   84,   85,   86,
 /*   210 */    87,   88,   89,   93,   19,   25,   42,   97,   44,  221,
 /*   220 */   225,  223,  224,  104,  105,  106,  146,  147,   54,  150,
 /*   230 */   219,  150,  152,  150,  115,  168,  169,  170,  150,  159,
 /*   240 */   205,  206,   47,   48,   85,   86,   87,   88,   89,  129,
 /*   250 */   130,  131,  173,  174,  173,  174,  150,  169,  170,  136,
 /*   260 */    65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   270 */    75,   76,   77,  193,   79,   80,   81,   82,   83,   84,
 /*   280 */    85,   86,   87,   88,   89,   95,   19,   19,   98,   99,
 /*   290 */   100,   24,  213,  214,  150,  212,  215,  217,  231,  109,
 /*   300 */   164,  220,  150,   95,  160,  161,   98,   99,  100,  173,
 /*   310 */    23,  159,   25,   54,   47,   48,   48,  109,  230,  231,
 /*   320 */   196,  168,  169,  170,  244,  173,  174,  203,  184,  185,
 /*   330 */   150,  136,   65,   66,   67,   68,   69,   70,   71,   72,
 /*   340 */    73,   74,   75,   76,   77,  193,   79,   80,   81,   82,
 /*   350 */    83,   84,   85,   86,   87,   88,   89,   19,  159,  150,
 /*   360 */   171,  172,   24,  104,  105,  106,  150,  215,  159,  180,
 /*   370 */   150,  103,  220,  150,  115,  221,  108,  223,  224,   47,
 /*   380 */    48,   23,  173,  174,  231,   47,   48,  189,  190,  173,
 /*   390 */   174,  165,  193,  173,  174,  241,  173,  174,  159,  150,
 /*   400 */    68,   69,  193,   65,   66,   67,   68,   69,   70,   71,
 /*   410 */    72,   73,   74,   75,   76,   77,  217,   79,   80,   81,
 /*   420 */    82,   83,   84,   85,   86,   87,   88,   89,   19,   97,
 /*   430 */   204,  215,  193,  234,   23,  150,  150,  194,  239,  150,
 /*   440 */   150,  150,   22,  182,  205,  206,   26,  221,  157,  223,
 /*   450 */   224,  160,  161,  159,  169,  115,   47,   48,   49,  173,
 /*   460 */   174,  212,  173,  174,  142,  143,  144,  145,  128,  111,
 /*   470 */    17,  113,  114,  150,   65,   66,   67,   68,   69,   70,
 /*   480 */    71,   72,   73,   74,   75,   76,   77,  193,   79,   80,
 /*   490 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   19,
 /*   500 */   214,   22,   23,   23,   25,   12,   23,   23,  219,   25,
 /*   510 */    57,  217,   59,   93,   94,  230,  231,   26,  150,   23,
 /*   520 */    27,   26,  111,  150,  113,  114,  150,   47,   48,  180,
 /*   530 */   181,   22,   23,  239,   25,   42,  187,   44,  245,  246,
 /*   540 */    22,  173,  174,   64,   26,   65,   66,   67,   68,   69,
 /*   550 */    70,   71,   72,   73,   74,   75,   76,   77,  150,   79,
 /*   560 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   89,
 /*   570 */    19,  150,  154,   64,   23,   26,   85,  150,   94,  189,
 /*   580 */   190,  173,  174,   96,   93,   94,   28,   19,   93,   94,
 /*   590 */    32,  138,   26,  150,  111,  150,  113,  114,   47,   48,
 /*   600 */   173,  174,  115,  119,   46,  160,  161,  111,  150,  113,
 /*   610 */   114,   93,   94,  192,  119,  128,   65,   66,   67,   68,
 /*   620 */    69,   70,   71,   72,   73,   74,   75,   76,   77,  186,
 /*   630 */    79,   80,   81,   82,   83,   84,   85,   86,   87,   88,
 /*   640 */    89,   19,   93,   94,  186,   23,  228,   23,  150,   25,
 /*   650 */   150,  233,  150,   24,  150,   26,  150,   22,  150,   93,
 /*   660 */   150,   26,  150,   26,  111,   97,  113,  114,  119,   47,
 /*   670 */    48,  173,  174,  173,  174,  173,  174,  173,  174,  173,
 /*   680 */   174,  173,  174,  173,  174,  173,  174,   65,   66,   67,
 /*   690 */    68,   69,   70,   71,   72,   73,   74,   75,   76,   77,
 /*   700 */   150,   79,   80,   81,   82,   83,   84,   85,   86,   87,
 /*   710 */    88,   89,   19,  150,  150,  150,   23,  247,  248,  150,
 /*   720 */   159,  150,   93,  173,  174,  150,  150,  150,   93,  150,
 /*   730 */    93,   94,  150,    0,    1,    2,  173,  174,  173,  174,
 /*   740 */    47,   48,  173,  174,  173,  174,   88,   89,  173,  174,
 /*   750 */   173,  174,  173,  174,  193,  173,  174,  150,   65,   66,
 /*   760 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   770 */    77,  150,   79,   80,   81,   82,   83,   84,   85,   86,
 /*   780 */    87,   88,   89,   19,  150,  207,  150,    7,    8,    9,
 /*   790 */   150,   23,  150,   25,  173,  174,  150,   96,   97,  150,
 /*   800 */   150,  150,  150,  150,  104,  105,  106,  173,  174,  173,
 /*   810 */   174,   47,   48,  173,  174,  173,  174,  150,  150,  173,
 /*   820 */   174,  150,  173,  174,  173,  174,  173,  174,  150,   65,
 /*   830 */    66,   67,   68,   69,   70,   71,   72,   73,   74,   75,
 /*   840 */    76,   77,  150,   79,   80,   81,   82,   83,   84,   85,
 /*   850 */    86,   87,   88,   89,   19,  150,   23,  150,   25,  192,
 /*   860 */   192,  150,   25,  192,  150,  173,  174,  150,  216,   23,
 /*   870 */   150,   25,  150,  150,  150,  150,  144,  145,  173,  174,
 /*   880 */   173,  174,   47,   48,  173,  174,  150,  173,  174,   22,
 /*   890 */   173,  174,   17,  173,  174,  173,  174,  173,  174,  159,
 /*   900 */    65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   910 */    75,   76,   77,  242,   79,   80,   81,   82,   83,   84,
 /*   920 */    85,   86,   87,   88,   89,   19,   21,  150,  159,  159,
 /*   930 */   159,   94,   57,  193,   59,  150,   25,  212,   83,   84,
 /*   940 */    73,   23,  150,   25,    1,    2,    7,    8,  129,  130,
 /*   950 */   173,  174,  216,   47,   48,   25,  119,  150,  165,  165,
 /*   960 */   148,  150,  193,  193,  193,   60,  150,  150,   23,   23,
 /*   970 */    25,  186,   66,   67,   68,   69,   70,   71,   72,   73,
 /*   980 */    74,   75,   76,   77,  192,   79,   80,   81,   82,   83,
 /*   990 */    84,   85,   86,   87,   88,   89,   19,  204,  204,  192,
 /*  1000 */   150,  150,  186,  192,   99,   23,   30,   25,  112,  192,
 /*  1010 */    64,   22,  116,   24,   48,   39,   23,   25,   25,   97,
 /*  1020 */    23,  135,   25,  137,   47,   48,   89,  173,  150,  118,
 /*  1030 */   108,  236,  102,  185,  173,  150,  227,  150,  150,  150,
 /*  1040 */   150,  150,  192,  138,   67,   68,   69,   70,   71,   72,
 /*  1050 */    73,   74,   75,   76,   77,  176,   79,   80,   81,   82,
 /*  1060 */    83,   84,   85,   86,   87,   88,   89,   19,   20,  103,
 /*  1070 */    22,  150,  165,  150,   26,  176,  182,  232,  198,   19,
 /*  1080 */    20,  150,   22,   35,  176,  150,   26,  177,  150,  176,
 /*  1090 */   208,  176,  190,  198,  150,   35,  232,  165,  165,  195,
 /*  1100 */   208,   53,  150,  150,  185,  165,  197,  181,  153,   65,
 /*  1110 */    38,   63,  188,   53,  240,  117,  156,  126,  126,  156,
 /*  1120 */   150,  150,  188,   63,  182,  198,  115,    6,  150,  150,
 /*  1130 */   201,   83,   84,   85,  149,   22,  195,  156,  218,  149,
 /*  1140 */    92,   93,   94,   83,   84,   97,   18,  191,  121,  149,
 /*  1150 */    13,   36,   92,   93,   94,  151,  188,   97,  210,  243,
 /*  1160 */     5,   18,  155,  123,  199,   10,   11,   12,   13,   14,
 /*  1170 */   198,   16,  218,  198,  156,  115,  240,  129,  130,  131,
 /*  1180 */   132,  133,  134,   22,   29,   45,   31,   26,  183,  129,
 /*  1190 */   130,  131,  132,  133,  134,   40,  135,   25,   19,   20,
 /*  1200 */   226,   22,  135,  158,  149,   26,  103,   52,  209,   54,
 /*  1210 */   124,  238,  200,   58,   35,  209,   61,   43,  210,  191,
 /*  1220 */   237,  151,  209,  191,   63,  210,  193,  156,   22,  156,
 /*  1230 */   178,   89,   53,  103,  175,  156,  178,  175,  229,  229,
 /*  1240 */   175,  175,   63,  155,   83,   84,  102,  183,  156,  175,
 /*  1250 */   155,  175,  177,  175,   93,  155,  179,  156,   97,  104,
 /*  1260 */   105,  106,   83,   84,  156,  110,  125,  163,  179,  249,
 /*  1270 */   115,   92,   93,   94,  235,  246,   97,  150,  191,  156,
 /*  1280 */   122,  150,  202,   23,  117,  140,   23,  118,   50,  208,
 /*  1290 */   129,  130,  131,  117,  139,   24,  128,  117,    1,  107,
 /*  1300 */    22,   19,   25,   20,    1,   49,   22,   50,  129,  130,
 /*  1310 */   131,  132,  133,  134,   25,  138,   11,   22,   20,  120,
 /*  1320 */   107,  127,   22,   17,   97,   73,   22,  127,    4,   15,
 /*  1330 */    23,   23,   22,    1,   23,   73,   49,   22,   22,  103,
 /*  1340 */    22,   56,   25,   23,  121,   33,   17,  119,   25,  103,
 /*  1350 */    41,    3,  117,   23,   23,    5,  117,   23,   33,  108,
 /*  1360 */    23,   22,   49,   22,   37,  101,   33,  118,   22,   15,
 /*  1370 */   112,   22,  250,  250,  250,  250,  250,  250,  250,  250,
 /*  1380 */   250,   62,
};
#define YY_SHIFT_USE_DFLT (-67)
#define YY_SHIFT_MAX 404
static const short yy_shift_ofst[] = {
 /*     0 */   943, 1060, 1155,  -19, 1060, 1179, 1179,   65,   63,  259,
 /*    10 */   409, 1179, 1179, 1179, 1179, 1179,  -48,  119,   18,  637,
 /*    20 */   855,  855,  566, 1011,   52,  622,  551,  480,  693,  195,
 /*    30 */   123,  267,  338,  764,  764,  764,  764,  764,  764,  764,
 /*    40 */   764,  764,  764,  764,  764,  764,  764,  764,  764,  764,
 /*    50 */   764,  764,  835,  906,  977,  977, 1048, 1179, 1179, 1179,
 /*    60 */  1179, 1179, 1179, 1179, 1179, 1179, 1179, 1179, 1179, 1179,
 /*    70 */  1179, 1179, 1179, 1179, 1179, 1179, 1179, 1179, 1179, 1179,
 /*    80 */  1179, 1179, 1179, 1179, 1179, 1179, 1179, 1179, 1179, 1179,
 /*    90 */  1179, 1179, 1179, 1179, 1179, 1179, 1179,  -66,  -66,   -1,
 /*   100 */    -1,   54,   92,  159,  905,  268,  637,  637,  658,  566,
 /*   110 */   937,  -67,  -67,  -67, 1161,    8,  174,  174,  509,  479,
 /*   120 */   637,  637,  637,  637,  637,  487,  637,  637,  637,  637,
 /*   130 */   733,  637,  629,  637,  637,  637,  637,  637,  637,  637,
 /*   140 */   637,  629,  629,  340, 1011, 1011, 1011,  -67,  -67,  -67,
 /*   150 */   120,  190,  120,  208,  358,  411,  493,  484,  420,  483,
 /*   160 */   491,  495,  549,  496,  518,  637,   41,  553,  637,  637,
 /*   170 */   637,  637,  780,  637,  637,  637,  637,  637,  637,  -40,
 /*   180 */   637,  558,  553,  637,  637,  637,  637,  637,  837,  637,
 /*   190 */   553,  637,  637,  637,  637,  637,  553,  637,  637,  637,
 /*   200 */   637,   41,  637,  637,  553,  637,  635,  637,  553,  637,
 /*   210 */     9,   41,  637,  886,   24,  566,  976,  976,  992,  819,
 /*   220 */   976,  930,  976,   24,  976,  992,  819,  566,   24,  896,
 /*   230 */   566,  911,  966,  989, 1044, 1072,  998,  991, 1044,  998,
 /*   240 */   998, 1141, 1128,  998, 1158, 1121, 1113,  998, 1121, 1128,
 /*   250 */  1027, 1121, 1137, 1115, 1044, 1143, 1113, 1040,  991,  991,
 /*   260 */   998, 1072, 1140, 1061, 1172, 1067, 1121, 1103, 1086, 1103,
 /*   270 */  1027, 1174, 1128, 1137, 1103, 1027,  998, 1128, 1011,  998,
 /*   280 */  1206, 1142, 1142, 1130,  998, 1130, 1130, 1206, 1143, 1130,
 /*   290 */  1130, 1144, 1130, 1140,  998, 1130, 1143, 1143,  998,  -67,
 /*   300 */   -67,  -67,  -67,  -67,  332,  453,  700,  875,  922,  568,
 /*   310 */   993,  997,  939,  867,  918,  846,   70,  946,  945,  982,
 /*   320 */   287,  701,  833,  624,  768, 1304, 1308, 1310, 1324, 1314,
 /*   330 */  1315, 1317, 1332, 1320, 1317, 1312, 1228, 1323, 1260, 1331,
 /*   340 */  1313, 1334, 1325, 1337, 1339, 1333, 1258, 1327, 1311, 1227,
 /*   350 */  1199, 1305, 1284, 1277, 1180, 1176, 1167, 1239, 1235, 1330,
 /*   360 */  1348, 1354, 1319, 1349, 1246, 1285, 1309, 1223, 1329, 1236,
 /*   370 */  1262, 1287, 1316, 1318, 1252, 1307, 1200, 1306, 1300, 1194,
 /*   380 */  1213, 1346, 1298, 1295, 1249, 1177, 1257, 1289, 1256, 1341,
 /*   390 */  1283, 1303, 1264, 1282, 1278, 1192, 1297, 1251, 1271, 1168,
 /*   400 */  1350, 1238, 1169, 1263, 1145,
};
#define YY_REDUCE_USE_DFLT (-221)
#define YY_REDUCE_MAX 303
static const short yy_reduce_ofst[] = {
 /*     0 */   322,  152,   80,  226,  209,   81,   79,  144,   88,  199,
 /*    10 */   154,  289,   -5,   11,  216,  286, -220,  294,  285,  291,
 /*    20 */    67,  153,  -72,  239,   -2,   -2,   -2,   -2,   -2,   -2,
 /*    30 */    -2,   -2,   -2,   -2,   -2,   -2,   -2,   -2,   -2,   -2,
 /*    40 */    -2,   -2,   -2,   -2,   -2,   -2,   -2,   -2,   -2,   -2,
 /*    50 */    -2,   -2,   -2,   -2,   -2,   -2,  427,  368,  500,  571,
 /*    60 */   508,  582,  636,  646,  722,  711,  724,  720,  640,  634,
 /*    70 */   579,  569,  506,  498,  408,  502,  504,  220,  223,  577,
 /*    80 */   642,  510,  512,  550,  563,  565,  705,  575,  707,  621,
 /*    90 */   714,  717,  777,  649,  651,  653,  692,   -2,   -2,   -2,
 /*   100 */    -2,  189,   -2,   -2,  418,  349,  671,  445,   -2, -141,
 /*   110 */    -2,   -2,   -2,   -2,  136,  -70,  198,  390,  470,  470,
 /*   120 */   850,  817,  811,  807,  816,  561,  792,  736,  249,  668,
 /*   130 */   732,  652,  794, -144,  725,  667,   83,  785,  458,  421,
 /*   140 */   443, -106,  793,  770,  771,  740,  769,  124,  293,   35,
 /*   150 */   861,  848,  854,  919,  243,  243,  902,  578,  935,  243,
 /*   160 */   723,  921,  851,  243,  180,   22,  261,  243,  376,  576,
 /*   170 */   607,  678,  812,  889,  888,  953,  971,  970, 1127,  941,
 /*   180 */   978, 1039,  243,  885,  887,  890,  106, 1131,  578,  650,
 /*   190 */   243,  564,  373,  323,  290, -138,  243,  723,   32,  891,
 /*   200 */   923,  894,  931,  938,  243,  944,  933,  952,  243,  878,
 /*   210 */   795,  942,  979,  809, 1081,  907,  879,  899,  880,  845,
 /*   220 */   908,  910,  913,  882,  915,  895,  864,  932,  892,  904,
 /*   230 */   940,  909,  926,  955,  924,  874,  960,  927,  934,  963,
 /*   240 */  1108, 1080, 1087, 1123,  929,  985,  920,  981,  990,  956,
 /*   250 */   948, 1000, 1004,  916,  968, 1007,  954,  965,  972,  975,
 /*   260 */  1018,  936, 1005,  974, 1045,  973, 1055,  999, 1012, 1006,
 /*   270 */  1008,  983, 1028, 1070, 1013, 1015, 1071, 1032, 1033, 1073,
 /*   280 */  1052, 1009, 1010, 1059, 1079, 1062, 1065, 1058, 1088, 1066,
 /*   290 */  1074, 1075, 1076, 1064, 1092, 1078, 1095, 1100, 1101, 1077,
 /*   300 */  1089, 1104, 1020, 1029,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   615,  848,  929,  736,  929,  848,  929,  929,  875,  929,
 /*    10 */   904,  929,  846,  929,  929,  929,  820,  929,  875,  929,
 /*    20 */   875,  875,  652,  740,  771,  929,  929,  929,  929,  929,
 /*    30 */   929,  929,  929,  903,  842,  778,  849,  905,  779,  785,
 /*    40 */   762,  769,  776,  786,  888,  841,  751,  773,  843,  850,
 /*    50 */   845,  772,  929,  808,  807,  826,  929,  929,  929,  929,
 /*    60 */   929,  929,  929,  929,  929,  929,  929,  929,  929,  929,
 /*    70 */   929,  929,  929,  929,  929,  929,  929,  929,  929,  929,
 /*    80 */   929,  929,  929,  929,  929,  929,  929,  929,  929,  929,
 /*    90 */   929,  929,  929,  929,  929,  929,  929,  810,  832,  819,
 /*   100 */   809,  645,  811,  812,  640,  705,  929,  929,  813,  929,
 /*   110 */   814,  828,  827,  829,  929,  929,  929,  929,  929,  929,
 /*   120 */   929,  929,  929,  929,  929,  929,  929,  929,  929,  929,
 /*   130 */   615,  929,  736,  929,  929,  929,  929,  929,  929,  929,
 /*   140 */   929,  736,  736,  929,  929,  929,  929,  730,  922,  740,
 /*   150 */   929,  696,  929,  929,  929,  929,  929,  929,  929,  929,
 /*   160 */   929,  929,  929,  929,  929,  929,  929,  893,  910,  929,
 /*   170 */   929,  929,  623,  929,  929,  861,  929,  929,  929,  728,
 /*   180 */   929,  881,  719,  929,  929,  929,  929,  621,  738,  929,
 /*   190 */   642,  929,  929,  929,  929,  929,  717,  929,  929,  929,
 /*   200 */   929,  929,  908,  929,  895,  929,  654,  929,  781,  929,
 /*   210 */   929,  929,  929,  844,  753,  929,  765,  765,  775,  929,
 /*   220 */   765,  678,  765,  753,  765,  775,  929,  929,  753,  728,
 /*   230 */   929,  737,  675,  929,  709,  907,  744,  775,  709,  744,
 /*   240 */   744,  770,  716,  744,  758,  620,  787,  744,  620,  716,
 /*   250 */   757,  620,  631,  915,  709,  637,  787,  766,  775,  775,
 /*   260 */   744,  907,  692,  929,  695,  887,  620,  752,  768,  752,
 /*   270 */   757,  885,  716,  631,  752,  757,  744,  716,  929,  744,
 /*   280 */   854,  858,  858,  707,  744,  707,  707,  854,  637,  707,
 /*   290 */   707,  678,  707,  692,  744,  707,  637,  637,  744,  680,
 /*   300 */   680,  662,  927,  922,  929,  929,  929,  929,  929,  929,
 /*   310 */   929,  929,  929,  868,  929,  929,  794,  929,  929,  929,
 /*   320 */   929,  929,  929,  929,  929,  929,  929,  929,  929,  629,
 /*   330 */   929,  847,  929,  929,  767,  929,  929,  929,  929,  929,
 /*   340 */   929,  929,  929,  929,  929,  929,  722,  929,  929,  929,
 /*   350 */   929,  929,  929,  759,  799,  929,  796,  929,  795,  929,
 /*   360 */   616,  929,  914,  929,  929,  929,  929,  929,  929,  929,
 /*   370 */   929,  929,  929,  917,  929,  929,  929,  929,  929,  929,
 /*   380 */   929,  929,  929,  929,  929,  929,  929,  884,  929,  929,
 /*   390 */   929,  929,  929,  929,  929,  929,  929,  929,  929,  929,
 /*   400 */   929,  883,  929,  929,  929,  671,  644,  694,  690,  693,
 /*   410 */   699,  673,  679,  706,  698,  702,  713,  670,  672,  805,
 /*   420 */   704,  792,  636,  669,  681,  684,  700,  743,  746,  674,
 /*   430 */   755,  877,  754,  703,  682,  859,  676,  882,  683,  687,
 /*   440 */   686,  878,  879,  638,  880,  689,  688,  756,  741,  668,
 /*   450 */   799,  646,  667,  653,  666,  851,  852,  804,  748,  747,
 /*   460 */   739,  729,  856,  783,  784,  761,  876,  701,  889,  764,
 /*   470 */   763,  855,  685,  664,  836,  733,  732,  835,  891,  731,
 /*   480 */   900,  899,  742,  677,  897,  896,  840,  788,  839,  806,
 /*   490 */   790,  803,  657,  658,  874,  892,  872,  697,  873,  871,
 /*   500 */   894,  857,  890,  886,  660,  659,  789,  656,  919,  655,
 /*   510 */   837,  724,  714,  639,  715,  723,  833,  718,  830,  825,
 /*   520 */   860,  823,  822,  901,  817,  735,  834,  831,  824,  774,
 /*   530 */   818,  816,  815,  734,  801,  800,  777,  750,  798,  797,
 /*   540 */   793,  802,  749,  648,  725,  780,  710,  782,  721,  862,
 /*   550 */   720,  791,  727,  726,  863,  864,  865,  866,  869,  870,
 /*   560 */   665,  691,  867,  647,  663,  661,  643,  641,  902,  635,
 /*   570 */   633,  906,  632,  634,  630,  628,  627,  909,  626,  625,
 /*   580 */   911,  821,  624,  760,  838,  651,  912,  745,  650,  649,
 /*   590 */   913,  916,  898,  622,  619,  918,  618,  614,  923,  924,
 /*   600 */   613,  611,  925,  928,  926,  708,  711,  712,  617,  612,
};
#define YY_SZ_ACTTAB (int)(sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*       SEMI => nothing */
   26,  /*    EXPLAIN => ID */
   26,  /*      QUERY => ID */
   26,  /*       PLAN => ID */
   26,  /*      BEGIN => ID */
    0,  /* TRANSACTION => nothing */
   26,  /*   DEFERRED => ID */
   26,  /*  IMMEDIATE => ID */
   26,  /*  EXCLUSIVE => ID */
    0,  /*     COMMIT => nothing */
   26,  /*        END => ID */
   26,  /*   ROLLBACK => ID */
   26,  /*  SAVEPOINT => ID */
   26,  /*    RELEASE => ID */
    0,  /*         TO => nothing */
    0,  /*     CREATE => nothing */
    0,  /*      TABLE => nothing */
   26,  /*         IF => ID */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
   26,  /*       TEMP => ID */
    0,  /*         LP => nothing */
    0,  /*         RP => nothing */
    0,  /*         AS => nothing */
    0,  /*      COMMA => nothing */
    0,  /*         ID => nothing */
   26,  /*      ABORT => ID */
   26,  /*      AFTER => ID */
   26,  /*    ANALYZE => ID */
   26,  /*        ASC => ID */
   26,  /*     ATTACH => ID */
   26,  /*     BEFORE => ID */
   26,  /*         BY => ID */
   26,  /*    CASCADE => ID */
   26,  /*       CAST => ID */
   26,  /*   COLUMNKW => ID */
   26,  /*   CONFLICT => ID */
   26,  /*   DATABASE => ID */
   26,  /*       DESC => ID */
   26,  /*     DETACH => ID */
   26,  /*       EACH => ID */
   26,  /*       FAIL => ID */
   26,  /*        FOR => ID */
   26,  /*     IGNORE => ID */
   26,  /*  INITIALLY => ID */
   26,  /*    INSTEAD => ID */
   26,  /*    LIKE_KW => ID */
   26,  /*      MATCH => ID */
   26,  /*        KEY => ID */
   26,  /*         OF => ID */
   26,  /*     OFFSET => ID */
   26,  /*     PRAGMA => ID */
   26,  /*      RAISE => ID */
   26,  /*    REPLACE => ID */
   26,  /*   RESTRICT => ID */
   26,  /*        ROW => ID */
   26,  /*    TRIGGER => ID */
   26,  /*     VACUUM => ID */
   26,  /*       VIEW => ID */
   26,  /*    VIRTUAL => ID */
   26,  /*    REINDEX => ID */
   26,  /*     RENAME => ID */
   26,  /*   CTIME_KW => ID */
    0,  /*        ANY => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*         IS => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IN => nothing */
    0,  /*     ISNULL => nothing */
    0,  /*    NOTNULL => nothing */
    0,  /*         NE => nothing */
    0,  /*         EQ => nothing */
    0,  /*         GT => nothing */
    0,  /*         LE => nothing */
    0,  /*         LT => nothing */
    0,  /*         GE => nothing */
    0,  /*     ESCAPE => nothing */
    0,  /*     BITAND => nothing */
    0,  /*      BITOR => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*       PLUS => nothing */
    0,  /*      MINUS => nothing */
    0,  /*       STAR => nothing */
    0,  /*      SLASH => nothing */
    0,  /*        REM => nothing */
    0,  /*     CONCAT => nothing */
    0,  /*    COLLATE => nothing */
    0,  /*     UMINUS => nothing */
    0,  /*      UPLUS => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*     STRING => nothing */
    0,  /*    JOIN_KW => nothing */
    0,  /* CONSTRAINT => nothing */
    0,  /*    DEFAULT => nothing */
    0,  /*       NULL => nothing */
    0,  /*    PRIMARY => nothing */
    0,  /*     UNIQUE => nothing */
    0,  /*      CHECK => nothing */
    0,  /* REFERENCES => nothing */
    0,  /*   AUTOINCR => nothing */
    0,  /*         ON => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*        SET => nothing */
    0,  /* DEFERRABLE => nothing */
    0,  /*    FOREIGN => nothing */
    0,  /*       DROP => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*        DOT => nothing */
    0,  /*       FROM => nothing */
    0,  /*       JOIN => nothing */
    0,  /*    INDEXED => nothing */
    0,  /*      USING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*       INTO => nothing */
    0,  /*     VALUES => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*       BLOB => nothing */
    0,  /*   REGISTER => nothing */
    0,  /*   VARIABLE => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        ADD => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyidxMax;                 /* Maximum value of yyidx */
#endif
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite3ParserARG_SDECL                /* A place to hold %extra_argument */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3ParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "SEMI",          "EXPLAIN",       "QUERY",       
  "PLAN",          "BEGIN",         "TRANSACTION",   "DEFERRED",    
  "IMMEDIATE",     "EXCLUSIVE",     "COMMIT",        "END",         
  "ROLLBACK",      "SAVEPOINT",     "RELEASE",       "TO",          
  "CREATE",        "TABLE",         "IF",            "NOT",         
  "EXISTS",        "TEMP",          "LP",            "RP",          
  "AS",            "COMMA",         "ID",            "ABORT",       
  "AFTER",         "ANALYZE",       "ASC",           "ATTACH",      
  "BEFORE",        "BY",            "CASCADE",       "CAST",        
  "COLUMNKW",      "CONFLICT",      "DATABASE",      "DESC",        
  "DETACH",        "EACH",          "FAIL",          "FOR",         
  "IGNORE",        "INITIALLY",     "INSTEAD",       "LIKE_KW",     
  "MATCH",         "KEY",           "OF",            "OFFSET",      
  "PRAGMA",        "RAISE",         "REPLACE",       "RESTRICT",    
  "ROW",           "TRIGGER",       "VACUUM",        "VIEW",        
  "VIRTUAL",       "REINDEX",       "RENAME",        "CTIME_KW",    
  "ANY",           "OR",            "AND",           "IS",          
  "BETWEEN",       "IN",            "ISNULL",        "NOTNULL",     
  "NE",            "EQ",            "GT",            "LE",          
  "LT",            "GE",            "ESCAPE",        "BITAND",      
  "BITOR",         "LSHIFT",        "RSHIFT",        "PLUS",        
  "MINUS",         "STAR",          "SLASH",         "REM",         
  "CONCAT",        "COLLATE",       "UMINUS",        "UPLUS",       
  "BITNOT",        "STRING",        "JOIN_KW",       "CONSTRAINT",  
  "DEFAULT",       "NULL",          "PRIMARY",       "UNIQUE",      
  "CHECK",         "REFERENCES",    "AUTOINCR",      "ON",          
  "DELETE",        "UPDATE",        "INSERT",        "SET",         
  "DEFERRABLE",    "FOREIGN",       "DROP",          "UNION",       
  "ALL",           "EXCEPT",        "INTERSECT",     "SELECT",      
  "DISTINCT",      "DOT",           "FROM",          "JOIN",        
  "INDEXED",       "USING",         "ORDER",         "GROUP",       
  "HAVING",        "LIMIT",         "WHERE",         "INTO",        
  "VALUES",        "INTEGER",       "FLOAT",         "BLOB",        
  "REGISTER",      "VARIABLE",      "CASE",          "WHEN",        
  "THEN",          "ELSE",          "INDEX",         "ALTER",       
  "ADD",           "error",         "input",         "cmdlist",     
  "ecmd",          "explain",       "cmdx",          "cmd",         
  "transtype",     "trans_opt",     "nm",            "savepoint_opt",
  "create_table",  "create_table_args",  "temp",          "ifnotexists", 
  "dbnm",          "columnlist",    "conslist_opt",  "select",      
  "column",        "columnid",      "type",          "carglist",    
  "id",            "ids",           "typetoken",     "typename",    
  "signed",        "plus_num",      "minus_num",     "carg",        
  "ccons",         "term",          "expr",          "onconf",      
  "sortorder",     "autoinc",       "idxlist_opt",   "refargs",     
  "defer_subclause",  "refarg",        "refact",        "init_deferred_pred_opt",
  "conslist",      "tcons",         "idxlist",       "defer_subclause_opt",
  "orconf",        "resolvetype",   "raisetype",     "ifexists",    
  "fullname",      "oneselect",     "multiselect_op",  "distinct",    
  "selcollist",    "from",          "where_opt",     "groupby_opt", 
  "having_opt",    "orderby_opt",   "limit_opt",     "sclp",        
  "as",            "seltablist",    "stl_prefix",    "joinop",      
  "indexed_opt",   "on_opt",        "using_opt",     "joinop2",     
  "inscollist",    "sortlist",      "sortitem",      "nexprlist",   
  "setlist",       "insert_cmd",    "inscollist_opt",  "itemlist",    
  "exprlist",      "likeop",        "escape",        "between_op",  
  "in_op",         "case_operand",  "case_exprlist",  "case_else",   
  "uniqueflag",    "collate",       "nmnum",         "plus_opt",    
  "number",        "trigger_decl",  "trigger_cmd_list",  "trigger_time",
  "trigger_event",  "foreach_clause",  "when_clause",   "trigger_cmd", 
  "database_kw_opt",  "key_opt",       "add_column_fullname",  "kwcolumn_opt",
  "create_vtab",   "vtabarglist",   "vtabarg",       "vtabargtoken",
  "lp",            "anylist",     
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "ecmd ::= SEMI",
 /*   4 */ "ecmd ::= explain cmdx SEMI",
 /*   5 */ "explain ::=",
 /*   6 */ "explain ::= EXPLAIN",
 /*   7 */ "explain ::= EXPLAIN QUERY PLAN",
 /*   8 */ "cmdx ::= cmd",
 /*   9 */ "cmd ::= BEGIN transtype trans_opt",
 /*  10 */ "trans_opt ::=",
 /*  11 */ "trans_opt ::= TRANSACTION",
 /*  12 */ "trans_opt ::= TRANSACTION nm",
 /*  13 */ "transtype ::=",
 /*  14 */ "transtype ::= DEFERRED",
 /*  15 */ "transtype ::= IMMEDIATE",
 /*  16 */ "transtype ::= EXCLUSIVE",
 /*  17 */ "cmd ::= COMMIT trans_opt",
 /*  18 */ "cmd ::= END trans_opt",
 /*  19 */ "cmd ::= ROLLBACK trans_opt",
 /*  20 */ "savepoint_opt ::= SAVEPOINT",
 /*  21 */ "savepoint_opt ::=",
 /*  22 */ "cmd ::= SAVEPOINT nm",
 /*  23 */ "cmd ::= RELEASE savepoint_opt nm",
 /*  24 */ "cmd ::= ROLLBACK trans_opt TO savepoint_opt nm",
 /*  25 */ "cmd ::= create_table create_table_args",
 /*  26 */ "create_table ::= CREATE temp TABLE ifnotexists nm dbnm",
 /*  27 */ "ifnotexists ::=",
 /*  28 */ "ifnotexists ::= IF NOT EXISTS",
 /*  29 */ "temp ::= TEMP",
 /*  30 */ "temp ::=",
 /*  31 */ "create_table_args ::= LP columnlist conslist_opt RP",
 /*  32 */ "create_table_args ::= AS select",
 /*  33 */ "columnlist ::= columnlist COMMA column",
 /*  34 */ "columnlist ::= column",
 /*  35 */ "column ::= columnid type carglist",
 /*  36 */ "columnid ::= nm",
 /*  37 */ "id ::= ID",
 /*  38 */ "ids ::= ID|STRING",
 /*  39 */ "nm ::= ID",
 /*  40 */ "nm ::= STRING",
 /*  41 */ "nm ::= JOIN_KW",
 /*  42 */ "type ::=",
 /*  43 */ "type ::= typetoken",
 /*  44 */ "typetoken ::= typename",
 /*  45 */ "typetoken ::= typename LP signed RP",
 /*  46 */ "typetoken ::= typename LP signed COMMA signed RP",
 /*  47 */ "typename ::= ids",
 /*  48 */ "typename ::= typename ids",
 /*  49 */ "signed ::= plus_num",
 /*  50 */ "signed ::= minus_num",
 /*  51 */ "carglist ::= carglist carg",
 /*  52 */ "carglist ::=",
 /*  53 */ "carg ::= CONSTRAINT nm ccons",
 /*  54 */ "carg ::= ccons",
 /*  55 */ "ccons ::= DEFAULT term",
 /*  56 */ "ccons ::= DEFAULT LP expr RP",
 /*  57 */ "ccons ::= DEFAULT PLUS term",
 /*  58 */ "ccons ::= DEFAULT MINUS term",
 /*  59 */ "ccons ::= DEFAULT id",
 /*  60 */ "ccons ::= NULL onconf",
 /*  61 */ "ccons ::= NOT NULL onconf",
 /*  62 */ "ccons ::= PRIMARY KEY sortorder onconf autoinc",
 /*  63 */ "ccons ::= UNIQUE onconf",
 /*  64 */ "ccons ::= CHECK LP expr RP",
 /*  65 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  66 */ "ccons ::= defer_subclause",
 /*  67 */ "ccons ::= COLLATE ids",
 /*  68 */ "autoinc ::=",
 /*  69 */ "autoinc ::= AUTOINCR",
 /*  70 */ "refargs ::=",
 /*  71 */ "refargs ::= refargs refarg",
 /*  72 */ "refarg ::= MATCH nm",
 /*  73 */ "refarg ::= ON DELETE refact",
 /*  74 */ "refarg ::= ON UPDATE refact",
 /*  75 */ "refarg ::= ON INSERT refact",
 /*  76 */ "refact ::= SET NULL",
 /*  77 */ "refact ::= SET DEFAULT",
 /*  78 */ "refact ::= CASCADE",
 /*  79 */ "refact ::= RESTRICT",
 /*  80 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /*  81 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /*  82 */ "init_deferred_pred_opt ::=",
 /*  83 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /*  84 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /*  85 */ "conslist_opt ::=",
 /*  86 */ "conslist_opt ::= COMMA conslist",
 /*  87 */ "conslist ::= conslist COMMA tcons",
 /*  88 */ "conslist ::= conslist tcons",
 /*  89 */ "conslist ::= tcons",
 /*  90 */ "tcons ::= CONSTRAINT nm",
 /*  91 */ "tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf",
 /*  92 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /*  93 */ "tcons ::= CHECK LP expr RP onconf",
 /*  94 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /*  95 */ "defer_subclause_opt ::=",
 /*  96 */ "defer_subclause_opt ::= defer_subclause",
 /*  97 */ "onconf ::=",
 /*  98 */ "onconf ::= ON CONFLICT resolvetype",
 /*  99 */ "orconf ::=",
 /* 100 */ "orconf ::= OR resolvetype",
 /* 101 */ "resolvetype ::= raisetype",
 /* 102 */ "resolvetype ::= IGNORE",
 /* 103 */ "resolvetype ::= REPLACE",
 /* 104 */ "cmd ::= DROP TABLE ifexists fullname",
 /* 105 */ "ifexists ::= IF EXISTS",
 /* 106 */ "ifexists ::=",
 /* 107 */ "cmd ::= CREATE temp VIEW ifnotexists nm dbnm AS select",
 /* 108 */ "cmd ::= DROP VIEW ifexists fullname",
 /* 109 */ "cmd ::= select",
 /* 110 */ "select ::= oneselect",
 /* 111 */ "select ::= select multiselect_op oneselect",
 /* 112 */ "multiselect_op ::= UNION",
 /* 113 */ "multiselect_op ::= UNION ALL",
 /* 114 */ "multiselect_op ::= EXCEPT|INTERSECT",
 /* 115 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 116 */ "distinct ::= DISTINCT",
 /* 117 */ "distinct ::= ALL",
 /* 118 */ "distinct ::=",
 /* 119 */ "sclp ::= selcollist COMMA",
 /* 120 */ "sclp ::=",
 /* 121 */ "selcollist ::= sclp expr as",
 /* 122 */ "selcollist ::= sclp STAR",
 /* 123 */ "selcollist ::= sclp nm DOT STAR",
 /* 124 */ "as ::= AS nm",
 /* 125 */ "as ::= ids",
 /* 126 */ "as ::=",
 /* 127 */ "from ::=",
 /* 128 */ "from ::= FROM seltablist",
 /* 129 */ "stl_prefix ::= seltablist joinop",
 /* 130 */ "stl_prefix ::=",
 /* 131 */ "seltablist ::= stl_prefix nm dbnm as indexed_opt on_opt using_opt",
 /* 132 */ "seltablist ::= stl_prefix LP select RP as on_opt using_opt",
 /* 133 */ "seltablist ::= stl_prefix LP seltablist RP as on_opt using_opt",
 /* 134 */ "dbnm ::=",
 /* 135 */ "dbnm ::= DOT nm",
 /* 136 */ "fullname ::= nm dbnm",
 /* 137 */ "joinop ::= COMMA|JOIN",
 /* 138 */ "joinop ::= JOIN_KW JOIN",
 /* 139 */ "joinop ::= JOIN_KW nm JOIN",
 /* 140 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 141 */ "on_opt ::= ON expr",
 /* 142 */ "on_opt ::=",
 /* 143 */ "indexed_opt ::=",
 /* 144 */ "indexed_opt ::= INDEXED BY nm",
 /* 145 */ "indexed_opt ::= NOT INDEXED",
 /* 146 */ "using_opt ::= USING LP inscollist RP",
 /* 147 */ "using_opt ::=",
 /* 148 */ "orderby_opt ::=",
 /* 149 */ "orderby_opt ::= ORDER BY sortlist",
 /* 150 */ "sortlist ::= sortlist COMMA sortitem sortorder",
 /* 151 */ "sortlist ::= sortitem sortorder",
 /* 152 */ "sortitem ::= expr",
 /* 153 */ "sortorder ::= ASC",
 /* 154 */ "sortorder ::= DESC",
 /* 155 */ "sortorder ::=",
 /* 156 */ "groupby_opt ::=",
 /* 157 */ "groupby_opt ::= GROUP BY nexprlist",
 /* 158 */ "having_opt ::=",
 /* 159 */ "having_opt ::= HAVING expr",
 /* 160 */ "limit_opt ::=",
 /* 161 */ "limit_opt ::= LIMIT expr",
 /* 162 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /* 163 */ "limit_opt ::= LIMIT expr COMMA expr",
 /* 164 */ "cmd ::= DELETE FROM fullname indexed_opt where_opt",
 /* 165 */ "where_opt ::=",
 /* 166 */ "where_opt ::= WHERE expr",
 /* 167 */ "cmd ::= UPDATE orconf fullname indexed_opt SET setlist where_opt",
 /* 168 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 169 */ "setlist ::= nm EQ expr",
 /* 170 */ "cmd ::= insert_cmd INTO fullname inscollist_opt VALUES LP itemlist RP",
 /* 171 */ "cmd ::= insert_cmd INTO fullname inscollist_opt select",
 /* 172 */ "cmd ::= insert_cmd INTO fullname inscollist_opt DEFAULT VALUES",
 /* 173 */ "insert_cmd ::= INSERT orconf",
 /* 174 */ "insert_cmd ::= REPLACE",
 /* 175 */ "itemlist ::= itemlist COMMA expr",
 /* 176 */ "itemlist ::= expr",
 /* 177 */ "inscollist_opt ::=",
 /* 178 */ "inscollist_opt ::= LP inscollist RP",
 /* 179 */ "inscollist ::= inscollist COMMA nm",
 /* 180 */ "inscollist ::= nm",
 /* 181 */ "expr ::= term",
 /* 182 */ "expr ::= LP expr RP",
 /* 183 */ "term ::= NULL",
 /* 184 */ "expr ::= ID",
 /* 185 */ "expr ::= JOIN_KW",
 /* 186 */ "expr ::= nm DOT nm",
 /* 187 */ "expr ::= nm DOT nm DOT nm",
 /* 188 */ "term ::= INTEGER|FLOAT|BLOB",
 /* 189 */ "term ::= STRING",
 /* 190 */ "expr ::= REGISTER",
 /* 191 */ "expr ::= VARIABLE",
 /* 192 */ "expr ::= expr COLLATE ids",
 /* 193 */ "expr ::= CAST LP expr AS typetoken RP",
 /* 194 */ "expr ::= ID LP distinct exprlist RP",
 /* 195 */ "expr ::= ID LP STAR RP",
 /* 196 */ "term ::= CTIME_KW",
 /* 197 */ "expr ::= expr AND expr",
 /* 198 */ "expr ::= expr OR expr",
 /* 199 */ "expr ::= expr LT|GT|GE|LE expr",
 /* 200 */ "expr ::= expr EQ|NE expr",
 /* 201 */ "expr ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr",
 /* 202 */ "expr ::= expr PLUS|MINUS expr",
 /* 203 */ "expr ::= expr STAR|SLASH|REM expr",
 /* 204 */ "expr ::= expr CONCAT expr",
 /* 205 */ "likeop ::= LIKE_KW",
 /* 206 */ "likeop ::= NOT LIKE_KW",
 /* 207 */ "likeop ::= MATCH",
 /* 208 */ "likeop ::= NOT MATCH",
 /* 209 */ "escape ::= ESCAPE expr",
 /* 210 */ "escape ::=",
 /* 211 */ "expr ::= expr likeop expr escape",
 /* 212 */ "expr ::= expr ISNULL|NOTNULL",
 /* 213 */ "expr ::= expr IS NULL",
 /* 214 */ "expr ::= expr NOT NULL",
 /* 215 */ "expr ::= expr IS NOT NULL",
 /* 216 */ "expr ::= NOT expr",
 /* 217 */ "expr ::= BITNOT expr",
 /* 218 */ "expr ::= MINUS expr",
 /* 219 */ "expr ::= PLUS expr",
 /* 220 */ "between_op ::= BETWEEN",
 /* 221 */ "between_op ::= NOT BETWEEN",
 /* 222 */ "expr ::= expr between_op expr AND expr",
 /* 223 */ "in_op ::= IN",
 /* 224 */ "in_op ::= NOT IN",
 /* 225 */ "expr ::= expr in_op LP exprlist RP",
 /* 226 */ "expr ::= LP select RP",
 /* 227 */ "expr ::= expr in_op LP select RP",
 /* 228 */ "expr ::= expr in_op nm dbnm",
 /* 229 */ "expr ::= EXISTS LP select RP",
 /* 230 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 231 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 232 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 233 */ "case_else ::= ELSE expr",
 /* 234 */ "case_else ::=",
 /* 235 */ "case_operand ::= expr",
 /* 236 */ "case_operand ::=",
 /* 237 */ "exprlist ::= nexprlist",
 /* 238 */ "exprlist ::=",
 /* 239 */ "nexprlist ::= nexprlist COMMA expr",
 /* 240 */ "nexprlist ::= expr",
 /* 241 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON nm LP idxlist RP",
 /* 242 */ "uniqueflag ::= UNIQUE",
 /* 243 */ "uniqueflag ::=",
 /* 244 */ "idxlist_opt ::=",
 /* 245 */ "idxlist_opt ::= LP idxlist RP",
 /* 246 */ "idxlist ::= idxlist COMMA nm collate sortorder",
 /* 247 */ "idxlist ::= nm collate sortorder",
 /* 248 */ "collate ::=",
 /* 249 */ "collate ::= COLLATE ids",
 /* 250 */ "cmd ::= DROP INDEX ifexists fullname",
 /* 251 */ "cmd ::= VACUUM",
 /* 252 */ "cmd ::= VACUUM nm",
 /* 253 */ "cmd ::= PRAGMA nm dbnm EQ nmnum",
 /* 254 */ "cmd ::= PRAGMA nm dbnm EQ ON",
 /* 255 */ "cmd ::= PRAGMA nm dbnm EQ DELETE",
 /* 256 */ "cmd ::= PRAGMA nm dbnm EQ minus_num",
 /* 257 */ "cmd ::= PRAGMA nm dbnm LP nmnum RP",
 /* 258 */ "cmd ::= PRAGMA nm dbnm",
 /* 259 */ "nmnum ::= plus_num",
 /* 260 */ "nmnum ::= nm",
 /* 261 */ "plus_num ::= plus_opt number",
 /* 262 */ "minus_num ::= MINUS number",
 /* 263 */ "number ::= INTEGER|FLOAT",
 /* 264 */ "plus_opt ::= PLUS",
 /* 265 */ "plus_opt ::=",
 /* 266 */ "cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END",
 /* 267 */ "trigger_decl ::= temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON fullname foreach_clause when_clause",
 /* 268 */ "trigger_time ::= BEFORE",
 /* 269 */ "trigger_time ::= AFTER",
 /* 270 */ "trigger_time ::= INSTEAD OF",
 /* 271 */ "trigger_time ::=",
 /* 272 */ "trigger_event ::= DELETE|INSERT",
 /* 273 */ "trigger_event ::= UPDATE",
 /* 274 */ "trigger_event ::= UPDATE OF inscollist",
 /* 275 */ "foreach_clause ::=",
 /* 276 */ "foreach_clause ::= FOR EACH ROW",
 /* 277 */ "when_clause ::=",
 /* 278 */ "when_clause ::= WHEN expr",
 /* 279 */ "trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI",
 /* 280 */ "trigger_cmd_list ::= trigger_cmd SEMI",
 /* 281 */ "trigger_cmd ::= UPDATE orconf nm SET setlist where_opt",
 /* 282 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP",
 /* 283 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt select",
 /* 284 */ "trigger_cmd ::= DELETE FROM nm where_opt",
 /* 285 */ "trigger_cmd ::= select",
 /* 286 */ "expr ::= RAISE LP IGNORE RP",
 /* 287 */ "expr ::= RAISE LP raisetype COMMA nm RP",
 /* 288 */ "raisetype ::= ROLLBACK",
 /* 289 */ "raisetype ::= ABORT",
 /* 290 */ "raisetype ::= FAIL",
 /* 291 */ "cmd ::= DROP TRIGGER ifexists fullname",
 /* 292 */ "cmd ::= ATTACH database_kw_opt expr AS expr key_opt",
 /* 293 */ "cmd ::= DETACH database_kw_opt expr",
 /* 294 */ "key_opt ::=",
 /* 295 */ "key_opt ::= KEY expr",
 /* 296 */ "database_kw_opt ::= DATABASE",
 /* 297 */ "database_kw_opt ::=",
 /* 298 */ "cmd ::= REINDEX",
 /* 299 */ "cmd ::= REINDEX nm dbnm",
 /* 300 */ "cmd ::= ANALYZE",
 /* 301 */ "cmd ::= ANALYZE nm dbnm",
 /* 302 */ "cmd ::= ALTER TABLE fullname RENAME TO nm",
 /* 303 */ "cmd ::= ALTER TABLE add_column_fullname ADD kwcolumn_opt column",
 /* 304 */ "add_column_fullname ::= fullname",
 /* 305 */ "kwcolumn_opt ::=",
 /* 306 */ "kwcolumn_opt ::= COLUMNKW",
 /* 307 */ "cmd ::= create_vtab",
 /* 308 */ "cmd ::= create_vtab LP vtabarglist RP",
 /* 309 */ "create_vtab ::= CREATE VIRTUAL TABLE nm dbnm USING nm",
 /* 310 */ "vtabarglist ::= vtabarg",
 /* 311 */ "vtabarglist ::= vtabarglist COMMA vtabarg",
 /* 312 */ "vtabarg ::=",
 /* 313 */ "vtabarg ::= vtabarg vtabargtoken",
 /* 314 */ "vtabargtoken ::= ANY",
 /* 315 */ "vtabargtoken ::= lp anylist RP",
 /* 316 */ "lp ::= LP",
 /* 317 */ "anylist ::=",
 /* 318 */ "anylist ::= anylist ANY",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.
*/
static void yyGrowStack(yyParser *p){
  int newSize;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  if( pNew ){
    p->yystack = pNew;
    p->yystksz = newSize;
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows to %d entries!\n",
              yyTracePrompt, p->yystksz);
    }
#endif
  }
}
#endif

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite3Parser and sqlite3ParserFree.
*/
void *sqlite3ParserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
#ifdef YYTRACKMAXSTACKDEPTH
    pParser->yyidxMax = 0;
#endif
#if YYSTACKDEPTH<=0
    pParser->yystack = NULL;
    pParser->yystksz = 0;
    yyGrowStack(pParser);
#endif
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  sqlite3ParserARG_FETCH;
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 159: /* select */
    case 193: /* oneselect */
{
#line 384 "parse.y"
sqlite3SelectDelete(pParse->db, (yypminor->yy159));
#line 1312 "parse.c"
}
      break;
    case 173: /* term */
    case 174: /* expr */
    case 198: /* where_opt */
    case 200: /* having_opt */
    case 209: /* on_opt */
    case 214: /* sortitem */
    case 222: /* escape */
    case 225: /* case_operand */
    case 227: /* case_else */
    case 238: /* when_clause */
    case 241: /* key_opt */
{
#line 695 "parse.y"
sqlite3ExprDelete(pParse->db, (yypminor->yy122));
#line 1329 "parse.c"
}
      break;
    case 178: /* idxlist_opt */
    case 186: /* idxlist */
    case 196: /* selcollist */
    case 199: /* groupby_opt */
    case 201: /* orderby_opt */
    case 203: /* sclp */
    case 213: /* sortlist */
    case 215: /* nexprlist */
    case 216: /* setlist */
    case 219: /* itemlist */
    case 220: /* exprlist */
    case 226: /* case_exprlist */
{
#line 953 "parse.y"
sqlite3ExprListDelete(pParse->db, (yypminor->yy442));
#line 1347 "parse.c"
}
      break;
    case 192: /* fullname */
    case 197: /* from */
    case 205: /* seltablist */
    case 206: /* stl_prefix */
{
#line 513 "parse.y"
sqlite3SrcListDelete(pParse->db, (yypminor->yy347));
#line 1357 "parse.c"
}
      break;
    case 210: /* using_opt */
    case 212: /* inscollist */
    case 218: /* inscollist_opt */
{
#line 545 "parse.y"
sqlite3IdListDelete(pParse->db, (yypminor->yy180));
#line 1366 "parse.c"
}
      break;
    case 234: /* trigger_cmd_list */
    case 239: /* trigger_cmd */
{
#line 1057 "parse.y"
sqlite3DeleteTriggerStep(pParse->db, (yypminor->yy327));
#line 1374 "parse.c"
}
      break;
    case 236: /* trigger_event */
{
#line 1043 "parse.y"
sqlite3IdListDelete(pParse->db, (yypminor->yy410).b);
#line 1381 "parse.c"
}
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor(pParser, yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite3ParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite3ParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  free(pParser->yystack);
#endif
  (*freeProc)((void*)pParser);
}

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int sqlite3ParserStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyidxMax;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  if( stateno>YY_SHIFT_MAX || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( j>=0 && j<YY_SZ_ACTTAB && yy_lookahead[j]==YYWILDCARD ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_MAX ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_MAX );
#endif
  i = yy_reduce_ofst[stateno];
  assert( i!=YY_REDUCE_USE_DFLT );
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_SZ_ACTTAB );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser, YYMINORTYPE *yypMinor){
   sqlite3ParserARG_FETCH;
   yypParser->yyidx--;
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
#line 40 "parse.y"

  UNUSED_PARAMETER(yypMinor); /* Silence some compiler warnings */
  sqlite3ErrorMsg(pParse, "parser stack overflow");
  pParse->parseError = 1;
#line 1559 "parse.c"
   sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument var */
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer to the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( yypParser->yyidx>yypParser->yyidxMax ){
    yypParser->yyidxMax = yypParser->yyidx;
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yyidx>=YYSTACKDEPTH ){
    yyStackOverflow(yypParser, yypMinor);
    return;
  }
#else
  if( yypParser->yyidx>=yypParser->yystksz ){
    yyGrowStack(yypParser);
    if( yypParser->yyidx>=yypParser->yystksz ){
      yyStackOverflow(yypParser, yypMinor);
      return;
    }
  }
#endif
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = (YYACTIONTYPE)yyNewState;
  yytos->major = (YYCODETYPE)yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 142, 1 },
  { 143, 2 },
  { 143, 1 },
  { 144, 1 },
  { 144, 3 },
  { 145, 0 },
  { 145, 1 },
  { 145, 3 },
  { 146, 1 },
  { 147, 3 },
  { 149, 0 },
  { 149, 1 },
  { 149, 2 },
  { 148, 0 },
  { 148, 1 },
  { 148, 1 },
  { 148, 1 },
  { 147, 2 },
  { 147, 2 },
  { 147, 2 },
  { 151, 1 },
  { 151, 0 },
  { 147, 2 },
  { 147, 3 },
  { 147, 5 },
  { 147, 2 },
  { 152, 6 },
  { 155, 0 },
  { 155, 3 },
  { 154, 1 },
  { 154, 0 },
  { 153, 4 },
  { 153, 2 },
  { 157, 3 },
  { 157, 1 },
  { 160, 3 },
  { 161, 1 },
  { 164, 1 },
  { 165, 1 },
  { 150, 1 },
  { 150, 1 },
  { 150, 1 },
  { 162, 0 },
  { 162, 1 },
  { 166, 1 },
  { 166, 4 },
  { 166, 6 },
  { 167, 1 },
  { 167, 2 },
  { 168, 1 },
  { 168, 1 },
  { 163, 2 },
  { 163, 0 },
  { 171, 3 },
  { 171, 1 },
  { 172, 2 },
  { 172, 4 },
  { 172, 3 },
  { 172, 3 },
  { 172, 2 },
  { 172, 2 },
  { 172, 3 },
  { 172, 5 },
  { 172, 2 },
  { 172, 4 },
  { 172, 4 },
  { 172, 1 },
  { 172, 2 },
  { 177, 0 },
  { 177, 1 },
  { 179, 0 },
  { 179, 2 },
  { 181, 2 },
  { 181, 3 },
  { 181, 3 },
  { 181, 3 },
  { 182, 2 },
  { 182, 2 },
  { 182, 1 },
  { 182, 1 },
  { 180, 3 },
  { 180, 2 },
  { 183, 0 },
  { 183, 2 },
  { 183, 2 },
  { 158, 0 },
  { 158, 2 },
  { 184, 3 },
  { 184, 2 },
  { 184, 1 },
  { 185, 2 },
  { 185, 7 },
  { 185, 5 },
  { 185, 5 },
  { 185, 10 },
  { 187, 0 },
  { 187, 1 },
  { 175, 0 },
  { 175, 3 },
  { 188, 0 },
  { 188, 2 },
  { 189, 1 },
  { 189, 1 },
  { 189, 1 },
  { 147, 4 },
  { 191, 2 },
  { 191, 0 },
  { 147, 8 },
  { 147, 4 },
  { 147, 1 },
  { 159, 1 },
  { 159, 3 },
  { 194, 1 },
  { 194, 2 },
  { 194, 1 },
  { 193, 9 },
  { 195, 1 },
  { 195, 1 },
  { 195, 0 },
  { 203, 2 },
  { 203, 0 },
  { 196, 3 },
  { 196, 2 },
  { 196, 4 },
  { 204, 2 },
  { 204, 1 },
  { 204, 0 },
  { 197, 0 },
  { 197, 2 },
  { 206, 2 },
  { 206, 0 },
  { 205, 7 },
  { 205, 7 },
  { 205, 7 },
  { 156, 0 },
  { 156, 2 },
  { 192, 2 },
  { 207, 1 },
  { 207, 2 },
  { 207, 3 },
  { 207, 4 },
  { 209, 2 },
  { 209, 0 },
  { 208, 0 },
  { 208, 3 },
  { 208, 2 },
  { 210, 4 },
  { 210, 0 },
  { 201, 0 },
  { 201, 3 },
  { 213, 4 },
  { 213, 2 },
  { 214, 1 },
  { 176, 1 },
  { 176, 1 },
  { 176, 0 },
  { 199, 0 },
  { 199, 3 },
  { 200, 0 },
  { 200, 2 },
  { 202, 0 },
  { 202, 2 },
  { 202, 4 },
  { 202, 4 },
  { 147, 5 },
  { 198, 0 },
  { 198, 2 },
  { 147, 7 },
  { 216, 5 },
  { 216, 3 },
  { 147, 8 },
  { 147, 5 },
  { 147, 6 },
  { 217, 2 },
  { 217, 1 },
  { 219, 3 },
  { 219, 1 },
  { 218, 0 },
  { 218, 3 },
  { 212, 3 },
  { 212, 1 },
  { 174, 1 },
  { 174, 3 },
  { 173, 1 },
  { 174, 1 },
  { 174, 1 },
  { 174, 3 },
  { 174, 5 },
  { 173, 1 },
  { 173, 1 },
  { 174, 1 },
  { 174, 1 },
  { 174, 3 },
  { 174, 6 },
  { 174, 5 },
  { 174, 4 },
  { 173, 1 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 221, 1 },
  { 221, 2 },
  { 221, 1 },
  { 221, 2 },
  { 222, 2 },
  { 222, 0 },
  { 174, 4 },
  { 174, 2 },
  { 174, 3 },
  { 174, 3 },
  { 174, 4 },
  { 174, 2 },
  { 174, 2 },
  { 174, 2 },
  { 174, 2 },
  { 223, 1 },
  { 223, 2 },
  { 174, 5 },
  { 224, 1 },
  { 224, 2 },
  { 174, 5 },
  { 174, 3 },
  { 174, 5 },
  { 174, 4 },
  { 174, 4 },
  { 174, 5 },
  { 226, 5 },
  { 226, 4 },
  { 227, 2 },
  { 227, 0 },
  { 225, 1 },
  { 225, 0 },
  { 220, 1 },
  { 220, 0 },
  { 215, 3 },
  { 215, 1 },
  { 147, 11 },
  { 228, 1 },
  { 228, 0 },
  { 178, 0 },
  { 178, 3 },
  { 186, 5 },
  { 186, 3 },
  { 229, 0 },
  { 229, 2 },
  { 147, 4 },
  { 147, 1 },
  { 147, 2 },
  { 147, 5 },
  { 147, 5 },
  { 147, 5 },
  { 147, 5 },
  { 147, 6 },
  { 147, 3 },
  { 230, 1 },
  { 230, 1 },
  { 169, 2 },
  { 170, 2 },
  { 232, 1 },
  { 231, 1 },
  { 231, 0 },
  { 147, 5 },
  { 233, 11 },
  { 235, 1 },
  { 235, 1 },
  { 235, 2 },
  { 235, 0 },
  { 236, 1 },
  { 236, 1 },
  { 236, 3 },
  { 237, 0 },
  { 237, 3 },
  { 238, 0 },
  { 238, 2 },
  { 234, 3 },
  { 234, 2 },
  { 239, 6 },
  { 239, 8 },
  { 239, 5 },
  { 239, 4 },
  { 239, 1 },
  { 174, 4 },
  { 174, 6 },
  { 190, 1 },
  { 190, 1 },
  { 190, 1 },
  { 147, 4 },
  { 147, 6 },
  { 147, 3 },
  { 241, 0 },
  { 241, 2 },
  { 240, 1 },
  { 240, 0 },
  { 147, 1 },
  { 147, 3 },
  { 147, 1 },
  { 147, 3 },
  { 147, 6 },
  { 147, 6 },
  { 242, 1 },
  { 243, 0 },
  { 243, 1 },
  { 147, 1 },
  { 147, 4 },
  { 244, 7 },
  { 245, 1 },
  { 245, 3 },
  { 246, 0 },
  { 246, 2 },
  { 247, 1 },
  { 247, 3 },
  { 248, 1 },
  { 249, 0 },
  { 249, 2 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite3ParserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  **
  ** 2007-01-16:  The wireshark project (www.wireshark.org) reports that
  ** without this code, their parser segfaults.  I'm not sure what there
  ** parser is doing to make this happen.  This is the second bug report
  ** from wireshark this week.  Clearly they are stressing Lemon in ways
  ** that it has not been previously stressed...  (SQLite ticket #2172)
  */
  /*memset(&yygotominor, 0, sizeof(yygotominor));*/
  yygotominor = yyzerominor;


  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 0: /* input ::= cmdlist */
      case 1: /* cmdlist ::= cmdlist ecmd */
      case 2: /* cmdlist ::= ecmd */
      case 3: /* ecmd ::= SEMI */
      case 4: /* ecmd ::= explain cmdx SEMI */
      case 10: /* trans_opt ::= */
      case 11: /* trans_opt ::= TRANSACTION */
      case 12: /* trans_opt ::= TRANSACTION nm */
      case 20: /* savepoint_opt ::= SAVEPOINT */
      case 21: /* savepoint_opt ::= */
      case 25: /* cmd ::= create_table create_table_args */
      case 33: /* columnlist ::= columnlist COMMA column */
      case 34: /* columnlist ::= column */
      case 42: /* type ::= */
      case 49: /* signed ::= plus_num */
      case 50: /* signed ::= minus_num */
      case 51: /* carglist ::= carglist carg */
      case 52: /* carglist ::= */
      case 53: /* carg ::= CONSTRAINT nm ccons */
      case 54: /* carg ::= ccons */
      case 60: /* ccons ::= NULL onconf */
      case 87: /* conslist ::= conslist COMMA tcons */
      case 88: /* conslist ::= conslist tcons */
      case 89: /* conslist ::= tcons */
      case 90: /* tcons ::= CONSTRAINT nm */
      case 264: /* plus_opt ::= PLUS */
      case 265: /* plus_opt ::= */
      case 275: /* foreach_clause ::= */
      case 276: /* foreach_clause ::= FOR EACH ROW */
      case 296: /* database_kw_opt ::= DATABASE */
      case 297: /* database_kw_opt ::= */
      case 305: /* kwcolumn_opt ::= */
      case 306: /* kwcolumn_opt ::= COLUMNKW */
      case 310: /* vtabarglist ::= vtabarg */
      case 311: /* vtabarglist ::= vtabarglist COMMA vtabarg */
      case 313: /* vtabarg ::= vtabarg vtabargtoken */
      case 317: /* anylist ::= */
#line 93 "parse.y"
{
}
#line 2029 "parse.c"
        break;
      case 5: /* explain ::= */
#line 98 "parse.y"
{ sqlite3BeginParse(pParse, 0); }
#line 2034 "parse.c"
        break;
      case 6: /* explain ::= EXPLAIN */
#line 100 "parse.y"
{ sqlite3BeginParse(pParse, 1); }
#line 2039 "parse.c"
        break;
      case 7: /* explain ::= EXPLAIN QUERY PLAN */
#line 101 "parse.y"
{ sqlite3BeginParse(pParse, 2); }
#line 2044 "parse.c"
        break;
      case 8: /* cmdx ::= cmd */
#line 103 "parse.y"
{ sqlite3FinishCoding(pParse); }
#line 2049 "parse.c"
        break;
      case 9: /* cmd ::= BEGIN transtype trans_opt */
#line 108 "parse.y"
{sqlite3BeginTransaction(pParse, yymsp[-1].minor.yy392);}
#line 2054 "parse.c"
        break;
      case 13: /* transtype ::= */
#line 113 "parse.y"
{yygotominor.yy392 = TK_DEFERRED;}
#line 2059 "parse.c"
        break;
      case 14: /* transtype ::= DEFERRED */
      case 15: /* transtype ::= IMMEDIATE */
      case 16: /* transtype ::= EXCLUSIVE */
      case 112: /* multiselect_op ::= UNION */
      case 114: /* multiselect_op ::= EXCEPT|INTERSECT */
#line 114 "parse.y"
{yygotominor.yy392 = yymsp[0].major;}
#line 2068 "parse.c"
        break;
      case 17: /* cmd ::= COMMIT trans_opt */
      case 18: /* cmd ::= END trans_opt */
#line 117 "parse.y"
{sqlite3CommitTransaction(pParse);}
#line 2074 "parse.c"
        break;
      case 19: /* cmd ::= ROLLBACK trans_opt */
#line 119 "parse.y"
{sqlite3RollbackTransaction(pParse);}
#line 2079 "parse.c"
        break;
      case 22: /* cmd ::= SAVEPOINT nm */
#line 123 "parse.y"
{
  sqlite3Savepoint(pParse, SAVEPOINT_BEGIN, &yymsp[0].minor.yy0);
}
#line 2086 "parse.c"
        break;
      case 23: /* cmd ::= RELEASE savepoint_opt nm */
#line 126 "parse.y"
{
  sqlite3Savepoint(pParse, SAVEPOINT_RELEASE, &yymsp[0].minor.yy0);
}
#line 2093 "parse.c"
        break;
      case 24: /* cmd ::= ROLLBACK trans_opt TO savepoint_opt nm */
#line 129 "parse.y"
{
  sqlite3Savepoint(pParse, SAVEPOINT_ROLLBACK, &yymsp[0].minor.yy0);
}
#line 2100 "parse.c"
        break;
      case 26: /* create_table ::= CREATE temp TABLE ifnotexists nm dbnm */
#line 136 "parse.y"
{
   sqlite3StartTable(pParse,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy0,yymsp[-4].minor.yy392,0,0,yymsp[-2].minor.yy392);
}
#line 2107 "parse.c"
        break;
      case 27: /* ifnotexists ::= */
      case 30: /* temp ::= */
      case 68: /* autoinc ::= */
      case 82: /* init_deferred_pred_opt ::= */
      case 84: /* init_deferred_pred_opt ::= INITIALLY IMMEDIATE */
      case 95: /* defer_subclause_opt ::= */
      case 106: /* ifexists ::= */
      case 117: /* distinct ::= ALL */
      case 118: /* distinct ::= */
      case 220: /* between_op ::= BETWEEN */
      case 223: /* in_op ::= IN */
#line 140 "parse.y"
{yygotominor.yy392 = 0;}
#line 2122 "parse.c"
        break;
      case 28: /* ifnotexists ::= IF NOT EXISTS */
      case 29: /* temp ::= TEMP */
      case 69: /* autoinc ::= AUTOINCR */
      case 83: /* init_deferred_pred_opt ::= INITIALLY DEFERRED */
      case 105: /* ifexists ::= IF EXISTS */
      case 116: /* distinct ::= DISTINCT */
      case 221: /* between_op ::= NOT BETWEEN */
      case 224: /* in_op ::= NOT IN */
#line 141 "parse.y"
{yygotominor.yy392 = 1;}
#line 2134 "parse.c"
        break;
      case 31: /* create_table_args ::= LP columnlist conslist_opt RP */
#line 147 "parse.y"
{
  sqlite3EndTable(pParse,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy0,0);
}
#line 2141 "parse.c"
        break;
      case 32: /* create_table_args ::= AS select */
#line 150 "parse.y"
{
  sqlite3EndTable(pParse,0,0,yymsp[0].minor.yy159);
  sqlite3SelectDelete(pParse->db, yymsp[0].minor.yy159);
}
#line 2149 "parse.c"
        break;
      case 35: /* column ::= columnid type carglist */
#line 162 "parse.y"
{
  yygotominor.yy0.z = yymsp[-2].minor.yy0.z;
  yygotominor.yy0.n = (int)(pParse->sLastToken.z-yymsp[-2].minor.yy0.z) + pParse->sLastToken.n;
}
#line 2157 "parse.c"
        break;
      case 36: /* columnid ::= nm */
#line 166 "parse.y"
{
  sqlite3AddColumn(pParse,&yymsp[0].minor.yy0);
  yygotominor.yy0 = yymsp[0].minor.yy0;
}
#line 2165 "parse.c"
        break;
      case 37: /* id ::= ID */
      case 38: /* ids ::= ID|STRING */
      case 39: /* nm ::= ID */
      case 40: /* nm ::= STRING */
      case 41: /* nm ::= JOIN_KW */
      case 44: /* typetoken ::= typename */
      case 47: /* typename ::= ids */
      case 124: /* as ::= AS nm */
      case 125: /* as ::= ids */
      case 135: /* dbnm ::= DOT nm */
      case 144: /* indexed_opt ::= INDEXED BY nm */
      case 249: /* collate ::= COLLATE ids */
      case 259: /* nmnum ::= plus_num */
      case 260: /* nmnum ::= nm */
      case 261: /* plus_num ::= plus_opt number */
      case 262: /* minus_num ::= MINUS number */
      case 263: /* number ::= INTEGER|FLOAT */
#line 176 "parse.y"
{yygotominor.yy0 = yymsp[0].minor.yy0;}
#line 2186 "parse.c"
        break;
      case 43: /* type ::= typetoken */
#line 237 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[0].minor.yy0);}
#line 2191 "parse.c"
        break;
      case 45: /* typetoken ::= typename LP signed RP */
#line 239 "parse.y"
{
  yygotominor.yy0.z = yymsp[-3].minor.yy0.z;
  yygotominor.yy0.n = (int)(&yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-3].minor.yy0.z);
}
#line 2199 "parse.c"
        break;
      case 46: /* typetoken ::= typename LP signed COMMA signed RP */
#line 243 "parse.y"
{
  yygotominor.yy0.z = yymsp[-5].minor.yy0.z;
  yygotominor.yy0.n = (int)(&yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-5].minor.yy0.z);
}
#line 2207 "parse.c"
        break;
      case 48: /* typename ::= typename ids */
#line 249 "parse.y"
{yygotominor.yy0.z=yymsp[-1].minor.yy0.z; yygotominor.yy0.n=yymsp[0].minor.yy0.n+(int)(yymsp[0].minor.yy0.z-yymsp[-1].minor.yy0.z);}
#line 2212 "parse.c"
        break;
      case 55: /* ccons ::= DEFAULT term */
      case 57: /* ccons ::= DEFAULT PLUS term */
#line 260 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[0].minor.yy122);}
#line 2218 "parse.c"
        break;
      case 56: /* ccons ::= DEFAULT LP expr RP */
#line 261 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[-1].minor.yy122);}
#line 2223 "parse.c"
        break;
      case 58: /* ccons ::= DEFAULT MINUS term */
#line 263 "parse.y"
{
  Expr *p = sqlite3PExpr(pParse, TK_UMINUS, yymsp[0].minor.yy122, 0, 0);
  sqlite3ExprSpan(p,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy122->span);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2232 "parse.c"
        break;
      case 59: /* ccons ::= DEFAULT id */
#line 268 "parse.y"
{
  Expr *p = sqlite3PExpr(pParse, TK_STRING, 0, 0, &yymsp[0].minor.yy0);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2240 "parse.c"
        break;
      case 61: /* ccons ::= NOT NULL onconf */
#line 277 "parse.y"
{sqlite3AddNotNull(pParse, yymsp[0].minor.yy392);}
#line 2245 "parse.c"
        break;
      case 62: /* ccons ::= PRIMARY KEY sortorder onconf autoinc */
#line 279 "parse.y"
{sqlite3AddPrimaryKey(pParse,0,yymsp[-1].minor.yy392,yymsp[0].minor.yy392,yymsp[-2].minor.yy392);}
#line 2250 "parse.c"
        break;
      case 63: /* ccons ::= UNIQUE onconf */
#line 280 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,0,yymsp[0].minor.yy392,0,0,0,0);}
#line 2255 "parse.c"
        break;
      case 64: /* ccons ::= CHECK LP expr RP */
#line 281 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-1].minor.yy122);}
#line 2260 "parse.c"
        break;
      case 65: /* ccons ::= REFERENCES nm idxlist_opt refargs */
#line 283 "parse.y"
{sqlite3CreateForeignKey(pParse,0,&yymsp[-2].minor.yy0,yymsp[-1].minor.yy442,yymsp[0].minor.yy392);}
#line 2265 "parse.c"
        break;
      case 66: /* ccons ::= defer_subclause */
#line 284 "parse.y"
{sqlite3DeferForeignKey(pParse,yymsp[0].minor.yy392);}
#line 2270 "parse.c"
        break;
      case 67: /* ccons ::= COLLATE ids */
#line 285 "parse.y"
{sqlite3AddCollateType(pParse, &yymsp[0].minor.yy0);}
#line 2275 "parse.c"
        break;
      case 70: /* refargs ::= */
#line 298 "parse.y"
{ yygotominor.yy392 = OE_Restrict * 0x010101; }
#line 2280 "parse.c"
        break;
      case 71: /* refargs ::= refargs refarg */
#line 299 "parse.y"
{ yygotominor.yy392 = (yymsp[-1].minor.yy392 & ~yymsp[0].minor.yy207.mask) | yymsp[0].minor.yy207.value; }
#line 2285 "parse.c"
        break;
      case 72: /* refarg ::= MATCH nm */
#line 301 "parse.y"
{ yygotominor.yy207.value = 0;     yygotominor.yy207.mask = 0x000000; }
#line 2290 "parse.c"
        break;
      case 73: /* refarg ::= ON DELETE refact */
#line 302 "parse.y"
{ yygotominor.yy207.value = yymsp[0].minor.yy392;     yygotominor.yy207.mask = 0x0000ff; }
#line 2295 "parse.c"
        break;
      case 74: /* refarg ::= ON UPDATE refact */
#line 303 "parse.y"
{ yygotominor.yy207.value = yymsp[0].minor.yy392<<8;  yygotominor.yy207.mask = 0x00ff00; }
#line 2300 "parse.c"
        break;
      case 75: /* refarg ::= ON INSERT refact */
#line 304 "parse.y"
{ yygotominor.yy207.value = yymsp[0].minor.yy392<<16; yygotominor.yy207.mask = 0xff0000; }
#line 2305 "parse.c"
        break;
      case 76: /* refact ::= SET NULL */
#line 306 "parse.y"
{ yygotominor.yy392 = OE_SetNull; }
#line 2310 "parse.c"
        break;
      case 77: /* refact ::= SET DEFAULT */
#line 307 "parse.y"
{ yygotominor.yy392 = OE_SetDflt; }
#line 2315 "parse.c"
        break;
      case 78: /* refact ::= CASCADE */
#line 308 "parse.y"
{ yygotominor.yy392 = OE_Cascade; }
#line 2320 "parse.c"
        break;
      case 79: /* refact ::= RESTRICT */
#line 309 "parse.y"
{ yygotominor.yy392 = OE_Restrict; }
#line 2325 "parse.c"
        break;
      case 80: /* defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt */
      case 81: /* defer_subclause ::= DEFERRABLE init_deferred_pred_opt */
      case 96: /* defer_subclause_opt ::= defer_subclause */
      case 98: /* onconf ::= ON CONFLICT resolvetype */
      case 100: /* orconf ::= OR resolvetype */
      case 101: /* resolvetype ::= raisetype */
      case 173: /* insert_cmd ::= INSERT orconf */
#line 311 "parse.y"
{yygotominor.yy392 = yymsp[0].minor.yy392;}
#line 2336 "parse.c"
        break;
      case 85: /* conslist_opt ::= */
#line 321 "parse.y"
{yygotominor.yy0.n = 0; yygotominor.yy0.z = 0;}
#line 2341 "parse.c"
        break;
      case 86: /* conslist_opt ::= COMMA conslist */
#line 322 "parse.y"
{yygotominor.yy0 = yymsp[-1].minor.yy0;}
#line 2346 "parse.c"
        break;
      case 91: /* tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf */
#line 328 "parse.y"
{sqlite3AddPrimaryKey(pParse,yymsp[-3].minor.yy442,yymsp[0].minor.yy392,yymsp[-2].minor.yy392,0);}
#line 2351 "parse.c"
        break;
      case 92: /* tcons ::= UNIQUE LP idxlist RP onconf */
#line 330 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,yymsp[-2].minor.yy442,yymsp[0].minor.yy392,0,0,0,0);}
#line 2356 "parse.c"
        break;
      case 93: /* tcons ::= CHECK LP expr RP onconf */
#line 331 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-2].minor.yy122);}
#line 2361 "parse.c"
        break;
      case 94: /* tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt */
#line 333 "parse.y"
{
    sqlite3CreateForeignKey(pParse, yymsp[-6].minor.yy442, &yymsp[-3].minor.yy0, yymsp[-2].minor.yy442, yymsp[-1].minor.yy392);
    sqlite3DeferForeignKey(pParse, yymsp[0].minor.yy392);
}
#line 2369 "parse.c"
        break;
      case 97: /* onconf ::= */
      case 99: /* orconf ::= */
#line 347 "parse.y"
{yygotominor.yy392 = OE_Default;}
#line 2375 "parse.c"
        break;
      case 102: /* resolvetype ::= IGNORE */
#line 352 "parse.y"
{yygotominor.yy392 = OE_Ignore;}
#line 2380 "parse.c"
        break;
      case 103: /* resolvetype ::= REPLACE */
      case 174: /* insert_cmd ::= REPLACE */
#line 353 "parse.y"
{yygotominor.yy392 = OE_Replace;}
#line 2386 "parse.c"
        break;
      case 104: /* cmd ::= DROP TABLE ifexists fullname */
#line 357 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy347, 0, yymsp[-1].minor.yy392);
}
#line 2393 "parse.c"
        break;
      case 107: /* cmd ::= CREATE temp VIEW ifnotexists nm dbnm AS select */
#line 367 "parse.y"
{
  sqlite3CreateView(pParse, &yymsp[-7].minor.yy0, &yymsp[-3].minor.yy0, &yymsp[-2].minor.yy0, yymsp[0].minor.yy159, yymsp[-6].minor.yy392, yymsp[-4].minor.yy392);
}
#line 2400 "parse.c"
        break;
      case 108: /* cmd ::= DROP VIEW ifexists fullname */
#line 370 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy347, 1, yymsp[-1].minor.yy392);
}
#line 2407 "parse.c"
        break;
      case 109: /* cmd ::= select */
#line 377 "parse.y"
{
  SelectDest dest = {SRT_Output, 0, 0, 0, 0};
  sqlite3Select(pParse, yymsp[0].minor.yy159, &dest);
  sqlite3SelectDelete(pParse->db, yymsp[0].minor.yy159);
}
#line 2416 "parse.c"
        break;
      case 110: /* select ::= oneselect */
#line 388 "parse.y"
{yygotominor.yy159 = yymsp[0].minor.yy159;}
#line 2421 "parse.c"
        break;
      case 111: /* select ::= select multiselect_op oneselect */
#line 390 "parse.y"
{
  if( yymsp[0].minor.yy159 ){
    yymsp[0].minor.yy159->op = (u8)yymsp[-1].minor.yy392;
    yymsp[0].minor.yy159->pPrior = yymsp[-2].minor.yy159;
  }else{
    sqlite3SelectDelete(pParse->db, yymsp[-2].minor.yy159);
  }
  yygotominor.yy159 = yymsp[0].minor.yy159;
}
#line 2434 "parse.c"
        break;
      case 113: /* multiselect_op ::= UNION ALL */
#line 401 "parse.y"
{yygotominor.yy392 = TK_ALL;}
#line 2439 "parse.c"
        break;
      case 115: /* oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt */
#line 405 "parse.y"
{
  yygotominor.yy159 = sqlite3SelectNew(pParse,yymsp[-6].minor.yy442,yymsp[-5].minor.yy347,yymsp[-4].minor.yy122,yymsp[-3].minor.yy442,yymsp[-2].minor.yy122,yymsp[-1].minor.yy442,yymsp[-7].minor.yy392,yymsp[0].minor.yy64.pLimit,yymsp[0].minor.yy64.pOffset);
}
#line 2446 "parse.c"
        break;
      case 119: /* sclp ::= selcollist COMMA */
      case 245: /* idxlist_opt ::= LP idxlist RP */
#line 426 "parse.y"
{yygotominor.yy442 = yymsp[-1].minor.yy442;}
#line 2452 "parse.c"
        break;
      case 120: /* sclp ::= */
      case 148: /* orderby_opt ::= */
      case 156: /* groupby_opt ::= */
      case 238: /* exprlist ::= */
      case 244: /* idxlist_opt ::= */
#line 427 "parse.y"
{yygotominor.yy442 = 0;}
#line 2461 "parse.c"
        break;
      case 121: /* selcollist ::= sclp expr as */
#line 428 "parse.y"
{
   yygotominor.yy442 = sqlite3ExprListAppend(pParse,yymsp[-2].minor.yy442,yymsp[-1].minor.yy122,yymsp[0].minor.yy0.n?&yymsp[0].minor.yy0:0);
}
#line 2468 "parse.c"
        break;
      case 122: /* selcollist ::= sclp STAR */
#line 431 "parse.y"
{
  Expr *p = sqlite3PExpr(pParse, TK_ALL, 0, 0, 0);
  yygotominor.yy442 = sqlite3ExprListAppend(pParse, yymsp[-1].minor.yy442, p, 0);
}
#line 2476 "parse.c"
        break;
      case 123: /* selcollist ::= sclp nm DOT STAR */
#line 435 "parse.y"
{
  Expr *pRight = sqlite3PExpr(pParse, TK_ALL, 0, 0, &yymsp[0].minor.yy0);
  Expr *pLeft = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[-2].minor.yy0);
  Expr *pDot = sqlite3PExpr(pParse, TK_DOT, pLeft, pRight, 0);
  yygotominor.yy442 = sqlite3ExprListAppend(pParse,yymsp[-3].minor.yy442, pDot, 0);
}
#line 2486 "parse.c"
        break;
      case 126: /* as ::= */
#line 448 "parse.y"
{yygotominor.yy0.n = 0;}
#line 2491 "parse.c"
        break;
      case 127: /* from ::= */
#line 460 "parse.y"
{yygotominor.yy347 = sqlite3DbMallocZero(pParse->db, sizeof(*yygotominor.yy347));}
#line 2496 "parse.c"
        break;
      case 128: /* from ::= FROM seltablist */
#line 461 "parse.y"
{
  yygotominor.yy347 = yymsp[0].minor.yy347;
  sqlite3SrcListShiftJoinType(yygotominor.yy347);
}
#line 2504 "parse.c"
        break;
      case 129: /* stl_prefix ::= seltablist joinop */
#line 469 "parse.y"
{
   yygotominor.yy347 = yymsp[-1].minor.yy347;
   if( yygotominor.yy347 && yygotominor.yy347->nSrc>0 ) yygotominor.yy347->a[yygotominor.yy347->nSrc-1].jointype = (u8)yymsp[0].minor.yy392;
}
#line 2512 "parse.c"
        break;
      case 130: /* stl_prefix ::= */
#line 473 "parse.y"
{yygotominor.yy347 = 0;}
#line 2517 "parse.c"
        break;
      case 131: /* seltablist ::= stl_prefix nm dbnm as indexed_opt on_opt using_opt */
#line 474 "parse.y"
{
  yygotominor.yy347 = sqlite3SrcListAppendFromTerm(pParse,yymsp[-6].minor.yy347,&yymsp[-5].minor.yy0,&yymsp[-4].minor.yy0,&yymsp[-3].minor.yy0,0,yymsp[-1].minor.yy122,yymsp[0].minor.yy180);
  sqlite3SrcListIndexedBy(pParse, yygotominor.yy347, &yymsp[-2].minor.yy0);
}
#line 2525 "parse.c"
        break;
      case 132: /* seltablist ::= stl_prefix LP select RP as on_opt using_opt */
#line 480 "parse.y"
{
    yygotominor.yy347 = sqlite3SrcListAppendFromTerm(pParse,yymsp[-6].minor.yy347,0,0,&yymsp[-2].minor.yy0,yymsp[-4].minor.yy159,yymsp[-1].minor.yy122,yymsp[0].minor.yy180);
  }
#line 2532 "parse.c"
        break;
      case 133: /* seltablist ::= stl_prefix LP seltablist RP as on_opt using_opt */
#line 484 "parse.y"
{
    if( yymsp[-6].minor.yy347==0 && yymsp[-2].minor.yy0.n==0 && yymsp[-1].minor.yy122==0 && yymsp[0].minor.yy180==0 ){
      yygotominor.yy347 = yymsp[-4].minor.yy347;
    }else{
      Select *pSubquery;
      sqlite3SrcListShiftJoinType(yymsp[-4].minor.yy347);
      pSubquery = sqlite3SelectNew(pParse,0,yymsp[-4].minor.yy347,0,0,0,0,0,0,0);
      yygotominor.yy347 = sqlite3SrcListAppendFromTerm(pParse,yymsp[-6].minor.yy347,0,0,&yymsp[-2].minor.yy0,pSubquery,yymsp[-1].minor.yy122,yymsp[0].minor.yy180);
    }
  }
#line 2546 "parse.c"
        break;
      case 134: /* dbnm ::= */
      case 143: /* indexed_opt ::= */
#line 509 "parse.y"
{yygotominor.yy0.z=0; yygotominor.yy0.n=0;}
#line 2552 "parse.c"
        break;
      case 136: /* fullname ::= nm dbnm */
#line 514 "parse.y"
{yygotominor.yy347 = sqlite3SrcListAppend(pParse->db,0,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy0);}
#line 2557 "parse.c"
        break;
      case 137: /* joinop ::= COMMA|JOIN */
#line 518 "parse.y"
{ yygotominor.yy392 = JT_INNER; }
#line 2562 "parse.c"
        break;
      case 138: /* joinop ::= JOIN_KW JOIN */
#line 519 "parse.y"
{ yygotominor.yy392 = sqlite3JoinType(pParse,&yymsp[-1].minor.yy0,0,0); }
#line 2567 "parse.c"
        break;
      case 139: /* joinop ::= JOIN_KW nm JOIN */
#line 520 "parse.y"
{ yygotominor.yy392 = sqlite3JoinType(pParse,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy0,0); }
#line 2572 "parse.c"
        break;
      case 140: /* joinop ::= JOIN_KW nm nm JOIN */
#line 522 "parse.y"
{ yygotominor.yy392 = sqlite3JoinType(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy0); }
#line 2577 "parse.c"
        break;
      case 141: /* on_opt ::= ON expr */
      case 152: /* sortitem ::= expr */
      case 159: /* having_opt ::= HAVING expr */
      case 166: /* where_opt ::= WHERE expr */
      case 181: /* expr ::= term */
      case 209: /* escape ::= ESCAPE expr */
      case 233: /* case_else ::= ELSE expr */
      case 235: /* case_operand ::= expr */
#line 526 "parse.y"
{yygotominor.yy122 = yymsp[0].minor.yy122;}
#line 2589 "parse.c"
        break;
      case 142: /* on_opt ::= */
      case 158: /* having_opt ::= */
      case 165: /* where_opt ::= */
      case 210: /* escape ::= */
      case 234: /* case_else ::= */
      case 236: /* case_operand ::= */
#line 527 "parse.y"
{yygotominor.yy122 = 0;}
#line 2599 "parse.c"
        break;
      case 145: /* indexed_opt ::= NOT INDEXED */
#line 542 "parse.y"
{yygotominor.yy0.z=0; yygotominor.yy0.n=1;}
#line 2604 "parse.c"
        break;
      case 146: /* using_opt ::= USING LP inscollist RP */
      case 178: /* inscollist_opt ::= LP inscollist RP */
#line 546 "parse.y"
{yygotominor.yy180 = yymsp[-1].minor.yy180;}
#line 2610 "parse.c"
        break;
      case 147: /* using_opt ::= */
      case 177: /* inscollist_opt ::= */
#line 547 "parse.y"
{yygotominor.yy180 = 0;}
#line 2616 "parse.c"
        break;
      case 149: /* orderby_opt ::= ORDER BY sortlist */
      case 157: /* groupby_opt ::= GROUP BY nexprlist */
      case 237: /* exprlist ::= nexprlist */
#line 558 "parse.y"
{yygotominor.yy442 = yymsp[0].minor.yy442;}
#line 2623 "parse.c"
        break;
      case 150: /* sortlist ::= sortlist COMMA sortitem sortorder */
#line 559 "parse.y"
{
  yygotominor.yy442 = sqlite3ExprListAppend(pParse,yymsp[-3].minor.yy442,yymsp[-1].minor.yy122,0);
  if( yygotominor.yy442 ) yygotominor.yy442->a[yygotominor.yy442->nExpr-1].sortOrder = (u8)yymsp[0].minor.yy392;
}
#line 2631 "parse.c"
        break;
      case 151: /* sortlist ::= sortitem sortorder */
#line 563 "parse.y"
{
  yygotominor.yy442 = sqlite3ExprListAppend(pParse,0,yymsp[-1].minor.yy122,0);
  if( yygotominor.yy442 && yygotominor.yy442->a ) yygotominor.yy442->a[0].sortOrder = (u8)yymsp[0].minor.yy392;
}
#line 2639 "parse.c"
        break;
      case 153: /* sortorder ::= ASC */
      case 155: /* sortorder ::= */
#line 571 "parse.y"
{yygotominor.yy392 = SQLITE_SO_ASC;}
#line 2645 "parse.c"
        break;
      case 154: /* sortorder ::= DESC */
#line 572 "parse.y"
{yygotominor.yy392 = SQLITE_SO_DESC;}
#line 2650 "parse.c"
        break;
      case 160: /* limit_opt ::= */
#line 598 "parse.y"
{yygotominor.yy64.pLimit = 0; yygotominor.yy64.pOffset = 0;}
#line 2655 "parse.c"
        break;
      case 161: /* limit_opt ::= LIMIT expr */
#line 599 "parse.y"
{yygotominor.yy64.pLimit = yymsp[0].minor.yy122; yygotominor.yy64.pOffset = 0;}
#line 2660 "parse.c"
        break;
      case 162: /* limit_opt ::= LIMIT expr OFFSET expr */
#line 601 "parse.y"
{yygotominor.yy64.pLimit = yymsp[-2].minor.yy122; yygotominor.yy64.pOffset = yymsp[0].minor.yy122;}
#line 2665 "parse.c"
        break;
      case 163: /* limit_opt ::= LIMIT expr COMMA expr */
#line 603 "parse.y"
{yygotominor.yy64.pOffset = yymsp[-2].minor.yy122; yygotominor.yy64.pLimit = yymsp[0].minor.yy122;}
#line 2670 "parse.c"
        break;
      case 164: /* cmd ::= DELETE FROM fullname indexed_opt where_opt */
#line 616 "parse.y"
{
  sqlite3SrcListIndexedBy(pParse, yymsp[-2].minor.yy347, &yymsp[-1].minor.yy0);
  sqlite3DeleteFrom(pParse,yymsp[-2].minor.yy347,yymsp[0].minor.yy122);
}
#line 2678 "parse.c"
        break;
      case 167: /* cmd ::= UPDATE orconf fullname indexed_opt SET setlist where_opt */
#line 639 "parse.y"
{
  sqlite3SrcListIndexedBy(pParse, yymsp[-4].minor.yy347, &yymsp[-3].minor.yy0);
  sqlite3ExprListCheckLength(pParse,yymsp[-1].minor.yy442,"set list"); 
  sqlite3Update(pParse,yymsp[-4].minor.yy347,yymsp[-1].minor.yy442,yymsp[0].minor.yy122,yymsp[-5].minor.yy392);
}
#line 2687 "parse.c"
        break;
      case 168: /* setlist ::= setlist COMMA nm EQ expr */
#line 650 "parse.y"
{yygotominor.yy442 = sqlite3ExprListAppend(pParse,yymsp[-4].minor.yy442,yymsp[0].minor.yy122,&yymsp[-2].minor.yy0);}
#line 2692 "parse.c"
        break;
      case 169: /* setlist ::= nm EQ expr */
#line 652 "parse.y"
{yygotominor.yy442 = sqlite3ExprListAppend(pParse,0,yymsp[0].minor.yy122,&yymsp[-2].minor.yy0);}
#line 2697 "parse.c"
        break;
      case 170: /* cmd ::= insert_cmd INTO fullname inscollist_opt VALUES LP itemlist RP */
#line 658 "parse.y"
{sqlite3Insert(pParse, yymsp[-5].minor.yy347, yymsp[-1].minor.yy442, 0, yymsp[-4].minor.yy180, yymsp[-7].minor.yy392);}
#line 2702 "parse.c"
        break;
      case 171: /* cmd ::= insert_cmd INTO fullname inscollist_opt select */
#line 660 "parse.y"
{sqlite3Insert(pParse, yymsp[-2].minor.yy347, 0, yymsp[0].minor.yy159, yymsp[-1].minor.yy180, yymsp[-4].minor.yy392);}
#line 2707 "parse.c"
        break;
      case 172: /* cmd ::= insert_cmd INTO fullname inscollist_opt DEFAULT VALUES */
#line 662 "parse.y"
{sqlite3Insert(pParse, yymsp[-3].minor.yy347, 0, 0, yymsp[-2].minor.yy180, yymsp[-5].minor.yy392);}
#line 2712 "parse.c"
        break;
      case 175: /* itemlist ::= itemlist COMMA expr */
      case 239: /* nexprlist ::= nexprlist COMMA expr */
#line 673 "parse.y"
{yygotominor.yy442 = sqlite3ExprListAppend(pParse,yymsp[-2].minor.yy442,yymsp[0].minor.yy122,0);}
#line 2718 "parse.c"
        break;
      case 176: /* itemlist ::= expr */
      case 240: /* nexprlist ::= expr */
#line 675 "parse.y"
{yygotominor.yy442 = sqlite3ExprListAppend(pParse,0,yymsp[0].minor.yy122,0);}
#line 2724 "parse.c"
        break;
      case 179: /* inscollist ::= inscollist COMMA nm */
#line 685 "parse.y"
{yygotominor.yy180 = sqlite3IdListAppend(pParse->db,yymsp[-2].minor.yy180,&yymsp[0].minor.yy0);}
#line 2729 "parse.c"
        break;
      case 180: /* inscollist ::= nm */
#line 687 "parse.y"
{yygotominor.yy180 = sqlite3IdListAppend(pParse->db,0,&yymsp[0].minor.yy0);}
#line 2734 "parse.c"
        break;
      case 182: /* expr ::= LP expr RP */
#line 698 "parse.y"
{yygotominor.yy122 = yymsp[-1].minor.yy122; sqlite3ExprSpan(yygotominor.yy122,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0); }
#line 2739 "parse.c"
        break;
      case 183: /* term ::= NULL */
      case 188: /* term ::= INTEGER|FLOAT|BLOB */
      case 189: /* term ::= STRING */
#line 699 "parse.y"
{yygotominor.yy122 = sqlite3PExpr(pParse, yymsp[0].major, 0, 0, &yymsp[0].minor.yy0);}
#line 2746 "parse.c"
        break;
      case 184: /* expr ::= ID */
      case 185: /* expr ::= JOIN_KW */
#line 700 "parse.y"
{yygotominor.yy122 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2752 "parse.c"
        break;
      case 186: /* expr ::= nm DOT nm */
#line 702 "parse.y"
{
  Expr *temp1 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[-2].minor.yy0);
  Expr *temp2 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[0].minor.yy0);
  yygotominor.yy122 = sqlite3PExpr(pParse, TK_DOT, temp1, temp2, 0);
}
#line 2761 "parse.c"
        break;
      case 187: /* expr ::= nm DOT nm DOT nm */
#line 707 "parse.y"
{
  Expr *temp1 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[-4].minor.yy0);
  Expr *temp2 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[-2].minor.yy0);
  Expr *temp3 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[0].minor.yy0);
  Expr *temp4 = sqlite3PExpr(pParse, TK_DOT, temp2, temp3, 0);
  yygotominor.yy122 = sqlite3PExpr(pParse, TK_DOT, temp1, temp4, 0);
}
#line 2772 "parse.c"
        break;
      case 190: /* expr ::= REGISTER */
#line 716 "parse.y"
{yygotominor.yy122 = sqlite3RegisterExpr(pParse, &yymsp[0].minor.yy0);}
#line 2777 "parse.c"
        break;
      case 191: /* expr ::= VARIABLE */
#line 717 "parse.y"
{
  Token *pToken = &yymsp[0].minor.yy0;
  Expr *pExpr = yygotominor.yy122 = sqlite3PExpr(pParse, TK_VARIABLE, 0, 0, pToken);
  sqlite3ExprAssignVarNumber(pParse, pExpr);
}
#line 2786 "parse.c"
        break;
      case 192: /* expr ::= expr COLLATE ids */
#line 722 "parse.y"
{
  yygotominor.yy122 = sqlite3ExprSetColl(pParse, yymsp[-2].minor.yy122, &yymsp[0].minor.yy0);
}
#line 2793 "parse.c"
        break;
      case 193: /* expr ::= CAST LP expr AS typetoken RP */
#line 726 "parse.y"
{
  yygotominor.yy122 = sqlite3PExpr(pParse, TK_CAST, yymsp[-3].minor.yy122, 0, &yymsp[-1].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy122,&yymsp[-5].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2801 "parse.c"
        break;
      case 194: /* expr ::= ID LP distinct exprlist RP */
#line 731 "parse.y"
{
  if( yymsp[-1].minor.yy442 && yymsp[-1].minor.yy442->nExpr>SQLITE_MAX_FUNCTION_ARG ){
    sqlite3ErrorMsg(pParse, "too many arguments on function %T", &yymsp[-4].minor.yy0);
  }
  yygotominor.yy122 = sqlite3ExprFunction(pParse, yymsp[-1].minor.yy442, &yymsp[-4].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy122,&yymsp[-4].minor.yy0,&yymsp[0].minor.yy0);
  if( yymsp[-2].minor.yy392 && yygotominor.yy122 ){
    yygotominor.yy122->flags |= EP_Distinct;
  }
}
#line 2815 "parse.c"
        break;
      case 195: /* expr ::= ID LP STAR RP */
#line 741 "parse.y"
{
  yygotominor.yy122 = sqlite3ExprFunction(pParse, 0, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy122,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2823 "parse.c"
        break;
      case 196: /* term ::= CTIME_KW */
#line 745 "parse.y"
{
  /* The CURRENT_TIME, CURRENT_DATE, and CURRENT_TIMESTAMP values are
  ** treated as functions that return constants */
  yygotominor.yy122 = sqlite3ExprFunction(pParse, 0,&yymsp[0].minor.yy0);
  if( yygotominor.yy122 ){
    yygotominor.yy122->op = TK_CONST_FUNC;  
    yygotominor.yy122->span = yymsp[0].minor.yy0;
  }
}
#line 2836 "parse.c"
        break;
      case 197: /* expr ::= expr AND expr */
      case 198: /* expr ::= expr OR expr */
      case 199: /* expr ::= expr LT|GT|GE|LE expr */
      case 200: /* expr ::= expr EQ|NE expr */
      case 201: /* expr ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr */
      case 202: /* expr ::= expr PLUS|MINUS expr */
      case 203: /* expr ::= expr STAR|SLASH|REM expr */
      case 204: /* expr ::= expr CONCAT expr */
#line 754 "parse.y"
{yygotominor.yy122 = sqlite3PExpr(pParse,yymsp[-1].major,yymsp[-2].minor.yy122,yymsp[0].minor.yy122,0);}
#line 2848 "parse.c"
        break;
      case 205: /* likeop ::= LIKE_KW */
      case 207: /* likeop ::= MATCH */
#line 766 "parse.y"
{yygotominor.yy318.eOperator = yymsp[0].minor.yy0; yygotominor.yy318.not = 0;}
#line 2854 "parse.c"
        break;
      case 206: /* likeop ::= NOT LIKE_KW */
      case 208: /* likeop ::= NOT MATCH */
#line 767 "parse.y"
{yygotominor.yy318.eOperator = yymsp[0].minor.yy0; yygotominor.yy318.not = 1;}
#line 2860 "parse.c"
        break;
      case 211: /* expr ::= expr likeop expr escape */
#line 774 "parse.y"
{
  ExprList *pList;
  pList = sqlite3ExprListAppend(pParse,0, yymsp[-1].minor.yy122, 0);
  pList = sqlite3ExprListAppend(pParse,pList, yymsp[-3].minor.yy122, 0);
  if( yymsp[0].minor.yy122 ){
    pList = sqlite3ExprListAppend(pParse,pList, yymsp[0].minor.yy122, 0);
  }
  yygotominor.yy122 = sqlite3ExprFunction(pParse, pList, &yymsp[-2].minor.yy318.eOperator);
  if( yymsp[-2].minor.yy318.not ) yygotominor.yy122 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy122, 0, 0);
  sqlite3ExprSpan(yygotominor.yy122, &yymsp[-3].minor.yy122->span, &yymsp[-1].minor.yy122->span);
  if( yygotominor.yy122 ) yygotominor.yy122->flags |= EP_InfixFunc;
}
#line 2876 "parse.c"
        break;
      case 212: /* expr ::= expr ISNULL|NOTNULL */
#line 787 "parse.y"
{
  yygotominor.yy122 = sqlite3PExpr(pParse, yymsp[0].major, yymsp[-1].minor.yy122, 0, 0);
  sqlite3ExprSpan(yygotominor.yy122,&yymsp[-1].minor.yy122->span,&yymsp[0].minor.yy0);
}
#line 2884 "parse.c"
        break;
      case 213: /* expr ::= expr IS NULL */
#line 791 "parse.y"
{
  yygotominor.yy122 = sqlite3PExpr(pParse, TK_ISNULL, yymsp[-2].minor.yy122, 0, 0);
  sqlite3ExprSpan(yygotominor.yy122,&yymsp[-2].minor.yy122->span,&yymsp[0].minor.yy0);
}
#line 2892 "parse.c"
        break;
      case 214: /* expr ::= expr NOT NULL */
#line 795 "parse.y"
{
  yygotominor.yy122 = sqlite3PExpr(pParse, TK_NOTNULL, yymsp[-2].minor.yy122, 0, 0);
  sqlite3ExprSpan(yygotominor.yy122,&yymsp[-2].minor.yy122->span,&yymsp[0].minor.yy0);
}
#line 2900 "parse.c"
        break;
      case 215: /* expr ::= expr IS NOT NULL */
#line 799 "parse.y"
{
  yygotominor.yy122 = sqlite3PExpr(pParse, TK_NOTNULL, yymsp[-3].minor.yy122, 0, 0);
  sqlite3ExprSpan(yygotominor.yy122,&yymsp[-3].minor.yy122->span,&yymsp[0].minor.yy0);
}
#line 2908 "parse.c"
        break;
      case 216: /* expr ::= NOT expr */
      case 217: /* expr ::= BITNOT expr */
#line 803 "parse.y"
{
  yygotominor.yy122 = sqlite3PExpr(pParse, yymsp[-1].major, yymsp[0].minor.yy122, 0, 0);
  sqlite3ExprSpan(yygotominor.yy122,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy122->span);
}
#line 2917 "parse.c"
        break;
      case 218: /* expr ::= MINUS expr */
#line 811 "parse.y"
{
  yygotominor.yy122 = sqlite3PExpr(pParse, TK_UMINUS, yymsp[0].minor.yy122, 0, 0);
  sqlite3ExprSpan(yygotominor.yy122,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy122->span);
}
#line 2925 "parse.c"
        break;
      case 219: /* expr ::= PLUS expr */
#line 815 "parse.y"
{
  yygotominor.yy122 = sqlite3PExpr(pParse, TK_UPLUS, yymsp[0].minor.yy122, 0, 0);
  sqlite3ExprSpan(yygotominor.yy122,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy122->span);
}
#line 2933 "parse.c"
        break;
      case 222: /* expr ::= expr between_op expr AND expr */
#line 822 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(pParse,0, yymsp[-2].minor.yy122, 0);
  pList = sqlite3ExprListAppend(pParse,pList, yymsp[0].minor.yy122, 0);
  yygotominor.yy122 = sqlite3PExpr(pParse, TK_BETWEEN, yymsp[-4].minor.yy122, 0, 0);
  if( yygotominor.yy122 ){
    yygotominor.yy122->pList = pList;
  }else{
    sqlite3ExprListDelete(pParse->db, pList);
  } 
  if( yymsp[-3].minor.yy392 ) yygotominor.yy122 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy122, 0, 0);
  sqlite3ExprSpan(yygotominor.yy122,&yymsp[-4].minor.yy122->span,&yymsp[0].minor.yy122->span);
}
#line 2949 "parse.c"
        break;
      case 225: /* expr ::= expr in_op LP exprlist RP */
#line 838 "parse.y"
{
    yygotominor.yy122 = sqlite3PExpr(pParse, TK_IN, yymsp[-4].minor.yy122, 0, 0);
    if( yygotominor.yy122 ){
      yygotominor.yy122->pList = yymsp[-1].minor.yy442;
      sqlite3ExprSetHeight(pParse, yygotominor.yy122);
    }else{
      sqlite3ExprListDelete(pParse->db, yymsp[-1].minor.yy442);
    }
    if( yymsp[-3].minor.yy392 ) yygotominor.yy122 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy122, 0, 0);
    sqlite3ExprSpan(yygotominor.yy122,&yymsp[-4].minor.yy122->span,&yymsp[0].minor.yy0);
  }
#line 2964 "parse.c"
        break;
      case 226: /* expr ::= LP select RP */
#line 849 "parse.y"
{
    yygotominor.yy122 = sqlite3PExpr(pParse, TK_SELECT, 0, 0, 0);
    if( yygotominor.yy122 ){
      yygotominor.yy122->pSelect = yymsp[-1].minor.yy159;
      sqlite3ExprSetHeight(pParse, yygotominor.yy122);
    }else{
      sqlite3SelectDelete(pParse->db, yymsp[-1].minor.yy159);
    }
    sqlite3ExprSpan(yygotominor.yy122,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);
  }
#line 2978 "parse.c"
        break;
      case 227: /* expr ::= expr in_op LP select RP */
#line 859 "parse.y"
{
    yygotominor.yy122 = sqlite3PExpr(pParse, TK_IN, yymsp[-4].minor.yy122, 0, 0);
    if( yygotominor.yy122 ){
      yygotominor.yy122->pSelect = yymsp[-1].minor.yy159;
      sqlite3ExprSetHeight(pParse, yygotominor.yy122);
    }else{
      sqlite3SelectDelete(pParse->db, yymsp[-1].minor.yy159);
    }
    if( yymsp[-3].minor.yy392 ) yygotominor.yy122 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy122, 0, 0);
    sqlite3ExprSpan(yygotominor.yy122,&yymsp[-4].minor.yy122->span,&yymsp[0].minor.yy0);
  }
#line 2993 "parse.c"
        break;
      case 228: /* expr ::= expr in_op nm dbnm */
#line 870 "parse.y"
{
    SrcList *pSrc = sqlite3SrcListAppend(pParse->db, 0,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy0);
    yygotominor.yy122 = sqlite3PExpr(pParse, TK_IN, yymsp[-3].minor.yy122, 0, 0);
    if( yygotominor.yy122 ){
      yygotominor.yy122->pSelect = sqlite3SelectNew(pParse, 0,pSrc,0,0,0,0,0,0,0);
      sqlite3ExprSetHeight(pParse, yygotominor.yy122);
    }else{
      sqlite3SrcListDelete(pParse->db, pSrc);
    }
    if( yymsp[-2].minor.yy392 ) yygotominor.yy122 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy122, 0, 0);
    sqlite3ExprSpan(yygotominor.yy122,&yymsp[-3].minor.yy122->span,yymsp[0].minor.yy0.z?&yymsp[0].minor.yy0:&yymsp[-1].minor.yy0);
  }
#line 3009 "parse.c"
        break;
      case 229: /* expr ::= EXISTS LP select RP */
#line 882 "parse.y"
{
    Expr *p = yygotominor.yy122 = sqlite3PExpr(pParse, TK_EXISTS, 0, 0, 0);
    if( p ){
      p->pSelect = yymsp[-1].minor.yy159;
      sqlite3ExprSpan(p,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
      sqlite3ExprSetHeight(pParse, yygotominor.yy122);
    }else{
      sqlite3SelectDelete(pParse->db, yymsp[-1].minor.yy159);
    }
  }
#line 3023 "parse.c"
        break;
      case 230: /* expr ::= CASE case_operand case_exprlist case_else END */
#line 895 "parse.y"
{
  yygotominor.yy122 = sqlite3PExpr(pParse, TK_CASE, yymsp[-3].minor.yy122, yymsp[-1].minor.yy122, 0);
  if( yygotominor.yy122 ){
    yygotominor.yy122->pList = yymsp[-2].minor.yy442;
    sqlite3ExprSetHeight(pParse, yygotominor.yy122);
  }else{
    sqlite3ExprListDelete(pParse->db, yymsp[-2].minor.yy442);
  }
  sqlite3ExprSpan(yygotominor.yy122, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3037 "parse.c"
        break;
      case 231: /* case_exprlist ::= case_exprlist WHEN expr THEN expr */
#line 907 "parse.y"
{
  yygotominor.yy442 = sqlite3ExprListAppend(pParse,yymsp[-4].minor.yy442, yymsp[-2].minor.yy122, 0);
  yygotominor.yy442 = sqlite3ExprListAppend(pParse,yygotominor.yy442, yymsp[0].minor.yy122, 0);
}
#line 3045 "parse.c"
        break;
      case 232: /* case_exprlist ::= WHEN expr THEN expr */
#line 911 "parse.y"
{
  yygotominor.yy442 = sqlite3ExprListAppend(pParse,0, yymsp[-2].minor.yy122, 0);
  yygotominor.yy442 = sqlite3ExprListAppend(pParse,yygotominor.yy442, yymsp[0].minor.yy122, 0);
}
#line 3053 "parse.c"
        break;
      case 241: /* cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON nm LP idxlist RP */
#line 940 "parse.y"
{
  sqlite3CreateIndex(pParse, &yymsp[-6].minor.yy0, &yymsp[-5].minor.yy0, 
                     sqlite3SrcListAppend(pParse->db,0,&yymsp[-3].minor.yy0,0), yymsp[-1].minor.yy442, yymsp[-9].minor.yy392,
                      &yymsp[-10].minor.yy0, &yymsp[0].minor.yy0, SQLITE_SO_ASC, yymsp[-7].minor.yy392);
}
#line 3062 "parse.c"
        break;
      case 242: /* uniqueflag ::= UNIQUE */
      case 289: /* raisetype ::= ABORT */
#line 947 "parse.y"
{yygotominor.yy392 = OE_Abort;}
#line 3068 "parse.c"
        break;
      case 243: /* uniqueflag ::= */
#line 948 "parse.y"
{yygotominor.yy392 = OE_None;}
#line 3073 "parse.c"
        break;
      case 246: /* idxlist ::= idxlist COMMA nm collate sortorder */
#line 957 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy0.n>0 ){
    p = sqlite3PExpr(pParse, TK_COLUMN, 0, 0, 0);
    sqlite3ExprSetColl(pParse, p, &yymsp[-1].minor.yy0);
  }
  yygotominor.yy442 = sqlite3ExprListAppend(pParse,yymsp[-4].minor.yy442, p, &yymsp[-2].minor.yy0);
  sqlite3ExprListCheckLength(pParse, yygotominor.yy442, "index");
  if( yygotominor.yy442 ) yygotominor.yy442->a[yygotominor.yy442->nExpr-1].sortOrder = (u8)yymsp[0].minor.yy392;
}
#line 3087 "parse.c"
        break;
      case 247: /* idxlist ::= nm collate sortorder */
#line 967 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy0.n>0 ){
    p = sqlite3PExpr(pParse, TK_COLUMN, 0, 0, 0);
    sqlite3ExprSetColl(pParse, p, &yymsp[-1].minor.yy0);
  }
  yygotominor.yy442 = sqlite3ExprListAppend(pParse,0, p, &yymsp[-2].minor.yy0);
  sqlite3ExprListCheckLength(pParse, yygotominor.yy442, "index");
  if( yygotominor.yy442 ) yygotominor.yy442->a[yygotominor.yy442->nExpr-1].sortOrder = (u8)yymsp[0].minor.yy392;
}
#line 3101 "parse.c"
        break;
      case 248: /* collate ::= */
#line 979 "parse.y"
{yygotominor.yy0.z = 0; yygotominor.yy0.n = 0;}
#line 3106 "parse.c"
        break;
      case 250: /* cmd ::= DROP INDEX ifexists fullname */
#line 985 "parse.y"
{sqlite3DropIndex(pParse, yymsp[0].minor.yy347, yymsp[-1].minor.yy392);}
#line 3111 "parse.c"
        break;
      case 251: /* cmd ::= VACUUM */
      case 252: /* cmd ::= VACUUM nm */
#line 991 "parse.y"
{sqlite3Vacuum(pParse);}
#line 3117 "parse.c"
        break;
      case 253: /* cmd ::= PRAGMA nm dbnm EQ nmnum */
      case 254: /* cmd ::= PRAGMA nm dbnm EQ ON */
      case 255: /* cmd ::= PRAGMA nm dbnm EQ DELETE */
#line 1000 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0,0);}
#line 3124 "parse.c"
        break;
      case 256: /* cmd ::= PRAGMA nm dbnm EQ minus_num */
#line 1003 "parse.y"
{
  sqlite3Pragma(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0,1);
}
#line 3131 "parse.c"
        break;
      case 257: /* cmd ::= PRAGMA nm dbnm LP nmnum RP */
#line 1006 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-4].minor.yy0,&yymsp[-3].minor.yy0,&yymsp[-1].minor.yy0,0);}
#line 3136 "parse.c"
        break;
      case 258: /* cmd ::= PRAGMA nm dbnm */
#line 1007 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy0,0,0);}
#line 3141 "parse.c"
        break;
      case 266: /* cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END */
#line 1022 "parse.y"
{
  Token all;
  all.z = yymsp[-3].minor.yy0.z;
  all.n = (int)(yymsp[0].minor.yy0.z - yymsp[-3].minor.yy0.z) + yymsp[0].minor.yy0.n;
  sqlite3FinishTrigger(pParse, yymsp[-1].minor.yy327, &all);
}
#line 3151 "parse.c"
        break;
      case 267: /* trigger_decl ::= temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON fullname foreach_clause when_clause */
#line 1031 "parse.y"
{
  sqlite3BeginTrigger(pParse, &yymsp[-7].minor.yy0, &yymsp[-6].minor.yy0, yymsp[-5].minor.yy392, yymsp[-4].minor.yy410.a, yymsp[-4].minor.yy410.b, yymsp[-2].minor.yy347, yymsp[0].minor.yy122, yymsp[-10].minor.yy392, yymsp[-8].minor.yy392);
  yygotominor.yy0 = (yymsp[-6].minor.yy0.n==0?yymsp[-7].minor.yy0:yymsp[-6].minor.yy0);
}
#line 3159 "parse.c"
        break;
      case 268: /* trigger_time ::= BEFORE */
      case 271: /* trigger_time ::= */
#line 1037 "parse.y"
{ yygotominor.yy392 = TK_BEFORE; }
#line 3165 "parse.c"
        break;
      case 269: /* trigger_time ::= AFTER */
#line 1038 "parse.y"
{ yygotominor.yy392 = TK_AFTER;  }
#line 3170 "parse.c"
        break;
      case 270: /* trigger_time ::= INSTEAD OF */
#line 1039 "parse.y"
{ yygotominor.yy392 = TK_INSTEAD;}
#line 3175 "parse.c"
        break;
      case 272: /* trigger_event ::= DELETE|INSERT */
      case 273: /* trigger_event ::= UPDATE */
#line 1044 "parse.y"
{yygotominor.yy410.a = yymsp[0].major; yygotominor.yy410.b = 0;}
#line 3181 "parse.c"
        break;
      case 274: /* trigger_event ::= UPDATE OF inscollist */
#line 1046 "parse.y"
{yygotominor.yy410.a = TK_UPDATE; yygotominor.yy410.b = yymsp[0].minor.yy180;}
#line 3186 "parse.c"
        break;
      case 277: /* when_clause ::= */
      case 294: /* key_opt ::= */
#line 1053 "parse.y"
{ yygotominor.yy122 = 0; }
#line 3192 "parse.c"
        break;
      case 278: /* when_clause ::= WHEN expr */
      case 295: /* key_opt ::= KEY expr */
#line 1054 "parse.y"
{ yygotominor.yy122 = yymsp[0].minor.yy122; }
#line 3198 "parse.c"
        break;
      case 279: /* trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI */
#line 1058 "parse.y"
{
/*
  if( yymsp[-2].minor.yy327 ){
    yymsp[-2].minor.yy327->pLast->pNext = yymsp[-1].minor.yy327;
  }else{
    yymsp[-2].minor.yy327 = yymsp[-1].minor.yy327;
  }
*/
  assert( yymsp[-2].minor.yy327!=0 );
  yymsp[-2].minor.yy327->pLast->pNext = yymsp[-1].minor.yy327;
  yymsp[-2].minor.yy327->pLast = yymsp[-1].minor.yy327;
  yygotominor.yy327 = yymsp[-2].minor.yy327;
}
#line 3215 "parse.c"
        break;
      case 280: /* trigger_cmd_list ::= trigger_cmd SEMI */
#line 1071 "parse.y"
{ 
  /* if( yymsp[-1].minor.yy327 ) */
  assert( yymsp[-1].minor.yy327!=0 );
  yymsp[-1].minor.yy327->pLast = yymsp[-1].minor.yy327;
  yygotominor.yy327 = yymsp[-1].minor.yy327;
}
#line 3225 "parse.c"
        break;
      case 281: /* trigger_cmd ::= UPDATE orconf nm SET setlist where_opt */
#line 1082 "parse.y"
{ yygotominor.yy327 = sqlite3TriggerUpdateStep(pParse->db, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy442, yymsp[0].minor.yy122, yymsp[-4].minor.yy392); }
#line 3230 "parse.c"
        break;
      case 282: /* trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP */
#line 1087 "parse.y"
{yygotominor.yy327 = sqlite3TriggerInsertStep(pParse->db, &yymsp[-5].minor.yy0, yymsp[-4].minor.yy180, yymsp[-1].minor.yy442, 0, yymsp[-7].minor.yy392);}
#line 3235 "parse.c"
        break;
      case 283: /* trigger_cmd ::= insert_cmd INTO nm inscollist_opt select */
#line 1090 "parse.y"
{yygotominor.yy327 = sqlite3TriggerInsertStep(pParse->db, &yymsp[-2].minor.yy0, yymsp[-1].minor.yy180, 0, yymsp[0].minor.yy159, yymsp[-4].minor.yy392);}
#line 3240 "parse.c"
        break;
      case 284: /* trigger_cmd ::= DELETE FROM nm where_opt */
#line 1094 "parse.y"
{yygotominor.yy327 = sqlite3TriggerDeleteStep(pParse->db, &yymsp[-1].minor.yy0, yymsp[0].minor.yy122);}
#line 3245 "parse.c"
        break;
      case 285: /* trigger_cmd ::= select */
#line 1097 "parse.y"
{yygotominor.yy327 = sqlite3TriggerSelectStep(pParse->db, yymsp[0].minor.yy159); }
#line 3250 "parse.c"
        break;
      case 286: /* expr ::= RAISE LP IGNORE RP */
#line 1100 "parse.y"
{
  yygotominor.yy122 = sqlite3PExpr(pParse, TK_RAISE, 0, 0, 0); 
  if( yygotominor.yy122 ){
    yygotominor.yy122->iColumn = OE_Ignore;
    sqlite3ExprSpan(yygotominor.yy122, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 3261 "parse.c"
        break;
      case 287: /* expr ::= RAISE LP raisetype COMMA nm RP */
#line 1107 "parse.y"
{
  yygotominor.yy122 = sqlite3PExpr(pParse, TK_RAISE, 0, 0, &yymsp[-1].minor.yy0); 
  if( yygotominor.yy122 ) {
    yygotominor.yy122->iColumn = yymsp[-3].minor.yy392;
    sqlite3ExprSpan(yygotominor.yy122, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 3272 "parse.c"
        break;
      case 288: /* raisetype ::= ROLLBACK */
#line 1117 "parse.y"
{yygotominor.yy392 = OE_Rollback;}
#line 3277 "parse.c"
        break;
      case 290: /* raisetype ::= FAIL */
#line 1119 "parse.y"
{yygotominor.yy392 = OE_Fail;}
#line 3282 "parse.c"
        break;
      case 291: /* cmd ::= DROP TRIGGER ifexists fullname */
#line 1124 "parse.y"
{
  sqlite3DropTrigger(pParse,yymsp[0].minor.yy347,yymsp[-1].minor.yy392);
}
#line 3289 "parse.c"
        break;
      case 292: /* cmd ::= ATTACH database_kw_opt expr AS expr key_opt */
#line 1131 "parse.y"
{
  sqlite3Attach(pParse, yymsp[-3].minor.yy122, yymsp[-1].minor.yy122, yymsp[0].minor.yy122);
}
#line 3296 "parse.c"
        break;
      case 293: /* cmd ::= DETACH database_kw_opt expr */
#line 1134 "parse.y"
{
  sqlite3Detach(pParse, yymsp[0].minor.yy122);
}
#line 3303 "parse.c"
        break;
      case 298: /* cmd ::= REINDEX */
#line 1149 "parse.y"
{sqlite3Reindex(pParse, 0, 0);}
#line 3308 "parse.c"
        break;
      case 299: /* cmd ::= REINDEX nm dbnm */
#line 1150 "parse.y"
{sqlite3Reindex(pParse, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0);}
#line 3313 "parse.c"
        break;
      case 300: /* cmd ::= ANALYZE */
#line 1155 "parse.y"
{sqlite3Analyze(pParse, 0, 0);}
#line 3318 "parse.c"
        break;
      case 301: /* cmd ::= ANALYZE nm dbnm */
#line 1156 "parse.y"
{sqlite3Analyze(pParse, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0);}
#line 3323 "parse.c"
        break;
      case 302: /* cmd ::= ALTER TABLE fullname RENAME TO nm */
#line 1161 "parse.y"
{
  sqlite3AlterRenameTable(pParse,yymsp[-3].minor.yy347,&yymsp[0].minor.yy0);
}
#line 3330 "parse.c"
        break;
      case 303: /* cmd ::= ALTER TABLE add_column_fullname ADD kwcolumn_opt column */
#line 1164 "parse.y"
{
  sqlite3AlterFinishAddColumn(pParse, &yymsp[0].minor.yy0);
}
#line 3337 "parse.c"
        break;
      case 304: /* add_column_fullname ::= fullname */
#line 1167 "parse.y"
{
  sqlite3AlterBeginAddColumn(pParse, yymsp[0].minor.yy347);
}
#line 3344 "parse.c"
        break;
      case 307: /* cmd ::= create_vtab */
#line 1176 "parse.y"
{sqlite3VtabFinishParse(pParse,0);}
#line 3349 "parse.c"
        break;
      case 308: /* cmd ::= create_vtab LP vtabarglist RP */
#line 1177 "parse.y"
{sqlite3VtabFinishParse(pParse,&yymsp[0].minor.yy0);}
#line 3354 "parse.c"
        break;
      case 309: /* create_vtab ::= CREATE VIRTUAL TABLE nm dbnm USING nm */
#line 1178 "parse.y"
{
    sqlite3VtabBeginParse(pParse, &yymsp[-3].minor.yy0, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3361 "parse.c"
        break;
      case 312: /* vtabarg ::= */
#line 1183 "parse.y"
{sqlite3VtabArgInit(pParse);}
#line 3366 "parse.c"
        break;
      case 314: /* vtabargtoken ::= ANY */
      case 315: /* vtabargtoken ::= lp anylist RP */
      case 316: /* lp ::= LP */
      case 318: /* anylist ::= anylist ANY */
#line 1185 "parse.y"
{sqlite3VtabArgExtend(pParse,&yymsp[0].minor.yy0);}
#line 3374 "parse.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,(YYCODETYPE)yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = (YYACTIONTYPE)yyact;
      yymsp->major = (YYCODETYPE)yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else{
    assert( yyact == YYNSTATE + YYNRULE + 1 );
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite3ParserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 34 "parse.y"

  UNUSED_PARAMETER(yymajor);  /* Silence some compiler warnings */
  assert( TOKEN.z[0] );  /* The tokenizer always gives us a token */
  sqlite3ErrorMsg(pParse, "near \"%T\": syntax error", &TOKEN);
  pParse->parseError = 1;
#line 3438 "parse.c"
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite3ParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3Parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite3ParserTOKENTYPE yyminor       /* The value for the token */
  sqlite3ParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
#if YYSTACKDEPTH<=0
    if( yypParser->yystksz <=0 ){
      /*memset(&yyminorunion, 0, sizeof(yyminorunion));*/
      yyminorunion = yyzerominor;
      yyStackOverflow(yypParser, &yyminorunion);
      return;
    }
#endif
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  sqlite3ParserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,(YYCODETYPE)yymajor);
    if( yyact<YYNSTATE ){
      assert( !yyendofinput );  /* Impossible to shift the $ token */
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      yymajor = YYNOCODE;
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else{
      assert( yyact == YY_ERROR_ACTION );
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
