
use strict;
use warnings;

use Test::More tests => 4;
BEGIN { use_ok('JavaScript::Minifier::XS') };

use JavaScript::Minifier::XS qw(minify);

my $file = q(if (!Scattershot)
	alert("Please load scattershot.js first.");

Scattershot.sections = function(id) {
	return $('.liquid-section-' + id).section();
};

Scattershot.Section = function(id, selector) {
	this.id = id;
	this.selector = selector;
	
	var section = this;
	
	this.render = function(hash) {
		return $.ajax({ url: "/render_liquid_section/" + section.id, dataType: "html", contentType: "application/json", type: "POST", data: JSON.stringify(hash) });
	};
	
	// Targets a section which is specifically for a particular object; refreshes the attributes of that object.
	// Or, alternatively, simply re-renders the same snippet with no extra parameters.
	// Only applies for sections instantiated with a selector.
	this.refresh = function(hash) {
		if (!hash)
			hash = {};
		if (this.selector)
			hash['id'] = this.selector.attr('data-object-id');
		this.render(hash).done(function(html) {
			if (section.selector)
				section.selector.html(html);
			for (var i = 0; i < Scattershot.sectionRefreshers; ++i)
				Scattershot.sectionRefreshers[i](section);
		}).fail(function(xhr) {
			if (section.selector)
				section.selector.html("Error: " + xhr.responseText);
		});
	};
};

Scattershot.sectionRefreshers = [];
Scattershot.sectionRefresh = function(closure) {
	Scattershot.sectionRefreshers.push(closure);
};

jQuery.fn.extend({
	section: function() {
		if (this)
			return new Scattershot.Section($(this).attr('data-id'), $(this));
		return $();
	}
});
Scattershot.sectionRefresh(function(section) {
	section.selector.find(".form").each(function() {
		Scattershot.hookForm($(this));
	});
}););

my $minified_file = q(
if(!Scattershot)
alert("Please load scattershot.js first.");Scattershot.sections=function(id){return $('.liquid-section-'+id).section();};Scattershot.Section=function(id,selector){this.id=id;this.selector=selector;var section=this;this.render=function(hash){return $.ajax({url:"/render_liquid_section/"+section.id,dataType:"html",contentType:"application/json",type:"POST",data:JSON.stringify(hash)});};this.refresh=function(hash){if(!hash)
hash={};if(this.selector)
hash['id']=this.selector.attr('data-object-id');this.render(hash).done(function(html){if(section.selector)
section.selector.html(html);for(var i=0;i<Scattershot.sectionRefreshers;++i)
Scattershot.sectionRefreshers[i](section);}).fail(function(xhr){if(section.selector)
section.selector.html("Error: "+xhr.responseText);});};};Scattershot.sectionRefreshers=[];Scattershot.sectionRefresh=function(closure){Scattershot.sectionRefreshers.push(closure);};jQuery.fn.extend({section:function(){if(this)
return new Scattershot.Section($(this).attr('data-id'),$(this));return $();}});Scattershot.sectionRefresh(function(section){section.selector.find(".form").each(function(){Scattershot.hookForm($(this));});}););

my $minified = minify($file);

is(length($minified_file), length($minified));

is($minified, $minified_file);


eval {
	$minified = minify("var a = 10; /* sfasfdsdf");
};
ok($@);