use Test::Spec;
require Test::NoWarnings;

$Carp::Internal{ 'Devel::Declare' } ||= 1;
BEGIN {
    require 'Syntax/Feature/Try.pm';
    return Syntax::Feature::Try->install;
}
sub g {
    my (@args) = @_;
    my $result = "yx";
    $result =~ /y(.+)/;
    my %named = ($1 , []);
    return @{$named{x}};
}

sub f {
    try {
        g(undef);
    }
    catch ($err) {
        die $err;
    }
}

describe "https://rt.cpan.org/Public/Bug/Display.html?id=107748" => sub {
    it "works" => sub {
        f;
    };
};

it "has no warnings" => sub {
    Test::NoWarnings::had_no_warnings();
};

package XX {

    $Carp::Internal{ 'Devel::Declare' } ||= 1;
    BEGIN { require 'Syntax/Feature/Try.pm'; return Syntax::Feature::Try->install; }
    foreach (2, 3, 4) {
        try {
            die "odd\n" if $_ % 2;
        }
        catch ($err) {
            next;
        }
        warn "got here $_\n";
    }
}

runtests;
