/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp;

import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.NetcdfFile;
import ucar.nc2.ParsedSectionSpec;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.iosp.IospHelper;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public abstract class AbstractIOServiceProvider
implements IOServiceProvider {
    protected RandomAccessFile raf;

    public static String createValidNetcdfObjectName(String name) {
        return name;
    }

    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        this.raf = raf;
    }

    public void close() throws IOException {
        if (this.raf != null) {
            this.raf.close();
        }
        this.raf = null;
    }

    public long readToByteChannel(Variable v2, Section section, WritableByteChannel channel) throws IOException, InvalidRangeException {
        Array data = this.readData(v2, section);
        return IospHelper.copyToByteChannel(data, channel);
    }

    public Array readSection(ParsedSectionSpec cer) throws IOException, InvalidRangeException {
        return IospHelper.readSection(cer);
    }

    public StructureDataIterator getStructureIterator(Structure s, int bufferSize) throws IOException {
        return null;
    }

    public Object sendIospMessage(Object message) {
        if (message == "RandomAccessFile") {
            return this.raf;
        }
        return null;
    }

    public boolean syncExtend() throws IOException {
        return false;
    }

    public boolean sync() throws IOException {
        return false;
    }

    public String toStringDebug(Object o) {
        return "";
    }

    public String getDetailInfo() {
        return "";
    }

    public String getFileTypeVersion() {
        return "N/A";
    }
}

