use Test;

use lib "lib";
use Transit::Network::Helpers;

is( dehourify(''),       '',     "''      -> ''");

is( dehourify('2h'),     120,    "2h      -> 120");
is( dehourify('2h00'),   120,    "2h00    -> 120");
is( dehourify('6h45'),   405,    "6h45    -> 405");
is( dehourify('6h45.5'), 405.5,  "6h45.5  -> 405.5");

is( dehourify('1d'),     1440,   "1h      -> 1440");
is( dehourify('1d2'),    1442,   "1h2     -> 1442");
is( dehourify('1d02'),   1442,   "1h02    -> 1442");
is( dehourify('1d02.5'), 1442.5, "1h02.5  -> 1442.5");

is( dehourify('10d'),    14400,   "10d    -> 14400");
is( dehourify('9d24h'),  14400,   "9d24h  -> 14400");
is( dehourify('8d48h'),  14400,   "4d48h  -> 14400");

is( dehourify('4d15h00'), 6660,   "4d15h00 -> 6660");
is( dehourify('111h00'),  6660,   "111h00  -> 6660");

is( dehourify-interval('3;3;4'),    '3;3;4',       '3;3;4    -> 3;3;4');
is( dehourify-interval('1h;2h;1d'), '60;120;1440', '1h;2h;1d -> 60;120;1440');

is( min2dep("0 2 4 6 8"),      <000.5 002.5 004.5 006.5 008.5>, "x  -> 000x.5");
is( min2dep("00 12 24 36 48"), <0000 0012 0024 0036 0048>,      "xx -> 00xx");

is( dep-add(<00 20 40>, '10'), <0010 0030 0050>, "<00 20 40> -> <0010 0030 0050>"); 

is( nice-time(122),          "0202 ", '122   -> "0202 "');
is( nice-time(122, :days), "  0202 ", '122 D -> "  0202 "');

is( nice-time(1440),          "2400 ", '1440   -> "2400 "');
is( nice-time(1440, :days), "1+0000 ", '1440 D -> "1+0000 "');

done-testing;
