#include "conf.h"
#include "sysdep.h"

#include "structs.h"
#include "db.h"
#include "utils.h"
#include "spells.h"
#include "interpreter.h"
#include "races.h"

const char *race_abbrevs[] = {
    "HUM",
    "DWA",
    "ELF",
    "GNO",
    "HLF",
/* NPC Races */
    "UND",
    "HMN",
    "ANI",
    "DRG",
    "GNT",
    "\n"
};	  
    
const char *pc_race_types[] = {
    "Human",
    "Dwarf",
    "Elf",
    "Gnome",
    "Halfling",
/* NPC Races */
    "Undead",
    "Humanoid",
    "Animal",
    "Dragon",
    "Giant",
    "\n"
};

const char *race_menu = 
"\r\nPlease select a race for your character.\r\n"
" [H]uman \r\n"
" [D]warf \r\n"
" [E]lf \r\n"
" [G]nome \r\n"
" Ha[l]fling \r\n";

int parse_race(char arg)
{
    int i = RACE_UNDEFINED;
    arg = LOWER(arg);
    
    switch (arg) {
    case 'h':
	i = RACE_HUMAN;
	break;
    case 'd':
	i = RACE_DWARF;
	break;
    case 'e':
	i = RACE_ELF;
	break;
    case 'g':
	i = RACE_GNOME;
	break;
    case 'l':
	i = RACE_HALFLING;
	break;
    }
    return i;
};


void racial_abil_mods(struct char_data * ch)
{
    /* modify ability scores by race */
    if (IS_DWARF(ch)) {
	ch->real_abils.con += 1;
	ch->real_abils.cha -= 1;      
    }
  
    if (IS_ELF(ch)) {
	ch->real_abils.dex += 1;
	ch->real_abils.con -= 1;      
    }

    if (IS_GNOME(ch)) {
	ch->real_abils.wis += 1;
	ch->real_abils.intel -= 1;      
    }

    if (IS_HALFLING(ch)) {
	ch->real_abils.dex += 1;
	ch->real_abils.str -= 1;      
    }
}


void racial_abilities(struct char_data * ch)
{
    /* set players size based on their race */
    ch->player_specials->saved.player_size = SIZE_MEDIUM;
    if IS_HALFLING(ch)
      ch->player_specials->saved.player_size = SIZE_SMALL;
    

    /* add in racial abilities here */
    if (IS_ELF(ch) || IS_DWARF(ch) || IS_GNOME(ch)) 
      SET_BIT(AFF_FLAGS(ch), AFF_INFRAVISION);
  
    if (IS_HALFLING(ch))
      SET_BIT(AFF_FLAGS(ch), AFF_SENSE_LIFE);
}  

void language_abilities(struct char_data * ch)
{
/* set language abilities */
/* let everybody speak common (hence the name, common!) */
/* language support doesn't fully work yet, but when it does,   *
 * you will want to uncomment the lines that set saved.speaking */

    if (IS_HUMAN(ch)) {
	SET_SKILL(ch, LANG_COMMON, 100);
	ch->player_specials->saved.speaking = LANG_COMMON;
    }
  
    if (IS_DWARF(ch)) {
	SET_SKILL(ch, LANG_DWARVEN, 100);
	SET_SKILL(ch, LANG_COMMON, 95);
/*    ch->player_specials->saved.speaking = LANG_DWARVEN; */
	ch->player_specials->saved.speaking = LANG_COMMON;
    }
  
    if (IS_ELF(ch)) {
	SET_SKILL(ch, LANG_ELVEN, 100);
	SET_SKILL(ch, LANG_COMMON, 99);
/*    ch->player_specials->saved.speaking = LANG_ELVEN; */
	ch->player_specials->saved.speaking = LANG_COMMON;
    }
  
    if (IS_GNOME(ch)) {
	SET_SKILL(ch, LANG_GNOMISH, 100);
	SET_SKILL(ch, LANG_COMMON, 95);
/*    ch->player_specials->saved.speaking = LANG_GNOMISH; */
	ch->player_specials->saved.speaking = LANG_COMMON;
    }
  
    if (IS_HALFLING(ch)) {
	SET_SKILL(ch, LANG_HALFLING, 100);
	SET_SKILL(ch, LANG_COMMON, 99);
/*    ch->player_specials->saved.speaking = LANG_HALFLING; */
	ch->player_specials->saved.speaking = LANG_COMMON;
    }
}

  

int invalid_race(struct char_data *ch, struct obj_data *obj) {
    if ((IS_OBJ_STAT(obj, ITEM_ANTI_ELF) && (IS_ELF(ch))) ||
        (IS_OBJ_STAT(obj, ITEM_ANTI_DWARF) && (IS_DWARF(ch))) ||
	(IS_OBJ_STAT(obj, ITEM_ANTI_GNOME) && (IS_GNOME(ch))) ||
	(IS_OBJ_STAT(obj, ITEM_ANTI_HALFLING) && (IS_HALFLING(ch))) ||
	(IS_OBJ_STAT(obj, ITEM_ANTI_HUMAN) && (IS_HUMAN(ch))))
      return 1;
    else
      return 0;
}

