/* char_routines.h: Data structures for character information

This file is part of the Omega project, which
is based on the web2c distribution of TeX.

Copyright (C) 2000 John Plaice and Yannis Haralambous

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

typedef struct char_entry_struct {
    in_list indices[C_MAX+1];
    unsigned c;
    unsigned tag;
    unsigned remainder;
    unsigned defined;
    unsigned accent;
    unsigned *extens;
    unsigned ovf_packet_length;
    char *ovf_packet;
} char_entry;

extern char_entry *current_character;

extern void print_characters(void);
extern void init_character(unsigned, char_entry *);
extern void copy_characters(unsigned);
extern void init_planes(void);

extern void ensure_existence(unsigned);
extern void check_char_tag(unsigned);
extern void set_char_tag(unsigned,unsigned);
extern void set_char_remainder(unsigned,unsigned);
extern void set_next_larger(unsigned);
extern void init_var_character(void);

typedef struct label_entry_struct {
    int rr;
    int cc;
} label_entry;

extern unsigned no_labels;
extern label_entry *label_table;
extern unsigned label_ptr, sort_ptr;
extern unsigned lk_offset;
extern unsigned extra_loc_needed;


extern void check_and_correct(void);
extern void finalize_dimension_lists(void);
extern void check_existence_all_character_fields(void);
extern void check_charlist_infinite_loops(void);

extern void adjust_labels(void);
extern void print_labels(void);
extern void set_extensible_piece(unsigned,unsigned);
extern void check_existence_and_safety(unsigned,unsigned,string,string);
extern void clear_ligature_entries(void);
extern void doublecheck_extens(void);
extern void print_extens(void);
extern void build_exten_table(void);
extern void doublecheck_existence(unsigned, string,string);
extern void output_ovf_chars(void);

extern unsigned bc;
extern unsigned ec;
extern unsigned ne;

extern void compute_ligkern_offset(void);
extern void compute_character_info_size(void);
extern void output_ofm_extensible(void);
extern void compute_ofm_character_info(void);
extern void output_ofm_character_info(void);
