/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.mappers.msad;

import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.naming.AuthenticationException;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.idm.query.internal.LDAPQuery;
import org.keycloak.storage.ldap.mappers.AbstractLDAPStorageMapper;
import org.keycloak.storage.ldap.mappers.LDAPOperationDecorator;
import org.keycloak.storage.ldap.mappers.PasswordUpdateCallback;
import org.keycloak.storage.ldap.mappers.TxAwareLDAPUserModelDelegate;
import org.keycloak.storage.ldap.mappers.msad.LDAPServerPolicyHintsDecorator;
import org.keycloak.storage.ldap.mappers.msad.UserAccountControl;

public class MSADUserAccountControlStorageMapper
extends AbstractLDAPStorageMapper
implements PasswordUpdateCallback {
    public static final String LDAP_PASSWORD_POLICY_HINTS_ENABLED = "ldap.password.policy.hints.enabled";
    public static final String ALWAYS_READ_ENABLED_VALUE_FROM_LDAP = "always.read.enabled.value.from.ldap";
    private static final Logger logger = Logger.getLogger(MSADUserAccountControlStorageMapper.class);
    private static final Pattern AUTH_EXCEPTION_REGEX = Pattern.compile(".*AcceptSecurityContext error, data ([0-9a-f]*), v.*");
    private static final Pattern ERROR_CODE_REGEX = Pattern.compile(".*ERROR CODE ([0-9A-F]*) - ([0-9A-F]*).*");
    public static final Set<String> PASSWORD_UPDATE_LDAP_ERROR_CODES = Set.of("53", "19");
    public static final Set<String> PASSWORD_UPDATE_MSAD_ERROR_CODES = Set.of("52D");
    private final Function<LDAPObject, UserAccountControl> GET_USER_ACCOUNT_CONTROL = ldapUser -> {
        if (ldapUser == null) {
            return UserAccountControl.empty();
        }
        String userAccountControl = ldapUser.getAttributeAsString("userAccountControl");
        return UserAccountControl.of(userAccountControl);
    };

    public MSADUserAccountControlStorageMapper(ComponentModel mapperModel, LDAPStorageProvider ldapProvider) {
        super(mapperModel, ldapProvider);
        ldapProvider.setUpdater(this);
    }

    @Override
    public void beforeLDAPQuery(LDAPQuery query) {
        query.addReturningLdapAttribute("pwdLastSet");
        query.addReturningLdapAttribute("userAccountControl");
        query.addReturningReadOnlyLdapAttribute("pwdLastSet");
        if (this.ldapProvider.getEditMode() != UserStorageProvider.EditMode.WRITABLE) {
            query.addReturningReadOnlyLdapAttribute("userAccountControl");
        }
    }

    @Override
    public LDAPOperationDecorator beforePasswordUpdate(UserModel user, LDAPObject ldapUser, UserCredentialModel password) {
        if (password.isAdminRequest()) {
            return null;
        }
        boolean applyDecorator = this.mapperModel.get(LDAP_PASSWORD_POLICY_HINTS_ENABLED, false);
        return applyDecorator ? new LDAPServerPolicyHintsDecorator() : null;
    }

    @Override
    public void passwordUpdated(UserModel user, LDAPObject ldapUser, UserCredentialModel password) {
        logger.debugf("Going to update userAccountControl for ldap user '%s' after successful password update. Keycloak user '%s' in realm '%s'", (Object)ldapUser.getDn().toString(), (Object)user.getUsername(), (Object)this.getRealmName());
        ldapUser.removeReadOnlyAttributeName("pwdLastSet");
        ldapUser.setSingleAttribute("pwdLastSet", "-1");
        UserAccountControl control = this.getUserAccountControl(ldapUser);
        control.remove(32L);
        control.remove(0x800000L);
        if (user.isEnabled()) {
            control.remove(2L);
        }
        this.updateUserAccountControl(true, ldapUser, control);
    }

    @Override
    public void passwordUpdateFailed(UserModel user, LDAPObject ldapUser, UserCredentialModel password, ModelException exception) {
        throw this.processFailedPasswordUpdateException(exception);
    }

    @Override
    public UserModel proxy(LDAPObject ldapUser, UserModel delegate, RealmModel realm) {
        return new MSADUserModelDelegate(delegate, ldapUser, MSADUserAccountControlStorageMapper.parseBooleanParameter(this.mapperModel, ALWAYS_READ_ENABLED_VALUE_FROM_LDAP));
    }

    @Override
    public void onRegisterUserToLDAP(LDAPObject ldapUser, UserModel localUser, RealmModel realm) {
    }

    @Override
    public void onImportUserFromLDAP(LDAPObject ldapUser, UserModel user, RealmModel realm, boolean isCreate) {
        user.setEnabled(!this.getUserAccountControl(ldapUser).has(2L));
    }

    @Override
    public boolean onAuthenticationFailure(LDAPObject ldapUser, UserModel user, AuthenticationException ldapException, RealmModel realm) {
        String exceptionMessage = ldapException.getMessage();
        Matcher m = AUTH_EXCEPTION_REGEX.matcher(exceptionMessage);
        if (m.matches()) {
            String errorCode = m.group(1);
            return this.processAuthErrorCode(errorCode, user);
        }
        return false;
    }

    protected boolean processAuthErrorCode(String errorCode, UserModel user) {
        logger.debugf("MSAD Error code is '%s' after failed LDAP login of user '%s'. Realm is '%s'", (Object)errorCode, (Object)user.getUsername(), (Object)this.getRealmName());
        if (this.ldapProvider.getEditMode() == UserStorageProvider.EditMode.WRITABLE) {
            if (errorCode.equals("532") || errorCode.equals("773")) {
                if (user.getRequiredActionsStream().noneMatch(action -> Objects.equals(action, UserModel.RequiredAction.UPDATE_PASSWORD.name()))) {
                    AuthenticationSessionModel authSession = this.session.getContext().getAuthenticationSession();
                    if (authSession != null) {
                        if (authSession.getRequiredActions().stream().noneMatch(action -> Objects.equals(action, UserModel.RequiredAction.UPDATE_PASSWORD.name()))) {
                            logger.debugf("Adding requiredAction UPDATE_PASSWORD to the authenticationSession of user %s", (Object)user.getUsername());
                            authSession.addRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD);
                        }
                    } else {
                        logger.debugf("Adding requiredAction UPDATE_PASSWORD to the user %s", (Object)user.getUsername());
                        user.addRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD);
                    }
                } else {
                    logger.tracef("Skip adding required action UPDATE_PASSWORD. It was already set on user '%s' in realm '%s'", (Object)user.getUsername(), (Object)this.getRealmName());
                }
                return true;
            }
            if (errorCode.equals("533")) {
                if (user.isEnabled()) {
                    user.setEnabled(false);
                }
                return true;
            }
            if (errorCode.equals("775")) {
                logger.warnf("Locked user '%s' attempt to login. Realm is '%s'", (Object)user.getUsername(), (Object)this.getRealmName());
            }
        }
        return false;
    }

    protected ModelException processFailedPasswordUpdateException(ModelException e) {
        if (e.getCause() == null || e.getCause().getMessage() == null) {
            return e;
        }
        String exceptionMessage = e.getCause().getMessage().replace('\n', ' ');
        logger.debugf("Failed to update password in Active Directory. Exception message: %s", (Object)exceptionMessage);
        exceptionMessage = exceptionMessage.toUpperCase();
        Matcher m = ERROR_CODE_REGEX.matcher(exceptionMessage);
        if (m.matches()) {
            String errorCode = m.group(1);
            String errorCode2 = m.group(2);
            if (PASSWORD_UPDATE_LDAP_ERROR_CODES.contains(errorCode)) {
                if (PASSWORD_UPDATE_MSAD_ERROR_CODES.stream().anyMatch(errorCode2::endsWith)) {
                    ModelException me = new ModelException("invalidPasswordGenericMessage", (Throwable)e);
                    return me;
                }
            }
        }
        return e;
    }

    protected UserAccountControl getUserAccountControl(LDAPObject ldapUser) {
        UserAccountControl control = this.GET_USER_ACCOUNT_CONTROL.apply(ldapUser);
        if (control.isAnySet()) {
            return control;
        }
        RealmModel realm = this.session.getContext().getRealm();
        if (realm == null) {
            return control;
        }
        ldapUser = this.ldapProvider.loadLDAPUserByUuid(realm, ldapUser.getUuid());
        return this.GET_USER_ACCOUNT_CONTROL.apply(ldapUser);
    }

    protected void updateUserAccountControl(boolean updateInLDAP, LDAPObject ldapUser, UserAccountControl accountControl) {
        String userAccountControlValue = String.valueOf(accountControl.getValue());
        logger.debugf("Updating userAccountControl of user '%s' to value '%s'. Realm is '%s'", (Object)ldapUser.getDn().toString(), (Object)userAccountControlValue, (Object)this.getRealmName());
        ldapUser.setSingleAttribute("userAccountControl", userAccountControlValue);
        if (updateInLDAP) {
            this.ldapProvider.getLdapIdentityStore().update(ldapUser);
        }
    }

    private String getRealmName() {
        RealmModel realm = this.session.getContext().getRealm();
        return realm != null ? realm.getName() : "null";
    }

    public class MSADUserModelDelegate
    extends TxAwareLDAPUserModelDelegate {
        private final LDAPObject ldapUser;
        private final boolean isAlwaysReadEnabledFromLdap;

        public MSADUserModelDelegate(UserModel delegate, LDAPObject ldapUser, boolean isAlwaysReadEnabledFromLdap) {
            super(delegate, MSADUserAccountControlStorageMapper.this.ldapProvider, ldapUser);
            this.ldapUser = ldapUser;
            this.isAlwaysReadEnabledFromLdap = isAlwaysReadEnabledFromLdap;
        }

        public boolean isEnabled() {
            if (this.isAlwaysReadEnabledFromLdap) {
                return !MSADUserAccountControlStorageMapper.this.getUserAccountControl(this.ldapUser).has(2L);
            }
            return super.isEnabled();
        }

        public void setEnabled(boolean enabled) {
            UserAccountControl control;
            if (UserStorageProvider.EditMode.WRITABLE.equals((Object)MSADUserAccountControlStorageMapper.this.ldapProvider.getEditMode()) && (control = MSADUserAccountControlStorageMapper.this.getUserAccountControl(this.ldapUser)).isAnySet()) {
                logger.debugf("Going to propagate enabled=%s for ldapUser '%s' to MSAD", (Object)enabled, (Object)this.ldapUser.getDn().toString());
                if (enabled) {
                    control.remove(2L);
                } else {
                    control.add(2L);
                }
                this.markUpdatedAttributeInTransaction("enabled");
                MSADUserAccountControlStorageMapper.this.updateUserAccountControl(false, this.ldapUser, control);
            }
            super.setEnabled(enabled);
        }

        public void addRequiredAction(UserModel.RequiredAction action) {
            String actionName = action.name();
            this.addRequiredAction(actionName);
        }

        public void addRequiredAction(String action) {
            if (MSADUserAccountControlStorageMapper.this.ldapProvider.getEditMode() == UserStorageProvider.EditMode.WRITABLE && UserModel.RequiredAction.UPDATE_PASSWORD.toString().equals(action)) {
                logger.debugf("Going to propagate required action UPDATE_PASSWORD to MSAD for ldap user '%s'. Keycloak user '%s' in realm '%s'", (Object)this.ldapUser.getDn().toString(), (Object)this.getUsername(), (Object)MSADUserAccountControlStorageMapper.this.getRealmName());
                this.ldapUser.removeReadOnlyAttributeName("pwdLastSet");
                this.ldapUser.setSingleAttribute("pwdLastSet", "0");
                this.markUpdatedRequiredActionInTransaction(action);
            } else {
                logger.debugf("Going to add required action '%s' of user '%s' in realm '%s' to the DB", (Object)action, (Object)this.getUsername(), (Object)MSADUserAccountControlStorageMapper.this.getRealmName());
                super.addRequiredAction(action);
            }
        }

        public void removeRequiredAction(UserModel.RequiredAction action) {
            String actionName = action.name();
            this.removeRequiredAction(actionName);
        }

        public void removeRequiredAction(String action) {
            super.removeRequiredAction(action);
            if (MSADUserAccountControlStorageMapper.this.ldapProvider.getEditMode() == UserStorageProvider.EditMode.WRITABLE && UserModel.RequiredAction.UPDATE_PASSWORD.toString().equals(action)) {
                UserAccountControl accountControl = MSADUserAccountControlStorageMapper.this.getUserAccountControl(this.ldapUser);
                if (accountControl.getValue() != 0L && !accountControl.has(32L)) {
                    logger.debugf("Going to remove required action UPDATE_PASSWORD from MSAD for ldap user '%s'. Account control: %s, Keycloak user '%s' in realm '%s'", new Object[]{this.ldapUser.getDn().toString(), accountControl.getValue(), this.getUsername(), MSADUserAccountControlStorageMapper.this.getRealmName()});
                    this.ldapUser.removeReadOnlyAttributeName("pwdLastSet");
                    this.ldapUser.setSingleAttribute("pwdLastSet", "-1");
                    this.markUpdatedRequiredActionInTransaction(action);
                } else {
                    logger.tracef("It was not required action to remove UPDATE_PASSWORD from MSAD for ldap user '%s' as it was not set on the user. Account control: %s, Keycloak user '%s' in realm '%s'", new Object[]{this.ldapUser.getDn().toString(), accountControl.getValue(), this.getUsername(), MSADUserAccountControlStorageMapper.this.getRealmName()});
                }
            }
        }

        public Stream<String> getRequiredActionsStream() {
            if (MSADUserAccountControlStorageMapper.this.ldapProvider.getEditMode() == UserStorageProvider.EditMode.WRITABLE && (this.getPwdLastSet() == 0L || MSADUserAccountControlStorageMapper.this.getUserAccountControl(this.ldapUser).has(0x800000L))) {
                logger.tracef("Required action UPDATE_PASSWORD is set in LDAP for user '%s' in realm '%s'", (Object)this.getUsername(), (Object)MSADUserAccountControlStorageMapper.this.getRealmName());
                return Stream.concat(super.getRequiredActionsStream(), Stream.of(UserModel.RequiredAction.UPDATE_PASSWORD.toString())).distinct();
            }
            return super.getRequiredActionsStream();
        }

        protected long getPwdLastSet() {
            String pwdLastSet = this.ldapUser.getAttributeAsString("pwdLastSet");
            return pwdLastSet == null ? 0L : Long.parseLong(pwdLastSet);
        }
    }
}

