/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.capabilities.CapabilitiesMetadata;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactBackedResolvedVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.DefaultArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.model.DefaultImmutableCapability;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactResolveMetadata;
import org.gradle.internal.component.model.ComponentArtifactResolveVariantState;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.gradle.internal.resolve.result.DefaultBuildableArtifactResolveResult;

public class ArtifactSetFactory {
    public static ArtifactSet createFromVariantMetadata(ComponentIdentifier componentIdentifier, ComponentArtifactResolveVariantState allVariants, Set<ResolvedVariant> legacyVariants, AttributesSchemaInternal schema, ImmutableAttributes selectionAttributes) {
        return new DefaultArtifactSet(componentIdentifier, schema, selectionAttributes, allVariants, legacyVariants);
    }

    public static ArtifactSet adHocVariant(ComponentArtifactResolveMetadata component, Collection<? extends ComponentArtifactMetadata> artifacts, AttributesSchemaInternal schema, ArtifactResolver artifactResolver, ImmutableAttributes variantAttributes, ImmutableAttributes selectionAttributes) {
        SingleArtifactVariantIdentifier identifier = null;
        if (artifacts.size() == 1) {
            identifier = new SingleArtifactVariantIdentifier(artifacts.iterator().next().getId());
        }
        ComponentIdentifier componentIdentifier = component.getId();
        ModuleVersionIdentifier ownerId = component.getModuleVersionId();
        ResolvedVariant resolvedVariant = ArtifactSetFactory.toResolvedVariant(identifier, Describables.of((Object)componentIdentifier), variantAttributes, (List<? extends ComponentArtifactMetadata>)ImmutableList.copyOf(artifacts), (CapabilitiesMetadata)ImmutableCapabilities.of((Capability)DefaultImmutableCapability.defaultCapabilityForComponent(ownerId)), component, artifactResolver);
        return new DefaultArtifactSet(componentIdentifier, schema, selectionAttributes, () -> Collections.singleton(resolvedVariant), Collections.singleton(resolvedVariant));
    }

    public static ResolvedVariant toResolvedVariant(@Nullable VariantResolveMetadata.Identifier identifier, DisplayName displayName, ImmutableAttributes variantAttributes, List<? extends ComponentArtifactMetadata> artifacts, CapabilitiesMetadata capabilitiesMetadata, ComponentArtifactResolveMetadata component, ArtifactResolver artifactResolver) {
        return ArtifactBackedResolvedVariant.create(identifier, displayName, (AttributeContainerInternal)variantAttributes, capabilitiesMetadata, ArtifactSetFactory.supplyLazilyResolvedArtifacts(component, artifacts, artifactResolver));
    }

    private static Supplier<Collection<? extends ResolvableArtifact>> supplyLazilyResolvedArtifacts(ComponentArtifactResolveMetadata component, List<? extends ComponentArtifactMetadata> artifacts, ArtifactResolver artifactResolver) {
        return () -> {
            ImmutableSet.Builder resolvedArtifacts = ImmutableSet.builder();
            for (ComponentArtifactMetadata artifact : artifacts) {
                DefaultBuildableArtifactResolveResult result = new DefaultBuildableArtifactResolveResult();
                artifactResolver.resolveArtifact(component, artifact, result);
                if (artifact.isOptionalArtifact()) {
                    try {
                        ((ResolvableArtifact)result.getResult()).getFile();
                    }
                    catch (Exception e) {
                        continue;
                    }
                }
                resolvedArtifacts.add((Object)((ResolvableArtifact)result.getResult()));
            }
            return resolvedArtifacts.build();
        };
    }

    private static class SingleArtifactVariantIdentifier
    implements VariantResolveMetadata.Identifier {
        private final ComponentArtifactIdentifier artifactIdentifier;

        public SingleArtifactVariantIdentifier(ComponentArtifactIdentifier artifactIdentifier) {
            this.artifactIdentifier = artifactIdentifier;
        }

        public int hashCode() {
            return this.artifactIdentifier.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            SingleArtifactVariantIdentifier other = (SingleArtifactVariantIdentifier)obj;
            return this.artifactIdentifier.equals(other.artifactIdentifier);
        }
    }
}

