#include "xbill.h"
#include "pixmaps.h"
#include "pixmapfiles.h"

extern Display *display;
extern Drawable rootwindow, window;
extern Pixmap offscreen;
extern Colormap colormap;
extern GC gc;
extern int depth;
extern XGCValues values;

void load_bill_pixmaps (horde *bill, XpmAttributes attr) {
	int i;
	i=XpmCreatePixmapFromData(display, rootwindow, bill1l_xpm, &bill->lcels[0],
		&bill->lmask[0], &attr);
	bill->lcontexts[0] = XCreateGC (display, offscreen, GCForeground|GCBackground,
		&values);
	XSetGraphicsExposures(display, bill->lcontexts[0], FALSE);
	XSetClipMask(display, bill->lcontexts[0], bill->lmask[0]);
	
	i=XpmCreatePixmapFromData(display, rootwindow, bill2l_xpm, &bill->lcels[1],
		&bill->lmask[1], &attr);
	bill->lcontexts[1] = XCreateGC (display, offscreen, GCForeground|GCBackground,
		&values);
	XSetGraphicsExposures(display, bill->lcontexts[1], FALSE);
	XSetClipMask(display, bill->lcontexts[1], bill->lmask[1]);
	
	i=XpmCreatePixmapFromData(display, rootwindow, bill3l_xpm, &bill->lcels[2],
		&bill->lmask[2], &attr);
	bill->lcontexts[2] = XCreateGC (display, offscreen, GCForeground|GCBackground,
		&values);
	XSetGraphicsExposures(display, bill->lcontexts[2], FALSE);
	XSetClipMask(display, bill->lcontexts[2], bill->lmask[2]);
	
	bill->lcels[3] = bill->lcels[1]; 
	bill->lcontexts[3] = bill->lcontexts[1]; 
		
	i=XpmCreatePixmapFromData(display, rootwindow, bill1r_xpm, &bill->rcels[0],
		&bill->rmask[0], &attr);
	bill->rcontexts[0] = XCreateGC (display, offscreen, GCForeground|GCBackground,
		&values);
	XSetGraphicsExposures(display, bill->rcontexts[0], FALSE);
	XSetClipMask(display, bill->rcontexts[0], bill->rmask[0]);
	
	i=XpmCreatePixmapFromData(display, rootwindow, bill2r_xpm, &bill->rcels[1],
		&bill->rmask[1], &attr);
	bill->rcontexts[1] = XCreateGC (display, offscreen, GCForeground|GCBackground,
		&values);
	XSetGraphicsExposures(display, bill->rcontexts[1], FALSE);
	XSetClipMask(display, bill->rcontexts[1], bill->rmask[1]);
	
	i=XpmCreatePixmapFromData(display, rootwindow, bill3r_xpm, &bill->rcels[2],
		&bill->rmask[2], &attr);
	bill->rcontexts[2] = XCreateGC (display, offscreen, GCForeground|GCBackground,
		&values);
	XSetGraphicsExposures(display, bill->rcontexts[2], FALSE);
	XSetClipMask(display, bill->rcontexts[2], bill->rmask[2]);
		
	bill->rcels[3] = bill->rcels[1]; 
	bill->rcontexts[3] = bill->rcontexts[1]; 


	i=XpmCreatePixmapFromData(display, rootwindow, bdeath1_xpm, &bill->dcels[0],
		&bill->dmask[0], &attr);
	bill->dcontexts[0] = XCreateGC (display, offscreen, GCForeground|GCBackground,
		&values);
	XSetGraphicsExposures(display, bill->dcontexts[0], FALSE);
	XSetClipMask(display, bill->dcontexts[0], bill->dmask[0]);
	
	i=XpmCreatePixmapFromData(display, rootwindow, bdeath2_xpm, &bill->dcels[1],
		&bill->dmask[1], &attr);
	bill->dcontexts[1] = XCreateGC (display, offscreen, GCForeground|GCBackground,
		&values);
	XSetGraphicsExposures(display, bill->dcontexts[1], FALSE);
	XSetClipMask(display, bill->dcontexts[1], bill->dmask[1]);
	
	i=XpmCreatePixmapFromData(display, rootwindow, bdeath3_xpm, &bill->dcels[2],
		&bill->dmask[2], &attr);
	bill->dcontexts[2] = XCreateGC (display, offscreen, GCForeground|GCBackground,
		&values);
	XSetGraphicsExposures(display, bill->dcontexts[2], FALSE);
	XSetClipMask(display, bill->dcontexts[2], bill->dmask[2]);

	i=XpmCreatePixmapFromData(display, rootwindow, bdeath4_xpm, &bill->dcels[3],
		&bill->dmask[3], &attr);
	bill->dcontexts[3] = XCreateGC (display, offscreen, GCForeground|GCBackground,
		&values);
	XSetGraphicsExposures(display, bill->dcontexts[3], FALSE);
	XSetClipMask(display, bill->dcontexts[3], bill->dmask[3]);
	
	i=XpmCreatePixmapFromData(display, rootwindow, bdeath5_xpm, &bill->dcels[4],
		&bill->dmask[4], &attr);
	bill->dcontexts[4] = XCreateGC (display, offscreen, GCForeground|GCBackground,
		&values);
	XSetGraphicsExposures(display, bill->dcontexts[4], FALSE);
	XSetClipMask(display, bill->dcontexts[4], bill->dmask[4]);
	
	bill->width=attr.width;
	bill->height=attr.height;

	i=XpmCreatePixmapFromData(display, rootwindow, billa1_xpm, &bill->acels[0],
		&bill->amask[0], &attr);
	bill->acontexts[0] = XCreateGC (display, offscreen, GCForeground|GCBackground,
		&values);
	XSetGraphicsExposures(display, bill->acontexts[0], FALSE);
	XSetClipMask(display, bill->acontexts[0], bill->amask[0]);

	i=XpmCreatePixmapFromData(display, rootwindow, billa2_xpm, &bill->acels[1],
		&bill->amask[1], &attr);
	bill->acontexts[1] = XCreateGC (display, offscreen, GCForeground|GCBackground,
		&values);
	XSetGraphicsExposures(display, bill->acontexts[1], FALSE);
	XSetClipMask(display, bill->acontexts[1], bill->amask[1]);

	i=XpmCreatePixmapFromData(display, rootwindow, billa3_xpm, &bill->acels[2],
		&bill->amask[2], &attr);
	bill->acontexts[2] = XCreateGC (display, offscreen, GCForeground|GCBackground,
		&values);
	XSetGraphicsExposures(display, bill->acontexts[2], FALSE);
	XSetClipMask(display, bill->acontexts[2], bill->amask[2]);

	i=XpmCreatePixmapFromData(display, rootwindow, billa4_xpm, &bill->acels[3],
		&bill->amask[3], &attr);
	bill->acontexts[3] = XCreateGC (display, offscreen, GCForeground|GCBackground,
		&values);
	XSetGraphicsExposures(display, bill->acontexts[3], FALSE);
	XSetClipMask(display, bill->acontexts[3], bill->amask[3]);

	i=XpmCreatePixmapFromData(display, rootwindow, billa5_xpm, &bill->acels[4],
		&bill->amask[4], &attr);
	bill->acontexts[4] = XCreateGC (display, offscreen, GCForeground|GCBackground,
		&values);
	XSetGraphicsExposures(display, bill->acontexts[4], FALSE);
	XSetClipMask(display, bill->acontexts[4], bill->amask[4]);

	i=XpmCreatePixmapFromData(display, rootwindow, billa6_xpm, &bill->acels[5],
		&bill->amask[5], &attr);
	bill->acontexts[5] = XCreateGC (display, offscreen, GCForeground|GCBackground,
		&values);
	XSetGraphicsExposures(display, bill->acontexts[5], FALSE);
	XSetClipMask(display, bill->acontexts[5], bill->amask[5]);

	i=XpmCreatePixmapFromData(display, rootwindow, billa7_xpm, &bill->acels[6],
		&bill->amask[6], &attr);
	bill->acontexts[6] = XCreateGC (display, offscreen, GCForeground|GCBackground,
		&values);
	XSetGraphicsExposures(display, bill->acontexts[6], FALSE);
	XSetClipMask(display, bill->acontexts[6], bill->amask[6]);

	i=XpmCreatePixmapFromData(display, rootwindow, billa8_xpm, &bill->acels[7],
		&bill->amask[7], &attr);
	bill->acontexts[7] = XCreateGC (display, offscreen, GCForeground|GCBackground,
		&values);
	XSetGraphicsExposures(display, bill->acontexts[7], FALSE);
	XSetClipMask(display, bill->acontexts[7], bill->amask[7]);

	i=XpmCreatePixmapFromData(display, rootwindow, billa9_xpm, &bill->acels[8],
		&bill->amask[8], &attr);
	bill->acontexts[8] = XCreateGC (display, offscreen, GCForeground|GCBackground,
		&values);
	XSetGraphicsExposures(display, bill->acontexts[8], FALSE);
	XSetClipMask(display, bill->acontexts[8], bill->amask[8]);

	i=XpmCreatePixmapFromData(display, rootwindow, billa10_xpm, &bill->acels[9],
		&bill->amask[9], &attr);
	bill->acontexts[9] = XCreateGC (display, offscreen, GCForeground|GCBackground,
		&values);
	XSetGraphicsExposures(display, bill->acontexts[9], FALSE);
	XSetClipMask(display, bill->acontexts[9], bill->amask[9]);

	i=XpmCreatePixmapFromData(display, rootwindow, billa11_xpm, &bill->acels[10],
		&bill->amask[10], &attr);
	bill->acontexts[10] = XCreateGC (display, offscreen, GCForeground|GCBackground,
		&values);
	XSetGraphicsExposures(display, bill->acontexts[10], FALSE);
	XSetClipMask(display, bill->acontexts[10], bill->amask[10]);

	i=XpmCreatePixmapFromData(display, rootwindow, billa12_xpm, &bill->acels[11],
		&bill->amask[11], &attr);
	bill->acontexts[11] = XCreateGC (display, offscreen, GCForeground|GCBackground,
		&values);
	XSetGraphicsExposures(display, bill->acontexts[11], FALSE);
	XSetClipMask(display, bill->acontexts[11], bill->amask[11]);

	i=XpmCreatePixmapFromData(display, rootwindow, billa13_xpm, &bill->acels[12],
		&bill->amask[12], &attr);
	bill->acontexts[12] = XCreateGC (display, offscreen, GCForeground|GCBackground,
		&values);
	XSetGraphicsExposures(display, bill->acontexts[12], FALSE);
	XSetClipMask(display, bill->acontexts[12], bill->amask[12]);

	bill->awidth=attr.width;
	bill->aheight=attr.height;

}

void load_systems_pixmaps_and_bitmaps(library *systems, XpmAttributes attr) {
	Pixmap temp;
	XColor fg, bg;
	int i;

        i=XpmCreatePixmapFromData(display, rootwindow, wingdows_xpm, &systems->os[0],
                NULL, &attr);
        i=XpmCreatePixmapFromData(display, rootwindow, apple_xpm, &systems->os[1],
                NULL, &attr);
        i=XpmCreatePixmapFromData(display, rootwindow, next_xpm, &systems->os[2],
                NULL, &attr);
        i=XpmCreatePixmapFromData(display, rootwindow, os2_xpm, &systems->os[3],
                NULL, &attr);
        i=XpmCreatePixmapFromData(display, rootwindow, sgi_xpm, &systems->os[4],
                NULL, &attr);
        i=XpmCreatePixmapFromData(display, rootwindow, sun_xpm, &systems->os[5],
                NULL, &attr);

        systems->width = attr.width;
        systems->height = attr.height;

        fg.pixel=values.foreground;
        XQueryColor(display, colormap, &fg);
        bg.pixel=values.background;
        XQueryColor(display, colormap, &bg);

        temp = XCreateBitmapFromData(display, rootwindow, apple_bits,
                apple_width, apple_height);
        systems->cursor[1] = XCreatePixmapCursor(display, temp, temp,
                &fg, &bg, 0, 0);

        temp = XCreateBitmapFromData(display, rootwindow, next_bits,
                next_width, next_height);
        systems->cursor[2] = XCreatePixmapCursor(display, temp, temp,
                &fg, &bg, 0, 0);

        temp = XCreateBitmapFromData(display, rootwindow, os2_bits,
                os2_width, os2_height);
        systems->cursor[3] = XCreatePixmapCursor(display, temp, temp,
                &fg, &bg, 0, 0);

        temp = XCreateBitmapFromData(display, rootwindow, sgi_bits,
                sgi_width, sgi_height);
        systems->cursor[4] = XCreatePixmapCursor(display, temp, temp,
                &fg, &bg, 0, 0);

        temp = XCreateBitmapFromData(display, rootwindow, sun_bits,
                sun_width, sun_height);
        systems->cursor[5] = XCreatePixmapCursor(display, temp, temp,
                &fg, &bg, 0, 0);
}


void load_net_pixmaps (network *net, library *systems, XpmAttributes attr) {
	int i;

	XpmCreatePixmapFromData(display, rootwindow, toaster_xpm,
		&net->pictures[0][OFF_STATE], NULL, &attr);
	XpmCreatePixmapFromData(display, rootwindow, maccpu_xpm,
		&net->pictures[1][OFF_STATE], NULL, &attr);
	XpmCreatePixmapFromData(display, rootwindow, nextcpu_xpm,
		&net->pictures[2][OFF_STATE], NULL, &attr);
	XpmCreatePixmapFromData(display, rootwindow, os2cpu_xpm,
		&net->pictures[3][OFF_STATE], NULL, &attr);
	XpmCreatePixmapFromData(display, rootwindow, sgicpu_xpm,
		&net->pictures[4][OFF_STATE], NULL, &attr);
	XpmCreatePixmapFromData(display, rootwindow, suncpu_xpm,
		&net->pictures[5][OFF_STATE], NULL, &attr);
	net->width = attr.width;
	net->height = attr.height;
	for (i=1; i<=NUM_OS;i++){
		net->pictures[i][BASE_STATE] = XCreatePixmap(display,
			window, net->width, net->height, depth);
		XCopyArea(display, net->pictures[i][OFF_STATE],
			net->pictures[i][BASE_STATE], gc,
			0, 0, net->width, net->height, 0, 0);
		XCopyArea(display, systems->os[i],
			net->pictures[i][BASE_STATE], gc,
			0, 0, systems->width, systems->height,
			OS_OFFSET, OS_OFFSET);
		net->pictures[i][WINGDOWS_STATE] = XCreatePixmap(display,
			rootwindow, net->width, net->height, depth);
		XCopyArea(display, net->pictures[i][OFF_STATE],
			net->pictures[i][WINGDOWS_STATE], gc,
			0, 0, net->width, net->height, 0, 0);
		XCopyArea(display, systems->os[0],
			net->pictures[i][WINGDOWS_STATE],
			gc, 0, 0, systems->width, systems->height,
			OS_OFFSET, OS_OFFSET);
	}
}

void load_cursors(Pixmap *defaultcursor, Pixmap *downcursor) {
	Pixmap temp, tempmask;
	XColor fg, bg;

        bg.pixel=values.background;
        XQueryColor(display, colormap, &bg);
        XParseColor(display, colormap, "black", &fg);
        temp = XCreateBitmapFromData(display, rootwindow, hand_up_bits,
                hand_up_width, hand_up_height);
        tempmask = XCreateBitmapFromData(display, rootwindow, hand_up_mask_bits,
                hand_up_mask_width, hand_up_mask_height);
        *defaultcursor = XCreatePixmapCursor(display, temp, tempmask,
                &fg, &bg, hand_up_width/2, hand_up_height/2);
        temp = XCreateBitmapFromData(display, rootwindow, hand_down_bits,
                hand_down_width, hand_down_height);
        tempmask = XCreateBitmapFromData(display, rootwindow, hand_down_mask_bits,
                hand_down_mask_width, hand_down_mask_height);
        *downcursor = XCreatePixmapCursor(display, temp, tempmask,
                &fg, &bg, hand_down_height/2, hand_down_height/2);
}	

void load_icon (Pixmap *icon, XpmAttributes attr) {
	int i;
	i=XpmCreatePixmapFromData(display, rootwindow, icon_xpm,
		icon, NULL, &attr);
}

void load_logo (Pixmap *logo, XpmAttributes attr) {
	int i;
	i=XpmCreatePixmapFromData(display, rootwindow, logo_xpm,
		logo, NULL, &attr);
}

void load_dialog_pixmaps (Pixmap *about_pix, Pixmap *rules_pix,
	Pixmap *thanks_pix, Pixmap *story_pix, Pixmap *freeware_pix,
	XpmAttributes attr)
{
	int i;
	i=XpmCreatePixmapFromData(display, rootwindow, about_xpm,
		about_pix, NULL, &attr);
	i=XpmCreatePixmapFromData(display, rootwindow, thanks_xpm,
		thanks_pix, NULL, &attr);
	i=XpmCreatePixmapFromData(display, rootwindow, rules_xpm,
		rules_pix, NULL, &attr);
	i=XpmCreatePixmapFromData(display, rootwindow, story_xpm,
		story_pix, NULL, &attr);
	i=XpmCreatePixmapFromData(display, rootwindow, freeware_xpm,
		freeware_pix, NULL, &attr);
}
