/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;

public class GregorianCalendar
extends Calendar {
    public static final int BC = 0;
    public static final int AD = 1;
    private long gregorianCutover;
    static final long serialVersionUID = -8125100834729963327L;
    private static final String bundleName = "gnu.java.locale.Calendar";
    private static final int[] minimums;
    private static final int[] maximums;

    private static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle(bundleName, locale);
    }

    public GregorianCalendar() {
        this(TimeZone.getDefault(), Locale.getDefault());
    }

    public GregorianCalendar(TimeZone zone) {
        this(zone, Locale.getDefault());
    }

    public GregorianCalendar(Locale locale) {
        this(TimeZone.getDefault(), locale);
    }

    public GregorianCalendar(TimeZone zone, Locale locale) {
        super(zone, locale);
        ResourceBundle rb = GregorianCalendar.getBundle(locale);
        this.gregorianCutover = ((Date)rb.getObject("gregorianCutOver")).getTime();
        this.setTimeInMillis(System.currentTimeMillis());
    }

    public GregorianCalendar(int year, int month, int day) {
        this.set(year, month, day);
    }

    public GregorianCalendar(int year, int month, int day, int hour, int minute) {
        this.set(year, month, day, hour, minute);
    }

    public GregorianCalendar(int year, int month, int day, int hour, int minute, int second) {
        this.set(year, month, day, hour, minute, second);
    }

    public void setGregorianChange(Date date) {
        this.gregorianCutover = date.getTime();
    }

    public final Date getGregorianChange() {
        return new Date(this.gregorianCutover);
    }

    public boolean isLeapYear(int year) {
        if ((year & 3) != 0) {
            return false;
        }
        int julianDay = ((year - 1) * 1461 >> 2) + -719105;
        if ((long)julianDay * 86400000L < this.gregorianCutover) {
            return true;
        }
        return year % 100 != 0 || year % 400 == 0;
    }

    private long getLinearTime(int year, int dayOfYear, int millis) {
        int julianDay = (year * 1461 >> 2) + dayOfYear - 719530;
        long time = (long)julianDay * 86400000L + (long)millis;
        if (time >= this.gregorianCutover) {
            int gregOffset = year / 400 - year / 100 + 2;
            if (this.isLeapYear(year, true)) {
                --gregOffset;
            }
            time += (long)gregOffset * 86400000L;
        }
        return time;
    }

    private int getWeekDay(int year, int dayOfYear) {
        int day = (int)(this.getLinearTime(year, dayOfYear, 0) / 86400000L);
        int weekday = (day + 5) % 7;
        if (weekday <= 0) {
            weekday += 7;
        }
        return weekday;
    }

    private int[] getDayOfYear(int year) {
        int dayOfYear;
        if (this.isSet[2]) {
            if (this.fields[2] > 1) {
                dayOfYear = (this.fields[2] * 153 - 9) / 5;
                if (this.isLeapYear(year)) {
                    ++dayOfYear;
                }
            } else {
                dayOfYear = 31 * this.fields[2];
            }
            if (this.isSet[5]) {
                return new int[]{dayOfYear + this.fields[5], 0};
            }
            if (this.isSet[4] && this.isSet[7]) {
                int weekday = this.getWeekDay(year, ++dayOfYear);
                return new int[]{dayOfYear, this.fields[7] - weekday + 7 * (this.fields[4] + (this.fields[7] < this.getFirstDayOfWeek() ? 0 : -1) + (weekday < this.getFirstDayOfWeek() ? -1 : 0))};
            }
            if (this.isSet[7] && this.isSet[8]) {
                int weekday = this.getWeekDay(year, ++dayOfYear);
                return new int[]{dayOfYear, this.fields[7] - weekday + 7 * (this.fields[8] + (this.fields[7] < weekday ? 0 : -1))};
            }
        }
        if (this.isSet[6]) {
            return new int[]{0, this.fields[6]};
        }
        if (this.isSet[7] && this.isSet[3]) {
            dayOfYear = this.getMinimalDaysInFirstWeek();
            int weekday = this.getWeekDay(year, dayOfYear);
            return new int[]{dayOfYear, this.fields[7] - weekday + 7 * (this.fields[3] + (this.fields[7] < this.getFirstDayOfWeek() ? 0 : -1) + (weekday < this.getFirstDayOfWeek() ? -1 : 0))};
        }
        return new int[]{1, 0};
    }

    protected synchronized void computeTime() {
        int millisInDay;
        int millis;
        int year;
        int era = this.isSet[0] ? this.fields[0] : 1;
        int n = year = this.isSet[1] ? this.fields[1] : 1970;
        if (era == 0) {
            year = 1 - year;
        }
        int[] daysOfYear = this.getDayOfYear(year);
        int hour = 0;
        if (this.isSet[11]) {
            hour = this.fields[11];
        } else if (this.isSet[10]) {
            hour = this.fields[10];
            if (this.isSet[9] && this.fields[9] == 1 && hour != 12) {
                hour += 12;
            }
            if (this.isSet[9] && this.fields[9] == 0 && hour == 12) {
                hour = 0;
            }
        }
        int minute = this.isSet[12] ? this.fields[12] : 0;
        int second = this.isSet[13] ? this.fields[13] : 0;
        int n2 = millis = this.isSet[14] ? this.fields[14] : 0;
        if (this.isLenient()) {
            long allMillis = (((long)hour * (long)60 + (long)minute) * (long)60 + (long)second) * (long)1000 + (long)millis;
            daysOfYear[1] = daysOfYear[1] + (int)(allMillis / 86400000L);
            millisInDay = (int)(allMillis % 86400000L);
        } else {
            if (hour < 0 || hour >= 24 || minute < 0 || minute > 59 || second < 0 || second > 59 || millis < 0 || millis >= 1000) {
                throw new IllegalArgumentException();
            }
            millisInDay = ((hour * 60 + minute) * 60 + second) * 1000 + millis;
        }
        this.time = this.getLinearTime(year, daysOfYear[0], millisInDay);
        this.time += (long)daysOfYear[1] * 86400000L;
        TimeZone zone = this.getTimeZone();
        int rawOffset = this.isSet[15] ? this.fields[15] : zone.getRawOffset();
        int dayOfYear = daysOfYear[0] + daysOfYear[1];
        int month = (dayOfYear * 5 + 3) / 153;
        int day = (6 + (dayOfYear * 5 + 3) % 153) / 5;
        int weekday = ((int)(this.time / 86400000L) + 5) % 7;
        if (weekday <= 0) {
            weekday += 7;
        }
        int dstOffset = this.isSet[16] ? this.fields[16] : zone.getOffset(year < 0 ? 0 : 1, year < 0 ? 1 - year : year, month, day, weekday, millisInDay) - zone.getRawOffset();
        this.time -= (long)(rawOffset + dstOffset);
        this.isTimeSet = true;
    }

    private boolean isLeapYear(int year, boolean gregorian) {
        if ((year & 3) != 0) {
            return false;
        }
        if (!gregorian) {
            return true;
        }
        return year % 100 != 0 || year % 400 == 0;
    }

    private int getLinearDay(int year, int dayOfYear, boolean gregorian) {
        int julianDay = (year * 1461 >> 2) + dayOfYear - 719530;
        if (gregorian) {
            int gregOffset = year / 400 - year / 100 + 2;
            if (this.isLeapYear(year, true) && dayOfYear < 60) {
                --gregOffset;
            }
            julianDay += gregOffset;
        }
        return julianDay;
    }

    private void calculateDay(int day, boolean gregorian) {
        int leapday;
        int firstDayOfYear;
        int weekday = (day + 5) % 7;
        if (weekday <= 0) {
            weekday += 7;
        }
        this.fields[7] = weekday;
        int year = 1970 + (gregorian ? (day - 100) * 400 / 146097 : (day - 100) * 4 / 1461);
        if (day >= 0) {
            ++year;
        }
        if (day < (firstDayOfYear = this.getLinearDay(year, 1, gregorian))) {
            firstDayOfYear = this.getLinearDay(--year, 1, gregorian);
        }
        this.fields[6] = day -= firstDayOfYear - 1;
        if (year <= 0) {
            this.fields[0] = 0;
            this.fields[1] = 1 - year;
        } else {
            this.fields[0] = 1;
            this.fields[1] = year;
        }
        int n = leapday = this.isLeapYear(year, gregorian) ? 1 : 0;
        if (day <= 59 + leapday) {
            this.fields[2] = day / 32;
            this.fields[5] = day - 31 * this.fields[2];
        } else {
            int scaledDay = (day - leapday) * 5 + 8;
            this.fields[2] = scaledDay / 153;
            this.fields[5] = scaledDay % 153 / 5 + 1;
        }
    }

    protected synchronized void computeFields() {
        int firstWeekday;
        boolean gregorian = this.time >= this.gregorianCutover;
        TimeZone zone = this.getTimeZone();
        this.fields[15] = zone.getRawOffset();
        long localTime = this.time + (long)this.fields[15];
        int day = (int)(localTime / 86400000L);
        int millisInDay = (int)(localTime % 86400000L);
        if (millisInDay < 0) {
            millisInDay += 86400000;
            --day;
        }
        this.calculateDay(day, gregorian);
        this.fields[16] = zone.getOffset(this.fields[0], this.fields[1], this.fields[2], this.fields[5], this.fields[7], millisInDay) - this.fields[15];
        if ((millisInDay += this.fields[16]) >= 86400000) {
            millisInDay -= 86400000;
            this.calculateDay(++day, gregorian);
        }
        this.fields[8] = (this.fields[5] + 6) / 7;
        int relativeWeekday = (7 + this.fields[7] - this.getFirstDayOfWeek()) % 7;
        this.fields[4] = (this.fields[5] - relativeWeekday + 12) / 7;
        int weekOfYear = (this.fields[6] - relativeWeekday + 6) / 7;
        int minDays = this.getMinimalDaysInFirstWeek();
        if (minDays - (firstWeekday = (7 + this.getWeekDay(this.fields[1], minDays) - this.getFirstDayOfWeek()) % 7) < 1) {
            // empty if block
        }
        this.fields[3] = ++weekOfYear;
        int hourOfDay = millisInDay / 3600000;
        this.fields[9] = hourOfDay < 12 ? 0 : 1;
        int hour = hourOfDay % 12;
        this.fields[10] = hour == 0 ? 12 : hour;
        this.fields[11] = hourOfDay;
        this.fields[12] = (millisInDay %= 3600000) / 60000;
        this.fields[13] = (millisInDay %= 60000) / 1000;
        this.fields[14] = millisInDay % 1000;
        this.isSet[16] = true;
        this.isSet[15] = true;
        this.isSet[14] = true;
        this.isSet[13] = true;
        this.isSet[12] = true;
        this.isSet[11] = true;
        this.isSet[10] = true;
        this.isSet[9] = true;
        this.isSet[8] = true;
        this.isSet[7] = true;
        this.isSet[6] = true;
        this.isSet[5] = true;
        this.isSet[4] = true;
        this.isSet[3] = true;
        this.isSet[2] = true;
        this.isSet[1] = true;
        this.isSet[0] = true;
        this.areFieldsSet = true;
    }

    public boolean equals(Object o) {
        if (!(o instanceof GregorianCalendar)) {
            return false;
        }
        GregorianCalendar cal = (GregorianCalendar)o;
        return cal.getTimeInMillis() == this.getTimeInMillis();
    }

    public void add(int field, int amount) {
        switch (field) {
            case 1: {
                this.complete();
                this.fields[1] = this.fields[1] + amount;
                this.isTimeSet = false;
                break;
            }
            case 2: {
                this.complete();
                int months = this.fields[2] + amount;
                this.fields[1] = this.fields[1] + months / 12;
                this.fields[2] = months % 12;
                if (this.fields[2] < 0) {
                    this.fields[2] = this.fields[2] + 12;
                    this.fields[1] = this.fields[1] - 1;
                }
                this.isTimeSet = false;
                int maxDay = this.getActualMaximum(5);
                if (this.fields[5] <= maxDay) break;
                this.fields[5] = maxDay;
                this.isTimeSet = false;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                if (!this.isTimeSet) {
                    this.computeTime();
                }
                this.time += (long)amount * 86400000L;
                this.areFieldsSet = false;
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                if (!this.isTimeSet) {
                    this.computeTime();
                }
                this.time += (long)amount * 604800000L;
                this.areFieldsSet = false;
                break;
            }
            case 9: {
                if (!this.isTimeSet) {
                    this.computeTime();
                }
                this.time += (long)amount * 43200000L;
                this.areFieldsSet = false;
                break;
            }
            case 10: 
            case 11: {
                if (!this.isTimeSet) {
                    this.computeTime();
                }
                this.time += (long)amount * 3600000L;
                this.areFieldsSet = false;
                break;
            }
            case 12: {
                if (!this.isTimeSet) {
                    this.computeTime();
                }
                this.time += (long)amount * 60000L;
                this.areFieldsSet = false;
                break;
            }
            case 13: {
                if (!this.isTimeSet) {
                    this.computeTime();
                }
                this.time += (long)amount * (long)1000;
                this.areFieldsSet = false;
                break;
            }
            case 14: {
                if (!this.isTimeSet) {
                    this.computeTime();
                }
                this.time += (long)amount;
                this.areFieldsSet = false;
                break;
            }
            case 15: {
                this.complete();
                this.fields[15] = this.fields[15] + amount;
                this.time -= (long)amount;
                break;
            }
            case 16: {
                this.complete();
                this.fields[16] = this.fields[16] + amount;
                this.isTimeSet = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Calendar field: " + field);
            }
        }
    }

    public void roll(int field, boolean up) {
        this.roll(field, up ? 1 : -1);
    }

    private void cleanUpAfterRoll(int field, int delta) {
        switch (field) {
            case 0: 
            case 1: 
            case 2: {
                if (this.fields[5] > this.getActualMaximum(5)) {
                    this.fields[5] = this.getActualMaximum(5);
                }
                this.isTimeSet = false;
                this.isSet[4] = false;
                this.isSet[7] = false;
                this.isSet[8] = false;
                this.isSet[6] = false;
                this.isSet[3] = false;
                break;
            }
            case 5: {
                this.isSet[4] = false;
                this.isSet[7] = false;
                this.isSet[8] = false;
                this.isSet[6] = false;
                this.isSet[3] = false;
                this.time += (long)delta * 86400000L;
                break;
            }
            case 4: {
                this.isSet[5] = false;
                this.isSet[8] = false;
                this.isSet[6] = false;
                this.isSet[3] = false;
                this.time += (long)delta * 604800000L;
                break;
            }
            case 8: {
                this.isSet[5] = false;
                this.isSet[4] = false;
                this.isSet[6] = false;
                this.isSet[3] = false;
                this.time += (long)delta * 604800000L;
                break;
            }
            case 6: {
                this.isSet[2] = false;
                this.isSet[5] = false;
                this.isSet[4] = false;
                this.isSet[8] = false;
                this.isSet[7] = false;
                this.isSet[3] = false;
                this.time += (long)delta * 86400000L;
                break;
            }
            case 3: {
                this.isSet[2] = false;
                this.isSet[5] = false;
                this.isSet[4] = false;
                this.isSet[8] = false;
                this.isSet[6] = false;
                this.time += (long)delta * 604800000L;
                break;
            }
            case 9: {
                this.isSet[11] = false;
                this.time += (long)delta * 43200000L;
                break;
            }
            case 10: {
                this.isSet[11] = false;
                this.time += (long)delta * 3600000L;
                break;
            }
            case 11: {
                this.isSet[10] = false;
                this.isSet[9] = false;
                this.time += (long)delta * 3600000L;
                break;
            }
            case 12: {
                this.time += (long)delta * 60000L;
                break;
            }
            case 13: {
                this.time += (long)delta * (long)1000;
                break;
            }
            case 14: {
                this.time += (long)delta;
            }
        }
    }

    public void roll(int field, int amount) {
        switch (field) {
            case 7: {
                this.add(field, amount);
                return;
            }
            case 15: 
            case 16: {
                throw new IllegalArgumentException("Can't roll time zone");
            }
        }
        this.complete();
        int min = this.getActualMinimum(field);
        int range = this.getActualMaximum(field) - min + 1;
        int oldval = this.fields[field];
        int newval = (oldval - min + range + amount) % range + min;
        if (newval < min) {
            newval += range;
        }
        this.fields[field] = newval;
        this.cleanUpAfterRoll(field, newval - oldval);
    }

    public int getMinimum(int field) {
        return minimums[field];
    }

    public int getMaximum(int field) {
        return maximums[field];
    }

    public int getGreatestMinimum(int field) {
        if (field == 3) {
            return 1;
        }
        return minimums[field];
    }

    public int getLeastMaximum(int field) {
        switch (field) {
            case 3: {
                return 52;
            }
            case 5: {
                return 28;
            }
            case 6: {
                return 365;
            }
            case 4: 
            case 8: {
                return 4;
            }
        }
        return maximums[field];
    }

    public int getActualMinimum(int field) {
        if (field == 3) {
            int year;
            int weekday;
            int min = this.getMinimalDaysInFirstWeek();
            if (min == 0) {
                return 1;
            }
            if (!(this.areFieldsSet && this.isSet[0] && this.isSet[1])) {
                this.complete();
            }
            if ((7 + (weekday = this.getWeekDay(year = this.fields[0] == 1 ? this.fields[1] : 1 - this.fields[1], min)) - this.getFirstDayOfWeek()) % 7 >= min - 1) {
                return 1;
            }
            return 0;
        }
        return minimums[field];
    }

    public int getActualMaximum(int field) {
        switch (field) {
            case 3: {
                int firstWeekday;
                if (!(this.areFieldsSet && this.isSet[0] && this.isSet[1])) {
                    this.complete();
                }
                int year = this.fields[0] == 1 ? this.fields[1] : 1 - this.fields[1];
                int lastDay = this.isLeapYear(year) ? 366 : 365;
                int weekday = this.getWeekDay(year, lastDay);
                int week = (lastDay + 6 - (7 + weekday - this.getFirstDayOfWeek()) % 7) / 7;
                int minimalDays = this.getMinimalDaysInFirstWeek();
                if (minimalDays - (7 + (firstWeekday = this.getWeekDay(year, minimalDays)) - this.getFirstDayOfWeek()) % 7 < 1) {
                    return week + 1;
                }
            }
            case 5: {
                int month;
                if (!this.areFieldsSet || !this.isSet[2]) {
                    this.complete();
                }
                if ((month = this.fields[2]) == 1) {
                    int year;
                    if (!this.isSet[1] || !this.isSet[0]) {
                        this.complete();
                    }
                    int n = year = this.fields[0] == 1 ? this.fields[1] : 1 - this.fields[1];
                    if (this.isLeapYear(year)) {
                        return 29;
                    }
                    return 28;
                }
                if (month < 7) {
                    return 31 - (month & 1);
                }
                return 30 + (month & 1);
            }
            case 6: {
                int year;
                if (!(this.areFieldsSet && this.isSet[0] && this.isSet[1])) {
                    this.complete();
                }
                int n = year = this.fields[0] == 1 ? this.fields[1] : 1 - this.fields[1];
                if (this.isLeapYear(year)) {
                    return 366;
                }
                return 365;
            }
            case 8: {
                int daysInMonth = this.getActualMaximum(5);
                return (daysInMonth - (this.fields[5] - 1) % 7 + 6) / 7;
            }
            case 4: {
                int daysInMonth = this.getActualMaximum(5);
                int weekday = (daysInMonth - this.fields[5] + this.fields[7] - 1) % 7 + 1;
                return (daysInMonth + 6 - (7 + weekday - this.getFirstDayOfWeek()) % 7) / 7;
            }
        }
        return maximums[field];
    }

    static {
        bundleName = bundleName;
        minimums = new int[]{0, 1, 0, 0, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, -43200000, 0};
        maximums = new int[]{1, 5000000, 11, 53, 5, 31, 366, 7, 5, 1, 12, 23, 59, 59, 999, 43200000, 43200000};
    }
}

