/*
 * Decompiled with CFR 0.152.
 */
package java.sql;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class DriverManager {
    private static PrintStream log_stream;
    private static PrintWriter log_writer;
    private static int login_timeout;
    private static Vector drivers;

    private DriverManager() {
    }

    public static PrintWriter getLogWriter() {
        return log_writer;
    }

    public static void setLogWriter(PrintWriter out) {
        log_writer = out;
    }

    public static Connection getConnection(String url, Properties properties) throws SQLException {
        Driver d = DriverManager.getDriver(url);
        if (d == null) {
            throw new SQLException("Driver not found for URL: " + url);
        }
        return d.connect(url, properties);
    }

    public static Connection getConnection(String url, String user, String password) throws SQLException {
        Properties p = new Properties();
        if (user != null) {
            p.setProperty("user", user);
        }
        if (password != null) {
            p.setProperty("password", password);
        }
        return DriverManager.getConnection(url, p);
    }

    public static Connection getConnection(String url) throws SQLException {
        return DriverManager.getConnection(url, new Properties());
    }

    public static Driver getDriver(String url) throws SQLException {
        Enumeration e = drivers.elements();
        while (e.hasMoreElements()) {
            Driver d = (Driver)e.nextElement();
            if (!d.acceptsURL(url)) continue;
            return d;
        }
        throw new SQLException("No driver found for " + url);
    }

    public static void registerDriver(Driver driver) throws SQLException {
        if (!drivers.contains(driver)) {
            drivers.addElement(driver);
        }
    }

    public static void deregisterDriver(Driver driver) throws SQLException {
        if (drivers.contains(driver)) {
            drivers.removeElement(driver);
        }
    }

    public static Enumeration getDrivers() {
        Vector v = new Vector();
        Enumeration e = drivers.elements();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            ClassLoader loader = obj.getClass().getClassLoader();
            if (loader == null) {
                loader = ClassLoader.getSystemClassLoader();
            }
            if (!loader.equals(cl)) continue;
            v.addElement(obj);
        }
        return v.elements();
    }

    public static void setLoginTimeout(int seconds) {
    }

    public static int getLoginTimeout() {
        return login_timeout;
    }

    public static void setLogStream(PrintStream out) {
    }

    public static PrintStream getLogStream() {
        return log_stream;
    }

    public static void println(String message) {
        if (log_stream != null) {
            log_stream.println(message);
        }
    }

    static {
        drivers = new Vector();
        String driver_string = System.getProperty("jdbc.drivers");
        if (driver_string != null) {
            StringTokenizer st = new StringTokenizer(driver_string);
            while (st.hasMoreTokens()) {
                String driver_classname = st.nextToken();
                try {
                    Class.forName(driver_classname);
                }
                catch (Exception exception) {}
            }
        }
    }
}

