#ifndef __ROMAJI2KANA_H__ /* file wrapper */
#define __ROMAJI2KANA_H__

/*
 * Jeffrey Friedl
 * Omron Corporation			ʳ
 * Nagaokakyoshi, Japan			617Ĺ
 *
 * jfriedl@nff.ncl.omron.co.jp
 *
 * This work is placed under the terms of the GNU General Purpose License
 * (the "GNU Copyleft").
 */

#define romaji2kana_version 101 /* 1.01 */

/*
 * Sets the mode of subsequent conversions. Returns the previous value.
 * Initial default is R2K_MIXED_MODE.
 */
extern unsigned r2k_setmode(unsigned newmode);

#define R2K_MIXED_MODE		0   /* lower case is hira, upper is kata */
#define R2K_ALL_HIRA_MODE	1   /* case doesn't matter; always hira */
#define R2K_ALL_KATA_MODE	2   /* case doesn't matter; always kata */


/*
 * The following three routines are used to set the PASS, OMIT, and LONGVOWEL
 * strings. The previous value is returned. If a null is given as the
 * argument, only the current version is returned (and nothing is changed)>
 *
 * The PASS string lists ASCII characters which are to be ignored without
 * comment (non-ASCII are always ignored). The default is "\t ".
 *
 * The OMIT string lists characters which are to be ignored in the input.
 * The default is "'". This allows conversions of "shinichi" and "shi'nichi"
 * to work (the single quote in the romaji will force the partition to
 * SHI NI CHI rather than SHI N I CHI) yet not result in an error.
 *
 * The LONGVOWEL string lists characters that are to be taken as indicating
 * a long vowel. Default is "-^".  If the output is katakana, a dash is
 * inserted into the output, while if hiragana the proper vowel.
 */
extern const char *r2k_setpass(const char *new);
extern const char *r2k_setomit(const char *new);
extern const char *r2k_setlongvowel(const char *new);

extern unsigned r2k_setflag(unsigned new);
#define R2K_UNCONVERTED_PUNC_OK		0x01
#define R2K_NONASCII_OK			0x02
#define R2K_ALLOW_LONG_O_WITH_H         0x04
#define R2K_ALLOW_M_FOR_N               0x08

struct romaji2kana_info
{
    unsigned short k_buf_used;
    unsigned short modified;
};

/*
 * Does a conversion of romaji bytes in the range from R to R_END,
 * depositing the potentially converted text to K, filling up to
 * K_BUF_LEN bytes.  If return value is negative, indicates an error.
 * Otherwise, returns the number of bytes not converted (and not
 * OMITed).
 * 
 * If INFO is non-null, it is filled in appropriately. K_BUF_USED is
 * the number of bytes that were written to K. MODIFIED is true if the
 * output is different from the input.
 * 
 * If K is null, just reports via INFO what would have happened.
 */
extern int romaji2kana(const unsigned char *r,
		       const unsigned char *r_end,
		       unsigned char *k,
		       unsigned k_buf_len,
		       struct romaji2kana_info *info);

#define R2K_BAD_ARGS		-1
#define R2K_OVERFLOW		-2 	/* overflow of the output buffer */

#endif /* file wrapper */
