/*
 * Jeffrey Friedl
 * Omron Corporation			ʳ
 * Nagaokakyoshi, Japan			617Ĺ
 *
 * jfriedl@nff.ncl.omron.co.jp
 *
 * This work is placed under the terms of the GNU General Purpose License
 * (the "GNU Copyleft").
 */
#ifndef __ASSERT_H__
#define __ASSERT_H__

#ifndef macro_start /* just in case this file is included stand-alone */
# define macro_start  do
# define macro_end    while (0)
#endif

/*
 * When NDEBUG (no debug) is on, these asserts become (almost) nothing.
 */
#ifdef NDEBUG
# define assert(expr)          macro_start { /* nothing */ } macro_end
# define soft_assert(expr)     macro_start { /* nothing */ } macro_end
# define kibishii_assert(expr) macro_start { /* nothing */ } macro_end
#else

#ifndef __OUTPUT_H__
#include "output.h"
#endif

/*
 * Regular assert -- die if EXPR is not true.
 */
#define assert(expr)                                                         \
macro_start {                                                                \
    if (!(expr))                                                             \
    {                                                                        \
	die("\nassert(" #expr ") failed \"%s\" line %d.\n",                  \
		      __FILE__, __LINE__);                                   \
    }                                                                        \
} macro_end

/*
 * just warn (if EXPR is not true.)
 */
#define soft_assert(expr)                                                    \
macro_start {                                                                \
    if (!(expr))                                                             \
    {                                                                        \
	warn("\nassert(" #expr ") failed \"%s\" line %d.\n",                 \
		      __FILE__, __LINE__);                                   \
    }                                                                        \
} macro_end

/*
 * Kibishii debug stuff is normally not on unless specifically requested,
 * such as under special debugging situations, or development times.
 * When on, it's just like a soft assert. When off, it's nothing.
 */
#ifndef KIBISHII_DEBUG
# define kibishii_assert(expr) macro_start { /* nothing */ } macro_end
#else
# define kibishii_assert(expr) soft_assert(expr)
#endif /* KIBISHII_DEBUG */


#endif /* NDEBUG wrapper */
#endif /* file wrapper */
