// Code generated by protoc-gen-go. DO NOT EDIT.
// source: github.com/container-storage-interface/spec/csi.proto

package csi

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	descriptor "github.com/golang/protobuf/protoc-gen-go/descriptor"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type PluginCapability_Service_Type int32

const (
	PluginCapability_Service_UNKNOWN PluginCapability_Service_Type = 0
	// CONTROLLER_SERVICE indicates that the Plugin provides RPCs for
	// the ControllerService. Plugins SHOULD provide this capability.
	// In rare cases certain plugins MAY wish to omit the
	// ControllerService entirely from their implementation, but such
	// SHOULD NOT be the common case.
	// The presence of this capability determines whether the CO will
	// attempt to invoke the REQUIRED ControllerService RPCs, as well
	// as specific RPCs as indicated by ControllerGetCapabilities.
	PluginCapability_Service_CONTROLLER_SERVICE PluginCapability_Service_Type = 1
	// VOLUME_ACCESSIBILITY_CONSTRAINTS indicates that the volumes for
	// this plugin MAY NOT be equally accessible by all nodes in the
	// cluster. The CO MUST use the topology information returned by
	// CreateVolumeRequest along with the topology information
	// returned by NodeGetInfo to ensure that a given volume is
	// accessible from a given node when scheduling workloads.
	PluginCapability_Service_VOLUME_ACCESSIBILITY_CONSTRAINTS PluginCapability_Service_Type = 2
)

var PluginCapability_Service_Type_name = map[int32]string{
	0: "UNKNOWN",
	1: "CONTROLLER_SERVICE",
	2: "VOLUME_ACCESSIBILITY_CONSTRAINTS",
}

var PluginCapability_Service_Type_value = map[string]int32{
	"UNKNOWN":                          0,
	"CONTROLLER_SERVICE":               1,
	"VOLUME_ACCESSIBILITY_CONSTRAINTS": 2,
}

func (x PluginCapability_Service_Type) String() string {
	return proto.EnumName(PluginCapability_Service_Type_name, int32(x))
}

func (PluginCapability_Service_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{4, 0, 0}
}

type PluginCapability_VolumeExpansion_Type int32

const (
	PluginCapability_VolumeExpansion_UNKNOWN PluginCapability_VolumeExpansion_Type = 0
	// ONLINE indicates that volumes may be expanded when published to
	// a node. When a Plugin implements this capability it MUST
	// implement either the EXPAND_VOLUME controller capability or the
	// EXPAND_VOLUME node capability or both. When a plugin supports
	// ONLINE volume expansion and also has the EXPAND_VOLUME
	// controller capability then the plugin MUST support expansion of
	// volumes currently published and available on a node. When a
	// plugin supports ONLINE volume expansion and also has the
	// EXPAND_VOLUME node capability then the plugin MAY support
	// expansion of node-published volume via NodeExpandVolume.
	//
	// Example 1: Given a shared filesystem volume (e.g. GlusterFs),
	//   the Plugin may set the ONLINE volume expansion capability and
	//   implement ControllerExpandVolume but not NodeExpandVolume.
	//
	// Example 2: Given a block storage volume type (e.g. EBS), the
	//   Plugin may set the ONLINE volume expansion capability and
	//   implement both ControllerExpandVolume and NodeExpandVolume.
	//
	// Example 3: Given a Plugin that supports volume expansion only
	//   upon a node, the Plugin may set the ONLINE volume
	//   expansion capability and implement NodeExpandVolume but not
	//   ControllerExpandVolume.
	PluginCapability_VolumeExpansion_ONLINE PluginCapability_VolumeExpansion_Type = 1
	// OFFLINE indicates that volumes currently published and
	// available on a node SHALL NOT be expanded via
	// ControllerExpandVolume. When a plugin supports OFFLINE volume
	// expansion it MUST implement either the EXPAND_VOLUME controller
	// capability or both the EXPAND_VOLUME controller capability and
	// the EXPAND_VOLUME node capability.
	//
	// Example 1: Given a block storage volume type (e.g. Azure Disk)
	//   that does not support expansion of "node-attached" (i.e.
	//   controller-published) volumes, the Plugin may indicate
	//   OFFLINE volume expansion support and implement both
	//   ControllerExpandVolume and NodeExpandVolume.
	PluginCapability_VolumeExpansion_OFFLINE PluginCapability_VolumeExpansion_Type = 2
)

var PluginCapability_VolumeExpansion_Type_name = map[int32]string{
	0: "UNKNOWN",
	1: "ONLINE",
	2: "OFFLINE",
}

var PluginCapability_VolumeExpansion_Type_value = map[string]int32{
	"UNKNOWN": 0,
	"ONLINE":  1,
	"OFFLINE": 2,
}

func (x PluginCapability_VolumeExpansion_Type) String() string {
	return proto.EnumName(PluginCapability_VolumeExpansion_Type_name, int32(x))
}

func (PluginCapability_VolumeExpansion_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{4, 1, 0}
}

type VolumeCapability_AccessMode_Mode int32

const (
	VolumeCapability_AccessMode_UNKNOWN VolumeCapability_AccessMode_Mode = 0
	// Can only be published once as read/write on a single node, at
	// any given time.
	VolumeCapability_AccessMode_SINGLE_NODE_WRITER VolumeCapability_AccessMode_Mode = 1
	// Can only be published once as readonly on a single node, at
	// any given time.
	VolumeCapability_AccessMode_SINGLE_NODE_READER_ONLY VolumeCapability_AccessMode_Mode = 2
	// Can be published as readonly at multiple nodes simultaneously.
	VolumeCapability_AccessMode_MULTI_NODE_READER_ONLY VolumeCapability_AccessMode_Mode = 3
	// Can be published at multiple nodes simultaneously. Only one of
	// the node can be used as read/write. The rest will be readonly.
	VolumeCapability_AccessMode_MULTI_NODE_SINGLE_WRITER VolumeCapability_AccessMode_Mode = 4
	// Can be published as read/write at multiple nodes
	// simultaneously.
	VolumeCapability_AccessMode_MULTI_NODE_MULTI_WRITER VolumeCapability_AccessMode_Mode = 5
)

var VolumeCapability_AccessMode_Mode_name = map[int32]string{
	0: "UNKNOWN",
	1: "SINGLE_NODE_WRITER",
	2: "SINGLE_NODE_READER_ONLY",
	3: "MULTI_NODE_READER_ONLY",
	4: "MULTI_NODE_SINGLE_WRITER",
	5: "MULTI_NODE_MULTI_WRITER",
}

var VolumeCapability_AccessMode_Mode_value = map[string]int32{
	"UNKNOWN":                  0,
	"SINGLE_NODE_WRITER":       1,
	"SINGLE_NODE_READER_ONLY":  2,
	"MULTI_NODE_READER_ONLY":   3,
	"MULTI_NODE_SINGLE_WRITER": 4,
	"MULTI_NODE_MULTI_WRITER":  5,
}

func (x VolumeCapability_AccessMode_Mode) String() string {
	return proto.EnumName(VolumeCapability_AccessMode_Mode_name, int32(x))
}

func (VolumeCapability_AccessMode_Mode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{10, 2, 0}
}

type ControllerServiceCapability_RPC_Type int32

const (
	ControllerServiceCapability_RPC_UNKNOWN                  ControllerServiceCapability_RPC_Type = 0
	ControllerServiceCapability_RPC_CREATE_DELETE_VOLUME     ControllerServiceCapability_RPC_Type = 1
	ControllerServiceCapability_RPC_PUBLISH_UNPUBLISH_VOLUME ControllerServiceCapability_RPC_Type = 2
	ControllerServiceCapability_RPC_LIST_VOLUMES             ControllerServiceCapability_RPC_Type = 3
	ControllerServiceCapability_RPC_GET_CAPACITY             ControllerServiceCapability_RPC_Type = 4
	// Currently the only way to consume a snapshot is to create
	// a volume from it. Therefore plugins supporting
	// CREATE_DELETE_SNAPSHOT MUST support creating volume from
	// snapshot.
	ControllerServiceCapability_RPC_CREATE_DELETE_SNAPSHOT ControllerServiceCapability_RPC_Type = 5
	ControllerServiceCapability_RPC_LIST_SNAPSHOTS         ControllerServiceCapability_RPC_Type = 6
	// Plugins supporting volume cloning at the storage level MAY
	// report this capability. The source volume MUST be managed by
	// the same plugin. Not all volume sources and parameters
	// combinations MAY work.
	ControllerServiceCapability_RPC_CLONE_VOLUME ControllerServiceCapability_RPC_Type = 7
	// Indicates the SP supports ControllerPublishVolume.readonly
	// field.
	ControllerServiceCapability_RPC_PUBLISH_READONLY ControllerServiceCapability_RPC_Type = 8
	// See VolumeExpansion for details.
	ControllerServiceCapability_RPC_EXPAND_VOLUME ControllerServiceCapability_RPC_Type = 9
	// Indicates the SP supports the
	// ListVolumesResponse.entry.published_nodes field
	ControllerServiceCapability_RPC_LIST_VOLUMES_PUBLISHED_NODES ControllerServiceCapability_RPC_Type = 10
)

var ControllerServiceCapability_RPC_Type_name = map[int32]string{
	0:  "UNKNOWN",
	1:  "CREATE_DELETE_VOLUME",
	2:  "PUBLISH_UNPUBLISH_VOLUME",
	3:  "LIST_VOLUMES",
	4:  "GET_CAPACITY",
	5:  "CREATE_DELETE_SNAPSHOT",
	6:  "LIST_SNAPSHOTS",
	7:  "CLONE_VOLUME",
	8:  "PUBLISH_READONLY",
	9:  "EXPAND_VOLUME",
	10: "LIST_VOLUMES_PUBLISHED_NODES",
}

var ControllerServiceCapability_RPC_Type_value = map[string]int32{
	"UNKNOWN":                      0,
	"CREATE_DELETE_VOLUME":         1,
	"PUBLISH_UNPUBLISH_VOLUME":     2,
	"LIST_VOLUMES":                 3,
	"GET_CAPACITY":                 4,
	"CREATE_DELETE_SNAPSHOT":       5,
	"LIST_SNAPSHOTS":               6,
	"CLONE_VOLUME":                 7,
	"PUBLISH_READONLY":             8,
	"EXPAND_VOLUME":                9,
	"LIST_VOLUMES_PUBLISHED_NODES": 10,
}

func (x ControllerServiceCapability_RPC_Type) String() string {
	return proto.EnumName(ControllerServiceCapability_RPC_Type_name, int32(x))
}

func (ControllerServiceCapability_RPC_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{29, 0, 0}
}

type VolumeUsage_Unit int32

const (
	VolumeUsage_UNKNOWN VolumeUsage_Unit = 0
	VolumeUsage_BYTES   VolumeUsage_Unit = 1
	VolumeUsage_INODES  VolumeUsage_Unit = 2
)

var VolumeUsage_Unit_name = map[int32]string{
	0: "UNKNOWN",
	1: "BYTES",
	2: "INODES",
}

var VolumeUsage_Unit_value = map[string]int32{
	"UNKNOWN": 0,
	"BYTES":   1,
	"INODES":  2,
}

func (x VolumeUsage_Unit) String() string {
	return proto.EnumName(VolumeUsage_Unit_name, int32(x))
}

func (VolumeUsage_Unit) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{49, 0}
}

type NodeServiceCapability_RPC_Type int32

const (
	NodeServiceCapability_RPC_UNKNOWN              NodeServiceCapability_RPC_Type = 0
	NodeServiceCapability_RPC_STAGE_UNSTAGE_VOLUME NodeServiceCapability_RPC_Type = 1
	// If Plugin implements GET_VOLUME_STATS capability
	// then it MUST implement NodeGetVolumeStats RPC
	// call for fetching volume statistics.
	NodeServiceCapability_RPC_GET_VOLUME_STATS NodeServiceCapability_RPC_Type = 2
	// See VolumeExpansion for details.
	NodeServiceCapability_RPC_EXPAND_VOLUME NodeServiceCapability_RPC_Type = 3
)

var NodeServiceCapability_RPC_Type_name = map[int32]string{
	0: "UNKNOWN",
	1: "STAGE_UNSTAGE_VOLUME",
	2: "GET_VOLUME_STATS",
	3: "EXPAND_VOLUME",
}

var NodeServiceCapability_RPC_Type_value = map[string]int32{
	"UNKNOWN":              0,
	"STAGE_UNSTAGE_VOLUME": 1,
	"GET_VOLUME_STATS":     2,
	"EXPAND_VOLUME":        3,
}

func (x NodeServiceCapability_RPC_Type) String() string {
	return proto.EnumName(NodeServiceCapability_RPC_Type_name, int32(x))
}

func (NodeServiceCapability_RPC_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{52, 0, 0}
}

type GetPluginInfoRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetPluginInfoRequest) Reset()         { *m = GetPluginInfoRequest{} }
func (m *GetPluginInfoRequest) String() string { return proto.CompactTextString(m) }
func (*GetPluginInfoRequest) ProtoMessage()    {}
func (*GetPluginInfoRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{0}
}

func (m *GetPluginInfoRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetPluginInfoRequest.Unmarshal(m, b)
}
func (m *GetPluginInfoRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetPluginInfoRequest.Marshal(b, m, deterministic)
}
func (m *GetPluginInfoRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetPluginInfoRequest.Merge(m, src)
}
func (m *GetPluginInfoRequest) XXX_Size() int {
	return xxx_messageInfo_GetPluginInfoRequest.Size(m)
}
func (m *GetPluginInfoRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetPluginInfoRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetPluginInfoRequest proto.InternalMessageInfo

type GetPluginInfoResponse struct {
	// The name MUST follow domain name notation format
	// (https://tools.ietf.org/html/rfc1035#section-2.3.1). It SHOULD
	// include the plugin's host company name and the plugin name,
	// to minimize the possibility of collisions. It MUST be 63
	// characters or less, beginning and ending with an alphanumeric
	// character ([a-z0-9A-Z]) with dashes (-), dots (.), and
	// alphanumerics between. This field is REQUIRED.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// This field is REQUIRED. Value of this field is opaque to the CO.
	VendorVersion string `protobuf:"bytes,2,opt,name=vendor_version,json=vendorVersion,proto3" json:"vendor_version,omitempty"`
	// This field is OPTIONAL. Values are opaque to the CO.
	Manifest             map[string]string `protobuf:"bytes,3,rep,name=manifest,proto3" json:"manifest,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *GetPluginInfoResponse) Reset()         { *m = GetPluginInfoResponse{} }
func (m *GetPluginInfoResponse) String() string { return proto.CompactTextString(m) }
func (*GetPluginInfoResponse) ProtoMessage()    {}
func (*GetPluginInfoResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{1}
}

func (m *GetPluginInfoResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetPluginInfoResponse.Unmarshal(m, b)
}
func (m *GetPluginInfoResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetPluginInfoResponse.Marshal(b, m, deterministic)
}
func (m *GetPluginInfoResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetPluginInfoResponse.Merge(m, src)
}
func (m *GetPluginInfoResponse) XXX_Size() int {
	return xxx_messageInfo_GetPluginInfoResponse.Size(m)
}
func (m *GetPluginInfoResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetPluginInfoResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetPluginInfoResponse proto.InternalMessageInfo

func (m *GetPluginInfoResponse) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GetPluginInfoResponse) GetVendorVersion() string {
	if m != nil {
		return m.VendorVersion
	}
	return ""
}

func (m *GetPluginInfoResponse) GetManifest() map[string]string {
	if m != nil {
		return m.Manifest
	}
	return nil
}

type GetPluginCapabilitiesRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetPluginCapabilitiesRequest) Reset()         { *m = GetPluginCapabilitiesRequest{} }
func (m *GetPluginCapabilitiesRequest) String() string { return proto.CompactTextString(m) }
func (*GetPluginCapabilitiesRequest) ProtoMessage()    {}
func (*GetPluginCapabilitiesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{2}
}

func (m *GetPluginCapabilitiesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetPluginCapabilitiesRequest.Unmarshal(m, b)
}
func (m *GetPluginCapabilitiesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetPluginCapabilitiesRequest.Marshal(b, m, deterministic)
}
func (m *GetPluginCapabilitiesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetPluginCapabilitiesRequest.Merge(m, src)
}
func (m *GetPluginCapabilitiesRequest) XXX_Size() int {
	return xxx_messageInfo_GetPluginCapabilitiesRequest.Size(m)
}
func (m *GetPluginCapabilitiesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetPluginCapabilitiesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetPluginCapabilitiesRequest proto.InternalMessageInfo

type GetPluginCapabilitiesResponse struct {
	// All the capabilities that the controller service supports. This
	// field is OPTIONAL.
	Capabilities         []*PluginCapability `protobuf:"bytes,1,rep,name=capabilities,proto3" json:"capabilities,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *GetPluginCapabilitiesResponse) Reset()         { *m = GetPluginCapabilitiesResponse{} }
func (m *GetPluginCapabilitiesResponse) String() string { return proto.CompactTextString(m) }
func (*GetPluginCapabilitiesResponse) ProtoMessage()    {}
func (*GetPluginCapabilitiesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{3}
}

func (m *GetPluginCapabilitiesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetPluginCapabilitiesResponse.Unmarshal(m, b)
}
func (m *GetPluginCapabilitiesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetPluginCapabilitiesResponse.Marshal(b, m, deterministic)
}
func (m *GetPluginCapabilitiesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetPluginCapabilitiesResponse.Merge(m, src)
}
func (m *GetPluginCapabilitiesResponse) XXX_Size() int {
	return xxx_messageInfo_GetPluginCapabilitiesResponse.Size(m)
}
func (m *GetPluginCapabilitiesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetPluginCapabilitiesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetPluginCapabilitiesResponse proto.InternalMessageInfo

func (m *GetPluginCapabilitiesResponse) GetCapabilities() []*PluginCapability {
	if m != nil {
		return m.Capabilities
	}
	return nil
}

// Specifies a capability of the plugin.
type PluginCapability struct {
	// Types that are valid to be assigned to Type:
	//	*PluginCapability_Service_
	//	*PluginCapability_VolumeExpansion_
	Type                 isPluginCapability_Type `protobuf_oneof:"type"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *PluginCapability) Reset()         { *m = PluginCapability{} }
func (m *PluginCapability) String() string { return proto.CompactTextString(m) }
func (*PluginCapability) ProtoMessage()    {}
func (*PluginCapability) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{4}
}

func (m *PluginCapability) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PluginCapability.Unmarshal(m, b)
}
func (m *PluginCapability) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PluginCapability.Marshal(b, m, deterministic)
}
func (m *PluginCapability) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PluginCapability.Merge(m, src)
}
func (m *PluginCapability) XXX_Size() int {
	return xxx_messageInfo_PluginCapability.Size(m)
}
func (m *PluginCapability) XXX_DiscardUnknown() {
	xxx_messageInfo_PluginCapability.DiscardUnknown(m)
}

var xxx_messageInfo_PluginCapability proto.InternalMessageInfo

type isPluginCapability_Type interface {
	isPluginCapability_Type()
}

type PluginCapability_Service_ struct {
	Service *PluginCapability_Service `protobuf:"bytes,1,opt,name=service,proto3,oneof"`
}

type PluginCapability_VolumeExpansion_ struct {
	VolumeExpansion *PluginCapability_VolumeExpansion `protobuf:"bytes,2,opt,name=volume_expansion,json=volumeExpansion,proto3,oneof"`
}

func (*PluginCapability_Service_) isPluginCapability_Type() {}

func (*PluginCapability_VolumeExpansion_) isPluginCapability_Type() {}

func (m *PluginCapability) GetType() isPluginCapability_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *PluginCapability) GetService() *PluginCapability_Service {
	if x, ok := m.GetType().(*PluginCapability_Service_); ok {
		return x.Service
	}
	return nil
}

func (m *PluginCapability) GetVolumeExpansion() *PluginCapability_VolumeExpansion {
	if x, ok := m.GetType().(*PluginCapability_VolumeExpansion_); ok {
		return x.VolumeExpansion
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*PluginCapability) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*PluginCapability_Service_)(nil),
		(*PluginCapability_VolumeExpansion_)(nil),
	}
}

type PluginCapability_Service struct {
	Type                 PluginCapability_Service_Type `protobuf:"varint,1,opt,name=type,proto3,enum=csi.v1.PluginCapability_Service_Type" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *PluginCapability_Service) Reset()         { *m = PluginCapability_Service{} }
func (m *PluginCapability_Service) String() string { return proto.CompactTextString(m) }
func (*PluginCapability_Service) ProtoMessage()    {}
func (*PluginCapability_Service) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{4, 0}
}

func (m *PluginCapability_Service) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PluginCapability_Service.Unmarshal(m, b)
}
func (m *PluginCapability_Service) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PluginCapability_Service.Marshal(b, m, deterministic)
}
func (m *PluginCapability_Service) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PluginCapability_Service.Merge(m, src)
}
func (m *PluginCapability_Service) XXX_Size() int {
	return xxx_messageInfo_PluginCapability_Service.Size(m)
}
func (m *PluginCapability_Service) XXX_DiscardUnknown() {
	xxx_messageInfo_PluginCapability_Service.DiscardUnknown(m)
}

var xxx_messageInfo_PluginCapability_Service proto.InternalMessageInfo

func (m *PluginCapability_Service) GetType() PluginCapability_Service_Type {
	if m != nil {
		return m.Type
	}
	return PluginCapability_Service_UNKNOWN
}

type PluginCapability_VolumeExpansion struct {
	Type                 PluginCapability_VolumeExpansion_Type `protobuf:"varint,1,opt,name=type,proto3,enum=csi.v1.PluginCapability_VolumeExpansion_Type" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                              `json:"-"`
	XXX_unrecognized     []byte                                `json:"-"`
	XXX_sizecache        int32                                 `json:"-"`
}

func (m *PluginCapability_VolumeExpansion) Reset()         { *m = PluginCapability_VolumeExpansion{} }
func (m *PluginCapability_VolumeExpansion) String() string { return proto.CompactTextString(m) }
func (*PluginCapability_VolumeExpansion) ProtoMessage()    {}
func (*PluginCapability_VolumeExpansion) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{4, 1}
}

func (m *PluginCapability_VolumeExpansion) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PluginCapability_VolumeExpansion.Unmarshal(m, b)
}
func (m *PluginCapability_VolumeExpansion) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PluginCapability_VolumeExpansion.Marshal(b, m, deterministic)
}
func (m *PluginCapability_VolumeExpansion) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PluginCapability_VolumeExpansion.Merge(m, src)
}
func (m *PluginCapability_VolumeExpansion) XXX_Size() int {
	return xxx_messageInfo_PluginCapability_VolumeExpansion.Size(m)
}
func (m *PluginCapability_VolumeExpansion) XXX_DiscardUnknown() {
	xxx_messageInfo_PluginCapability_VolumeExpansion.DiscardUnknown(m)
}

var xxx_messageInfo_PluginCapability_VolumeExpansion proto.InternalMessageInfo

func (m *PluginCapability_VolumeExpansion) GetType() PluginCapability_VolumeExpansion_Type {
	if m != nil {
		return m.Type
	}
	return PluginCapability_VolumeExpansion_UNKNOWN
}

type ProbeRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ProbeRequest) Reset()         { *m = ProbeRequest{} }
func (m *ProbeRequest) String() string { return proto.CompactTextString(m) }
func (*ProbeRequest) ProtoMessage()    {}
func (*ProbeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{5}
}

func (m *ProbeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProbeRequest.Unmarshal(m, b)
}
func (m *ProbeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProbeRequest.Marshal(b, m, deterministic)
}
func (m *ProbeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProbeRequest.Merge(m, src)
}
func (m *ProbeRequest) XXX_Size() int {
	return xxx_messageInfo_ProbeRequest.Size(m)
}
func (m *ProbeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ProbeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ProbeRequest proto.InternalMessageInfo

type ProbeResponse struct {
	// Readiness allows a plugin to report its initialization status back
	// to the CO. Initialization for some plugins MAY be time consuming
	// and it is important for a CO to distinguish between the following
	// cases:
	//
	// 1) The plugin is in an unhealthy state and MAY need restarting. In
	//    this case a gRPC error code SHALL be returned.
	// 2) The plugin is still initializing, but is otherwise perfectly
	//    healthy. In this case a successful response SHALL be returned
	//    with a readiness value of `false`. Calls to the plugin's
	//    Controller and/or Node services MAY fail due to an incomplete
	//    initialization state.
	// 3) The plugin has finished initializing and is ready to service
	//    calls to its Controller and/or Node services. A successful
	//    response is returned with a readiness value of `true`.
	//
	// This field is OPTIONAL. If not present, the caller SHALL assume
	// that the plugin is in a ready state and is accepting calls to its
	// Controller and/or Node services (according to the plugin's reported
	// capabilities).
	Ready                *wrappers.BoolValue `protobuf:"bytes,1,opt,name=ready,proto3" json:"ready,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *ProbeResponse) Reset()         { *m = ProbeResponse{} }
func (m *ProbeResponse) String() string { return proto.CompactTextString(m) }
func (*ProbeResponse) ProtoMessage()    {}
func (*ProbeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{6}
}

func (m *ProbeResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProbeResponse.Unmarshal(m, b)
}
func (m *ProbeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProbeResponse.Marshal(b, m, deterministic)
}
func (m *ProbeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProbeResponse.Merge(m, src)
}
func (m *ProbeResponse) XXX_Size() int {
	return xxx_messageInfo_ProbeResponse.Size(m)
}
func (m *ProbeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ProbeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ProbeResponse proto.InternalMessageInfo

func (m *ProbeResponse) GetReady() *wrappers.BoolValue {
	if m != nil {
		return m.Ready
	}
	return nil
}

type CreateVolumeRequest struct {
	// The suggested name for the storage space. This field is REQUIRED.
	// It serves two purposes:
	// 1) Idempotency - This name is generated by the CO to achieve
	//    idempotency.  The Plugin SHOULD ensure that multiple
	//    `CreateVolume` calls for the same name do not result in more
	//    than one piece of storage provisioned corresponding to that
	//    name. If a Plugin is unable to enforce idempotency, the CO's
	//    error recovery logic could result in multiple (unused) volumes
	//    being provisioned.
	//    In the case of error, the CO MUST handle the gRPC error codes
	//    per the recovery behavior defined in the "CreateVolume Errors"
	//    section below.
	//    The CO is responsible for cleaning up volumes it provisioned
	//    that it no longer needs. If the CO is uncertain whether a volume
	//    was provisioned or not when a `CreateVolume` call fails, the CO
	//    MAY call `CreateVolume` again, with the same name, to ensure the
	//    volume exists and to retrieve the volume's `volume_id` (unless
	//    otherwise prohibited by "CreateVolume Errors").
	// 2) Suggested name - Some storage systems allow callers to specify
	//    an identifier by which to refer to the newly provisioned
	//    storage. If a storage system supports this, it can optionally
	//    use this name as the identifier for the new volume.
	// Any Unicode string that conforms to the length limit is allowed
	// except those containing the following banned characters:
	// U+0000-U+0008, U+000B, U+000C, U+000E-U+001F, U+007F-U+009F.
	// (These are control characters other than commonly used whitespace.)
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// This field is OPTIONAL. This allows the CO to specify the capacity
	// requirement of the volume to be provisioned. If not specified, the
	// Plugin MAY choose an implementation-defined capacity range. If
	// specified it MUST always be honored, even when creating volumes
	// from a source; which MAY force some backends to internally extend
	// the volume after creating it.
	CapacityRange *CapacityRange `protobuf:"bytes,2,opt,name=capacity_range,json=capacityRange,proto3" json:"capacity_range,omitempty"`
	// The capabilities that the provisioned volume MUST have. SP MUST
	// provision a volume that will satisfy ALL of the capabilities
	// specified in this list. Otherwise SP MUST return the appropriate
	// gRPC error code.
	// The Plugin MUST assume that the CO MAY use the provisioned volume
	// with ANY of the capabilities specified in this list.
	// For example, a CO MAY specify two volume capabilities: one with
	// access mode SINGLE_NODE_WRITER and another with access mode
	// MULTI_NODE_READER_ONLY. In this case, the SP MUST verify that the
	// provisioned volume can be used in either mode.
	// This also enables the CO to do early validation: If ANY of the
	// specified volume capabilities are not supported by the SP, the call
	// MUST return the appropriate gRPC error code.
	// This field is REQUIRED.
	VolumeCapabilities []*VolumeCapability `protobuf:"bytes,3,rep,name=volume_capabilities,json=volumeCapabilities,proto3" json:"volume_capabilities,omitempty"`
	// Plugin specific parameters passed in as opaque key-value pairs.
	// This field is OPTIONAL. The Plugin is responsible for parsing and
	// validating these parameters. COs will treat these as opaque.
	Parameters map[string]string `protobuf:"bytes,4,rep,name=parameters,proto3" json:"parameters,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Secrets required by plugin to complete volume creation request.
	// This field is OPTIONAL. Refer to the `Secrets Requirements`
	// section on how to use this field.
	Secrets map[string]string `protobuf:"bytes,5,rep,name=secrets,proto3" json:"secrets,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// If specified, the new volume will be pre-populated with data from
	// this source. This field is OPTIONAL.
	VolumeContentSource *VolumeContentSource `protobuf:"bytes,6,opt,name=volume_content_source,json=volumeContentSource,proto3" json:"volume_content_source,omitempty"`
	// Specifies where (regions, zones, racks, etc.) the provisioned
	// volume MUST be accessible from.
	// An SP SHALL advertise the requirements for topological
	// accessibility information in documentation. COs SHALL only specify
	// topological accessibility information supported by the SP.
	// This field is OPTIONAL.
	// This field SHALL NOT be specified unless the SP has the
	// VOLUME_ACCESSIBILITY_CONSTRAINTS plugin capability.
	// If this field is not specified and the SP has the
	// VOLUME_ACCESSIBILITY_CONSTRAINTS plugin capability, the SP MAY
	// choose where the provisioned volume is accessible from.
	AccessibilityRequirements *TopologyRequirement `protobuf:"bytes,7,opt,name=accessibility_requirements,json=accessibilityRequirements,proto3" json:"accessibility_requirements,omitempty"`
	XXX_NoUnkeyedLiteral      struct{}             `json:"-"`
	XXX_unrecognized          []byte               `json:"-"`
	XXX_sizecache             int32                `json:"-"`
}

func (m *CreateVolumeRequest) Reset()         { *m = CreateVolumeRequest{} }
func (m *CreateVolumeRequest) String() string { return proto.CompactTextString(m) }
func (*CreateVolumeRequest) ProtoMessage()    {}
func (*CreateVolumeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{7}
}

func (m *CreateVolumeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateVolumeRequest.Unmarshal(m, b)
}
func (m *CreateVolumeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateVolumeRequest.Marshal(b, m, deterministic)
}
func (m *CreateVolumeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateVolumeRequest.Merge(m, src)
}
func (m *CreateVolumeRequest) XXX_Size() int {
	return xxx_messageInfo_CreateVolumeRequest.Size(m)
}
func (m *CreateVolumeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateVolumeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateVolumeRequest proto.InternalMessageInfo

func (m *CreateVolumeRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateVolumeRequest) GetCapacityRange() *CapacityRange {
	if m != nil {
		return m.CapacityRange
	}
	return nil
}

func (m *CreateVolumeRequest) GetVolumeCapabilities() []*VolumeCapability {
	if m != nil {
		return m.VolumeCapabilities
	}
	return nil
}

func (m *CreateVolumeRequest) GetParameters() map[string]string {
	if m != nil {
		return m.Parameters
	}
	return nil
}

func (m *CreateVolumeRequest) GetSecrets() map[string]string {
	if m != nil {
		return m.Secrets
	}
	return nil
}

func (m *CreateVolumeRequest) GetVolumeContentSource() *VolumeContentSource {
	if m != nil {
		return m.VolumeContentSource
	}
	return nil
}

func (m *CreateVolumeRequest) GetAccessibilityRequirements() *TopologyRequirement {
	if m != nil {
		return m.AccessibilityRequirements
	}
	return nil
}

// Specifies what source the volume will be created from. One of the
// type fields MUST be specified.
type VolumeContentSource struct {
	// Types that are valid to be assigned to Type:
	//	*VolumeContentSource_Snapshot
	//	*VolumeContentSource_Volume
	Type                 isVolumeContentSource_Type `protobuf_oneof:"type"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *VolumeContentSource) Reset()         { *m = VolumeContentSource{} }
func (m *VolumeContentSource) String() string { return proto.CompactTextString(m) }
func (*VolumeContentSource) ProtoMessage()    {}
func (*VolumeContentSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{8}
}

func (m *VolumeContentSource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VolumeContentSource.Unmarshal(m, b)
}
func (m *VolumeContentSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VolumeContentSource.Marshal(b, m, deterministic)
}
func (m *VolumeContentSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VolumeContentSource.Merge(m, src)
}
func (m *VolumeContentSource) XXX_Size() int {
	return xxx_messageInfo_VolumeContentSource.Size(m)
}
func (m *VolumeContentSource) XXX_DiscardUnknown() {
	xxx_messageInfo_VolumeContentSource.DiscardUnknown(m)
}

var xxx_messageInfo_VolumeContentSource proto.InternalMessageInfo

type isVolumeContentSource_Type interface {
	isVolumeContentSource_Type()
}

type VolumeContentSource_Snapshot struct {
	Snapshot *VolumeContentSource_SnapshotSource `protobuf:"bytes,1,opt,name=snapshot,proto3,oneof"`
}

type VolumeContentSource_Volume struct {
	Volume *VolumeContentSource_VolumeSource `protobuf:"bytes,2,opt,name=volume,proto3,oneof"`
}

func (*VolumeContentSource_Snapshot) isVolumeContentSource_Type() {}

func (*VolumeContentSource_Volume) isVolumeContentSource_Type() {}

func (m *VolumeContentSource) GetType() isVolumeContentSource_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *VolumeContentSource) GetSnapshot() *VolumeContentSource_SnapshotSource {
	if x, ok := m.GetType().(*VolumeContentSource_Snapshot); ok {
		return x.Snapshot
	}
	return nil
}

func (m *VolumeContentSource) GetVolume() *VolumeContentSource_VolumeSource {
	if x, ok := m.GetType().(*VolumeContentSource_Volume); ok {
		return x.Volume
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*VolumeContentSource) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*VolumeContentSource_Snapshot)(nil),
		(*VolumeContentSource_Volume)(nil),
	}
}

type VolumeContentSource_SnapshotSource struct {
	// Contains identity information for the existing source snapshot.
	// This field is REQUIRED. Plugin is REQUIRED to support creating
	// volume from snapshot if it supports the capability
	// CREATE_DELETE_SNAPSHOT.
	SnapshotId           string   `protobuf:"bytes,1,opt,name=snapshot_id,json=snapshotId,proto3" json:"snapshot_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *VolumeContentSource_SnapshotSource) Reset()         { *m = VolumeContentSource_SnapshotSource{} }
func (m *VolumeContentSource_SnapshotSource) String() string { return proto.CompactTextString(m) }
func (*VolumeContentSource_SnapshotSource) ProtoMessage()    {}
func (*VolumeContentSource_SnapshotSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{8, 0}
}

func (m *VolumeContentSource_SnapshotSource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VolumeContentSource_SnapshotSource.Unmarshal(m, b)
}
func (m *VolumeContentSource_SnapshotSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VolumeContentSource_SnapshotSource.Marshal(b, m, deterministic)
}
func (m *VolumeContentSource_SnapshotSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VolumeContentSource_SnapshotSource.Merge(m, src)
}
func (m *VolumeContentSource_SnapshotSource) XXX_Size() int {
	return xxx_messageInfo_VolumeContentSource_SnapshotSource.Size(m)
}
func (m *VolumeContentSource_SnapshotSource) XXX_DiscardUnknown() {
	xxx_messageInfo_VolumeContentSource_SnapshotSource.DiscardUnknown(m)
}

var xxx_messageInfo_VolumeContentSource_SnapshotSource proto.InternalMessageInfo

func (m *VolumeContentSource_SnapshotSource) GetSnapshotId() string {
	if m != nil {
		return m.SnapshotId
	}
	return ""
}

type VolumeContentSource_VolumeSource struct {
	// Contains identity information for the existing source volume.
	// This field is REQUIRED. Plugins reporting CLONE_VOLUME
	// capability MUST support creating a volume from another volume.
	VolumeId             string   `protobuf:"bytes,1,opt,name=volume_id,json=volumeId,proto3" json:"volume_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *VolumeContentSource_VolumeSource) Reset()         { *m = VolumeContentSource_VolumeSource{} }
func (m *VolumeContentSource_VolumeSource) String() string { return proto.CompactTextString(m) }
func (*VolumeContentSource_VolumeSource) ProtoMessage()    {}
func (*VolumeContentSource_VolumeSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{8, 1}
}

func (m *VolumeContentSource_VolumeSource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VolumeContentSource_VolumeSource.Unmarshal(m, b)
}
func (m *VolumeContentSource_VolumeSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VolumeContentSource_VolumeSource.Marshal(b, m, deterministic)
}
func (m *VolumeContentSource_VolumeSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VolumeContentSource_VolumeSource.Merge(m, src)
}
func (m *VolumeContentSource_VolumeSource) XXX_Size() int {
	return xxx_messageInfo_VolumeContentSource_VolumeSource.Size(m)
}
func (m *VolumeContentSource_VolumeSource) XXX_DiscardUnknown() {
	xxx_messageInfo_VolumeContentSource_VolumeSource.DiscardUnknown(m)
}

var xxx_messageInfo_VolumeContentSource_VolumeSource proto.InternalMessageInfo

func (m *VolumeContentSource_VolumeSource) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

type CreateVolumeResponse struct {
	// Contains all attributes of the newly created volume that are
	// relevant to the CO along with information required by the Plugin
	// to uniquely identify the volume. This field is REQUIRED.
	Volume               *Volume  `protobuf:"bytes,1,opt,name=volume,proto3" json:"volume,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateVolumeResponse) Reset()         { *m = CreateVolumeResponse{} }
func (m *CreateVolumeResponse) String() string { return proto.CompactTextString(m) }
func (*CreateVolumeResponse) ProtoMessage()    {}
func (*CreateVolumeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{9}
}

func (m *CreateVolumeResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateVolumeResponse.Unmarshal(m, b)
}
func (m *CreateVolumeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateVolumeResponse.Marshal(b, m, deterministic)
}
func (m *CreateVolumeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateVolumeResponse.Merge(m, src)
}
func (m *CreateVolumeResponse) XXX_Size() int {
	return xxx_messageInfo_CreateVolumeResponse.Size(m)
}
func (m *CreateVolumeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateVolumeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CreateVolumeResponse proto.InternalMessageInfo

func (m *CreateVolumeResponse) GetVolume() *Volume {
	if m != nil {
		return m.Volume
	}
	return nil
}

// Specify a capability of a volume.
type VolumeCapability struct {
	// Specifies what API the volume will be accessed using. One of the
	// following fields MUST be specified.
	//
	// Types that are valid to be assigned to AccessType:
	//	*VolumeCapability_Block
	//	*VolumeCapability_Mount
	AccessType isVolumeCapability_AccessType `protobuf_oneof:"access_type"`
	// This is a REQUIRED field.
	AccessMode           *VolumeCapability_AccessMode `protobuf:"bytes,3,opt,name=access_mode,json=accessMode,proto3" json:"access_mode,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *VolumeCapability) Reset()         { *m = VolumeCapability{} }
func (m *VolumeCapability) String() string { return proto.CompactTextString(m) }
func (*VolumeCapability) ProtoMessage()    {}
func (*VolumeCapability) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{10}
}

func (m *VolumeCapability) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VolumeCapability.Unmarshal(m, b)
}
func (m *VolumeCapability) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VolumeCapability.Marshal(b, m, deterministic)
}
func (m *VolumeCapability) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VolumeCapability.Merge(m, src)
}
func (m *VolumeCapability) XXX_Size() int {
	return xxx_messageInfo_VolumeCapability.Size(m)
}
func (m *VolumeCapability) XXX_DiscardUnknown() {
	xxx_messageInfo_VolumeCapability.DiscardUnknown(m)
}

var xxx_messageInfo_VolumeCapability proto.InternalMessageInfo

type isVolumeCapability_AccessType interface {
	isVolumeCapability_AccessType()
}

type VolumeCapability_Block struct {
	Block *VolumeCapability_BlockVolume `protobuf:"bytes,1,opt,name=block,proto3,oneof"`
}

type VolumeCapability_Mount struct {
	Mount *VolumeCapability_MountVolume `protobuf:"bytes,2,opt,name=mount,proto3,oneof"`
}

func (*VolumeCapability_Block) isVolumeCapability_AccessType() {}

func (*VolumeCapability_Mount) isVolumeCapability_AccessType() {}

func (m *VolumeCapability) GetAccessType() isVolumeCapability_AccessType {
	if m != nil {
		return m.AccessType
	}
	return nil
}

func (m *VolumeCapability) GetBlock() *VolumeCapability_BlockVolume {
	if x, ok := m.GetAccessType().(*VolumeCapability_Block); ok {
		return x.Block
	}
	return nil
}

func (m *VolumeCapability) GetMount() *VolumeCapability_MountVolume {
	if x, ok := m.GetAccessType().(*VolumeCapability_Mount); ok {
		return x.Mount
	}
	return nil
}

func (m *VolumeCapability) GetAccessMode() *VolumeCapability_AccessMode {
	if m != nil {
		return m.AccessMode
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*VolumeCapability) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*VolumeCapability_Block)(nil),
		(*VolumeCapability_Mount)(nil),
	}
}

// Indicate that the volume will be accessed via the block device API.
type VolumeCapability_BlockVolume struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *VolumeCapability_BlockVolume) Reset()         { *m = VolumeCapability_BlockVolume{} }
func (m *VolumeCapability_BlockVolume) String() string { return proto.CompactTextString(m) }
func (*VolumeCapability_BlockVolume) ProtoMessage()    {}
func (*VolumeCapability_BlockVolume) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{10, 0}
}

func (m *VolumeCapability_BlockVolume) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VolumeCapability_BlockVolume.Unmarshal(m, b)
}
func (m *VolumeCapability_BlockVolume) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VolumeCapability_BlockVolume.Marshal(b, m, deterministic)
}
func (m *VolumeCapability_BlockVolume) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VolumeCapability_BlockVolume.Merge(m, src)
}
func (m *VolumeCapability_BlockVolume) XXX_Size() int {
	return xxx_messageInfo_VolumeCapability_BlockVolume.Size(m)
}
func (m *VolumeCapability_BlockVolume) XXX_DiscardUnknown() {
	xxx_messageInfo_VolumeCapability_BlockVolume.DiscardUnknown(m)
}

var xxx_messageInfo_VolumeCapability_BlockVolume proto.InternalMessageInfo

// Indicate that the volume will be accessed via the filesystem API.
type VolumeCapability_MountVolume struct {
	// The filesystem type. This field is OPTIONAL.
	// An empty string is equal to an unspecified field value.
	FsType string `protobuf:"bytes,1,opt,name=fs_type,json=fsType,proto3" json:"fs_type,omitempty"`
	// The mount options that can be used for the volume. This field is
	// OPTIONAL. `mount_flags` MAY contain sensitive information.
	// Therefore, the CO and the Plugin MUST NOT leak this information
	// to untrusted entities. The total size of this repeated field
	// SHALL NOT exceed 4 KiB.
	MountFlags           []string `protobuf:"bytes,2,rep,name=mount_flags,json=mountFlags,proto3" json:"mount_flags,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *VolumeCapability_MountVolume) Reset()         { *m = VolumeCapability_MountVolume{} }
func (m *VolumeCapability_MountVolume) String() string { return proto.CompactTextString(m) }
func (*VolumeCapability_MountVolume) ProtoMessage()    {}
func (*VolumeCapability_MountVolume) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{10, 1}
}

func (m *VolumeCapability_MountVolume) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VolumeCapability_MountVolume.Unmarshal(m, b)
}
func (m *VolumeCapability_MountVolume) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VolumeCapability_MountVolume.Marshal(b, m, deterministic)
}
func (m *VolumeCapability_MountVolume) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VolumeCapability_MountVolume.Merge(m, src)
}
func (m *VolumeCapability_MountVolume) XXX_Size() int {
	return xxx_messageInfo_VolumeCapability_MountVolume.Size(m)
}
func (m *VolumeCapability_MountVolume) XXX_DiscardUnknown() {
	xxx_messageInfo_VolumeCapability_MountVolume.DiscardUnknown(m)
}

var xxx_messageInfo_VolumeCapability_MountVolume proto.InternalMessageInfo

func (m *VolumeCapability_MountVolume) GetFsType() string {
	if m != nil {
		return m.FsType
	}
	return ""
}

func (m *VolumeCapability_MountVolume) GetMountFlags() []string {
	if m != nil {
		return m.MountFlags
	}
	return nil
}

// Specify how a volume can be accessed.
type VolumeCapability_AccessMode struct {
	// This field is REQUIRED.
	Mode                 VolumeCapability_AccessMode_Mode `protobuf:"varint,1,opt,name=mode,proto3,enum=csi.v1.VolumeCapability_AccessMode_Mode" json:"mode,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                         `json:"-"`
	XXX_unrecognized     []byte                           `json:"-"`
	XXX_sizecache        int32                            `json:"-"`
}

func (m *VolumeCapability_AccessMode) Reset()         { *m = VolumeCapability_AccessMode{} }
func (m *VolumeCapability_AccessMode) String() string { return proto.CompactTextString(m) }
func (*VolumeCapability_AccessMode) ProtoMessage()    {}
func (*VolumeCapability_AccessMode) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{10, 2}
}

func (m *VolumeCapability_AccessMode) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VolumeCapability_AccessMode.Unmarshal(m, b)
}
func (m *VolumeCapability_AccessMode) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VolumeCapability_AccessMode.Marshal(b, m, deterministic)
}
func (m *VolumeCapability_AccessMode) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VolumeCapability_AccessMode.Merge(m, src)
}
func (m *VolumeCapability_AccessMode) XXX_Size() int {
	return xxx_messageInfo_VolumeCapability_AccessMode.Size(m)
}
func (m *VolumeCapability_AccessMode) XXX_DiscardUnknown() {
	xxx_messageInfo_VolumeCapability_AccessMode.DiscardUnknown(m)
}

var xxx_messageInfo_VolumeCapability_AccessMode proto.InternalMessageInfo

func (m *VolumeCapability_AccessMode) GetMode() VolumeCapability_AccessMode_Mode {
	if m != nil {
		return m.Mode
	}
	return VolumeCapability_AccessMode_UNKNOWN
}

// The capacity of the storage space in bytes. To specify an exact size,
// `required_bytes` and `limit_bytes` SHALL be set to the same value. At
// least one of the these fields MUST be specified.
type CapacityRange struct {
	// Volume MUST be at least this big. This field is OPTIONAL.
	// A value of 0 is equal to an unspecified field value.
	// The value of this field MUST NOT be negative.
	RequiredBytes int64 `protobuf:"varint,1,opt,name=required_bytes,json=requiredBytes,proto3" json:"required_bytes,omitempty"`
	// Volume MUST not be bigger than this. This field is OPTIONAL.
	// A value of 0 is equal to an unspecified field value.
	// The value of this field MUST NOT be negative.
	LimitBytes           int64    `protobuf:"varint,2,opt,name=limit_bytes,json=limitBytes,proto3" json:"limit_bytes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CapacityRange) Reset()         { *m = CapacityRange{} }
func (m *CapacityRange) String() string { return proto.CompactTextString(m) }
func (*CapacityRange) ProtoMessage()    {}
func (*CapacityRange) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{11}
}

func (m *CapacityRange) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CapacityRange.Unmarshal(m, b)
}
func (m *CapacityRange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CapacityRange.Marshal(b, m, deterministic)
}
func (m *CapacityRange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CapacityRange.Merge(m, src)
}
func (m *CapacityRange) XXX_Size() int {
	return xxx_messageInfo_CapacityRange.Size(m)
}
func (m *CapacityRange) XXX_DiscardUnknown() {
	xxx_messageInfo_CapacityRange.DiscardUnknown(m)
}

var xxx_messageInfo_CapacityRange proto.InternalMessageInfo

func (m *CapacityRange) GetRequiredBytes() int64 {
	if m != nil {
		return m.RequiredBytes
	}
	return 0
}

func (m *CapacityRange) GetLimitBytes() int64 {
	if m != nil {
		return m.LimitBytes
	}
	return 0
}

// Information about a specific volume.
type Volume struct {
	// The capacity of the volume in bytes. This field is OPTIONAL. If not
	// set (value of 0), it indicates that the capacity of the volume is
	// unknown (e.g., NFS share).
	// The value of this field MUST NOT be negative.
	CapacityBytes int64 `protobuf:"varint,1,opt,name=capacity_bytes,json=capacityBytes,proto3" json:"capacity_bytes,omitempty"`
	// The identifier for this volume, generated by the plugin.
	// This field is REQUIRED.
	// This field MUST contain enough information to uniquely identify
	// this specific volume vs all other volumes supported by this plugin.
	// This field SHALL be used by the CO in subsequent calls to refer to
	// this volume.
	// The SP is NOT responsible for global uniqueness of volume_id across
	// multiple SPs.
	VolumeId string `protobuf:"bytes,2,opt,name=volume_id,json=volumeId,proto3" json:"volume_id,omitempty"`
	// Opaque static properties of the volume. SP MAY use this field to
	// ensure subsequent volume validation and publishing calls have
	// contextual information.
	// The contents of this field SHALL be opaque to a CO.
	// The contents of this field SHALL NOT be mutable.
	// The contents of this field SHALL be safe for the CO to cache.
	// The contents of this field SHOULD NOT contain sensitive
	// information.
	// The contents of this field SHOULD NOT be used for uniquely
	// identifying a volume. The `volume_id` alone SHOULD be sufficient to
	// identify the volume.
	// A volume uniquely identified by `volume_id` SHALL always report the
	// same volume_context.
	// This field is OPTIONAL and when present MUST be passed to volume
	// validation and publishing calls.
	VolumeContext map[string]string `protobuf:"bytes,3,rep,name=volume_context,json=volumeContext,proto3" json:"volume_context,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// If specified, indicates that the volume is not empty and is
	// pre-populated with data from the specified source.
	// This field is OPTIONAL.
	ContentSource *VolumeContentSource `protobuf:"bytes,4,opt,name=content_source,json=contentSource,proto3" json:"content_source,omitempty"`
	// Specifies where (regions, zones, racks, etc.) the provisioned
	// volume is accessible from.
	// A plugin that returns this field MUST also set the
	// VOLUME_ACCESSIBILITY_CONSTRAINTS plugin capability.
	// An SP MAY specify multiple topologies to indicate the volume is
	// accessible from multiple locations.
	// COs MAY use this information along with the topology information
	// returned by NodeGetInfo to ensure that a given volume is accessible
	// from a given node when scheduling workloads.
	// This field is OPTIONAL. If it is not specified, the CO MAY assume
	// the volume is equally accessible from all nodes in the cluster and
	// MAY schedule workloads referencing the volume on any available
	// node.
	//
	// Example 1:
	//   accessible_topology = {"region": "R1", "zone": "Z2"}
	// Indicates a volume accessible only from the "region" "R1" and the
	// "zone" "Z2".
	//
	// Example 2:
	//   accessible_topology =
	//     {"region": "R1", "zone": "Z2"},
	//     {"region": "R1", "zone": "Z3"}
	// Indicates a volume accessible from both "zone" "Z2" and "zone" "Z3"
	// in the "region" "R1".
	AccessibleTopology   []*Topology `protobuf:"bytes,5,rep,name=accessible_topology,json=accessibleTopology,proto3" json:"accessible_topology,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *Volume) Reset()         { *m = Volume{} }
func (m *Volume) String() string { return proto.CompactTextString(m) }
func (*Volume) ProtoMessage()    {}
func (*Volume) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{12}
}

func (m *Volume) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Volume.Unmarshal(m, b)
}
func (m *Volume) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Volume.Marshal(b, m, deterministic)
}
func (m *Volume) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Volume.Merge(m, src)
}
func (m *Volume) XXX_Size() int {
	return xxx_messageInfo_Volume.Size(m)
}
func (m *Volume) XXX_DiscardUnknown() {
	xxx_messageInfo_Volume.DiscardUnknown(m)
}

var xxx_messageInfo_Volume proto.InternalMessageInfo

func (m *Volume) GetCapacityBytes() int64 {
	if m != nil {
		return m.CapacityBytes
	}
	return 0
}

func (m *Volume) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *Volume) GetVolumeContext() map[string]string {
	if m != nil {
		return m.VolumeContext
	}
	return nil
}

func (m *Volume) GetContentSource() *VolumeContentSource {
	if m != nil {
		return m.ContentSource
	}
	return nil
}

func (m *Volume) GetAccessibleTopology() []*Topology {
	if m != nil {
		return m.AccessibleTopology
	}
	return nil
}

type TopologyRequirement struct {
	// Specifies the list of topologies the provisioned volume MUST be
	// accessible from.
	// This field is OPTIONAL. If TopologyRequirement is specified either
	// requisite or preferred or both MUST be specified.
	//
	// If requisite is specified, the provisioned volume MUST be
	// accessible from at least one of the requisite topologies.
	//
	// Given
	//   x = number of topologies provisioned volume is accessible from
	//   n = number of requisite topologies
	// The CO MUST ensure n >= 1. The SP MUST ensure x >= 1
	// If x==n, then the SP MUST make the provisioned volume available to
	// all topologies from the list of requisite topologies. If it is
	// unable to do so, the SP MUST fail the CreateVolume call.
	// For example, if a volume should be accessible from a single zone,
	// and requisite =
	//   {"region": "R1", "zone": "Z2"}
	// then the provisioned volume MUST be accessible from the "region"
	// "R1" and the "zone" "Z2".
	// Similarly, if a volume should be accessible from two zones, and
	// requisite =
	//   {"region": "R1", "zone": "Z2"},
	//   {"region": "R1", "zone": "Z3"}
	// then the provisioned volume MUST be accessible from the "region"
	// "R1" and both "zone" "Z2" and "zone" "Z3".
	//
	// If x<n, then the SP SHALL choose x unique topologies from the list
	// of requisite topologies. If it is unable to do so, the SP MUST fail
	// the CreateVolume call.
	// For example, if a volume should be accessible from a single zone,
	// and requisite =
	//   {"region": "R1", "zone": "Z2"},
	//   {"region": "R1", "zone": "Z3"}
	// then the SP may choose to make the provisioned volume available in
	// either the "zone" "Z2" or the "zone" "Z3" in the "region" "R1".
	// Similarly, if a volume should be accessible from two zones, and
	// requisite =
	//   {"region": "R1", "zone": "Z2"},
	//   {"region": "R1", "zone": "Z3"},
	//   {"region": "R1", "zone": "Z4"}
	// then the provisioned volume MUST be accessible from any combination
	// of two unique topologies: e.g. "R1/Z2" and "R1/Z3", or "R1/Z2" and
	//  "R1/Z4", or "R1/Z3" and "R1/Z4".
	//
	// If x>n, then the SP MUST make the provisioned volume available from
	// all topologies from the list of requisite topologies and MAY choose
	// the remaining x-n unique topologies from the list of all possible
	// topologies. If it is unable to do so, the SP MUST fail the
	// CreateVolume call.
	// For example, if a volume should be accessible from two zones, and
	// requisite =
	//   {"region": "R1", "zone": "Z2"}
	// then the provisioned volume MUST be accessible from the "region"
	// "R1" and the "zone" "Z2" and the SP may select the second zone
	// independently, e.g. "R1/Z4".
	Requisite []*Topology `protobuf:"bytes,1,rep,name=requisite,proto3" json:"requisite,omitempty"`
	// Specifies the list of topologies the CO would prefer the volume to
	// be provisioned in.
	//
	// This field is OPTIONAL. If TopologyRequirement is specified either
	// requisite or preferred or both MUST be specified.
	//
	// An SP MUST attempt to make the provisioned volume available using
	// the preferred topologies in order from first to last.
	//
	// If requisite is specified, all topologies in preferred list MUST
	// also be present in the list of requisite topologies.
	//
	// If the SP is unable to to make the provisioned volume available
	// from any of the preferred topologies, the SP MAY choose a topology
	// from the list of requisite topologies.
	// If the list of requisite topologies is not specified, then the SP
	// MAY choose from the list of all possible topologies.
	// If the list of requisite topologies is specified and the SP is
	// unable to to make the provisioned volume available from any of the
	// requisite topologies it MUST fail the CreateVolume call.
	//
	// Example 1:
	// Given a volume should be accessible from a single zone, and
	// requisite =
	//   {"region": "R1", "zone": "Z2"},
	//   {"region": "R1", "zone": "Z3"}
	// preferred =
	//   {"region": "R1", "zone": "Z3"}
	// then the the SP SHOULD first attempt to make the provisioned volume
	// available from "zone" "Z3" in the "region" "R1" and fall back to
	// "zone" "Z2" in the "region" "R1" if that is not possible.
	//
	// Example 2:
	// Given a volume should be accessible from a single zone, and
	// requisite =
	//   {"region": "R1", "zone": "Z2"},
	//   {"region": "R1", "zone": "Z3"},
	//   {"region": "R1", "zone": "Z4"},
	//   {"region": "R1", "zone": "Z5"}
	// preferred =
	//   {"region": "R1", "zone": "Z4"},
	//   {"region": "R1", "zone": "Z2"}
	// then the the SP SHOULD first attempt to make the provisioned volume
	// accessible from "zone" "Z4" in the "region" "R1" and fall back to
	// "zone" "Z2" in the "region" "R1" if that is not possible. If that
	// is not possible, the SP may choose between either the "zone"
	// "Z3" or "Z5" in the "region" "R1".
	//
	// Example 3:
	// Given a volume should be accessible from TWO zones (because an
	// opaque parameter in CreateVolumeRequest, for example, specifies
	// the volume is accessible from two zones, aka synchronously
	// replicated), and
	// requisite =
	//   {"region": "R1", "zone": "Z2"},
	//   {"region": "R1", "zone": "Z3"},
	//   {"region": "R1", "zone": "Z4"},
	//   {"region": "R1", "zone": "Z5"}
	// preferred =
	//   {"region": "R1", "zone": "Z5"},
	//   {"region": "R1", "zone": "Z3"}
	// then the the SP SHOULD first attempt to make the provisioned volume
	// accessible from the combination of the two "zones" "Z5" and "Z3" in
	// the "region" "R1". If that's not possible, it should fall back to
	// a combination of "Z5" and other possibilities from the list of
	// requisite. If that's not possible, it should fall back  to a
	// combination of "Z3" and other possibilities from the list of
	// requisite. If that's not possible, it should fall back  to a
	// combination of other possibilities from the list of requisite.
	Preferred            []*Topology `protobuf:"bytes,2,rep,name=preferred,proto3" json:"preferred,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *TopologyRequirement) Reset()         { *m = TopologyRequirement{} }
func (m *TopologyRequirement) String() string { return proto.CompactTextString(m) }
func (*TopologyRequirement) ProtoMessage()    {}
func (*TopologyRequirement) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{13}
}

func (m *TopologyRequirement) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TopologyRequirement.Unmarshal(m, b)
}
func (m *TopologyRequirement) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TopologyRequirement.Marshal(b, m, deterministic)
}
func (m *TopologyRequirement) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TopologyRequirement.Merge(m, src)
}
func (m *TopologyRequirement) XXX_Size() int {
	return xxx_messageInfo_TopologyRequirement.Size(m)
}
func (m *TopologyRequirement) XXX_DiscardUnknown() {
	xxx_messageInfo_TopologyRequirement.DiscardUnknown(m)
}

var xxx_messageInfo_TopologyRequirement proto.InternalMessageInfo

func (m *TopologyRequirement) GetRequisite() []*Topology {
	if m != nil {
		return m.Requisite
	}
	return nil
}

func (m *TopologyRequirement) GetPreferred() []*Topology {
	if m != nil {
		return m.Preferred
	}
	return nil
}

// Topology is a map of topological domains to topological segments.
// A topological domain is a sub-division of a cluster, like "region",
// "zone", "rack", etc.
// A topological segment is a specific instance of a topological domain,
// like "zone3", "rack3", etc.
// For example {"com.company/zone": "Z1", "com.company/rack": "R3"}
// Valid keys have two segments: an OPTIONAL prefix and name, separated
// by a slash (/), for example: "com.company.example/zone".
// The key name segment is REQUIRED. The prefix is OPTIONAL.
// The key name MUST be 63 characters or less, begin and end with an
// alphanumeric character ([a-z0-9A-Z]), and contain only dashes (-),
// underscores (_), dots (.), or alphanumerics in between, for example
// "zone".
// The key prefix MUST be 63 characters or less, begin and end with a
// lower-case alphanumeric character ([a-z0-9]), contain only
// dashes (-), dots (.), or lower-case alphanumerics in between, and
// follow domain name notation format
// (https://tools.ietf.org/html/rfc1035#section-2.3.1).
// The key prefix SHOULD include the plugin's host company name and/or
// the plugin name, to minimize the possibility of collisions with keys
// from other plugins.
// If a key prefix is specified, it MUST be identical across all
// topology keys returned by the SP (across all RPCs).
// Keys MUST be case-insensitive. Meaning the keys "Zone" and "zone"
// MUST not both exist.
// Each value (topological segment) MUST contain 1 or more strings.
// Each string MUST be 63 characters or less and begin and end with an
// alphanumeric character with '-', '_', '.', or alphanumerics in
// between.
type Topology struct {
	Segments             map[string]string `protobuf:"bytes,1,rep,name=segments,proto3" json:"segments,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Topology) Reset()         { *m = Topology{} }
func (m *Topology) String() string { return proto.CompactTextString(m) }
func (*Topology) ProtoMessage()    {}
func (*Topology) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{14}
}

func (m *Topology) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Topology.Unmarshal(m, b)
}
func (m *Topology) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Topology.Marshal(b, m, deterministic)
}
func (m *Topology) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Topology.Merge(m, src)
}
func (m *Topology) XXX_Size() int {
	return xxx_messageInfo_Topology.Size(m)
}
func (m *Topology) XXX_DiscardUnknown() {
	xxx_messageInfo_Topology.DiscardUnknown(m)
}

var xxx_messageInfo_Topology proto.InternalMessageInfo

func (m *Topology) GetSegments() map[string]string {
	if m != nil {
		return m.Segments
	}
	return nil
}

type DeleteVolumeRequest struct {
	// The ID of the volume to be deprovisioned.
	// This field is REQUIRED.
	VolumeId string `protobuf:"bytes,1,opt,name=volume_id,json=volumeId,proto3" json:"volume_id,omitempty"`
	// Secrets required by plugin to complete volume deletion request.
	// This field is OPTIONAL. Refer to the `Secrets Requirements`
	// section on how to use this field.
	Secrets              map[string]string `protobuf:"bytes,2,rep,name=secrets,proto3" json:"secrets,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *DeleteVolumeRequest) Reset()         { *m = DeleteVolumeRequest{} }
func (m *DeleteVolumeRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteVolumeRequest) ProtoMessage()    {}
func (*DeleteVolumeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{15}
}

func (m *DeleteVolumeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteVolumeRequest.Unmarshal(m, b)
}
func (m *DeleteVolumeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteVolumeRequest.Marshal(b, m, deterministic)
}
func (m *DeleteVolumeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteVolumeRequest.Merge(m, src)
}
func (m *DeleteVolumeRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteVolumeRequest.Size(m)
}
func (m *DeleteVolumeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteVolumeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteVolumeRequest proto.InternalMessageInfo

func (m *DeleteVolumeRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *DeleteVolumeRequest) GetSecrets() map[string]string {
	if m != nil {
		return m.Secrets
	}
	return nil
}

type DeleteVolumeResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteVolumeResponse) Reset()         { *m = DeleteVolumeResponse{} }
func (m *DeleteVolumeResponse) String() string { return proto.CompactTextString(m) }
func (*DeleteVolumeResponse) ProtoMessage()    {}
func (*DeleteVolumeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{16}
}

func (m *DeleteVolumeResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteVolumeResponse.Unmarshal(m, b)
}
func (m *DeleteVolumeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteVolumeResponse.Marshal(b, m, deterministic)
}
func (m *DeleteVolumeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteVolumeResponse.Merge(m, src)
}
func (m *DeleteVolumeResponse) XXX_Size() int {
	return xxx_messageInfo_DeleteVolumeResponse.Size(m)
}
func (m *DeleteVolumeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteVolumeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteVolumeResponse proto.InternalMessageInfo

type ControllerPublishVolumeRequest struct {
	// The ID of the volume to be used on a node.
	// This field is REQUIRED.
	VolumeId string `protobuf:"bytes,1,opt,name=volume_id,json=volumeId,proto3" json:"volume_id,omitempty"`
	// The ID of the node. This field is REQUIRED. The CO SHALL set this
	// field to match the node ID returned by `NodeGetInfo`.
	NodeId string `protobuf:"bytes,2,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
	// Volume capability describing how the CO intends to use this volume.
	// SP MUST ensure the CO can use the published volume as described.
	// Otherwise SP MUST return the appropriate gRPC error code.
	// This is a REQUIRED field.
	VolumeCapability *VolumeCapability `protobuf:"bytes,3,opt,name=volume_capability,json=volumeCapability,proto3" json:"volume_capability,omitempty"`
	// Indicates SP MUST publish the volume in readonly mode.
	// CO MUST set this field to false if SP does not have the
	// PUBLISH_READONLY controller capability.
	// This is a REQUIRED field.
	Readonly bool `protobuf:"varint,4,opt,name=readonly,proto3" json:"readonly,omitempty"`
	// Secrets required by plugin to complete controller publish volume
	// request. This field is OPTIONAL. Refer to the
	// `Secrets Requirements` section on how to use this field.
	Secrets map[string]string `protobuf:"bytes,5,rep,name=secrets,proto3" json:"secrets,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Volume context as returned by CO in CreateVolumeRequest. This field
	// is OPTIONAL and MUST match the volume_context of the volume
	// identified by `volume_id`.
	VolumeContext        map[string]string `protobuf:"bytes,6,rep,name=volume_context,json=volumeContext,proto3" json:"volume_context,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ControllerPublishVolumeRequest) Reset()         { *m = ControllerPublishVolumeRequest{} }
func (m *ControllerPublishVolumeRequest) String() string { return proto.CompactTextString(m) }
func (*ControllerPublishVolumeRequest) ProtoMessage()    {}
func (*ControllerPublishVolumeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{17}
}

func (m *ControllerPublishVolumeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ControllerPublishVolumeRequest.Unmarshal(m, b)
}
func (m *ControllerPublishVolumeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ControllerPublishVolumeRequest.Marshal(b, m, deterministic)
}
func (m *ControllerPublishVolumeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ControllerPublishVolumeRequest.Merge(m, src)
}
func (m *ControllerPublishVolumeRequest) XXX_Size() int {
	return xxx_messageInfo_ControllerPublishVolumeRequest.Size(m)
}
func (m *ControllerPublishVolumeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ControllerPublishVolumeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ControllerPublishVolumeRequest proto.InternalMessageInfo

func (m *ControllerPublishVolumeRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *ControllerPublishVolumeRequest) GetNodeId() string {
	if m != nil {
		return m.NodeId
	}
	return ""
}

func (m *ControllerPublishVolumeRequest) GetVolumeCapability() *VolumeCapability {
	if m != nil {
		return m.VolumeCapability
	}
	return nil
}

func (m *ControllerPublishVolumeRequest) GetReadonly() bool {
	if m != nil {
		return m.Readonly
	}
	return false
}

func (m *ControllerPublishVolumeRequest) GetSecrets() map[string]string {
	if m != nil {
		return m.Secrets
	}
	return nil
}

func (m *ControllerPublishVolumeRequest) GetVolumeContext() map[string]string {
	if m != nil {
		return m.VolumeContext
	}
	return nil
}

type ControllerPublishVolumeResponse struct {
	// Opaque static publish properties of the volume. SP MAY use this
	// field to ensure subsequent `NodeStageVolume` or `NodePublishVolume`
	// calls calls have contextual information.
	// The contents of this field SHALL be opaque to a CO.
	// The contents of this field SHALL NOT be mutable.
	// The contents of this field SHALL be safe for the CO to cache.
	// The contents of this field SHOULD NOT contain sensitive
	// information.
	// The contents of this field SHOULD NOT be used for uniquely
	// identifying a volume. The `volume_id` alone SHOULD be sufficient to
	// identify the volume.
	// This field is OPTIONAL and when present MUST be passed to
	// subsequent `NodeStageVolume` or `NodePublishVolume` calls
	PublishContext       map[string]string `protobuf:"bytes,1,rep,name=publish_context,json=publishContext,proto3" json:"publish_context,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ControllerPublishVolumeResponse) Reset()         { *m = ControllerPublishVolumeResponse{} }
func (m *ControllerPublishVolumeResponse) String() string { return proto.CompactTextString(m) }
func (*ControllerPublishVolumeResponse) ProtoMessage()    {}
func (*ControllerPublishVolumeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{18}
}

func (m *ControllerPublishVolumeResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ControllerPublishVolumeResponse.Unmarshal(m, b)
}
func (m *ControllerPublishVolumeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ControllerPublishVolumeResponse.Marshal(b, m, deterministic)
}
func (m *ControllerPublishVolumeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ControllerPublishVolumeResponse.Merge(m, src)
}
func (m *ControllerPublishVolumeResponse) XXX_Size() int {
	return xxx_messageInfo_ControllerPublishVolumeResponse.Size(m)
}
func (m *ControllerPublishVolumeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ControllerPublishVolumeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ControllerPublishVolumeResponse proto.InternalMessageInfo

func (m *ControllerPublishVolumeResponse) GetPublishContext() map[string]string {
	if m != nil {
		return m.PublishContext
	}
	return nil
}

type ControllerUnpublishVolumeRequest struct {
	// The ID of the volume. This field is REQUIRED.
	VolumeId string `protobuf:"bytes,1,opt,name=volume_id,json=volumeId,proto3" json:"volume_id,omitempty"`
	// The ID of the node. This field is OPTIONAL. The CO SHOULD set this
	// field to match the node ID returned by `NodeGetInfo` or leave it
	// unset. If the value is set, the SP MUST unpublish the volume from
	// the specified node. If the value is unset, the SP MUST unpublish
	// the volume from all nodes it is published to.
	NodeId string `protobuf:"bytes,2,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
	// Secrets required by plugin to complete controller unpublish volume
	// request. This SHOULD be the same secrets passed to the
	// ControllerPublishVolume call for the specified volume.
	// This field is OPTIONAL. Refer to the `Secrets Requirements`
	// section on how to use this field.
	Secrets              map[string]string `protobuf:"bytes,3,rep,name=secrets,proto3" json:"secrets,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ControllerUnpublishVolumeRequest) Reset()         { *m = ControllerUnpublishVolumeRequest{} }
func (m *ControllerUnpublishVolumeRequest) String() string { return proto.CompactTextString(m) }
func (*ControllerUnpublishVolumeRequest) ProtoMessage()    {}
func (*ControllerUnpublishVolumeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{19}
}

func (m *ControllerUnpublishVolumeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ControllerUnpublishVolumeRequest.Unmarshal(m, b)
}
func (m *ControllerUnpublishVolumeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ControllerUnpublishVolumeRequest.Marshal(b, m, deterministic)
}
func (m *ControllerUnpublishVolumeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ControllerUnpublishVolumeRequest.Merge(m, src)
}
func (m *ControllerUnpublishVolumeRequest) XXX_Size() int {
	return xxx_messageInfo_ControllerUnpublishVolumeRequest.Size(m)
}
func (m *ControllerUnpublishVolumeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ControllerUnpublishVolumeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ControllerUnpublishVolumeRequest proto.InternalMessageInfo

func (m *ControllerUnpublishVolumeRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *ControllerUnpublishVolumeRequest) GetNodeId() string {
	if m != nil {
		return m.NodeId
	}
	return ""
}

func (m *ControllerUnpublishVolumeRequest) GetSecrets() map[string]string {
	if m != nil {
		return m.Secrets
	}
	return nil
}

type ControllerUnpublishVolumeResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ControllerUnpublishVolumeResponse) Reset()         { *m = ControllerUnpublishVolumeResponse{} }
func (m *ControllerUnpublishVolumeResponse) String() string { return proto.CompactTextString(m) }
func (*ControllerUnpublishVolumeResponse) ProtoMessage()    {}
func (*ControllerUnpublishVolumeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{20}
}

func (m *ControllerUnpublishVolumeResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ControllerUnpublishVolumeResponse.Unmarshal(m, b)
}
func (m *ControllerUnpublishVolumeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ControllerUnpublishVolumeResponse.Marshal(b, m, deterministic)
}
func (m *ControllerUnpublishVolumeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ControllerUnpublishVolumeResponse.Merge(m, src)
}
func (m *ControllerUnpublishVolumeResponse) XXX_Size() int {
	return xxx_messageInfo_ControllerUnpublishVolumeResponse.Size(m)
}
func (m *ControllerUnpublishVolumeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ControllerUnpublishVolumeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ControllerUnpublishVolumeResponse proto.InternalMessageInfo

type ValidateVolumeCapabilitiesRequest struct {
	// The ID of the volume to check. This field is REQUIRED.
	VolumeId string `protobuf:"bytes,1,opt,name=volume_id,json=volumeId,proto3" json:"volume_id,omitempty"`
	// Volume context as returned by CO in CreateVolumeRequest. This field
	// is OPTIONAL and MUST match the volume_context of the volume
	// identified by `volume_id`.
	VolumeContext map[string]string `protobuf:"bytes,2,rep,name=volume_context,json=volumeContext,proto3" json:"volume_context,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The capabilities that the CO wants to check for the volume. This
	// call SHALL return "confirmed" only if all the volume capabilities
	// specified below are supported. This field is REQUIRED.
	VolumeCapabilities []*VolumeCapability `protobuf:"bytes,3,rep,name=volume_capabilities,json=volumeCapabilities,proto3" json:"volume_capabilities,omitempty"`
	// See CreateVolumeRequest.parameters.
	// This field is OPTIONAL.
	Parameters map[string]string `protobuf:"bytes,4,rep,name=parameters,proto3" json:"parameters,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Secrets required by plugin to complete volume validation request.
	// This field is OPTIONAL. Refer to the `Secrets Requirements`
	// section on how to use this field.
	Secrets              map[string]string `protobuf:"bytes,5,rep,name=secrets,proto3" json:"secrets,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ValidateVolumeCapabilitiesRequest) Reset()         { *m = ValidateVolumeCapabilitiesRequest{} }
func (m *ValidateVolumeCapabilitiesRequest) String() string { return proto.CompactTextString(m) }
func (*ValidateVolumeCapabilitiesRequest) ProtoMessage()    {}
func (*ValidateVolumeCapabilitiesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{21}
}

func (m *ValidateVolumeCapabilitiesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ValidateVolumeCapabilitiesRequest.Unmarshal(m, b)
}
func (m *ValidateVolumeCapabilitiesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ValidateVolumeCapabilitiesRequest.Marshal(b, m, deterministic)
}
func (m *ValidateVolumeCapabilitiesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ValidateVolumeCapabilitiesRequest.Merge(m, src)
}
func (m *ValidateVolumeCapabilitiesRequest) XXX_Size() int {
	return xxx_messageInfo_ValidateVolumeCapabilitiesRequest.Size(m)
}
func (m *ValidateVolumeCapabilitiesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ValidateVolumeCapabilitiesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ValidateVolumeCapabilitiesRequest proto.InternalMessageInfo

func (m *ValidateVolumeCapabilitiesRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *ValidateVolumeCapabilitiesRequest) GetVolumeContext() map[string]string {
	if m != nil {
		return m.VolumeContext
	}
	return nil
}

func (m *ValidateVolumeCapabilitiesRequest) GetVolumeCapabilities() []*VolumeCapability {
	if m != nil {
		return m.VolumeCapabilities
	}
	return nil
}

func (m *ValidateVolumeCapabilitiesRequest) GetParameters() map[string]string {
	if m != nil {
		return m.Parameters
	}
	return nil
}

func (m *ValidateVolumeCapabilitiesRequest) GetSecrets() map[string]string {
	if m != nil {
		return m.Secrets
	}
	return nil
}

type ValidateVolumeCapabilitiesResponse struct {
	// Confirmed indicates to the CO the set of capabilities that the
	// plugin has validated. This field SHALL only be set to a non-empty
	// value for successful validation responses.
	// For successful validation responses, the CO SHALL compare the
	// fields of this message to the originally requested capabilities in
	// order to guard against an older plugin reporting "valid" for newer
	// capability fields that it does not yet understand.
	// This field is OPTIONAL.
	Confirmed *ValidateVolumeCapabilitiesResponse_Confirmed `protobuf:"bytes,1,opt,name=confirmed,proto3" json:"confirmed,omitempty"`
	// Message to the CO if `confirmed` above is empty. This field is
	// OPTIONAL.
	// An empty string is equal to an unspecified field value.
	Message              string   `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ValidateVolumeCapabilitiesResponse) Reset()         { *m = ValidateVolumeCapabilitiesResponse{} }
func (m *ValidateVolumeCapabilitiesResponse) String() string { return proto.CompactTextString(m) }
func (*ValidateVolumeCapabilitiesResponse) ProtoMessage()    {}
func (*ValidateVolumeCapabilitiesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{22}
}

func (m *ValidateVolumeCapabilitiesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ValidateVolumeCapabilitiesResponse.Unmarshal(m, b)
}
func (m *ValidateVolumeCapabilitiesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ValidateVolumeCapabilitiesResponse.Marshal(b, m, deterministic)
}
func (m *ValidateVolumeCapabilitiesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ValidateVolumeCapabilitiesResponse.Merge(m, src)
}
func (m *ValidateVolumeCapabilitiesResponse) XXX_Size() int {
	return xxx_messageInfo_ValidateVolumeCapabilitiesResponse.Size(m)
}
func (m *ValidateVolumeCapabilitiesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ValidateVolumeCapabilitiesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ValidateVolumeCapabilitiesResponse proto.InternalMessageInfo

func (m *ValidateVolumeCapabilitiesResponse) GetConfirmed() *ValidateVolumeCapabilitiesResponse_Confirmed {
	if m != nil {
		return m.Confirmed
	}
	return nil
}

func (m *ValidateVolumeCapabilitiesResponse) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

type ValidateVolumeCapabilitiesResponse_Confirmed struct {
	// Volume context validated by the plugin.
	// This field is OPTIONAL.
	VolumeContext map[string]string `protobuf:"bytes,1,rep,name=volume_context,json=volumeContext,proto3" json:"volume_context,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Volume capabilities supported by the plugin.
	// This field is REQUIRED.
	VolumeCapabilities []*VolumeCapability `protobuf:"bytes,2,rep,name=volume_capabilities,json=volumeCapabilities,proto3" json:"volume_capabilities,omitempty"`
	// The volume creation parameters validated by the plugin.
	// This field is OPTIONAL.
	Parameters           map[string]string `protobuf:"bytes,3,rep,name=parameters,proto3" json:"parameters,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ValidateVolumeCapabilitiesResponse_Confirmed) Reset() {
	*m = ValidateVolumeCapabilitiesResponse_Confirmed{}
}
func (m *ValidateVolumeCapabilitiesResponse_Confirmed) String() string {
	return proto.CompactTextString(m)
}
func (*ValidateVolumeCapabilitiesResponse_Confirmed) ProtoMessage() {}
func (*ValidateVolumeCapabilitiesResponse_Confirmed) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{22, 0}
}

func (m *ValidateVolumeCapabilitiesResponse_Confirmed) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ValidateVolumeCapabilitiesResponse_Confirmed.Unmarshal(m, b)
}
func (m *ValidateVolumeCapabilitiesResponse_Confirmed) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ValidateVolumeCapabilitiesResponse_Confirmed.Marshal(b, m, deterministic)
}
func (m *ValidateVolumeCapabilitiesResponse_Confirmed) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ValidateVolumeCapabilitiesResponse_Confirmed.Merge(m, src)
}
func (m *ValidateVolumeCapabilitiesResponse_Confirmed) XXX_Size() int {
	return xxx_messageInfo_ValidateVolumeCapabilitiesResponse_Confirmed.Size(m)
}
func (m *ValidateVolumeCapabilitiesResponse_Confirmed) XXX_DiscardUnknown() {
	xxx_messageInfo_ValidateVolumeCapabilitiesResponse_Confirmed.DiscardUnknown(m)
}

var xxx_messageInfo_ValidateVolumeCapabilitiesResponse_Confirmed proto.InternalMessageInfo

func (m *ValidateVolumeCapabilitiesResponse_Confirmed) GetVolumeContext() map[string]string {
	if m != nil {
		return m.VolumeContext
	}
	return nil
}

func (m *ValidateVolumeCapabilitiesResponse_Confirmed) GetVolumeCapabilities() []*VolumeCapability {
	if m != nil {
		return m.VolumeCapabilities
	}
	return nil
}

func (m *ValidateVolumeCapabilitiesResponse_Confirmed) GetParameters() map[string]string {
	if m != nil {
		return m.Parameters
	}
	return nil
}

type ListVolumesRequest struct {
	// If specified (non-zero value), the Plugin MUST NOT return more
	// entries than this number in the response. If the actual number of
	// entries is more than this number, the Plugin MUST set `next_token`
	// in the response which can be used to get the next page of entries
	// in the subsequent `ListVolumes` call. This field is OPTIONAL. If
	// not specified (zero value), it means there is no restriction on the
	// number of entries that can be returned.
	// The value of this field MUST NOT be negative.
	MaxEntries int32 `protobuf:"varint,1,opt,name=max_entries,json=maxEntries,proto3" json:"max_entries,omitempty"`
	// A token to specify where to start paginating. Set this field to
	// `next_token` returned by a previous `ListVolumes` call to get the
	// next page of entries. This field is OPTIONAL.
	// An empty string is equal to an unspecified field value.
	StartingToken        string   `protobuf:"bytes,2,opt,name=starting_token,json=startingToken,proto3" json:"starting_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListVolumesRequest) Reset()         { *m = ListVolumesRequest{} }
func (m *ListVolumesRequest) String() string { return proto.CompactTextString(m) }
func (*ListVolumesRequest) ProtoMessage()    {}
func (*ListVolumesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{23}
}

func (m *ListVolumesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListVolumesRequest.Unmarshal(m, b)
}
func (m *ListVolumesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListVolumesRequest.Marshal(b, m, deterministic)
}
func (m *ListVolumesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListVolumesRequest.Merge(m, src)
}
func (m *ListVolumesRequest) XXX_Size() int {
	return xxx_messageInfo_ListVolumesRequest.Size(m)
}
func (m *ListVolumesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListVolumesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListVolumesRequest proto.InternalMessageInfo

func (m *ListVolumesRequest) GetMaxEntries() int32 {
	if m != nil {
		return m.MaxEntries
	}
	return 0
}

func (m *ListVolumesRequest) GetStartingToken() string {
	if m != nil {
		return m.StartingToken
	}
	return ""
}

type ListVolumesResponse struct {
	Entries []*ListVolumesResponse_Entry `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
	// This token allows you to get the next page of entries for
	// `ListVolumes` request. If the number of entries is larger than
	// `max_entries`, use the `next_token` as a value for the
	// `starting_token` field in the next `ListVolumes` request. This
	// field is OPTIONAL.
	// An empty string is equal to an unspecified field value.
	NextToken            string   `protobuf:"bytes,2,opt,name=next_token,json=nextToken,proto3" json:"next_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListVolumesResponse) Reset()         { *m = ListVolumesResponse{} }
func (m *ListVolumesResponse) String() string { return proto.CompactTextString(m) }
func (*ListVolumesResponse) ProtoMessage()    {}
func (*ListVolumesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{24}
}

func (m *ListVolumesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListVolumesResponse.Unmarshal(m, b)
}
func (m *ListVolumesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListVolumesResponse.Marshal(b, m, deterministic)
}
func (m *ListVolumesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListVolumesResponse.Merge(m, src)
}
func (m *ListVolumesResponse) XXX_Size() int {
	return xxx_messageInfo_ListVolumesResponse.Size(m)
}
func (m *ListVolumesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListVolumesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListVolumesResponse proto.InternalMessageInfo

func (m *ListVolumesResponse) GetEntries() []*ListVolumesResponse_Entry {
	if m != nil {
		return m.Entries
	}
	return nil
}

func (m *ListVolumesResponse) GetNextToken() string {
	if m != nil {
		return m.NextToken
	}
	return ""
}

type ListVolumesResponse_VolumeStatus struct {
	// A list of all `node_id` of nodes that the volume in this entry
	// is controller published on.
	// This field is OPTIONAL. If it is not specified and the SP has
	// the LIST_VOLUMES_PUBLISHED_NODES controller capability, the CO
	// MAY assume the volume is not controller published to any nodes.
	// If the field is not specified and the SP does not have the
	// LIST_VOLUMES_PUBLISHED_NODES controller capability, the CO MUST
	// not interpret this field.
	// published_node_ids MAY include nodes not published to or
	// reported by the SP. The CO MUST be resilient to that.
	PublishedNodeIds     []string `protobuf:"bytes,1,rep,name=published_node_ids,json=publishedNodeIds,proto3" json:"published_node_ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListVolumesResponse_VolumeStatus) Reset()         { *m = ListVolumesResponse_VolumeStatus{} }
func (m *ListVolumesResponse_VolumeStatus) String() string { return proto.CompactTextString(m) }
func (*ListVolumesResponse_VolumeStatus) ProtoMessage()    {}
func (*ListVolumesResponse_VolumeStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{24, 0}
}

func (m *ListVolumesResponse_VolumeStatus) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListVolumesResponse_VolumeStatus.Unmarshal(m, b)
}
func (m *ListVolumesResponse_VolumeStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListVolumesResponse_VolumeStatus.Marshal(b, m, deterministic)
}
func (m *ListVolumesResponse_VolumeStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListVolumesResponse_VolumeStatus.Merge(m, src)
}
func (m *ListVolumesResponse_VolumeStatus) XXX_Size() int {
	return xxx_messageInfo_ListVolumesResponse_VolumeStatus.Size(m)
}
func (m *ListVolumesResponse_VolumeStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_ListVolumesResponse_VolumeStatus.DiscardUnknown(m)
}

var xxx_messageInfo_ListVolumesResponse_VolumeStatus proto.InternalMessageInfo

func (m *ListVolumesResponse_VolumeStatus) GetPublishedNodeIds() []string {
	if m != nil {
		return m.PublishedNodeIds
	}
	return nil
}

type ListVolumesResponse_Entry struct {
	// This field is REQUIRED
	Volume *Volume `protobuf:"bytes,1,opt,name=volume,proto3" json:"volume,omitempty"`
	// This field is OPTIONAL. This field MUST be specified if the
	// LIST_VOLUMES_PUBLISHED_NODES controller capability is
	// supported.
	Status               *ListVolumesResponse_VolumeStatus `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *ListVolumesResponse_Entry) Reset()         { *m = ListVolumesResponse_Entry{} }
func (m *ListVolumesResponse_Entry) String() string { return proto.CompactTextString(m) }
func (*ListVolumesResponse_Entry) ProtoMessage()    {}
func (*ListVolumesResponse_Entry) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{24, 1}
}

func (m *ListVolumesResponse_Entry) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListVolumesResponse_Entry.Unmarshal(m, b)
}
func (m *ListVolumesResponse_Entry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListVolumesResponse_Entry.Marshal(b, m, deterministic)
}
func (m *ListVolumesResponse_Entry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListVolumesResponse_Entry.Merge(m, src)
}
func (m *ListVolumesResponse_Entry) XXX_Size() int {
	return xxx_messageInfo_ListVolumesResponse_Entry.Size(m)
}
func (m *ListVolumesResponse_Entry) XXX_DiscardUnknown() {
	xxx_messageInfo_ListVolumesResponse_Entry.DiscardUnknown(m)
}

var xxx_messageInfo_ListVolumesResponse_Entry proto.InternalMessageInfo

func (m *ListVolumesResponse_Entry) GetVolume() *Volume {
	if m != nil {
		return m.Volume
	}
	return nil
}

func (m *ListVolumesResponse_Entry) GetStatus() *ListVolumesResponse_VolumeStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

type GetCapacityRequest struct {
	// If specified, the Plugin SHALL report the capacity of the storage
	// that can be used to provision volumes that satisfy ALL of the
	// specified `volume_capabilities`. These are the same
	// `volume_capabilities` the CO will use in `CreateVolumeRequest`.
	// This field is OPTIONAL.
	VolumeCapabilities []*VolumeCapability `protobuf:"bytes,1,rep,name=volume_capabilities,json=volumeCapabilities,proto3" json:"volume_capabilities,omitempty"`
	// If specified, the Plugin SHALL report the capacity of the storage
	// that can be used to provision volumes with the given Plugin
	// specific `parameters`. These are the same `parameters` the CO will
	// use in `CreateVolumeRequest`. This field is OPTIONAL.
	Parameters map[string]string `protobuf:"bytes,2,rep,name=parameters,proto3" json:"parameters,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// If specified, the Plugin SHALL report the capacity of the storage
	// that can be used to provision volumes that in the specified
	// `accessible_topology`. This is the same as the
	// `accessible_topology` the CO returns in a `CreateVolumeResponse`.
	// This field is OPTIONAL. This field SHALL NOT be set unless the
	// plugin advertises the VOLUME_ACCESSIBILITY_CONSTRAINTS capability.
	AccessibleTopology   *Topology `protobuf:"bytes,3,opt,name=accessible_topology,json=accessibleTopology,proto3" json:"accessible_topology,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *GetCapacityRequest) Reset()         { *m = GetCapacityRequest{} }
func (m *GetCapacityRequest) String() string { return proto.CompactTextString(m) }
func (*GetCapacityRequest) ProtoMessage()    {}
func (*GetCapacityRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{25}
}

func (m *GetCapacityRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetCapacityRequest.Unmarshal(m, b)
}
func (m *GetCapacityRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetCapacityRequest.Marshal(b, m, deterministic)
}
func (m *GetCapacityRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetCapacityRequest.Merge(m, src)
}
func (m *GetCapacityRequest) XXX_Size() int {
	return xxx_messageInfo_GetCapacityRequest.Size(m)
}
func (m *GetCapacityRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetCapacityRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetCapacityRequest proto.InternalMessageInfo

func (m *GetCapacityRequest) GetVolumeCapabilities() []*VolumeCapability {
	if m != nil {
		return m.VolumeCapabilities
	}
	return nil
}

func (m *GetCapacityRequest) GetParameters() map[string]string {
	if m != nil {
		return m.Parameters
	}
	return nil
}

func (m *GetCapacityRequest) GetAccessibleTopology() *Topology {
	if m != nil {
		return m.AccessibleTopology
	}
	return nil
}

type GetCapacityResponse struct {
	// The available capacity, in bytes, of the storage that can be used
	// to provision volumes. If `volume_capabilities` or `parameters` is
	// specified in the request, the Plugin SHALL take those into
	// consideration when calculating the available capacity of the
	// storage. This field is REQUIRED.
	// The value of this field MUST NOT be negative.
	AvailableCapacity    int64    `protobuf:"varint,1,opt,name=available_capacity,json=availableCapacity,proto3" json:"available_capacity,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetCapacityResponse) Reset()         { *m = GetCapacityResponse{} }
func (m *GetCapacityResponse) String() string { return proto.CompactTextString(m) }
func (*GetCapacityResponse) ProtoMessage()    {}
func (*GetCapacityResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{26}
}

func (m *GetCapacityResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetCapacityResponse.Unmarshal(m, b)
}
func (m *GetCapacityResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetCapacityResponse.Marshal(b, m, deterministic)
}
func (m *GetCapacityResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetCapacityResponse.Merge(m, src)
}
func (m *GetCapacityResponse) XXX_Size() int {
	return xxx_messageInfo_GetCapacityResponse.Size(m)
}
func (m *GetCapacityResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetCapacityResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetCapacityResponse proto.InternalMessageInfo

func (m *GetCapacityResponse) GetAvailableCapacity() int64 {
	if m != nil {
		return m.AvailableCapacity
	}
	return 0
}

type ControllerGetCapabilitiesRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ControllerGetCapabilitiesRequest) Reset()         { *m = ControllerGetCapabilitiesRequest{} }
func (m *ControllerGetCapabilitiesRequest) String() string { return proto.CompactTextString(m) }
func (*ControllerGetCapabilitiesRequest) ProtoMessage()    {}
func (*ControllerGetCapabilitiesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{27}
}

func (m *ControllerGetCapabilitiesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ControllerGetCapabilitiesRequest.Unmarshal(m, b)
}
func (m *ControllerGetCapabilitiesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ControllerGetCapabilitiesRequest.Marshal(b, m, deterministic)
}
func (m *ControllerGetCapabilitiesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ControllerGetCapabilitiesRequest.Merge(m, src)
}
func (m *ControllerGetCapabilitiesRequest) XXX_Size() int {
	return xxx_messageInfo_ControllerGetCapabilitiesRequest.Size(m)
}
func (m *ControllerGetCapabilitiesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ControllerGetCapabilitiesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ControllerGetCapabilitiesRequest proto.InternalMessageInfo

type ControllerGetCapabilitiesResponse struct {
	// All the capabilities that the controller service supports. This
	// field is OPTIONAL.
	Capabilities         []*ControllerServiceCapability `protobuf:"bytes,1,rep,name=capabilities,proto3" json:"capabilities,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *ControllerGetCapabilitiesResponse) Reset()         { *m = ControllerGetCapabilitiesResponse{} }
func (m *ControllerGetCapabilitiesResponse) String() string { return proto.CompactTextString(m) }
func (*ControllerGetCapabilitiesResponse) ProtoMessage()    {}
func (*ControllerGetCapabilitiesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{28}
}

func (m *ControllerGetCapabilitiesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ControllerGetCapabilitiesResponse.Unmarshal(m, b)
}
func (m *ControllerGetCapabilitiesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ControllerGetCapabilitiesResponse.Marshal(b, m, deterministic)
}
func (m *ControllerGetCapabilitiesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ControllerGetCapabilitiesResponse.Merge(m, src)
}
func (m *ControllerGetCapabilitiesResponse) XXX_Size() int {
	return xxx_messageInfo_ControllerGetCapabilitiesResponse.Size(m)
}
func (m *ControllerGetCapabilitiesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ControllerGetCapabilitiesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ControllerGetCapabilitiesResponse proto.InternalMessageInfo

func (m *ControllerGetCapabilitiesResponse) GetCapabilities() []*ControllerServiceCapability {
	if m != nil {
		return m.Capabilities
	}
	return nil
}

// Specifies a capability of the controller service.
type ControllerServiceCapability struct {
	// Types that are valid to be assigned to Type:
	//	*ControllerServiceCapability_Rpc
	Type                 isControllerServiceCapability_Type `protobuf_oneof:"type"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *ControllerServiceCapability) Reset()         { *m = ControllerServiceCapability{} }
func (m *ControllerServiceCapability) String() string { return proto.CompactTextString(m) }
func (*ControllerServiceCapability) ProtoMessage()    {}
func (*ControllerServiceCapability) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{29}
}

func (m *ControllerServiceCapability) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ControllerServiceCapability.Unmarshal(m, b)
}
func (m *ControllerServiceCapability) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ControllerServiceCapability.Marshal(b, m, deterministic)
}
func (m *ControllerServiceCapability) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ControllerServiceCapability.Merge(m, src)
}
func (m *ControllerServiceCapability) XXX_Size() int {
	return xxx_messageInfo_ControllerServiceCapability.Size(m)
}
func (m *ControllerServiceCapability) XXX_DiscardUnknown() {
	xxx_messageInfo_ControllerServiceCapability.DiscardUnknown(m)
}

var xxx_messageInfo_ControllerServiceCapability proto.InternalMessageInfo

type isControllerServiceCapability_Type interface {
	isControllerServiceCapability_Type()
}

type ControllerServiceCapability_Rpc struct {
	Rpc *ControllerServiceCapability_RPC `protobuf:"bytes,1,opt,name=rpc,proto3,oneof"`
}

func (*ControllerServiceCapability_Rpc) isControllerServiceCapability_Type() {}

func (m *ControllerServiceCapability) GetType() isControllerServiceCapability_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *ControllerServiceCapability) GetRpc() *ControllerServiceCapability_RPC {
	if x, ok := m.GetType().(*ControllerServiceCapability_Rpc); ok {
		return x.Rpc
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ControllerServiceCapability) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ControllerServiceCapability_Rpc)(nil),
	}
}

type ControllerServiceCapability_RPC struct {
	Type                 ControllerServiceCapability_RPC_Type `protobuf:"varint,1,opt,name=type,proto3,enum=csi.v1.ControllerServiceCapability_RPC_Type" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                             `json:"-"`
	XXX_unrecognized     []byte                               `json:"-"`
	XXX_sizecache        int32                                `json:"-"`
}

func (m *ControllerServiceCapability_RPC) Reset()         { *m = ControllerServiceCapability_RPC{} }
func (m *ControllerServiceCapability_RPC) String() string { return proto.CompactTextString(m) }
func (*ControllerServiceCapability_RPC) ProtoMessage()    {}
func (*ControllerServiceCapability_RPC) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{29, 0}
}

func (m *ControllerServiceCapability_RPC) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ControllerServiceCapability_RPC.Unmarshal(m, b)
}
func (m *ControllerServiceCapability_RPC) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ControllerServiceCapability_RPC.Marshal(b, m, deterministic)
}
func (m *ControllerServiceCapability_RPC) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ControllerServiceCapability_RPC.Merge(m, src)
}
func (m *ControllerServiceCapability_RPC) XXX_Size() int {
	return xxx_messageInfo_ControllerServiceCapability_RPC.Size(m)
}
func (m *ControllerServiceCapability_RPC) XXX_DiscardUnknown() {
	xxx_messageInfo_ControllerServiceCapability_RPC.DiscardUnknown(m)
}

var xxx_messageInfo_ControllerServiceCapability_RPC proto.InternalMessageInfo

func (m *ControllerServiceCapability_RPC) GetType() ControllerServiceCapability_RPC_Type {
	if m != nil {
		return m.Type
	}
	return ControllerServiceCapability_RPC_UNKNOWN
}

type CreateSnapshotRequest struct {
	// The ID of the source volume to be snapshotted.
	// This field is REQUIRED.
	SourceVolumeId string `protobuf:"bytes,1,opt,name=source_volume_id,json=sourceVolumeId,proto3" json:"source_volume_id,omitempty"`
	// The suggested name for the snapshot. This field is REQUIRED for
	// idempotency.
	// Any Unicode string that conforms to the length limit is allowed
	// except those containing the following banned characters:
	// U+0000-U+0008, U+000B, U+000C, U+000E-U+001F, U+007F-U+009F.
	// (These are control characters other than commonly used whitespace.)
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Secrets required by plugin to complete snapshot creation request.
	// This field is OPTIONAL. Refer to the `Secrets Requirements`
	// section on how to use this field.
	Secrets map[string]string `protobuf:"bytes,3,rep,name=secrets,proto3" json:"secrets,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Plugin specific parameters passed in as opaque key-value pairs.
	// This field is OPTIONAL. The Plugin is responsible for parsing and
	// validating these parameters. COs will treat these as opaque.
	// Use cases for opaque parameters:
	// - Specify a policy to automatically clean up the snapshot.
	// - Specify an expiration date for the snapshot.
	// - Specify whether the snapshot is readonly or read/write.
	// - Specify if the snapshot should be replicated to some place.
	// - Specify primary or secondary for replication systems that
	//   support snapshotting only on primary.
	Parameters           map[string]string `protobuf:"bytes,4,rep,name=parameters,proto3" json:"parameters,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *CreateSnapshotRequest) Reset()         { *m = CreateSnapshotRequest{} }
func (m *CreateSnapshotRequest) String() string { return proto.CompactTextString(m) }
func (*CreateSnapshotRequest) ProtoMessage()    {}
func (*CreateSnapshotRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{30}
}

func (m *CreateSnapshotRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateSnapshotRequest.Unmarshal(m, b)
}
func (m *CreateSnapshotRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateSnapshotRequest.Marshal(b, m, deterministic)
}
func (m *CreateSnapshotRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateSnapshotRequest.Merge(m, src)
}
func (m *CreateSnapshotRequest) XXX_Size() int {
	return xxx_messageInfo_CreateSnapshotRequest.Size(m)
}
func (m *CreateSnapshotRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateSnapshotRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateSnapshotRequest proto.InternalMessageInfo

func (m *CreateSnapshotRequest) GetSourceVolumeId() string {
	if m != nil {
		return m.SourceVolumeId
	}
	return ""
}

func (m *CreateSnapshotRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateSnapshotRequest) GetSecrets() map[string]string {
	if m != nil {
		return m.Secrets
	}
	return nil
}

func (m *CreateSnapshotRequest) GetParameters() map[string]string {
	if m != nil {
		return m.Parameters
	}
	return nil
}

type CreateSnapshotResponse struct {
	// Contains all attributes of the newly created snapshot that are
	// relevant to the CO along with information required by the Plugin
	// to uniquely identify the snapshot. This field is REQUIRED.
	Snapshot             *Snapshot `protobuf:"bytes,1,opt,name=snapshot,proto3" json:"snapshot,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *CreateSnapshotResponse) Reset()         { *m = CreateSnapshotResponse{} }
func (m *CreateSnapshotResponse) String() string { return proto.CompactTextString(m) }
func (*CreateSnapshotResponse) ProtoMessage()    {}
func (*CreateSnapshotResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{31}
}

func (m *CreateSnapshotResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateSnapshotResponse.Unmarshal(m, b)
}
func (m *CreateSnapshotResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateSnapshotResponse.Marshal(b, m, deterministic)
}
func (m *CreateSnapshotResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateSnapshotResponse.Merge(m, src)
}
func (m *CreateSnapshotResponse) XXX_Size() int {
	return xxx_messageInfo_CreateSnapshotResponse.Size(m)
}
func (m *CreateSnapshotResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateSnapshotResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CreateSnapshotResponse proto.InternalMessageInfo

func (m *CreateSnapshotResponse) GetSnapshot() *Snapshot {
	if m != nil {
		return m.Snapshot
	}
	return nil
}

// Information about a specific snapshot.
type Snapshot struct {
	// This is the complete size of the snapshot in bytes. The purpose of
	// this field is to give CO guidance on how much space is needed to
	// create a volume from this snapshot. The size of the volume MUST NOT
	// be less than the size of the source snapshot. This field is
	// OPTIONAL. If this field is not set, it indicates that this size is
	// unknown. The value of this field MUST NOT be negative and a size of
	// zero means it is unspecified.
	SizeBytes int64 `protobuf:"varint,1,opt,name=size_bytes,json=sizeBytes,proto3" json:"size_bytes,omitempty"`
	// The identifier for this snapshot, generated by the plugin.
	// This field is REQUIRED.
	// This field MUST contain enough information to uniquely identify
	// this specific snapshot vs all other snapshots supported by this
	// plugin.
	// This field SHALL be used by the CO in subsequent calls to refer to
	// this snapshot.
	// The SP is NOT responsible for global uniqueness of snapshot_id
	// across multiple SPs.
	SnapshotId string `protobuf:"bytes,2,opt,name=snapshot_id,json=snapshotId,proto3" json:"snapshot_id,omitempty"`
	// Identity information for the source volume. Note that creating a
	// snapshot from a snapshot is not supported here so the source has to
	// be a volume. This field is REQUIRED.
	SourceVolumeId string `protobuf:"bytes,3,opt,name=source_volume_id,json=sourceVolumeId,proto3" json:"source_volume_id,omitempty"`
	// Timestamp when the point-in-time snapshot is taken on the storage
	// system. This field is REQUIRED.
	CreationTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=creation_time,json=creationTime,proto3" json:"creation_time,omitempty"`
	// Indicates if a snapshot is ready to use as a
	// `volume_content_source` in a `CreateVolumeRequest`. The default
	// value is false. This field is REQUIRED.
	ReadyToUse           bool     `protobuf:"varint,5,opt,name=ready_to_use,json=readyToUse,proto3" json:"ready_to_use,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Snapshot) Reset()         { *m = Snapshot{} }
func (m *Snapshot) String() string { return proto.CompactTextString(m) }
func (*Snapshot) ProtoMessage()    {}
func (*Snapshot) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{32}
}

func (m *Snapshot) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Snapshot.Unmarshal(m, b)
}
func (m *Snapshot) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Snapshot.Marshal(b, m, deterministic)
}
func (m *Snapshot) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Snapshot.Merge(m, src)
}
func (m *Snapshot) XXX_Size() int {
	return xxx_messageInfo_Snapshot.Size(m)
}
func (m *Snapshot) XXX_DiscardUnknown() {
	xxx_messageInfo_Snapshot.DiscardUnknown(m)
}

var xxx_messageInfo_Snapshot proto.InternalMessageInfo

func (m *Snapshot) GetSizeBytes() int64 {
	if m != nil {
		return m.SizeBytes
	}
	return 0
}

func (m *Snapshot) GetSnapshotId() string {
	if m != nil {
		return m.SnapshotId
	}
	return ""
}

func (m *Snapshot) GetSourceVolumeId() string {
	if m != nil {
		return m.SourceVolumeId
	}
	return ""
}

func (m *Snapshot) GetCreationTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreationTime
	}
	return nil
}

func (m *Snapshot) GetReadyToUse() bool {
	if m != nil {
		return m.ReadyToUse
	}
	return false
}

type DeleteSnapshotRequest struct {
	// The ID of the snapshot to be deleted.
	// This field is REQUIRED.
	SnapshotId string `protobuf:"bytes,1,opt,name=snapshot_id,json=snapshotId,proto3" json:"snapshot_id,omitempty"`
	// Secrets required by plugin to complete snapshot deletion request.
	// This field is OPTIONAL. Refer to the `Secrets Requirements`
	// section on how to use this field.
	Secrets              map[string]string `protobuf:"bytes,2,rep,name=secrets,proto3" json:"secrets,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *DeleteSnapshotRequest) Reset()         { *m = DeleteSnapshotRequest{} }
func (m *DeleteSnapshotRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteSnapshotRequest) ProtoMessage()    {}
func (*DeleteSnapshotRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{33}
}

func (m *DeleteSnapshotRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteSnapshotRequest.Unmarshal(m, b)
}
func (m *DeleteSnapshotRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteSnapshotRequest.Marshal(b, m, deterministic)
}
func (m *DeleteSnapshotRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteSnapshotRequest.Merge(m, src)
}
func (m *DeleteSnapshotRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteSnapshotRequest.Size(m)
}
func (m *DeleteSnapshotRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteSnapshotRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteSnapshotRequest proto.InternalMessageInfo

func (m *DeleteSnapshotRequest) GetSnapshotId() string {
	if m != nil {
		return m.SnapshotId
	}
	return ""
}

func (m *DeleteSnapshotRequest) GetSecrets() map[string]string {
	if m != nil {
		return m.Secrets
	}
	return nil
}

type DeleteSnapshotResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteSnapshotResponse) Reset()         { *m = DeleteSnapshotResponse{} }
func (m *DeleteSnapshotResponse) String() string { return proto.CompactTextString(m) }
func (*DeleteSnapshotResponse) ProtoMessage()    {}
func (*DeleteSnapshotResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{34}
}

func (m *DeleteSnapshotResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteSnapshotResponse.Unmarshal(m, b)
}
func (m *DeleteSnapshotResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteSnapshotResponse.Marshal(b, m, deterministic)
}
func (m *DeleteSnapshotResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteSnapshotResponse.Merge(m, src)
}
func (m *DeleteSnapshotResponse) XXX_Size() int {
	return xxx_messageInfo_DeleteSnapshotResponse.Size(m)
}
func (m *DeleteSnapshotResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteSnapshotResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteSnapshotResponse proto.InternalMessageInfo

// List all snapshots on the storage system regardless of how they were
// created.
type ListSnapshotsRequest struct {
	// If specified (non-zero value), the Plugin MUST NOT return more
	// entries than this number in the response. If the actual number of
	// entries is more than this number, the Plugin MUST set `next_token`
	// in the response which can be used to get the next page of entries
	// in the subsequent `ListSnapshots` call. This field is OPTIONAL. If
	// not specified (zero value), it means there is no restriction on the
	// number of entries that can be returned.
	// The value of this field MUST NOT be negative.
	MaxEntries int32 `protobuf:"varint,1,opt,name=max_entries,json=maxEntries,proto3" json:"max_entries,omitempty"`
	// A token to specify where to start paginating. Set this field to
	// `next_token` returned by a previous `ListSnapshots` call to get the
	// next page of entries. This field is OPTIONAL.
	// An empty string is equal to an unspecified field value.
	StartingToken string `protobuf:"bytes,2,opt,name=starting_token,json=startingToken,proto3" json:"starting_token,omitempty"`
	// Identity information for the source volume. This field is OPTIONAL.
	// It can be used to list snapshots by volume.
	SourceVolumeId string `protobuf:"bytes,3,opt,name=source_volume_id,json=sourceVolumeId,proto3" json:"source_volume_id,omitempty"`
	// Identity information for a specific snapshot. This field is
	// OPTIONAL. It can be used to list only a specific snapshot.
	// ListSnapshots will return with current snapshot information
	// and will not block if the snapshot is being processed after
	// it is cut.
	SnapshotId string `protobuf:"bytes,4,opt,name=snapshot_id,json=snapshotId,proto3" json:"snapshot_id,omitempty"`
	// Secrets required by plugin to complete ListSnapshot request.
	// This field is OPTIONAL. Refer to the `Secrets Requirements`
	// section on how to use this field.
	Secrets              map[string]string `protobuf:"bytes,5,rep,name=secrets,proto3" json:"secrets,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ListSnapshotsRequest) Reset()         { *m = ListSnapshotsRequest{} }
func (m *ListSnapshotsRequest) String() string { return proto.CompactTextString(m) }
func (*ListSnapshotsRequest) ProtoMessage()    {}
func (*ListSnapshotsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{35}
}

func (m *ListSnapshotsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSnapshotsRequest.Unmarshal(m, b)
}
func (m *ListSnapshotsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSnapshotsRequest.Marshal(b, m, deterministic)
}
func (m *ListSnapshotsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSnapshotsRequest.Merge(m, src)
}
func (m *ListSnapshotsRequest) XXX_Size() int {
	return xxx_messageInfo_ListSnapshotsRequest.Size(m)
}
func (m *ListSnapshotsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSnapshotsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListSnapshotsRequest proto.InternalMessageInfo

func (m *ListSnapshotsRequest) GetMaxEntries() int32 {
	if m != nil {
		return m.MaxEntries
	}
	return 0
}

func (m *ListSnapshotsRequest) GetStartingToken() string {
	if m != nil {
		return m.StartingToken
	}
	return ""
}

func (m *ListSnapshotsRequest) GetSourceVolumeId() string {
	if m != nil {
		return m.SourceVolumeId
	}
	return ""
}

func (m *ListSnapshotsRequest) GetSnapshotId() string {
	if m != nil {
		return m.SnapshotId
	}
	return ""
}

func (m *ListSnapshotsRequest) GetSecrets() map[string]string {
	if m != nil {
		return m.Secrets
	}
	return nil
}

type ListSnapshotsResponse struct {
	Entries []*ListSnapshotsResponse_Entry `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
	// This token allows you to get the next page of entries for
	// `ListSnapshots` request. If the number of entries is larger than
	// `max_entries`, use the `next_token` as a value for the
	// `starting_token` field in the next `ListSnapshots` request. This
	// field is OPTIONAL.
	// An empty string is equal to an unspecified field value.
	NextToken            string   `protobuf:"bytes,2,opt,name=next_token,json=nextToken,proto3" json:"next_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSnapshotsResponse) Reset()         { *m = ListSnapshotsResponse{} }
func (m *ListSnapshotsResponse) String() string { return proto.CompactTextString(m) }
func (*ListSnapshotsResponse) ProtoMessage()    {}
func (*ListSnapshotsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{36}
}

func (m *ListSnapshotsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSnapshotsResponse.Unmarshal(m, b)
}
func (m *ListSnapshotsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSnapshotsResponse.Marshal(b, m, deterministic)
}
func (m *ListSnapshotsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSnapshotsResponse.Merge(m, src)
}
func (m *ListSnapshotsResponse) XXX_Size() int {
	return xxx_messageInfo_ListSnapshotsResponse.Size(m)
}
func (m *ListSnapshotsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSnapshotsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListSnapshotsResponse proto.InternalMessageInfo

func (m *ListSnapshotsResponse) GetEntries() []*ListSnapshotsResponse_Entry {
	if m != nil {
		return m.Entries
	}
	return nil
}

func (m *ListSnapshotsResponse) GetNextToken() string {
	if m != nil {
		return m.NextToken
	}
	return ""
}

type ListSnapshotsResponse_Entry struct {
	Snapshot             *Snapshot `protobuf:"bytes,1,opt,name=snapshot,proto3" json:"snapshot,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *ListSnapshotsResponse_Entry) Reset()         { *m = ListSnapshotsResponse_Entry{} }
func (m *ListSnapshotsResponse_Entry) String() string { return proto.CompactTextString(m) }
func (*ListSnapshotsResponse_Entry) ProtoMessage()    {}
func (*ListSnapshotsResponse_Entry) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{36, 0}
}

func (m *ListSnapshotsResponse_Entry) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSnapshotsResponse_Entry.Unmarshal(m, b)
}
func (m *ListSnapshotsResponse_Entry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSnapshotsResponse_Entry.Marshal(b, m, deterministic)
}
func (m *ListSnapshotsResponse_Entry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSnapshotsResponse_Entry.Merge(m, src)
}
func (m *ListSnapshotsResponse_Entry) XXX_Size() int {
	return xxx_messageInfo_ListSnapshotsResponse_Entry.Size(m)
}
func (m *ListSnapshotsResponse_Entry) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSnapshotsResponse_Entry.DiscardUnknown(m)
}

var xxx_messageInfo_ListSnapshotsResponse_Entry proto.InternalMessageInfo

func (m *ListSnapshotsResponse_Entry) GetSnapshot() *Snapshot {
	if m != nil {
		return m.Snapshot
	}
	return nil
}

type ControllerExpandVolumeRequest struct {
	// The ID of the volume to expand. This field is REQUIRED.
	VolumeId string `protobuf:"bytes,1,opt,name=volume_id,json=volumeId,proto3" json:"volume_id,omitempty"`
	// This allows CO to specify the capacity requirements of the volume
	// after expansion. This field is REQUIRED.
	CapacityRange *CapacityRange `protobuf:"bytes,2,opt,name=capacity_range,json=capacityRange,proto3" json:"capacity_range,omitempty"`
	// Secrets required by the plugin for expanding the volume.
	// This field is OPTIONAL.
	Secrets map[string]string `protobuf:"bytes,3,rep,name=secrets,proto3" json:"secrets,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Volume capability describing how the CO intends to use this volume.
	// This allows SP to determine if volume is being used as a block
	// device or mounted file system. For example - if volume is
	// being used as a block device - the SP MAY set
	// node_expansion_required to false in ControllerExpandVolumeResponse
	// to skip invocation of NodeExpandVolume on the node by the CO.
	// This is an OPTIONAL field.
	VolumeCapability     *VolumeCapability `protobuf:"bytes,4,opt,name=volume_capability,json=volumeCapability,proto3" json:"volume_capability,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ControllerExpandVolumeRequest) Reset()         { *m = ControllerExpandVolumeRequest{} }
func (m *ControllerExpandVolumeRequest) String() string { return proto.CompactTextString(m) }
func (*ControllerExpandVolumeRequest) ProtoMessage()    {}
func (*ControllerExpandVolumeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{37}
}

func (m *ControllerExpandVolumeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ControllerExpandVolumeRequest.Unmarshal(m, b)
}
func (m *ControllerExpandVolumeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ControllerExpandVolumeRequest.Marshal(b, m, deterministic)
}
func (m *ControllerExpandVolumeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ControllerExpandVolumeRequest.Merge(m, src)
}
func (m *ControllerExpandVolumeRequest) XXX_Size() int {
	return xxx_messageInfo_ControllerExpandVolumeRequest.Size(m)
}
func (m *ControllerExpandVolumeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ControllerExpandVolumeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ControllerExpandVolumeRequest proto.InternalMessageInfo

func (m *ControllerExpandVolumeRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *ControllerExpandVolumeRequest) GetCapacityRange() *CapacityRange {
	if m != nil {
		return m.CapacityRange
	}
	return nil
}

func (m *ControllerExpandVolumeRequest) GetSecrets() map[string]string {
	if m != nil {
		return m.Secrets
	}
	return nil
}

func (m *ControllerExpandVolumeRequest) GetVolumeCapability() *VolumeCapability {
	if m != nil {
		return m.VolumeCapability
	}
	return nil
}

type ControllerExpandVolumeResponse struct {
	// Capacity of volume after expansion. This field is REQUIRED.
	CapacityBytes int64 `protobuf:"varint,1,opt,name=capacity_bytes,json=capacityBytes,proto3" json:"capacity_bytes,omitempty"`
	// Whether node expansion is required for the volume. When true
	// the CO MUST make NodeExpandVolume RPC call on the node. This field
	// is REQUIRED.
	NodeExpansionRequired bool     `protobuf:"varint,2,opt,name=node_expansion_required,json=nodeExpansionRequired,proto3" json:"node_expansion_required,omitempty"`
	XXX_NoUnkeyedLiteral  struct{} `json:"-"`
	XXX_unrecognized      []byte   `json:"-"`
	XXX_sizecache         int32    `json:"-"`
}

func (m *ControllerExpandVolumeResponse) Reset()         { *m = ControllerExpandVolumeResponse{} }
func (m *ControllerExpandVolumeResponse) String() string { return proto.CompactTextString(m) }
func (*ControllerExpandVolumeResponse) ProtoMessage()    {}
func (*ControllerExpandVolumeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{38}
}

func (m *ControllerExpandVolumeResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ControllerExpandVolumeResponse.Unmarshal(m, b)
}
func (m *ControllerExpandVolumeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ControllerExpandVolumeResponse.Marshal(b, m, deterministic)
}
func (m *ControllerExpandVolumeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ControllerExpandVolumeResponse.Merge(m, src)
}
func (m *ControllerExpandVolumeResponse) XXX_Size() int {
	return xxx_messageInfo_ControllerExpandVolumeResponse.Size(m)
}
func (m *ControllerExpandVolumeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ControllerExpandVolumeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ControllerExpandVolumeResponse proto.InternalMessageInfo

func (m *ControllerExpandVolumeResponse) GetCapacityBytes() int64 {
	if m != nil {
		return m.CapacityBytes
	}
	return 0
}

func (m *ControllerExpandVolumeResponse) GetNodeExpansionRequired() bool {
	if m != nil {
		return m.NodeExpansionRequired
	}
	return false
}

type NodeStageVolumeRequest struct {
	// The ID of the volume to publish. This field is REQUIRED.
	VolumeId string `protobuf:"bytes,1,opt,name=volume_id,json=volumeId,proto3" json:"volume_id,omitempty"`
	// The CO SHALL set this field to the value returned by
	// `ControllerPublishVolume` if the corresponding Controller Plugin
	// has `PUBLISH_UNPUBLISH_VOLUME` controller capability, and SHALL be
	// left unset if the corresponding Controller Plugin does not have
	// this capability. This is an OPTIONAL field.
	PublishContext map[string]string `protobuf:"bytes,2,rep,name=publish_context,json=publishContext,proto3" json:"publish_context,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The path to which the volume MAY be staged. It MUST be an
	// absolute path in the root filesystem of the process serving this
	// request, and MUST be a directory. The CO SHALL ensure that there
	// is only one `staging_target_path` per volume. The CO SHALL ensure
	// that the path is directory and that the process serving the
	// request has `read` and `write` permission to that directory. The
	// CO SHALL be responsible for creating the directory if it does not
	// exist.
	// This is a REQUIRED field.
	StagingTargetPath string `protobuf:"bytes,3,opt,name=staging_target_path,json=stagingTargetPath,proto3" json:"staging_target_path,omitempty"`
	// Volume capability describing how the CO intends to use this volume.
	// SP MUST ensure the CO can use the staged volume as described.
	// Otherwise SP MUST return the appropriate gRPC error code.
	// This is a REQUIRED field.
	VolumeCapability *VolumeCapability `protobuf:"bytes,4,opt,name=volume_capability,json=volumeCapability,proto3" json:"volume_capability,omitempty"`
	// Secrets required by plugin to complete node stage volume request.
	// This field is OPTIONAL. Refer to the `Secrets Requirements`
	// section on how to use this field.
	Secrets map[string]string `protobuf:"bytes,5,rep,name=secrets,proto3" json:"secrets,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Volume context as returned by CO in CreateVolumeRequest. This field
	// is OPTIONAL and MUST match the volume_context of the volume
	// identified by `volume_id`.
	VolumeContext        map[string]string `protobuf:"bytes,6,rep,name=volume_context,json=volumeContext,proto3" json:"volume_context,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *NodeStageVolumeRequest) Reset()         { *m = NodeStageVolumeRequest{} }
func (m *NodeStageVolumeRequest) String() string { return proto.CompactTextString(m) }
func (*NodeStageVolumeRequest) ProtoMessage()    {}
func (*NodeStageVolumeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{39}
}

func (m *NodeStageVolumeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NodeStageVolumeRequest.Unmarshal(m, b)
}
func (m *NodeStageVolumeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NodeStageVolumeRequest.Marshal(b, m, deterministic)
}
func (m *NodeStageVolumeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeStageVolumeRequest.Merge(m, src)
}
func (m *NodeStageVolumeRequest) XXX_Size() int {
	return xxx_messageInfo_NodeStageVolumeRequest.Size(m)
}
func (m *NodeStageVolumeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeStageVolumeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_NodeStageVolumeRequest proto.InternalMessageInfo

func (m *NodeStageVolumeRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *NodeStageVolumeRequest) GetPublishContext() map[string]string {
	if m != nil {
		return m.PublishContext
	}
	return nil
}

func (m *NodeStageVolumeRequest) GetStagingTargetPath() string {
	if m != nil {
		return m.StagingTargetPath
	}
	return ""
}

func (m *NodeStageVolumeRequest) GetVolumeCapability() *VolumeCapability {
	if m != nil {
		return m.VolumeCapability
	}
	return nil
}

func (m *NodeStageVolumeRequest) GetSecrets() map[string]string {
	if m != nil {
		return m.Secrets
	}
	return nil
}

func (m *NodeStageVolumeRequest) GetVolumeContext() map[string]string {
	if m != nil {
		return m.VolumeContext
	}
	return nil
}

type NodeStageVolumeResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NodeStageVolumeResponse) Reset()         { *m = NodeStageVolumeResponse{} }
func (m *NodeStageVolumeResponse) String() string { return proto.CompactTextString(m) }
func (*NodeStageVolumeResponse) ProtoMessage()    {}
func (*NodeStageVolumeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{40}
}

func (m *NodeStageVolumeResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NodeStageVolumeResponse.Unmarshal(m, b)
}
func (m *NodeStageVolumeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NodeStageVolumeResponse.Marshal(b, m, deterministic)
}
func (m *NodeStageVolumeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeStageVolumeResponse.Merge(m, src)
}
func (m *NodeStageVolumeResponse) XXX_Size() int {
	return xxx_messageInfo_NodeStageVolumeResponse.Size(m)
}
func (m *NodeStageVolumeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeStageVolumeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_NodeStageVolumeResponse proto.InternalMessageInfo

type NodeUnstageVolumeRequest struct {
	// The ID of the volume. This field is REQUIRED.
	VolumeId string `protobuf:"bytes,1,opt,name=volume_id,json=volumeId,proto3" json:"volume_id,omitempty"`
	// The path at which the volume was staged. It MUST be an absolute
	// path in the root filesystem of the process serving this request.
	// This is a REQUIRED field.
	StagingTargetPath    string   `protobuf:"bytes,2,opt,name=staging_target_path,json=stagingTargetPath,proto3" json:"staging_target_path,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NodeUnstageVolumeRequest) Reset()         { *m = NodeUnstageVolumeRequest{} }
func (m *NodeUnstageVolumeRequest) String() string { return proto.CompactTextString(m) }
func (*NodeUnstageVolumeRequest) ProtoMessage()    {}
func (*NodeUnstageVolumeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{41}
}

func (m *NodeUnstageVolumeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NodeUnstageVolumeRequest.Unmarshal(m, b)
}
func (m *NodeUnstageVolumeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NodeUnstageVolumeRequest.Marshal(b, m, deterministic)
}
func (m *NodeUnstageVolumeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeUnstageVolumeRequest.Merge(m, src)
}
func (m *NodeUnstageVolumeRequest) XXX_Size() int {
	return xxx_messageInfo_NodeUnstageVolumeRequest.Size(m)
}
func (m *NodeUnstageVolumeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeUnstageVolumeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_NodeUnstageVolumeRequest proto.InternalMessageInfo

func (m *NodeUnstageVolumeRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *NodeUnstageVolumeRequest) GetStagingTargetPath() string {
	if m != nil {
		return m.StagingTargetPath
	}
	return ""
}

type NodeUnstageVolumeResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NodeUnstageVolumeResponse) Reset()         { *m = NodeUnstageVolumeResponse{} }
func (m *NodeUnstageVolumeResponse) String() string { return proto.CompactTextString(m) }
func (*NodeUnstageVolumeResponse) ProtoMessage()    {}
func (*NodeUnstageVolumeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{42}
}

func (m *NodeUnstageVolumeResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NodeUnstageVolumeResponse.Unmarshal(m, b)
}
func (m *NodeUnstageVolumeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NodeUnstageVolumeResponse.Marshal(b, m, deterministic)
}
func (m *NodeUnstageVolumeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeUnstageVolumeResponse.Merge(m, src)
}
func (m *NodeUnstageVolumeResponse) XXX_Size() int {
	return xxx_messageInfo_NodeUnstageVolumeResponse.Size(m)
}
func (m *NodeUnstageVolumeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeUnstageVolumeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_NodeUnstageVolumeResponse proto.InternalMessageInfo

type NodePublishVolumeRequest struct {
	// The ID of the volume to publish. This field is REQUIRED.
	VolumeId string `protobuf:"bytes,1,opt,name=volume_id,json=volumeId,proto3" json:"volume_id,omitempty"`
	// The CO SHALL set this field to the value returned by
	// `ControllerPublishVolume` if the corresponding Controller Plugin
	// has `PUBLISH_UNPUBLISH_VOLUME` controller capability, and SHALL be
	// left unset if the corresponding Controller Plugin does not have
	// this capability. This is an OPTIONAL field.
	PublishContext map[string]string `protobuf:"bytes,2,rep,name=publish_context,json=publishContext,proto3" json:"publish_context,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The path to which the volume was staged by `NodeStageVolume`.
	// It MUST be an absolute path in the root filesystem of the process
	// serving this request.
	// It MUST be set if the Node Plugin implements the
	// `STAGE_UNSTAGE_VOLUME` node capability.
	// This is an OPTIONAL field.
	StagingTargetPath string `protobuf:"bytes,3,opt,name=staging_target_path,json=stagingTargetPath,proto3" json:"staging_target_path,omitempty"`
	// The path to which the volume will be published. It MUST be an
	// absolute path in the root filesystem of the process serving this
	// request. The CO SHALL ensure uniqueness of target_path per volume.
	// The CO SHALL ensure that the parent directory of this path exists
	// and that the process serving the request has `read` and `write`
	// permissions to that parent directory.
	// For volumes with an access type of block, the SP SHALL place the
	// block device at target_path.
	// For volumes with an access type of mount, the SP SHALL place the
	// mounted directory at target_path.
	// Creation of target_path is the responsibility of the SP.
	// This is a REQUIRED field.
	TargetPath string `protobuf:"bytes,4,opt,name=target_path,json=targetPath,proto3" json:"target_path,omitempty"`
	// Volume capability describing how the CO intends to use this volume.
	// SP MUST ensure the CO can use the published volume as described.
	// Otherwise SP MUST return the appropriate gRPC error code.
	// This is a REQUIRED field.
	VolumeCapability *VolumeCapability `protobuf:"bytes,5,opt,name=volume_capability,json=volumeCapability,proto3" json:"volume_capability,omitempty"`
	// Indicates SP MUST publish the volume in readonly mode.
	// This field is REQUIRED.
	Readonly bool `protobuf:"varint,6,opt,name=readonly,proto3" json:"readonly,omitempty"`
	// Secrets required by plugin to complete node publish volume request.
	// This field is OPTIONAL. Refer to the `Secrets Requirements`
	// section on how to use this field.
	Secrets map[string]string `protobuf:"bytes,7,rep,name=secrets,proto3" json:"secrets,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Volume context as returned by CO in CreateVolumeRequest. This field
	// is OPTIONAL and MUST match the volume_context of the volume
	// identified by `volume_id`.
	VolumeContext        map[string]string `protobuf:"bytes,8,rep,name=volume_context,json=volumeContext,proto3" json:"volume_context,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *NodePublishVolumeRequest) Reset()         { *m = NodePublishVolumeRequest{} }
func (m *NodePublishVolumeRequest) String() string { return proto.CompactTextString(m) }
func (*NodePublishVolumeRequest) ProtoMessage()    {}
func (*NodePublishVolumeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{43}
}

func (m *NodePublishVolumeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NodePublishVolumeRequest.Unmarshal(m, b)
}
func (m *NodePublishVolumeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NodePublishVolumeRequest.Marshal(b, m, deterministic)
}
func (m *NodePublishVolumeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodePublishVolumeRequest.Merge(m, src)
}
func (m *NodePublishVolumeRequest) XXX_Size() int {
	return xxx_messageInfo_NodePublishVolumeRequest.Size(m)
}
func (m *NodePublishVolumeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_NodePublishVolumeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_NodePublishVolumeRequest proto.InternalMessageInfo

func (m *NodePublishVolumeRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *NodePublishVolumeRequest) GetPublishContext() map[string]string {
	if m != nil {
		return m.PublishContext
	}
	return nil
}

func (m *NodePublishVolumeRequest) GetStagingTargetPath() string {
	if m != nil {
		return m.StagingTargetPath
	}
	return ""
}

func (m *NodePublishVolumeRequest) GetTargetPath() string {
	if m != nil {
		return m.TargetPath
	}
	return ""
}

func (m *NodePublishVolumeRequest) GetVolumeCapability() *VolumeCapability {
	if m != nil {
		return m.VolumeCapability
	}
	return nil
}

func (m *NodePublishVolumeRequest) GetReadonly() bool {
	if m != nil {
		return m.Readonly
	}
	return false
}

func (m *NodePublishVolumeRequest) GetSecrets() map[string]string {
	if m != nil {
		return m.Secrets
	}
	return nil
}

func (m *NodePublishVolumeRequest) GetVolumeContext() map[string]string {
	if m != nil {
		return m.VolumeContext
	}
	return nil
}

type NodePublishVolumeResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NodePublishVolumeResponse) Reset()         { *m = NodePublishVolumeResponse{} }
func (m *NodePublishVolumeResponse) String() string { return proto.CompactTextString(m) }
func (*NodePublishVolumeResponse) ProtoMessage()    {}
func (*NodePublishVolumeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{44}
}

func (m *NodePublishVolumeResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NodePublishVolumeResponse.Unmarshal(m, b)
}
func (m *NodePublishVolumeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NodePublishVolumeResponse.Marshal(b, m, deterministic)
}
func (m *NodePublishVolumeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodePublishVolumeResponse.Merge(m, src)
}
func (m *NodePublishVolumeResponse) XXX_Size() int {
	return xxx_messageInfo_NodePublishVolumeResponse.Size(m)
}
func (m *NodePublishVolumeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_NodePublishVolumeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_NodePublishVolumeResponse proto.InternalMessageInfo

type NodeUnpublishVolumeRequest struct {
	// The ID of the volume. This field is REQUIRED.
	VolumeId string `protobuf:"bytes,1,opt,name=volume_id,json=volumeId,proto3" json:"volume_id,omitempty"`
	// The path at which the volume was published. It MUST be an absolute
	// path in the root filesystem of the process serving this request.
	// The SP MUST delete the file or directory it created at this path.
	// This is a REQUIRED field.
	TargetPath           string   `protobuf:"bytes,2,opt,name=target_path,json=targetPath,proto3" json:"target_path,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NodeUnpublishVolumeRequest) Reset()         { *m = NodeUnpublishVolumeRequest{} }
func (m *NodeUnpublishVolumeRequest) String() string { return proto.CompactTextString(m) }
func (*NodeUnpublishVolumeRequest) ProtoMessage()    {}
func (*NodeUnpublishVolumeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{45}
}

func (m *NodeUnpublishVolumeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NodeUnpublishVolumeRequest.Unmarshal(m, b)
}
func (m *NodeUnpublishVolumeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NodeUnpublishVolumeRequest.Marshal(b, m, deterministic)
}
func (m *NodeUnpublishVolumeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeUnpublishVolumeRequest.Merge(m, src)
}
func (m *NodeUnpublishVolumeRequest) XXX_Size() int {
	return xxx_messageInfo_NodeUnpublishVolumeRequest.Size(m)
}
func (m *NodeUnpublishVolumeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeUnpublishVolumeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_NodeUnpublishVolumeRequest proto.InternalMessageInfo

func (m *NodeUnpublishVolumeRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *NodeUnpublishVolumeRequest) GetTargetPath() string {
	if m != nil {
		return m.TargetPath
	}
	return ""
}

type NodeUnpublishVolumeResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NodeUnpublishVolumeResponse) Reset()         { *m = NodeUnpublishVolumeResponse{} }
func (m *NodeUnpublishVolumeResponse) String() string { return proto.CompactTextString(m) }
func (*NodeUnpublishVolumeResponse) ProtoMessage()    {}
func (*NodeUnpublishVolumeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{46}
}

func (m *NodeUnpublishVolumeResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NodeUnpublishVolumeResponse.Unmarshal(m, b)
}
func (m *NodeUnpublishVolumeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NodeUnpublishVolumeResponse.Marshal(b, m, deterministic)
}
func (m *NodeUnpublishVolumeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeUnpublishVolumeResponse.Merge(m, src)
}
func (m *NodeUnpublishVolumeResponse) XXX_Size() int {
	return xxx_messageInfo_NodeUnpublishVolumeResponse.Size(m)
}
func (m *NodeUnpublishVolumeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeUnpublishVolumeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_NodeUnpublishVolumeResponse proto.InternalMessageInfo

type NodeGetVolumeStatsRequest struct {
	// The ID of the volume. This field is REQUIRED.
	VolumeId string `protobuf:"bytes,1,opt,name=volume_id,json=volumeId,proto3" json:"volume_id,omitempty"`
	// It can be any valid path where volume was previously
	// staged or published.
	// It MUST be an absolute path in the root filesystem of
	// the process serving this request.
	// This is a REQUIRED field.
	VolumePath string `protobuf:"bytes,2,opt,name=volume_path,json=volumePath,proto3" json:"volume_path,omitempty"`
	// The path where the volume is staged, if the plugin has the
	// STAGE_UNSTAGE_VOLUME capability, otherwise empty.
	// If not empty, it MUST be an absolute path in the root
	// filesystem of the process serving this request.
	// This field is OPTIONAL.
	StagingTargetPath    string   `protobuf:"bytes,3,opt,name=staging_target_path,json=stagingTargetPath,proto3" json:"staging_target_path,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NodeGetVolumeStatsRequest) Reset()         { *m = NodeGetVolumeStatsRequest{} }
func (m *NodeGetVolumeStatsRequest) String() string { return proto.CompactTextString(m) }
func (*NodeGetVolumeStatsRequest) ProtoMessage()    {}
func (*NodeGetVolumeStatsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{47}
}

func (m *NodeGetVolumeStatsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NodeGetVolumeStatsRequest.Unmarshal(m, b)
}
func (m *NodeGetVolumeStatsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NodeGetVolumeStatsRequest.Marshal(b, m, deterministic)
}
func (m *NodeGetVolumeStatsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeGetVolumeStatsRequest.Merge(m, src)
}
func (m *NodeGetVolumeStatsRequest) XXX_Size() int {
	return xxx_messageInfo_NodeGetVolumeStatsRequest.Size(m)
}
func (m *NodeGetVolumeStatsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeGetVolumeStatsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_NodeGetVolumeStatsRequest proto.InternalMessageInfo

func (m *NodeGetVolumeStatsRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *NodeGetVolumeStatsRequest) GetVolumePath() string {
	if m != nil {
		return m.VolumePath
	}
	return ""
}

func (m *NodeGetVolumeStatsRequest) GetStagingTargetPath() string {
	if m != nil {
		return m.StagingTargetPath
	}
	return ""
}

type NodeGetVolumeStatsResponse struct {
	// This field is OPTIONAL.
	Usage                []*VolumeUsage `protobuf:"bytes,1,rep,name=usage,proto3" json:"usage,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *NodeGetVolumeStatsResponse) Reset()         { *m = NodeGetVolumeStatsResponse{} }
func (m *NodeGetVolumeStatsResponse) String() string { return proto.CompactTextString(m) }
func (*NodeGetVolumeStatsResponse) ProtoMessage()    {}
func (*NodeGetVolumeStatsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{48}
}

func (m *NodeGetVolumeStatsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NodeGetVolumeStatsResponse.Unmarshal(m, b)
}
func (m *NodeGetVolumeStatsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NodeGetVolumeStatsResponse.Marshal(b, m, deterministic)
}
func (m *NodeGetVolumeStatsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeGetVolumeStatsResponse.Merge(m, src)
}
func (m *NodeGetVolumeStatsResponse) XXX_Size() int {
	return xxx_messageInfo_NodeGetVolumeStatsResponse.Size(m)
}
func (m *NodeGetVolumeStatsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeGetVolumeStatsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_NodeGetVolumeStatsResponse proto.InternalMessageInfo

func (m *NodeGetVolumeStatsResponse) GetUsage() []*VolumeUsage {
	if m != nil {
		return m.Usage
	}
	return nil
}

type VolumeUsage struct {
	// The available capacity in specified Unit. This field is OPTIONAL.
	// The value of this field MUST NOT be negative.
	Available int64 `protobuf:"varint,1,opt,name=available,proto3" json:"available,omitempty"`
	// The total capacity in specified Unit. This field is REQUIRED.
	// The value of this field MUST NOT be negative.
	Total int64 `protobuf:"varint,2,opt,name=total,proto3" json:"total,omitempty"`
	// The used capacity in specified Unit. This field is OPTIONAL.
	// The value of this field MUST NOT be negative.
	Used int64 `protobuf:"varint,3,opt,name=used,proto3" json:"used,omitempty"`
	// Units by which values are measured. This field is REQUIRED.
	Unit                 VolumeUsage_Unit `protobuf:"varint,4,opt,name=unit,proto3,enum=csi.v1.VolumeUsage_Unit" json:"unit,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *VolumeUsage) Reset()         { *m = VolumeUsage{} }
func (m *VolumeUsage) String() string { return proto.CompactTextString(m) }
func (*VolumeUsage) ProtoMessage()    {}
func (*VolumeUsage) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{49}
}

func (m *VolumeUsage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VolumeUsage.Unmarshal(m, b)
}
func (m *VolumeUsage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VolumeUsage.Marshal(b, m, deterministic)
}
func (m *VolumeUsage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VolumeUsage.Merge(m, src)
}
func (m *VolumeUsage) XXX_Size() int {
	return xxx_messageInfo_VolumeUsage.Size(m)
}
func (m *VolumeUsage) XXX_DiscardUnknown() {
	xxx_messageInfo_VolumeUsage.DiscardUnknown(m)
}

var xxx_messageInfo_VolumeUsage proto.InternalMessageInfo

func (m *VolumeUsage) GetAvailable() int64 {
	if m != nil {
		return m.Available
	}
	return 0
}

func (m *VolumeUsage) GetTotal() int64 {
	if m != nil {
		return m.Total
	}
	return 0
}

func (m *VolumeUsage) GetUsed() int64 {
	if m != nil {
		return m.Used
	}
	return 0
}

func (m *VolumeUsage) GetUnit() VolumeUsage_Unit {
	if m != nil {
		return m.Unit
	}
	return VolumeUsage_UNKNOWN
}

type NodeGetCapabilitiesRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NodeGetCapabilitiesRequest) Reset()         { *m = NodeGetCapabilitiesRequest{} }
func (m *NodeGetCapabilitiesRequest) String() string { return proto.CompactTextString(m) }
func (*NodeGetCapabilitiesRequest) ProtoMessage()    {}
func (*NodeGetCapabilitiesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{50}
}

func (m *NodeGetCapabilitiesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NodeGetCapabilitiesRequest.Unmarshal(m, b)
}
func (m *NodeGetCapabilitiesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NodeGetCapabilitiesRequest.Marshal(b, m, deterministic)
}
func (m *NodeGetCapabilitiesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeGetCapabilitiesRequest.Merge(m, src)
}
func (m *NodeGetCapabilitiesRequest) XXX_Size() int {
	return xxx_messageInfo_NodeGetCapabilitiesRequest.Size(m)
}
func (m *NodeGetCapabilitiesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeGetCapabilitiesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_NodeGetCapabilitiesRequest proto.InternalMessageInfo

type NodeGetCapabilitiesResponse struct {
	// All the capabilities that the node service supports. This field
	// is OPTIONAL.
	Capabilities         []*NodeServiceCapability `protobuf:"bytes,1,rep,name=capabilities,proto3" json:"capabilities,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *NodeGetCapabilitiesResponse) Reset()         { *m = NodeGetCapabilitiesResponse{} }
func (m *NodeGetCapabilitiesResponse) String() string { return proto.CompactTextString(m) }
func (*NodeGetCapabilitiesResponse) ProtoMessage()    {}
func (*NodeGetCapabilitiesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{51}
}

func (m *NodeGetCapabilitiesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NodeGetCapabilitiesResponse.Unmarshal(m, b)
}
func (m *NodeGetCapabilitiesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NodeGetCapabilitiesResponse.Marshal(b, m, deterministic)
}
func (m *NodeGetCapabilitiesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeGetCapabilitiesResponse.Merge(m, src)
}
func (m *NodeGetCapabilitiesResponse) XXX_Size() int {
	return xxx_messageInfo_NodeGetCapabilitiesResponse.Size(m)
}
func (m *NodeGetCapabilitiesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeGetCapabilitiesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_NodeGetCapabilitiesResponse proto.InternalMessageInfo

func (m *NodeGetCapabilitiesResponse) GetCapabilities() []*NodeServiceCapability {
	if m != nil {
		return m.Capabilities
	}
	return nil
}

// Specifies a capability of the node service.
type NodeServiceCapability struct {
	// Types that are valid to be assigned to Type:
	//	*NodeServiceCapability_Rpc
	Type                 isNodeServiceCapability_Type `protobuf_oneof:"type"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *NodeServiceCapability) Reset()         { *m = NodeServiceCapability{} }
func (m *NodeServiceCapability) String() string { return proto.CompactTextString(m) }
func (*NodeServiceCapability) ProtoMessage()    {}
func (*NodeServiceCapability) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{52}
}

func (m *NodeServiceCapability) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NodeServiceCapability.Unmarshal(m, b)
}
func (m *NodeServiceCapability) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NodeServiceCapability.Marshal(b, m, deterministic)
}
func (m *NodeServiceCapability) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeServiceCapability.Merge(m, src)
}
func (m *NodeServiceCapability) XXX_Size() int {
	return xxx_messageInfo_NodeServiceCapability.Size(m)
}
func (m *NodeServiceCapability) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeServiceCapability.DiscardUnknown(m)
}

var xxx_messageInfo_NodeServiceCapability proto.InternalMessageInfo

type isNodeServiceCapability_Type interface {
	isNodeServiceCapability_Type()
}

type NodeServiceCapability_Rpc struct {
	Rpc *NodeServiceCapability_RPC `protobuf:"bytes,1,opt,name=rpc,proto3,oneof"`
}

func (*NodeServiceCapability_Rpc) isNodeServiceCapability_Type() {}

func (m *NodeServiceCapability) GetType() isNodeServiceCapability_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *NodeServiceCapability) GetRpc() *NodeServiceCapability_RPC {
	if x, ok := m.GetType().(*NodeServiceCapability_Rpc); ok {
		return x.Rpc
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*NodeServiceCapability) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*NodeServiceCapability_Rpc)(nil),
	}
}

type NodeServiceCapability_RPC struct {
	Type                 NodeServiceCapability_RPC_Type `protobuf:"varint,1,opt,name=type,proto3,enum=csi.v1.NodeServiceCapability_RPC_Type" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *NodeServiceCapability_RPC) Reset()         { *m = NodeServiceCapability_RPC{} }
func (m *NodeServiceCapability_RPC) String() string { return proto.CompactTextString(m) }
func (*NodeServiceCapability_RPC) ProtoMessage()    {}
func (*NodeServiceCapability_RPC) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{52, 0}
}

func (m *NodeServiceCapability_RPC) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NodeServiceCapability_RPC.Unmarshal(m, b)
}
func (m *NodeServiceCapability_RPC) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NodeServiceCapability_RPC.Marshal(b, m, deterministic)
}
func (m *NodeServiceCapability_RPC) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeServiceCapability_RPC.Merge(m, src)
}
func (m *NodeServiceCapability_RPC) XXX_Size() int {
	return xxx_messageInfo_NodeServiceCapability_RPC.Size(m)
}
func (m *NodeServiceCapability_RPC) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeServiceCapability_RPC.DiscardUnknown(m)
}

var xxx_messageInfo_NodeServiceCapability_RPC proto.InternalMessageInfo

func (m *NodeServiceCapability_RPC) GetType() NodeServiceCapability_RPC_Type {
	if m != nil {
		return m.Type
	}
	return NodeServiceCapability_RPC_UNKNOWN
}

type NodeGetInfoRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NodeGetInfoRequest) Reset()         { *m = NodeGetInfoRequest{} }
func (m *NodeGetInfoRequest) String() string { return proto.CompactTextString(m) }
func (*NodeGetInfoRequest) ProtoMessage()    {}
func (*NodeGetInfoRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{53}
}

func (m *NodeGetInfoRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NodeGetInfoRequest.Unmarshal(m, b)
}
func (m *NodeGetInfoRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NodeGetInfoRequest.Marshal(b, m, deterministic)
}
func (m *NodeGetInfoRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeGetInfoRequest.Merge(m, src)
}
func (m *NodeGetInfoRequest) XXX_Size() int {
	return xxx_messageInfo_NodeGetInfoRequest.Size(m)
}
func (m *NodeGetInfoRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeGetInfoRequest.DiscardUnknown(m)
}

var xxx_messageInfo_NodeGetInfoRequest proto.InternalMessageInfo

type NodeGetInfoResponse struct {
	// The identifier of the node as understood by the SP.
	// This field is REQUIRED.
	// This field MUST contain enough information to uniquely identify
	// this specific node vs all other nodes supported by this plugin.
	// This field SHALL be used by the CO in subsequent calls, including
	// `ControllerPublishVolume`, to refer to this node.
	// The SP is NOT responsible for global uniqueness of node_id across
	// multiple SPs.
	NodeId string `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
	// Maximum number of volumes that controller can publish to the node.
	// If value is not set or zero CO SHALL decide how many volumes of
	// this type can be published by the controller to the node. The
	// plugin MUST NOT set negative values here.
	// This field is OPTIONAL.
	MaxVolumesPerNode int64 `protobuf:"varint,2,opt,name=max_volumes_per_node,json=maxVolumesPerNode,proto3" json:"max_volumes_per_node,omitempty"`
	// Specifies where (regions, zones, racks, etc.) the node is
	// accessible from.
	// A plugin that returns this field MUST also set the
	// VOLUME_ACCESSIBILITY_CONSTRAINTS plugin capability.
	// COs MAY use this information along with the topology information
	// returned in CreateVolumeResponse to ensure that a given volume is
	// accessible from a given node when scheduling workloads.
	// This field is OPTIONAL. If it is not specified, the CO MAY assume
	// the node is not subject to any topological constraint, and MAY
	// schedule workloads that reference any volume V, such that there are
	// no topological constraints declared for V.
	//
	// Example 1:
	//   accessible_topology =
	//     {"region": "R1", "zone": "Z2"}
	// Indicates the node exists within the "region" "R1" and the "zone"
	// "Z2".
	AccessibleTopology   *Topology `protobuf:"bytes,3,opt,name=accessible_topology,json=accessibleTopology,proto3" json:"accessible_topology,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *NodeGetInfoResponse) Reset()         { *m = NodeGetInfoResponse{} }
func (m *NodeGetInfoResponse) String() string { return proto.CompactTextString(m) }
func (*NodeGetInfoResponse) ProtoMessage()    {}
func (*NodeGetInfoResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{54}
}

func (m *NodeGetInfoResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NodeGetInfoResponse.Unmarshal(m, b)
}
func (m *NodeGetInfoResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NodeGetInfoResponse.Marshal(b, m, deterministic)
}
func (m *NodeGetInfoResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeGetInfoResponse.Merge(m, src)
}
func (m *NodeGetInfoResponse) XXX_Size() int {
	return xxx_messageInfo_NodeGetInfoResponse.Size(m)
}
func (m *NodeGetInfoResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeGetInfoResponse.DiscardUnknown(m)
}

var xxx_messageInfo_NodeGetInfoResponse proto.InternalMessageInfo

func (m *NodeGetInfoResponse) GetNodeId() string {
	if m != nil {
		return m.NodeId
	}
	return ""
}

func (m *NodeGetInfoResponse) GetMaxVolumesPerNode() int64 {
	if m != nil {
		return m.MaxVolumesPerNode
	}
	return 0
}

func (m *NodeGetInfoResponse) GetAccessibleTopology() *Topology {
	if m != nil {
		return m.AccessibleTopology
	}
	return nil
}

type NodeExpandVolumeRequest struct {
	// The ID of the volume. This field is REQUIRED.
	VolumeId string `protobuf:"bytes,1,opt,name=volume_id,json=volumeId,proto3" json:"volume_id,omitempty"`
	// The path on which volume is available. This field is REQUIRED.
	VolumePath string `protobuf:"bytes,2,opt,name=volume_path,json=volumePath,proto3" json:"volume_path,omitempty"`
	// This allows CO to specify the capacity requirements of the volume
	// after expansion. If capacity_range is omitted then a plugin MAY
	// inspect the file system of the volume to determine the maximum
	// capacity to which the volume can be expanded. In such cases a
	// plugin MAY expand the volume to its maximum capacity.
	// This field is OPTIONAL.
	CapacityRange *CapacityRange `protobuf:"bytes,3,opt,name=capacity_range,json=capacityRange,proto3" json:"capacity_range,omitempty"`
	// The path where the volume is staged, if the plugin has the
	// STAGE_UNSTAGE_VOLUME capability, otherwise empty.
	// If not empty, it MUST be an absolute path in the root
	// filesystem of the process serving this request.
	// This field is OPTIONAL.
	StagingTargetPath string `protobuf:"bytes,4,opt,name=staging_target_path,json=stagingTargetPath,proto3" json:"staging_target_path,omitempty"`
	// Volume capability describing how the CO intends to use this volume.
	// This allows SP to determine if volume is being used as a block
	// device or mounted file system. For example - if volume is being
	// used as a block device the SP MAY choose to skip expanding the
	// filesystem in NodeExpandVolume implementation but still perform
	// rest of the housekeeping needed for expanding the volume. If
	// volume_capability is omitted the SP MAY determine
	// access_type from given volume_path for the volume and perform
	// node expansion. This is an OPTIONAL field.
	VolumeCapability     *VolumeCapability `protobuf:"bytes,5,opt,name=volume_capability,json=volumeCapability,proto3" json:"volume_capability,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *NodeExpandVolumeRequest) Reset()         { *m = NodeExpandVolumeRequest{} }
func (m *NodeExpandVolumeRequest) String() string { return proto.CompactTextString(m) }
func (*NodeExpandVolumeRequest) ProtoMessage()    {}
func (*NodeExpandVolumeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{55}
}

func (m *NodeExpandVolumeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NodeExpandVolumeRequest.Unmarshal(m, b)
}
func (m *NodeExpandVolumeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NodeExpandVolumeRequest.Marshal(b, m, deterministic)
}
func (m *NodeExpandVolumeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeExpandVolumeRequest.Merge(m, src)
}
func (m *NodeExpandVolumeRequest) XXX_Size() int {
	return xxx_messageInfo_NodeExpandVolumeRequest.Size(m)
}
func (m *NodeExpandVolumeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeExpandVolumeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_NodeExpandVolumeRequest proto.InternalMessageInfo

func (m *NodeExpandVolumeRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *NodeExpandVolumeRequest) GetVolumePath() string {
	if m != nil {
		return m.VolumePath
	}
	return ""
}

func (m *NodeExpandVolumeRequest) GetCapacityRange() *CapacityRange {
	if m != nil {
		return m.CapacityRange
	}
	return nil
}

func (m *NodeExpandVolumeRequest) GetStagingTargetPath() string {
	if m != nil {
		return m.StagingTargetPath
	}
	return ""
}

func (m *NodeExpandVolumeRequest) GetVolumeCapability() *VolumeCapability {
	if m != nil {
		return m.VolumeCapability
	}
	return nil
}

type NodeExpandVolumeResponse struct {
	// The capacity of the volume in bytes. This field is OPTIONAL.
	CapacityBytes        int64    `protobuf:"varint,1,opt,name=capacity_bytes,json=capacityBytes,proto3" json:"capacity_bytes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NodeExpandVolumeResponse) Reset()         { *m = NodeExpandVolumeResponse{} }
func (m *NodeExpandVolumeResponse) String() string { return proto.CompactTextString(m) }
func (*NodeExpandVolumeResponse) ProtoMessage()    {}
func (*NodeExpandVolumeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdb00adce470e01, []int{56}
}

func (m *NodeExpandVolumeResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NodeExpandVolumeResponse.Unmarshal(m, b)
}
func (m *NodeExpandVolumeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NodeExpandVolumeResponse.Marshal(b, m, deterministic)
}
func (m *NodeExpandVolumeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeExpandVolumeResponse.Merge(m, src)
}
func (m *NodeExpandVolumeResponse) XXX_Size() int {
	return xxx_messageInfo_NodeExpandVolumeResponse.Size(m)
}
func (m *NodeExpandVolumeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeExpandVolumeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_NodeExpandVolumeResponse proto.InternalMessageInfo

func (m *NodeExpandVolumeResponse) GetCapacityBytes() int64 {
	if m != nil {
		return m.CapacityBytes
	}
	return 0
}

var E_CsiSecret = &proto.ExtensionDesc{
	ExtendedType:  (*descriptor.FieldOptions)(nil),
	ExtensionType: (*bool)(nil),
	Field:         1059,
	Name:          "csi.v1.csi_secret",
	Tag:           "varint,1059,opt,name=csi_secret",
	Filename:      "github.com/container-storage-interface/spec/csi.proto",
}

func init() {
	proto.RegisterEnum("csi.v1.PluginCapability_Service_Type", PluginCapability_Service_Type_name, PluginCapability_Service_Type_value)
	proto.RegisterEnum("csi.v1.PluginCapability_VolumeExpansion_Type", PluginCapability_VolumeExpansion_Type_name, PluginCapability_VolumeExpansion_Type_value)
	proto.RegisterEnum("csi.v1.VolumeCapability_AccessMode_Mode", VolumeCapability_AccessMode_Mode_name, VolumeCapability_AccessMode_Mode_value)
	proto.RegisterEnum("csi.v1.ControllerServiceCapability_RPC_Type", ControllerServiceCapability_RPC_Type_name, ControllerServiceCapability_RPC_Type_value)
	proto.RegisterEnum("csi.v1.VolumeUsage_Unit", VolumeUsage_Unit_name, VolumeUsage_Unit_value)
	proto.RegisterEnum("csi.v1.NodeServiceCapability_RPC_Type", NodeServiceCapability_RPC_Type_name, NodeServiceCapability_RPC_Type_value)
	proto.RegisterType((*GetPluginInfoRequest)(nil), "csi.v1.GetPluginInfoRequest")
	proto.RegisterType((*GetPluginInfoResponse)(nil), "csi.v1.GetPluginInfoResponse")
	proto.RegisterMapType((map[string]string)(nil), "csi.v1.GetPluginInfoResponse.ManifestEntry")
	proto.RegisterType((*GetPluginCapabilitiesRequest)(nil), "csi.v1.GetPluginCapabilitiesRequest")
	proto.RegisterType((*GetPluginCapabilitiesResponse)(nil), "csi.v1.GetPluginCapabilitiesResponse")
	proto.RegisterType((*PluginCapability)(nil), "csi.v1.PluginCapability")
	proto.RegisterType((*PluginCapability_Service)(nil), "csi.v1.PluginCapability.Service")
	proto.RegisterType((*PluginCapability_VolumeExpansion)(nil), "csi.v1.PluginCapability.VolumeExpansion")
	proto.RegisterType((*ProbeRequest)(nil), "csi.v1.ProbeRequest")
	proto.RegisterType((*ProbeResponse)(nil), "csi.v1.ProbeResponse")
	proto.RegisterType((*CreateVolumeRequest)(nil), "csi.v1.CreateVolumeRequest")
	proto.RegisterMapType((map[string]string)(nil), "csi.v1.CreateVolumeRequest.ParametersEntry")
	proto.RegisterMapType((map[string]string)(nil), "csi.v1.CreateVolumeRequest.SecretsEntry")
	proto.RegisterType((*VolumeContentSource)(nil), "csi.v1.VolumeContentSource")
	proto.RegisterType((*VolumeContentSource_SnapshotSource)(nil), "csi.v1.VolumeContentSource.SnapshotSource")
	proto.RegisterType((*VolumeContentSource_VolumeSource)(nil), "csi.v1.VolumeContentSource.VolumeSource")
	proto.RegisterType((*CreateVolumeResponse)(nil), "csi.v1.CreateVolumeResponse")
	proto.RegisterType((*VolumeCapability)(nil), "csi.v1.VolumeCapability")
	proto.RegisterType((*VolumeCapability_BlockVolume)(nil), "csi.v1.VolumeCapability.BlockVolume")
	proto.RegisterType((*VolumeCapability_MountVolume)(nil), "csi.v1.VolumeCapability.MountVolume")
	proto.RegisterType((*VolumeCapability_AccessMode)(nil), "csi.v1.VolumeCapability.AccessMode")
	proto.RegisterType((*CapacityRange)(nil), "csi.v1.CapacityRange")
	proto.RegisterType((*Volume)(nil), "csi.v1.Volume")
	proto.RegisterMapType((map[string]string)(nil), "csi.v1.Volume.VolumeContextEntry")
	proto.RegisterType((*TopologyRequirement)(nil), "csi.v1.TopologyRequirement")
	proto.RegisterType((*Topology)(nil), "csi.v1.Topology")
	proto.RegisterMapType((map[string]string)(nil), "csi.v1.Topology.SegmentsEntry")
	proto.RegisterType((*DeleteVolumeRequest)(nil), "csi.v1.DeleteVolumeRequest")
	proto.RegisterMapType((map[string]string)(nil), "csi.v1.DeleteVolumeRequest.SecretsEntry")
	proto.RegisterType((*DeleteVolumeResponse)(nil), "csi.v1.DeleteVolumeResponse")
	proto.RegisterType((*ControllerPublishVolumeRequest)(nil), "csi.v1.ControllerPublishVolumeRequest")
	proto.RegisterMapType((map[string]string)(nil), "csi.v1.ControllerPublishVolumeRequest.SecretsEntry")
	proto.RegisterMapType((map[string]string)(nil), "csi.v1.ControllerPublishVolumeRequest.VolumeContextEntry")
	proto.RegisterType((*ControllerPublishVolumeResponse)(nil), "csi.v1.ControllerPublishVolumeResponse")
	proto.RegisterMapType((map[string]string)(nil), "csi.v1.ControllerPublishVolumeResponse.PublishContextEntry")
	proto.RegisterType((*ControllerUnpublishVolumeRequest)(nil), "csi.v1.ControllerUnpublishVolumeRequest")
	proto.RegisterMapType((map[string]string)(nil), "csi.v1.ControllerUnpublishVolumeRequest.SecretsEntry")
	proto.RegisterType((*ControllerUnpublishVolumeResponse)(nil), "csi.v1.ControllerUnpublishVolumeResponse")
	proto.RegisterType((*ValidateVolumeCapabilitiesRequest)(nil), "csi.v1.ValidateVolumeCapabilitiesRequest")
	proto.RegisterMapType((map[string]string)(nil), "csi.v1.ValidateVolumeCapabilitiesRequest.ParametersEntry")
	proto.RegisterMapType((map[string]string)(nil), "csi.v1.ValidateVolumeCapabilitiesRequest.SecretsEntry")
	proto.RegisterMapType((map[string]string)(nil), "csi.v1.ValidateVolumeCapabilitiesRequest.VolumeContextEntry")
	proto.RegisterType((*ValidateVolumeCapabilitiesResponse)(nil), "csi.v1.ValidateVolumeCapabilitiesResponse")
	proto.RegisterType((*ValidateVolumeCapabilitiesResponse_Confirmed)(nil), "csi.v1.ValidateVolumeCapabilitiesResponse.Confirmed")
	proto.RegisterMapType((map[string]string)(nil), "csi.v1.ValidateVolumeCapabilitiesResponse.Confirmed.ParametersEntry")
	proto.RegisterMapType((map[string]string)(nil), "csi.v1.ValidateVolumeCapabilitiesResponse.Confirmed.VolumeContextEntry")
	proto.RegisterType((*ListVolumesRequest)(nil), "csi.v1.ListVolumesRequest")
	proto.RegisterType((*ListVolumesResponse)(nil), "csi.v1.ListVolumesResponse")
	proto.RegisterType((*ListVolumesResponse_VolumeStatus)(nil), "csi.v1.ListVolumesResponse.VolumeStatus")
	proto.RegisterType((*ListVolumesResponse_Entry)(nil), "csi.v1.ListVolumesResponse.Entry")
	proto.RegisterType((*GetCapacityRequest)(nil), "csi.v1.GetCapacityRequest")
	proto.RegisterMapType((map[string]string)(nil), "csi.v1.GetCapacityRequest.ParametersEntry")
	proto.RegisterType((*GetCapacityResponse)(nil), "csi.v1.GetCapacityResponse")
	proto.RegisterType((*ControllerGetCapabilitiesRequest)(nil), "csi.v1.ControllerGetCapabilitiesRequest")
	proto.RegisterType((*ControllerGetCapabilitiesResponse)(nil), "csi.v1.ControllerGetCapabilitiesResponse")
	proto.RegisterType((*ControllerServiceCapability)(nil), "csi.v1.ControllerServiceCapability")
	proto.RegisterType((*ControllerServiceCapability_RPC)(nil), "csi.v1.ControllerServiceCapability.RPC")
	proto.RegisterType((*CreateSnapshotRequest)(nil), "csi.v1.CreateSnapshotRequest")
	proto.RegisterMapType((map[string]string)(nil), "csi.v1.CreateSnapshotRequest.ParametersEntry")
	proto.RegisterMapType((map[string]string)(nil), "csi.v1.CreateSnapshotRequest.SecretsEntry")
	proto.RegisterType((*CreateSnapshotResponse)(nil), "csi.v1.CreateSnapshotResponse")
	proto.RegisterType((*Snapshot)(nil), "csi.v1.Snapshot")
	proto.RegisterType((*DeleteSnapshotRequest)(nil), "csi.v1.DeleteSnapshotRequest")
	proto.RegisterMapType((map[string]string)(nil), "csi.v1.DeleteSnapshotRequest.SecretsEntry")
	proto.RegisterType((*DeleteSnapshotResponse)(nil), "csi.v1.DeleteSnapshotResponse")
	proto.RegisterType((*ListSnapshotsRequest)(nil), "csi.v1.ListSnapshotsRequest")
	proto.RegisterMapType((map[string]string)(nil), "csi.v1.ListSnapshotsRequest.SecretsEntry")
	proto.RegisterType((*ListSnapshotsResponse)(nil), "csi.v1.ListSnapshotsResponse")
	proto.RegisterType((*ListSnapshotsResponse_Entry)(nil), "csi.v1.ListSnapshotsResponse.Entry")
	proto.RegisterType((*ControllerExpandVolumeRequest)(nil), "csi.v1.ControllerExpandVolumeRequest")
	proto.RegisterMapType((map[string]string)(nil), "csi.v1.ControllerExpandVolumeRequest.SecretsEntry")
	proto.RegisterType((*ControllerExpandVolumeResponse)(nil), "csi.v1.ControllerExpandVolumeResponse")
	proto.RegisterType((*NodeStageVolumeRequest)(nil), "csi.v1.NodeStageVolumeRequest")
	proto.RegisterMapType((map[string]string)(nil), "csi.v1.NodeStageVolumeRequest.PublishContextEntry")
	proto.RegisterMapType((map[string]string)(nil), "csi.v1.NodeStageVolumeRequest.SecretsEntry")
	proto.RegisterMapType((map[string]string)(nil), "csi.v1.NodeStageVolumeRequest.VolumeContextEntry")
	proto.RegisterType((*NodeStageVolumeResponse)(nil), "csi.v1.NodeStageVolumeResponse")
	proto.RegisterType((*NodeUnstageVolumeRequest)(nil), "csi.v1.NodeUnstageVolumeRequest")
	proto.RegisterType((*NodeUnstageVolumeResponse)(nil), "csi.v1.NodeUnstageVolumeResponse")
	proto.RegisterType((*NodePublishVolumeRequest)(nil), "csi.v1.NodePublishVolumeRequest")
	proto.RegisterMapType((map[string]string)(nil), "csi.v1.NodePublishVolumeRequest.PublishContextEntry")
	proto.RegisterMapType((map[string]string)(nil), "csi.v1.NodePublishVolumeRequest.SecretsEntry")
	proto.RegisterMapType((map[string]string)(nil), "csi.v1.NodePublishVolumeRequest.VolumeContextEntry")
	proto.RegisterType((*NodePublishVolumeResponse)(nil), "csi.v1.NodePublishVolumeResponse")
	proto.RegisterType((*NodeUnpublishVolumeRequest)(nil), "csi.v1.NodeUnpublishVolumeRequest")
	proto.RegisterType((*NodeUnpublishVolumeResponse)(nil), "csi.v1.NodeUnpublishVolumeResponse")
	proto.RegisterType((*NodeGetVolumeStatsRequest)(nil), "csi.v1.NodeGetVolumeStatsRequest")
	proto.RegisterType((*NodeGetVolumeStatsResponse)(nil), "csi.v1.NodeGetVolumeStatsResponse")
	proto.RegisterType((*VolumeUsage)(nil), "csi.v1.VolumeUsage")
	proto.RegisterType((*NodeGetCapabilitiesRequest)(nil), "csi.v1.NodeGetCapabilitiesRequest")
	proto.RegisterType((*NodeGetCapabilitiesResponse)(nil), "csi.v1.NodeGetCapabilitiesResponse")
	proto.RegisterType((*NodeServiceCapability)(nil), "csi.v1.NodeServiceCapability")
	proto.RegisterType((*NodeServiceCapability_RPC)(nil), "csi.v1.NodeServiceCapability.RPC")
	proto.RegisterType((*NodeGetInfoRequest)(nil), "csi.v1.NodeGetInfoRequest")
	proto.RegisterType((*NodeGetInfoResponse)(nil), "csi.v1.NodeGetInfoResponse")
	proto.RegisterType((*NodeExpandVolumeRequest)(nil), "csi.v1.NodeExpandVolumeRequest")
	proto.RegisterType((*NodeExpandVolumeResponse)(nil), "csi.v1.NodeExpandVolumeResponse")
	proto.RegisterExtension(E_CsiSecret)
}

func init() {
	proto.RegisterFile("github.com/container-storage-interface/spec/csi.proto", fileDescriptor_9cdb00adce470e01)
}

var fileDescriptor_9cdb00adce470e01 = []byte{
	// 3366 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe4, 0x5a, 0x4d, 0x70, 0xdb, 0xc6,
	0xf5, 0x27, 0xf8, 0x25, 0xea, 0xe9, 0xc3, 0xf4, 0xea, 0xc3, 0x34, 0x24, 0xd9, 0x32, 0x1c, 0x3b,
	0xb2, 0x63, 0xd3, 0xff, 0x28, 0x71, 0xe6, 0x1f, 0x5b, 0x69, 0x43, 0x51, 0xb4, 0xc4, 0x98, 0xa6,
	0x14, 0x90, 0x92, 0x63, 0xb7, 0x19, 0x04, 0x22, 0x57, 0x34, 0x26, 0x24, 0xc0, 0x00, 0xa0, 0x2a,
	0xf5, 0xd2, 0x99, 0xf6, 0xd4, 0x69, 0xef, 0x6d, 0x4f, 0x9d, 0x49, 0x6f, 0x6d, 0x33, 0x39, 0x75,
	0x7a, 0xec, 0x4c, 0x0f, 0x3d, 0xf4, 0xd0, 0xe9, 0xad, 0x9d, 0x5e, 0x72, 0xed, 0x64, 0xda, 0x99,
	0x4c, 0x8f, 0x9d, 0x1e, 0x3a, 0xc0, 0x2e, 0x40, 0x2c, 0x08, 0x80, 0xa4, 0x65, 0x4f, 0x0e, 0x3d,
	0x49, 0x7c, 0xfb, 0xf6, 0xed, 0xdb, 0xb7, 0xef, 0xbd, 0x7d, 0xef, 0xb7, 0x80, 0xbb, 0x2d, 0xc5,
	0x7c, 0xd6, 0x3b, 0xcc, 0x37, 0xb4, 0xce, 0x9d, 0x86, 0xa6, 0x9a, 0xb2, 0xa2, 0x62, 0xfd, 0xb6,
	0x61, 0x6a, 0xba, 0xdc, 0xc2, 0xb7, 0x15, 0xd5, 0xc4, 0xfa, 0x91, 0xdc, 0xc0, 0x77, 0x8c, 0x2e,
	0x6e, 0xdc, 0x69, 0x18, 0x4a, 0xbe, 0xab, 0x6b, 0xa6, 0x86, 0xd2, 0xd6, 0xbf, 0xc7, 0xaf, 0xf3,
	0xab, 0x2d, 0x4d, 0x6b, 0xb5, 0xf1, 0x1d, 0x9b, 0x7a, 0xd8, 0x3b, 0xba, 0xd3, 0xc4, 0x46, 0x43,
	0x57, 0xba, 0xa6, 0xa6, 0x13, 0x4e, 0xfe, 0xb2, 0x9f, 0xc3, 0x54, 0x3a, 0xd8, 0x30, 0xe5, 0x4e,
	0x97, 0x32, 0x5c, 0xf2, 0x33, 0x7c, 0x47, 0x97, 0xbb, 0x5d, 0xac, 0x1b, 0x64, 0x5c, 0x58, 0x84,
	0xf9, 0x6d, 0x6c, 0xee, 0xb5, 0x7b, 0x2d, 0x45, 0x2d, 0xab, 0x47, 0x9a, 0x88, 0x3f, 0xe9, 0x61,
	0xc3, 0x14, 0xfe, 0xca, 0xc1, 0x82, 0x6f, 0xc0, 0xe8, 0x6a, 0xaa, 0x81, 0x11, 0x82, 0xa4, 0x2a,
	0x77, 0x70, 0x8e, 0x5b, 0xe5, 0xd6, 0x26, 0x45, 0xfb, 0x7f, 0x74, 0x0d, 0x66, 0x8f, 0xb1, 0xda,
	0xd4, 0x74, 0xe9, 0x18, 0xeb, 0x86, 0xa2, 0xa9, 0xb9, 0xb8, 0x3d, 0x3a, 0x43, 0xa8, 0x07, 0x84,
	0x88, 0xb6, 0x21, 0xd3, 0x91, 0x55, 0xe5, 0x08, 0x1b, 0x66, 0x2e, 0xb1, 0x9a, 0x58, 0x9b, 0x5a,
	0x7f, 0x2d, 0x4f, 0xb6, 0x9a, 0x0f, 0x5c, 0x2b, 0xff, 0x88, 0x72, 0x97, 0x54, 0x53, 0x3f, 0x15,
	0xdd, 0xc9, 0xfc, 0x7d, 0x98, 0x61, 0x86, 0x50, 0x16, 0x12, 0x1f, 0xe3, 0x53, 0xaa, 0x93, 0xf5,
	0x2f, 0x9a, 0x87, 0xd4, 0xb1, 0xdc, 0xee, 0x61, 0xaa, 0x09, 0xf9, 0x71, 0x2f, 0xfe, 0xff, 0x9c,
	0x70, 0x09, 0x96, 0xdd, 0xd5, 0x8a, 0x72, 0x57, 0x3e, 0x54, 0xda, 0x8a, 0xa9, 0x60, 0xc3, 0xd9,
	0xfa, 0x87, 0xb0, 0x12, 0x32, 0x4e, 0x2d, 0xb0, 0x01, 0xd3, 0x0d, 0x0f, 0x3d, 0xc7, 0xd9, 0x5b,
	0xc9, 0x39, 0x5b, 0xf1, 0xcd, 0x3c, 0x15, 0x19, 0x6e, 0xe1, 0x4f, 0x09, 0xc8, 0xfa, 0x59, 0xd0,
	0x06, 0x4c, 0x18, 0x58, 0x3f, 0x56, 0x1a, 0xc4, 0xae, 0x53, 0xeb, 0xab, 0x61, 0xd2, 0xf2, 0x35,
	0xc2, 0xb7, 0x13, 0x13, 0x9d, 0x29, 0x68, 0x1f, 0xb2, 0xc7, 0x5a, 0xbb, 0xd7, 0xc1, 0x12, 0x3e,
	0xe9, 0xca, 0xaa, 0x7b, 0x00, 0x53, 0xeb, 0x6b, 0xa1, 0x62, 0x0e, 0xec, 0x09, 0x25, 0x87, 0x7f,
	0x27, 0x26, 0x9e, 0x3b, 0x66, 0x49, 0xfc, 0x4f, 0x38, 0x98, 0xa0, 0xab, 0xa1, 0xb7, 0x21, 0x69,
	0x9e, 0x76, 0x89, 0x76, 0xb3, 0xeb, 0xd7, 0x86, 0x69, 0x97, 0xaf, 0x9f, 0x76, 0xb1, 0x68, 0x4f,
	0x11, 0xde, 0x87, 0xa4, 0xf5, 0x0b, 0x4d, 0xc1, 0xc4, 0x7e, 0xf5, 0x61, 0x75, 0xf7, 0x71, 0x35,
	0x1b, 0x43, 0x8b, 0x80, 0x8a, 0xbb, 0xd5, 0xba, 0xb8, 0x5b, 0xa9, 0x94, 0x44, 0xa9, 0x56, 0x12,
	0x0f, 0xca, 0xc5, 0x52, 0x96, 0x43, 0xaf, 0xc0, 0xea, 0xc1, 0x6e, 0x65, 0xff, 0x51, 0x49, 0x2a,
	0x14, 0x8b, 0xa5, 0x5a, 0xad, 0xbc, 0x59, 0xae, 0x94, 0xeb, 0x4f, 0xa4, 0xe2, 0x6e, 0xb5, 0x56,
	0x17, 0x0b, 0xe5, 0x6a, 0xbd, 0x96, 0x8d, 0xf3, 0xdf, 0xe7, 0xe0, 0x9c, 0x6f, 0x03, 0xa8, 0xc0,
	0x68, 0x78, 0x7b, 0xd4, 0x8d, 0x7b, 0x35, 0xbd, 0x15, 0xa4, 0x29, 0x40, 0x7a, 0xb7, 0x5a, 0x29,
	0x57, 0x2d, 0xed, 0xa6, 0x60, 0x62, 0xf7, 0xc1, 0x03, 0xfb, 0x47, 0x7c, 0x33, 0x4d, 0x16, 0x14,
	0x66, 0x61, 0x7a, 0x4f, 0xd7, 0x0e, 0xb1, 0xe3, 0x3f, 0x05, 0x98, 0xa1, 0xbf, 0xa9, 0xbf, 0xfc,
	0x1f, 0xa4, 0x74, 0x2c, 0x37, 0x4f, 0xe9, 0xd1, 0xf2, 0x79, 0x12, 0x93, 0x79, 0x27, 0x26, 0xf3,
	0x9b, 0x9a, 0xd6, 0x3e, 0xb0, 0xfc, 0x53, 0x24, 0x8c, 0xc2, 0x57, 0x49, 0x98, 0x2b, 0xea, 0x58,
	0x36, 0x31, 0xd1, 0x96, 0x8a, 0x0e, 0x8c, 0xbd, 0x0d, 0x98, 0xb5, 0xfc, 0xab, 0xa1, 0x98, 0xa7,
	0x92, 0x2e, 0xab, 0x2d, 0x4c, 0x8f, 0x7e, 0xc1, 0xb1, 0x40, 0x91, 0x8e, 0x8a, 0xd6, 0xa0, 0x38,
	0xd3, 0xf0, 0xfe, 0x44, 0x65, 0x98, 0xa3, 0xae, 0xc3, 0xb8, 0x74, 0x82, 0x75, 0x69, 0xa2, 0x85,
	0xc7, 0xa5, 0xd1, 0x31, 0x4b, 0x51, 0xb0, 0x81, 0x1e, 0x02, 0x74, 0x65, 0x5d, 0xee, 0x60, 0x13,
	0xeb, 0x46, 0x2e, 0xc9, 0xc6, 0x77, 0xc0, 0x6e, 0xf2, 0x7b, 0x2e, 0x37, 0x89, 0x6f, 0xcf, 0x74,
	0xb4, 0x6d, 0x05, 0x44, 0x43, 0xc7, 0xa6, 0x91, 0x4b, 0xd9, 0x92, 0xd6, 0xa2, 0x24, 0xd5, 0x08,
	0xab, 0x2d, 0x66, 0x33, 0xf1, 0xd3, 0x4d, 0x4e, 0x74, 0x66, 0xa3, 0x5d, 0x58, 0x70, 0x36, 0xa8,
	0xa9, 0x26, 0x56, 0x4d, 0xc9, 0xd0, 0x7a, 0x7a, 0x03, 0xe7, 0xd2, 0xb6, 0x95, 0x96, 0x7c, 0x5b,
	0x24, 0x3c, 0x35, 0x9b, 0x45, 0xa4, 0xa6, 0x61, 0x88, 0xe8, 0x29, 0xf0, 0x72, 0xa3, 0x81, 0x0d,
	0x43, 0x21, 0xb6, 0x90, 0x74, 0xfc, 0x49, 0x4f, 0xd1, 0x71, 0x07, 0xab, 0xa6, 0x91, 0x9b, 0x60,
	0xa5, 0xd6, 0xb5, 0xae, 0xd6, 0xd6, 0x5a, 0xa7, 0x62, 0x9f, 0x47, 0xbc, 0xc8, 0x4c, 0xf7, 0x8c,
	0x18, 0xfc, 0x3b, 0x70, 0xce, 0x67, 0x94, 0x71, 0x32, 0x1b, 0x7f, 0x0f, 0xa6, 0xbd, 0x96, 0x18,
	0x2b, 0x2b, 0xfe, 0x28, 0x0e, 0x73, 0x01, 0x36, 0x40, 0x3b, 0x90, 0x31, 0x54, 0xb9, 0x6b, 0x3c,
	0xd3, 0x4c, 0xea, 0xbf, 0x37, 0x23, 0x4c, 0x96, 0xaf, 0x51, 0x5e, 0xf2, 0x73, 0x27, 0x26, 0xba,
	0xb3, 0xd1, 0x26, 0xa4, 0x89, 0x3d, 0xfd, 0xb9, 0x29, 0x48, 0x0e, 0xa1, 0xb9, 0x52, 0xe8, 0x4c,
	0xfe, 0x75, 0x98, 0x65, 0x57, 0x40, 0x97, 0x61, 0xca, 0x59, 0x41, 0x52, 0x9a, 0x74, 0xaf, 0xe0,
	0x90, 0xca, 0x4d, 0xfe, 0x35, 0x98, 0xf6, 0x0a, 0x43, 0x4b, 0x30, 0x49, 0x1d, 0xc2, 0x65, 0xcf,
	0x10, 0x42, 0xb9, 0xe9, 0xc6, 0xf4, 0x37, 0x60, 0x9e, 0xf5, 0x33, 0x1a, 0xca, 0xd7, 0xdd, 0x3d,
	0x10, 0x5b, 0xcc, 0xb2, 0x7b, 0x70, 0xf4, 0x14, 0x7e, 0x99, 0x84, 0xac, 0x3f, 0x68, 0xd0, 0x06,
	0xa4, 0x0e, 0xdb, 0x5a, 0xe3, 0x63, 0x3a, 0xf7, 0x95, 0xb0, 0xe8, 0xca, 0x6f, 0x5a, 0x5c, 0x84,
	0xba, 0x13, 0x13, 0xc9, 0x24, 0x6b, 0x76, 0x47, 0xeb, 0xa9, 0x26, 0xb5, 0x5e, 0xf8, 0xec, 0x47,
	0x16, 0x57, 0x7f, 0xb6, 0x3d, 0x09, 0x6d, 0xc1, 0x14, 0x71, 0x3b, 0xa9, 0xa3, 0x35, 0x71, 0x2e,
	0x61, 0xcb, 0xb8, 0x1a, 0x2a, 0xa3, 0x60, 0xf3, 0x3e, 0xd2, 0x9a, 0x58, 0x04, 0xd9, 0xfd, 0x9f,
	0x9f, 0x81, 0x29, 0x8f, 0x6e, 0xfc, 0x36, 0x4c, 0x79, 0x16, 0x43, 0x17, 0x60, 0xe2, 0xc8, 0x90,
	0xdc, 0x24, 0x3c, 0x29, 0xa6, 0x8f, 0x0c, 0x3b, 0x9f, 0x5e, 0x86, 0x29, 0x5b, 0x0b, 0xe9, 0xa8,
	0x2d, 0xb7, 0x8c, 0x5c, 0x7c, 0x35, 0x61, 0x9d, 0x91, 0x4d, 0x7a, 0x60, 0x51, 0xf8, 0x7f, 0x70,
	0x00, 0xfd, 0x25, 0xd1, 0x06, 0x24, 0x6d, 0x2d, 0x49, 0x2a, 0x5f, 0x1b, 0x41, 0xcb, 0xbc, 0xad,
	0xaa, 0x3d, 0x4b, 0xf8, 0x39, 0x07, 0x49, 0x5b, 0x8c, 0xff, 0xc2, 0xa9, 0x95, 0xab, 0xdb, 0x95,
	0x92, 0x54, 0xdd, 0xdd, 0x2a, 0x49, 0x8f, 0xc5, 0x72, 0xbd, 0x24, 0x66, 0x39, 0xb4, 0x04, 0x17,
	0xbc, 0x74, 0xb1, 0x54, 0xd8, 0x2a, 0x89, 0xd2, 0x6e, 0xb5, 0xf2, 0x24, 0x1b, 0x47, 0x3c, 0x2c,
	0x3e, 0xda, 0xaf, 0xd4, 0xcb, 0x83, 0x63, 0x09, 0xb4, 0x0c, 0x39, 0xcf, 0x18, 0x95, 0x41, 0xc5,
	0x26, 0x2d, 0xb1, 0x9e, 0x51, 0xf2, 0x2f, 0x1d, 0x4c, 0x6d, 0xce, 0xb8, 0x87, 0x61, 0x3b, 0xdb,
	0x63, 0x98, 0x61, 0x72, 0xb4, 0x55, 0x4e, 0xd1, 0xa4, 0xd2, 0x94, 0x0e, 0x4f, 0x4d, 0xbb, 0xc4,
	0xe0, 0xd6, 0x12, 0xe2, 0x8c, 0x43, 0xdd, 0xb4, 0x88, 0x96, 0x59, 0xdb, 0x4a, 0x47, 0x31, 0x29,
	0x4f, 0xdc, 0xe6, 0x01, 0x9b, 0x64, 0x33, 0x08, 0x5f, 0xc4, 0x21, 0x4d, 0xcf, 0xe6, 0x9a, 0xe7,
	0x96, 0x60, 0x44, 0x3a, 0x54, 0x22, 0x92, 0x09, 0x8e, 0x38, 0x1b, 0x1c, 0x68, 0x07, 0x66, 0xbd,
	0xa9, 0xf4, 0xc4, 0x29, 0xe2, 0xae, 0xb0, 0x07, 0xe4, 0x8d, 0xe7, 0x13, 0x5a, 0xba, 0xcd, 0x1c,
	0x7b, 0x69, 0x68, 0x13, 0x66, 0x7d, 0xd9, 0x38, 0x39, 0x3c, 0x1b, 0xcf, 0x34, 0x98, 0xc4, 0x54,
	0x80, 0x39, 0x27, 0x91, 0xb6, 0xb1, 0x64, 0xd2, 0x44, 0x4b, 0x6f, 0x8b, 0xec, 0x40, 0x02, 0x46,
	0x7d, 0x66, 0x87, 0xc6, 0xbf, 0x0b, 0x68, 0x50, 0xd7, 0xb1, 0xb2, 0x66, 0x0f, 0xe6, 0x02, 0x52,
	0x3c, 0xca, 0xc3, 0xa4, 0x7d, 0x54, 0x86, 0x62, 0x62, 0x5a, 0x1e, 0x0e, 0x6a, 0xd4, 0x67, 0xb1,
	0xf8, 0xbb, 0x3a, 0x3e, 0xc2, 0xba, 0x8e, 0x9b, 0x76, 0x78, 0x04, 0xf2, 0xbb, 0x2c, 0xc2, 0x0f,
	0x38, 0xc8, 0x38, 0x74, 0x74, 0x0f, 0x32, 0x06, 0x6e, 0x91, 0xeb, 0x87, 0xac, 0x75, 0xc9, 0x3f,
	0x37, 0x5f, 0xa3, 0x0c, 0xb4, 0x90, 0x76, 0xf8, 0xad, 0x42, 0x9a, 0x19, 0x1a, 0x6b, 0xf3, 0xbf,
	0xe5, 0x60, 0x6e, 0x0b, 0xb7, 0xb1, 0xbf, 0x4a, 0x89, 0xca, 0xb0, 0xde, 0x8b, 0x3d, 0xce, 0x5e,
	0xec, 0x01, 0xa2, 0x22, 0x2e, 0xf6, 0x33, 0x5d, 0x76, 0x8b, 0x30, 0xcf, 0xae, 0x46, 0xd2, 0xbb,
	0xf0, 0xcf, 0x04, 0x5c, 0xb2, 0x7c, 0x41, 0xd7, 0xda, 0x6d, 0xac, 0xef, 0xf5, 0x0e, 0xdb, 0x8a,
	0xf1, 0x6c, 0x8c, 0xcd, 0x5d, 0x80, 0x09, 0x55, 0x6b, 0x7a, 0x82, 0x27, 0x6d, 0xfd, 0x2c, 0x37,
	0x51, 0x09, 0xce, 0xfb, 0xcb, 0xac, 0x53, 0x9a, 0x84, 0xc3, 0x8b, 0xac, 0xec, 0xb1, 0xff, 0x06,
	0xe1, 0x21, 0x63, 0x15, 0x88, 0x9a, 0xda, 0x3e, 0xb5, 0x23, 0x26, 0x23, 0xba, 0xbf, 0x91, 0xe8,
	0xaf, 0x98, 0xde, 0x70, 0x2b, 0xa6, 0xc8, 0x1d, 0x45, 0x15, 0x4f, 0x1f, 0x0d, 0x44, 0x7c, 0xda,
	0x16, 0xfd, 0xf6, 0x88, 0xa2, 0x87, 0x66, 0x82, 0xb3, 0x9c, 0xe2, 0x0b, 0x08, 0xdf, 0x3f, 0x72,
	0x70, 0x39, 0x74, 0x0b, 0xf4, 0xca, 0x6f, 0xc2, 0xb9, 0x2e, 0x19, 0x70, 0x8d, 0x40, 0xa2, 0xec,
	0xfe, 0x50, 0x23, 0xd0, 0x2e, 0x96, 0x52, 0x19, 0x33, 0xcc, 0x76, 0x19, 0x22, 0x5f, 0x80, 0xb9,
	0x00, 0xb6, 0xb1, 0x36, 0xf3, 0x25, 0x07, 0xab, 0x7d, 0x55, 0xf6, 0xd5, 0xee, 0x8b, 0x73, 0xdf,
	0x7a, 0xdf, 0xb7, 0x48, 0xca, 0xbf, 0x3b, 0xb8, 0xf7, 0xe0, 0x05, 0x5f, 0x56, 0x04, 0x5f, 0x85,
	0x2b, 0x11, 0x4b, 0xd3, 0x70, 0xfe, 0x22, 0x09, 0x57, 0x0e, 0xe4, 0xb6, 0xd2, 0x74, 0x0b, 0xb9,
	0x80, 0x7e, 0x3f, 0xda, 0x24, 0x8d, 0x81, 0x08, 0x20, 0x59, 0x6b, 0xc3, 0x8d, 0xda, 0x61, 0xf2,
	0x47, 0xb8, 0x0e, 0x5f, 0x60, 0x13, 0xf6, 0x24, 0xa0, 0x09, 0x7b, 0x7b, 0x74, 0x5d, 0xa3, 0x5a,
	0xb2, 0x7d, 0x7f, 0x82, 0x79, 0x6b, 0x74, 0xb9, 0x11, 0x5e, 0x70, 0xe6, 0x28, 0xfe, 0x3a, 0xbb,
	0xa6, 0xdf, 0x27, 0x41, 0x88, 0xda, 0x3d, 0xcd, 0x21, 0x22, 0x4c, 0x36, 0x34, 0xf5, 0x48, 0xd1,
	0x3b, 0xb8, 0x49, 0xab, 0xff, 0x37, 0x47, 0x31, 0x1e, 0x4d, 0x20, 0x45, 0x67, 0xae, 0xd8, 0x17,
	0x83, 0x72, 0x30, 0xd1, 0xc1, 0x86, 0x21, 0xb7, 0x1c, 0xb5, 0x9c, 0x9f, 0xfc, 0x67, 0x09, 0x98,
	0x74, 0xa7, 0x20, 0x75, 0xc0, 0x83, 0x49, 0xfa, 0xda, 0x7e, 0x1e, 0x05, 0x9e, 0xdf, 0x99, 0xe3,
	0xcf, 0xe1, 0xcc, 0x4d, 0xc6, 0x99, 0x49, 0x38, 0x6c, 0x3d, 0x97, 0xda, 0x11, 0x7e, 0xfd, 0xb5,
	0x3b, 0xa0, 0xf0, 0x6d, 0x40, 0x15, 0xc5, 0xa0, 0x5d, 0x94, 0x9b, 0x96, 0xac, 0xa6, 0x49, 0x3e,
	0x91, 0xb0, 0x6a, 0xea, 0x0a, 0x2d, 0xd7, 0x53, 0x22, 0x74, 0xe4, 0x93, 0x12, 0xa1, 0x58, 0x25,
	0xbd, 0x61, 0xca, 0xba, 0xa9, 0xa8, 0x2d, 0xc9, 0xd4, 0x3e, 0xc6, 0x2e, 0xe8, 0xea, 0x50, 0xeb,
	0x16, 0x51, 0xf8, 0x34, 0x0e, 0x73, 0x8c, 0x78, 0xea, 0x93, 0xf7, 0x61, 0xa2, 0x2f, 0x9b, 0x29,
	0xe3, 0x03, 0xb8, 0xf3, 0xc4, 0x6c, 0xce, 0x0c, 0xb4, 0x02, 0xa0, 0xe2, 0x13, 0x93, 0x59, 0x77,
	0xd2, 0xa2, 0xd8, 0x6b, 0xf2, 0x1b, 0x6e, 0xcf, 0x6d, 0xca, 0x66, 0xcf, 0x40, 0xb7, 0x00, 0xd1,
	0x0c, 0x8d, 0x9b, 0x12, 0xbd, 0x62, 0xc8, 0xb2, 0x93, 0x62, 0xd6, 0x1d, 0xa9, 0xda, 0x97, 0x8d,
	0xc1, 0x7f, 0x02, 0x29, 0x62, 0xc4, 0x11, 0xbb, 0x6d, 0xf4, 0x2e, 0xa4, 0x0d, 0x7b, 0x21, 0x3f,
	0xb2, 0x10, 0xb4, 0x13, 0xaf, 0x62, 0x22, 0x9d, 0x27, 0x7c, 0x16, 0x07, 0xb4, 0x8d, 0x4d, 0xb7,
	0x0d, 0xa3, 0x67, 0x10, 0xe2, 0xcb, 0xdc, 0x73, 0xf8, 0xf2, 0x7b, 0x8c, 0x2f, 0x93, 0x68, 0xb8,
	0xe9, 0x41, 0xbf, 0x7d, 0x4b, 0x47, 0x66, 0xe2, 0x90, 0xd6, 0x87, 0xd4, 0x93, 0xa3, 0xb5, 0x3e,
	0x67, 0x74, 0xd9, 0x2d, 0x98, 0x63, 0x74, 0xa6, 0x3e, 0x75, 0x1b, 0x90, 0x7c, 0x2c, 0x2b, 0x6d,
	0xd9, 0xd2, 0xcb, 0xe9, 0x2c, 0x69, 0xa7, 0x79, 0xde, 0x1d, 0x71, 0xa6, 0x09, 0x82, 0xb7, 0x60,
	0xa1, 0xf2, 0xfc, 0x68, 0x7c, 0xdb, 0x7b, 0xd1, 0x0f, 0xf0, 0xd0, 0x75, 0xb7, 0x03, 0x11, 0xf9,
	0xab, 0x83, 0x45, 0x0a, 0x85, 0xa7, 0x43, 0xc1, 0xf9, 0x5f, 0x25, 0x60, 0x29, 0x82, 0x1b, 0xdd,
	0x87, 0x84, 0xde, 0x6d, 0x50, 0x77, 0x7c, 0x75, 0x04, 0xf9, 0x79, 0x71, 0xaf, 0xb8, 0x13, 0x13,
	0xad, 0x59, 0xfc, 0x1f, 0xe2, 0x90, 0x10, 0xf7, 0x8a, 0xe8, 0x5d, 0x06, 0xa9, 0xbe, 0x35, 0xa2,
	0x14, 0x2f, 0x50, 0xfd, 0x1f, 0x2e, 0x08, 0xa9, 0xce, 0xc1, 0x7c, 0x51, 0x2c, 0x15, 0xea, 0x25,
	0x69, 0xab, 0x54, 0x29, 0xd5, 0x4b, 0x12, 0x41, 0xd2, 0xb3, 0x1c, 0x5a, 0x86, 0xdc, 0xde, 0xfe,
	0x66, 0xa5, 0x5c, 0xdb, 0x91, 0xf6, 0xab, 0xce, 0x7f, 0x74, 0x34, 0x8e, 0xb2, 0x30, 0x5d, 0x29,
	0xd7, 0xea, 0x94, 0x50, 0xcb, 0x26, 0x2c, 0xca, 0x76, 0xa9, 0x2e, 0x15, 0x0b, 0x7b, 0x85, 0x62,
	0xb9, 0xfe, 0x24, 0x9b, 0x44, 0x3c, 0x2c, 0xb2, 0xb2, 0x6b, 0xd5, 0xc2, 0x5e, 0x6d, 0x67, 0xb7,
	0x9e, 0x4d, 0x21, 0x04, 0xb3, 0xf6, 0x7c, 0x87, 0x54, 0xcb, 0xa6, 0x2d, 0x09, 0xc5, 0xca, 0x6e,
	0xd5, 0xd5, 0x61, 0x02, 0xcd, 0x43, 0xd6, 0x59, 0x59, 0x2c, 0x15, 0xb6, 0x6c, 0x14, 0x25, 0x83,
	0xce, 0xc3, 0x4c, 0xe9, 0x83, 0xbd, 0x42, 0x75, 0xcb, 0x61, 0x9c, 0x44, 0xab, 0xb0, 0xec, 0x55,
	0x47, 0xa2, 0xb3, 0x4a, 0x5b, 0x36, 0x96, 0x52, 0xcb, 0x82, 0x8b, 0xd2, 0x7d, 0x19, 0x87, 0x05,
	0x02, 0xd3, 0x39, 0xa0, 0xa0, 0x13, 0xb8, 0x6b, 0x90, 0x25, 0xc0, 0x82, 0xe4, 0x2f, 0xed, 0x66,
	0x09, 0xfd, 0xc0, 0x29, 0xf0, 0x1c, 0x48, 0x3d, 0xee, 0x81, 0xd4, 0xcb, 0xfe, 0x72, 0xf7, 0x26,
	0x0b, 0x3e, 0xfb, 0x56, 0x8b, 0xea, 0xa0, 0x1e, 0x05, 0xd4, 0x63, 0xb7, 0xa3, 0xa5, 0x45, 0xdd,
	0x55, 0x67, 0x69, 0x97, 0xce, 0x18, 0xf2, 0x0f, 0x60, 0xd1, 0xaf, 0x2f, 0x8d, 0xbe, 0x5b, 0x03,
	0x10, 0xb1, 0x9b, 0x83, 0x5c, 0x5e, 0x97, 0x43, 0xf8, 0x0b, 0x07, 0x19, 0x87, 0x6c, 0xdd, 0x23,
	0x86, 0xf2, 0x5d, 0xcc, 0x40, 0x52, 0x93, 0x16, 0xc5, 0x45, 0xb8, 0xbc, 0xe0, 0x6e, 0xdc, 0x0f,
	0xee, 0x06, 0x9e, 0x73, 0x22, 0xf0, 0x9c, 0xbf, 0x09, 0x33, 0x0d, 0x4b, 0x7d, 0x45, 0x53, 0x25,
	0x53, 0xe9, 0x38, 0x88, 0xd3, 0xe0, 0x63, 0x4c, 0xdd, 0x79, 0x41, 0x15, 0xa7, 0x9d, 0x09, 0x16,
	0x09, 0xad, 0xc2, 0xb4, 0xfd, 0x38, 0x23, 0x99, 0x9a, 0xd4, 0x33, 0x70, 0x2e, 0x65, 0xf7, 0xdf,
	0x60, 0xd3, 0xea, 0xda, 0xbe, 0x81, 0x85, 0xdf, 0x71, 0xb0, 0x40, 0x60, 0x05, 0xbf, 0x3b, 0x0e,
	0x03, 0xa9, 0xbd, 0x1e, 0xe7, 0xbb, 0x1a, 0x02, 0x05, 0xbe, 0xac, 0xae, 0x2a, 0x07, 0x8b, 0xfe,
	0xf5, 0x68, 0x2b, 0xf5, 0x79, 0x1c, 0xe6, 0xad, 0xdb, 0xd4, 0x19, 0x78, 0xd1, 0x65, 0xca, 0x18,
	0x27, 0xe9, 0x33, 0x66, 0x72, 0xc0, 0x98, 0x3b, 0xfe, 0x46, 0xe5, 0x86, 0xb7, 0x1e, 0xf0, 0xef,
	0xe0, 0x65, 0xd9, 0xf2, 0xd7, 0x1c, 0x2c, 0xf8, 0xd6, 0xa3, 0xf1, 0xf2, 0x8e, 0xbf, 0xf2, 0xba,
	0x1a, 0xa2, 0xdf, 0x73, 0xd5, 0x5e, 0x77, 0x9d, 0xea, 0x69, 0xbc, 0xb0, 0xfc, 0x73, 0x1c, 0x56,
	0xfa, 0x37, 0x90, 0xfd, 0x3c, 0xda, 0x1c, 0x03, 0x3a, 0x38, 0xdb, 0x2b, 0xe4, 0xfb, 0xfe, 0x84,
	0xbb, 0x3e, 0x78, 0x29, 0x06, 0xa8, 0x14, 0x95, 0x78, 0x03, 0x11, 0xb7, 0xe4, 0xb8, 0x88, 0xdb,
	0x99, 0x3c, 0xe0, 0x7b, 0x5e, 0x30, 0x91, 0x55, 0x9f, 0x7a, 0xc2, 0x88, 0xa8, 0xfc, 0x5b, 0x70,
	0xc1, 0x2e, 0x9a, 0xdd, 0xd7, 0x7d, 0xe7, 0xcd, 0x91, 0xa4, 0xc4, 0x8c, 0xb8, 0x60, 0x0d, 0xbb,
	0x4f, 0xda, 0x14, 0x89, 0x6e, 0x0a, 0x5f, 0x25, 0x61, 0xd1, 0x2a, 0xaa, 0x6b, 0xa6, 0xdc, 0x1a,
	0x07, 0xa3, 0xfd, 0xd6, 0x20, 0xe4, 0x15, 0x67, 0x8f, 0x25, 0x58, 0xea, 0x28, 0x48, 0x17, 0xca,
	0xc3, 0x9c, 0x61, 0xca, 0x2d, 0x3b, 0x1d, 0xc8, 0x7a, 0x0b, 0x9b, 0x52, 0x57, 0x36, 0x9f, 0xd1,
	0x58, 0x3f, 0x4f, 0x87, 0xea, 0xf6, 0xc8, 0x9e, 0x6c, 0x3e, 0x7b, 0x41, 0x07, 0x89, 0xde, 0xf3,
	0x27, 0x85, 0xd7, 0x86, 0xec, 0x25, 0xc2, 0xb7, 0x3e, 0x08, 0x81, 0x45, 0x5f, 0x1f, 0x22, 0x72,
	0x38, 0x1c, 0x7a, 0x76, 0x18, 0xf0, 0x6b, 0x46, 0x54, 0x2f, 0xc2, 0x85, 0x81, 0xcd, 0xd3, 0x2b,
	0xa4, 0x05, 0x39, 0x6b, 0x68, 0x5f, 0x35, 0xc6, 0x74, 0xc7, 0x10, 0x8f, 0x89, 0x87, 0x78, 0x8c,
	0xb0, 0x04, 0x17, 0x03, 0x16, 0xa2, 0x5a, 0xfc, 0x26, 0x45, 0xd4, 0x18, 0x1f, 0xdc, 0xff, 0x30,
	0x2c, 0x2a, 0xde, 0xf4, 0x1e, 0x7b, 0x20, 0x0e, 0xfe, 0x32, 0xe2, 0xe2, 0x32, 0x4c, 0x79, 0xf9,
	0xe8, 0x35, 0x68, 0x0e, 0x09, 0x9c, 0xd4, 0x99, 0xde, 0x1c, 0xd2, 0xbe, 0x37, 0x87, 0x4a, 0x3f,
	0xa8, 0x26, 0xd8, 0xd2, 0x36, 0xd4, 0x14, 0x11, 0x61, 0xf5, 0x74, 0x20, 0xac, 0x32, 0xec, 0x43,
	0x46, 0xa8, 0xd0, 0xff, 0x81, 0xc0, 0xa2, 0x4e, 0x1d, 0xf8, 0xc2, 0x20, 0x3c, 0x05, 0x9e, 0x78,
	0xfc, 0xf8, 0x98, 0xbf, 0xcf, 0x8d, 0xe2, 0x7e, 0x37, 0x12, 0x56, 0x60, 0x29, 0x50, 0x36, 0x5d,
	0xfa, 0x87, 0x1c, 0x51, 0x6c, 0x1b, 0x9b, 0x7d, 0x64, 0xc5, 0x18, 0x75, 0x69, 0x3a, 0xe8, 0x5d,
	0x9a, 0x90, 0x6c, 0x0f, 0x1e, 0x33, 0x24, 0x84, 0x6d, 0x62, 0x06, 0xbf, 0x2a, 0xf4, 0xb2, 0xbd,
	0x01, 0xa9, 0x9e, 0x0d, 0x97, 0x92, 0xa2, 0x6b, 0x8e, 0x8d, 0x81, 0x7d, 0x6b, 0x48, 0x24, 0x1c,
	0xc2, 0xe7, 0x1c, 0x4c, 0x79, 0xc8, 0x68, 0x19, 0x26, 0x5d, 0xf4, 0xc2, 0xe9, 0x52, 0x5c, 0x82,
	0x75, 0x68, 0xa6, 0x66, 0xca, 0x6d, 0xfa, 0x02, 0x4f, 0x7e, 0x58, 0x8d, 0x65, 0xcf, 0xc0, 0xa4,
	0x88, 0x4d, 0x88, 0xf6, 0xff, 0xe8, 0x16, 0x24, 0x7b, 0xaa, 0x62, 0xda, 0xc1, 0x3a, 0xeb, 0x8f,
	0x42, 0x7b, 0xa9, 0xfc, 0xbe, 0xaa, 0x98, 0xa2, 0xcd, 0x25, 0xdc, 0x84, 0xa4, 0xf5, 0x8b, 0x6d,
	0xf2, 0x27, 0x21, 0xb5, 0xf9, 0xa4, 0x5e, 0xaa, 0x65, 0x39, 0x04, 0x90, 0x2e, 0x93, 0x96, 0x38,
	0x2e, 0x2c, 0xbb, 0x5b, 0x0f, 0x02, 0x51, 0x3e, 0x22, 0x67, 0x18, 0x06, 0x9f, 0x14, 0x02, 0xe1,
	0x93, 0x15, 0xe6, 0x36, 0x1b, 0x02, 0x9c, 0xfc, 0x8b, 0x83, 0x85, 0x40, 0x3e, 0x74, 0xd7, 0x0b,
	0x99, 0x5c, 0x89, 0x94, 0xe9, 0x05, 0x4b, 0x7e, 0xc6, 0x11, 0xb0, 0xe4, 0x1e, 0x03, 0x96, 0x5c,
	0x1f, 0x3a, 0xdf, 0x0b, 0x93, 0x1c, 0x84, 0xa0, 0x24, 0xb5, 0x7a, 0x61, 0xbb, 0x24, 0xed, 0x57,
	0xc9, 0x5f, 0x17, 0x25, 0x99, 0x87, 0xec, 0x76, 0xc9, 0xc1, 0x1d, 0xa4, 0x5a, 0xbd, 0x50, 0xaf,
	0x65, 0xe3, 0x83, 0x08, 0x45, 0xc2, 0xc5, 0x1f, 0xe6, 0x01, 0x51, 0xb3, 0x7a, 0x3f, 0x9d, 0xfd,
	0x94, 0x83, 0x39, 0x86, 0x4c, 0xad, 0xec, 0x79, 0x5d, 0xe3, 0x98, 0xd7, 0xb5, 0x3b, 0x30, 0x6f,
	0xb5, 0x50, 0xc4, 0xf1, 0x0d, 0xa9, 0x8b, 0x75, 0x1b, 0x23, 0xa5, 0xee, 0x74, 0xbe, 0x23, 0x9f,
	0x50, 0x0c, 0x73, 0x0f, 0xeb, 0x96, 0xe0, 0x17, 0x80, 0xff, 0x09, 0x3f, 0x8e, 0x93, 0x8b, 0x7a,
	0xec, 0x42, 0x7f, 0x68, 0xd0, 0x0e, 0x76, 0x02, 0x89, 0x31, 0x3a, 0x81, 0x90, 0x90, 0x4f, 0x8e,
	0x55, 0x1d, 0x8e, 0x7d, 0xc9, 0x09, 0x05, 0x52, 0x14, 0x9c, 0xa1, 0x48, 0x5f, 0xff, 0x37, 0x07,
	0x99, 0x72, 0x13, 0xab, 0xa6, 0xe5, 0xf4, 0x55, 0x98, 0x61, 0xbe, 0x68, 0x46, 0xcb, 0x21, 0x1f,
	0x3a, 0xdb, 0x16, 0xe7, 0x57, 0x22, 0x3f, 0x83, 0x16, 0x62, 0xe8, 0xc8, 0xf3, 0x35, 0x36, 0x03,
	0x2b, 0xbf, 0x32, 0x30, 0x33, 0x20, 0xfe, 0xf9, 0x6b, 0x43, 0xb8, 0xdc, 0x75, 0xde, 0x82, 0x94,
	0xfd, 0xed, 0x2a, 0x9a, 0x77, 0xbf, 0x9f, 0xf5, 0x7c, 0xda, 0xca, 0x2f, 0xf8, 0xa8, 0xce, 0xbc,
	0xf5, 0xbf, 0x67, 0x00, 0xfa, 0xbd, 0x0e, 0x7a, 0x08, 0xd3, 0xde, 0xcf, 0xe7, 0xd0, 0x52, 0xc4,
	0xc7, 0x9b, 0xfc, 0x72, 0xf0, 0xa0, 0xab, 0xd3, 0x43, 0x98, 0xf6, 0x7e, 0xac, 0xd1, 0x17, 0x16,
	0xf0, 0xc1, 0x48, 0x5f, 0x58, 0xe0, 0xf7, 0x1d, 0x31, 0xd4, 0x86, 0x0b, 0x21, 0xcf, 0xf5, 0xe8,
	0xfa, 0x68, 0x1f, 0x35, 0xf0, 0xaf, 0x8e, 0xf8, 0xee, 0x2f, 0xc4, 0x90, 0x0e, 0x17, 0x43, 0x5f,
	0xa9, 0xd1, 0xda, 0xa8, 0x6f, 0xe8, 0xfc, 0x8d, 0x11, 0x38, 0xdd, 0x35, 0x7b, 0xc0, 0x87, 0x3f,
	0x8d, 0xa1, 0x1b, 0x23, 0xbf, 0xd9, 0xf2, 0x37, 0x47, 0x7f, 0x69, 0x13, 0x62, 0x68, 0x07, 0xa6,
	0x3c, 0xaf, 0x2d, 0x88, 0x0f, 0x7c, 0x82, 0x21, 0x82, 0x97, 0x22, 0x9e, 0x67, 0x88, 0x24, 0xcf,
	0xdb, 0x42, 0x5f, 0xd2, 0xe0, 0x23, 0x49, 0x5f, 0x52, 0xc0, 0x63, 0x84, 0xdf, 0xfc, 0xbe, 0xcb,
	0x2f, 0xc8, 0xfc, 0xc1, 0xb7, 0x67, 0x90, 0xf9, 0x43, 0x6e, 0x52, 0x21, 0x86, 0xde, 0x87, 0x59,
	0x16, 0x26, 0x45, 0x2b, 0x91, 0x70, 0x2f, 0x7f, 0x29, 0x6c, 0xd8, 0x2b, 0x92, 0x45, 0xe5, 0xfa,
	0x22, 0x03, 0xd1, 0xc1, 0xbe, 0xc8, 0x10, 0x30, 0x2f, 0x66, 0xe5, 0x27, 0x06, 0x6b, 0xea, 0xe7,
	0xa7, 0x20, 0x88, 0xac, 0x9f, 0x9f, 0x02, 0x01, 0x2a, 0x21, 0x86, 0x14, 0x58, 0x0c, 0x86, 0x3a,
	0xd0, 0xb5, 0x91, 0x90, 0x1c, 0xfe, 0xfa, 0x30, 0x36, 0x37, 0xd5, 0xfc, 0x2d, 0x05, 0x49, 0xfb,
	0x16, 0xac, 0xc3, 0x39, 0x5f, 0xab, 0x89, 0x2e, 0x45, 0x37, 0xe0, 0xfc, 0xe5, 0xd0, 0x71, 0x77,
	0x27, 0x4f, 0xe1, 0xfc, 0x40, 0xf3, 0x88, 0x56, 0xbd, 0xf3, 0x82, 0x1a, 0x58, 0xfe, 0x4a, 0x04,
	0x87, 0x5f, 0x36, 0x9b, 0x76, 0x56, 0x87, 0x75, 0x37, 0xac, 0xec, 0xb0, 0x54, 0xf3, 0x11, 0x29,
	0x3a, 0xfc, 0x49, 0x46, 0x60, 0xf5, 0x0a, 0x4c, 0x2f, 0x57, 0x23, 0x79, 0xdc, 0x15, 0x3e, 0x74,
	0xab, 0x1d, 0x4f, 0x75, 0x8d, 0x18, 0xe5, 0x02, 0x9b, 0x00, 0x5e, 0x88, 0x62, 0x71, 0xc5, 0x3f,
	0x86, 0xac, 0xff, 0x0a, 0x46, 0xcc, 0x79, 0x05, 0xb9, 0xcd, 0x6a, 0x38, 0x83, 0xdf, 0x32, 0xfe,
	0xf8, 0xf7, 0x6b, 0x15, 0x14, 0xf9, 0x57, 0x23, 0x79, 0xbc, 0x19, 0xcb, 0x53, 0xf0, 0xf5, 0x33,
	0xd6, 0x60, 0x71, 0xd8, 0xcf, 0x58, 0x01, 0x15, 0xa2, 0x10, 0xbb, 0xf7, 0x0e, 0x40, 0xc3, 0x50,
	0x24, 0xd2, 0x11, 0xa3, 0x95, 0x81, 0xc7, 0x89, 0x07, 0x0a, 0x6e, 0x37, 0x77, 0xbb, 0xa6, 0xa2,
	0xa9, 0x46, 0xee, 0x17, 0x19, 0xbb, 0x1d, 0x9f, 0x6c, 0x18, 0x0a, 0x69, 0x4c, 0x37, 0x53, 0x4f,
	0x13, 0x0d, 0x43, 0x39, 0x4c, 0xdb, 0xfc, 0x6f, 0xfc, 0x37, 0x00, 0x00, 0xff, 0xff, 0x16, 0x7c,
	0xfe, 0x46, 0x7f, 0x36, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// IdentityClient is the client API for Identity service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type IdentityClient interface {
	GetPluginInfo(ctx context.Context, in *GetPluginInfoRequest, opts ...grpc.CallOption) (*GetPluginInfoResponse, error)
	GetPluginCapabilities(ctx context.Context, in *GetPluginCapabilitiesRequest, opts ...grpc.CallOption) (*GetPluginCapabilitiesResponse, error)
	Probe(ctx context.Context, in *ProbeRequest, opts ...grpc.CallOption) (*ProbeResponse, error)
}

type identityClient struct {
	cc *grpc.ClientConn
}

func NewIdentityClient(cc *grpc.ClientConn) IdentityClient {
	return &identityClient{cc}
}

func (c *identityClient) GetPluginInfo(ctx context.Context, in *GetPluginInfoRequest, opts ...grpc.CallOption) (*GetPluginInfoResponse, error) {
	out := new(GetPluginInfoResponse)
	err := c.cc.Invoke(ctx, "/csi.v1.Identity/GetPluginInfo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *identityClient) GetPluginCapabilities(ctx context.Context, in *GetPluginCapabilitiesRequest, opts ...grpc.CallOption) (*GetPluginCapabilitiesResponse, error) {
	out := new(GetPluginCapabilitiesResponse)
	err := c.cc.Invoke(ctx, "/csi.v1.Identity/GetPluginCapabilities", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *identityClient) Probe(ctx context.Context, in *ProbeRequest, opts ...grpc.CallOption) (*ProbeResponse, error) {
	out := new(ProbeResponse)
	err := c.cc.Invoke(ctx, "/csi.v1.Identity/Probe", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// IdentityServer is the server API for Identity service.
type IdentityServer interface {
	GetPluginInfo(context.Context, *GetPluginInfoRequest) (*GetPluginInfoResponse, error)
	GetPluginCapabilities(context.Context, *GetPluginCapabilitiesRequest) (*GetPluginCapabilitiesResponse, error)
	Probe(context.Context, *ProbeRequest) (*ProbeResponse, error)
}

// UnimplementedIdentityServer can be embedded to have forward compatible implementations.
type UnimplementedIdentityServer struct {
}

func (*UnimplementedIdentityServer) GetPluginInfo(ctx context.Context, req *GetPluginInfoRequest) (*GetPluginInfoResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPluginInfo not implemented")
}
func (*UnimplementedIdentityServer) GetPluginCapabilities(ctx context.Context, req *GetPluginCapabilitiesRequest) (*GetPluginCapabilitiesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPluginCapabilities not implemented")
}
func (*UnimplementedIdentityServer) Probe(ctx context.Context, req *ProbeRequest) (*ProbeResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Probe not implemented")
}

func RegisterIdentityServer(s *grpc.Server, srv IdentityServer) {
	s.RegisterService(&_Identity_serviceDesc, srv)
}

func _Identity_GetPluginInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPluginInfoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IdentityServer).GetPluginInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.v1.Identity/GetPluginInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IdentityServer).GetPluginInfo(ctx, req.(*GetPluginInfoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Identity_GetPluginCapabilities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPluginCapabilitiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IdentityServer).GetPluginCapabilities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.v1.Identity/GetPluginCapabilities",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IdentityServer).GetPluginCapabilities(ctx, req.(*GetPluginCapabilitiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Identity_Probe_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ProbeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IdentityServer).Probe(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.v1.Identity/Probe",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IdentityServer).Probe(ctx, req.(*ProbeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Identity_serviceDesc = grpc.ServiceDesc{
	ServiceName: "csi.v1.Identity",
	HandlerType: (*IdentityServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetPluginInfo",
			Handler:    _Identity_GetPluginInfo_Handler,
		},
		{
			MethodName: "GetPluginCapabilities",
			Handler:    _Identity_GetPluginCapabilities_Handler,
		},
		{
			MethodName: "Probe",
			Handler:    _Identity_Probe_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "github.com/container-storage-interface/spec/csi.proto",
}

// ControllerClient is the client API for Controller service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ControllerClient interface {
	CreateVolume(ctx context.Context, in *CreateVolumeRequest, opts ...grpc.CallOption) (*CreateVolumeResponse, error)
	DeleteVolume(ctx context.Context, in *DeleteVolumeRequest, opts ...grpc.CallOption) (*DeleteVolumeResponse, error)
	ControllerPublishVolume(ctx context.Context, in *ControllerPublishVolumeRequest, opts ...grpc.CallOption) (*ControllerPublishVolumeResponse, error)
	ControllerUnpublishVolume(ctx context.Context, in *ControllerUnpublishVolumeRequest, opts ...grpc.CallOption) (*ControllerUnpublishVolumeResponse, error)
	ValidateVolumeCapabilities(ctx context.Context, in *ValidateVolumeCapabilitiesRequest, opts ...grpc.CallOption) (*ValidateVolumeCapabilitiesResponse, error)
	ListVolumes(ctx context.Context, in *ListVolumesRequest, opts ...grpc.CallOption) (*ListVolumesResponse, error)
	GetCapacity(ctx context.Context, in *GetCapacityRequest, opts ...grpc.CallOption) (*GetCapacityResponse, error)
	ControllerGetCapabilities(ctx context.Context, in *ControllerGetCapabilitiesRequest, opts ...grpc.CallOption) (*ControllerGetCapabilitiesResponse, error)
	CreateSnapshot(ctx context.Context, in *CreateSnapshotRequest, opts ...grpc.CallOption) (*CreateSnapshotResponse, error)
	DeleteSnapshot(ctx context.Context, in *DeleteSnapshotRequest, opts ...grpc.CallOption) (*DeleteSnapshotResponse, error)
	ListSnapshots(ctx context.Context, in *ListSnapshotsRequest, opts ...grpc.CallOption) (*ListSnapshotsResponse, error)
	ControllerExpandVolume(ctx context.Context, in *ControllerExpandVolumeRequest, opts ...grpc.CallOption) (*ControllerExpandVolumeResponse, error)
}

type controllerClient struct {
	cc *grpc.ClientConn
}

func NewControllerClient(cc *grpc.ClientConn) ControllerClient {
	return &controllerClient{cc}
}

func (c *controllerClient) CreateVolume(ctx context.Context, in *CreateVolumeRequest, opts ...grpc.CallOption) (*CreateVolumeResponse, error) {
	out := new(CreateVolumeResponse)
	err := c.cc.Invoke(ctx, "/csi.v1.Controller/CreateVolume", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *controllerClient) DeleteVolume(ctx context.Context, in *DeleteVolumeRequest, opts ...grpc.CallOption) (*DeleteVolumeResponse, error) {
	out := new(DeleteVolumeResponse)
	err := c.cc.Invoke(ctx, "/csi.v1.Controller/DeleteVolume", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *controllerClient) ControllerPublishVolume(ctx context.Context, in *ControllerPublishVolumeRequest, opts ...grpc.CallOption) (*ControllerPublishVolumeResponse, error) {
	out := new(ControllerPublishVolumeResponse)
	err := c.cc.Invoke(ctx, "/csi.v1.Controller/ControllerPublishVolume", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *controllerClient) ControllerUnpublishVolume(ctx context.Context, in *ControllerUnpublishVolumeRequest, opts ...grpc.CallOption) (*ControllerUnpublishVolumeResponse, error) {
	out := new(ControllerUnpublishVolumeResponse)
	err := c.cc.Invoke(ctx, "/csi.v1.Controller/ControllerUnpublishVolume", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *controllerClient) ValidateVolumeCapabilities(ctx context.Context, in *ValidateVolumeCapabilitiesRequest, opts ...grpc.CallOption) (*ValidateVolumeCapabilitiesResponse, error) {
	out := new(ValidateVolumeCapabilitiesResponse)
	err := c.cc.Invoke(ctx, "/csi.v1.Controller/ValidateVolumeCapabilities", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *controllerClient) ListVolumes(ctx context.Context, in *ListVolumesRequest, opts ...grpc.CallOption) (*ListVolumesResponse, error) {
	out := new(ListVolumesResponse)
	err := c.cc.Invoke(ctx, "/csi.v1.Controller/ListVolumes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *controllerClient) GetCapacity(ctx context.Context, in *GetCapacityRequest, opts ...grpc.CallOption) (*GetCapacityResponse, error) {
	out := new(GetCapacityResponse)
	err := c.cc.Invoke(ctx, "/csi.v1.Controller/GetCapacity", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *controllerClient) ControllerGetCapabilities(ctx context.Context, in *ControllerGetCapabilitiesRequest, opts ...grpc.CallOption) (*ControllerGetCapabilitiesResponse, error) {
	out := new(ControllerGetCapabilitiesResponse)
	err := c.cc.Invoke(ctx, "/csi.v1.Controller/ControllerGetCapabilities", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *controllerClient) CreateSnapshot(ctx context.Context, in *CreateSnapshotRequest, opts ...grpc.CallOption) (*CreateSnapshotResponse, error) {
	out := new(CreateSnapshotResponse)
	err := c.cc.Invoke(ctx, "/csi.v1.Controller/CreateSnapshot", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *controllerClient) DeleteSnapshot(ctx context.Context, in *DeleteSnapshotRequest, opts ...grpc.CallOption) (*DeleteSnapshotResponse, error) {
	out := new(DeleteSnapshotResponse)
	err := c.cc.Invoke(ctx, "/csi.v1.Controller/DeleteSnapshot", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *controllerClient) ListSnapshots(ctx context.Context, in *ListSnapshotsRequest, opts ...grpc.CallOption) (*ListSnapshotsResponse, error) {
	out := new(ListSnapshotsResponse)
	err := c.cc.Invoke(ctx, "/csi.v1.Controller/ListSnapshots", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *controllerClient) ControllerExpandVolume(ctx context.Context, in *ControllerExpandVolumeRequest, opts ...grpc.CallOption) (*ControllerExpandVolumeResponse, error) {
	out := new(ControllerExpandVolumeResponse)
	err := c.cc.Invoke(ctx, "/csi.v1.Controller/ControllerExpandVolume", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ControllerServer is the server API for Controller service.
type ControllerServer interface {
	CreateVolume(context.Context, *CreateVolumeRequest) (*CreateVolumeResponse, error)
	DeleteVolume(context.Context, *DeleteVolumeRequest) (*DeleteVolumeResponse, error)
	ControllerPublishVolume(context.Context, *ControllerPublishVolumeRequest) (*ControllerPublishVolumeResponse, error)
	ControllerUnpublishVolume(context.Context, *ControllerUnpublishVolumeRequest) (*ControllerUnpublishVolumeResponse, error)
	ValidateVolumeCapabilities(context.Context, *ValidateVolumeCapabilitiesRequest) (*ValidateVolumeCapabilitiesResponse, error)
	ListVolumes(context.Context, *ListVolumesRequest) (*ListVolumesResponse, error)
	GetCapacity(context.Context, *GetCapacityRequest) (*GetCapacityResponse, error)
	ControllerGetCapabilities(context.Context, *ControllerGetCapabilitiesRequest) (*ControllerGetCapabilitiesResponse, error)
	CreateSnapshot(context.Context, *CreateSnapshotRequest) (*CreateSnapshotResponse, error)
	DeleteSnapshot(context.Context, *DeleteSnapshotRequest) (*DeleteSnapshotResponse, error)
	ListSnapshots(context.Context, *ListSnapshotsRequest) (*ListSnapshotsResponse, error)
	ControllerExpandVolume(context.Context, *ControllerExpandVolumeRequest) (*ControllerExpandVolumeResponse, error)
}

// UnimplementedControllerServer can be embedded to have forward compatible implementations.
type UnimplementedControllerServer struct {
}

func (*UnimplementedControllerServer) CreateVolume(ctx context.Context, req *CreateVolumeRequest) (*CreateVolumeResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateVolume not implemented")
}
func (*UnimplementedControllerServer) DeleteVolume(ctx context.Context, req *DeleteVolumeRequest) (*DeleteVolumeResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteVolume not implemented")
}
func (*UnimplementedControllerServer) ControllerPublishVolume(ctx context.Context, req *ControllerPublishVolumeRequest) (*ControllerPublishVolumeResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ControllerPublishVolume not implemented")
}
func (*UnimplementedControllerServer) ControllerUnpublishVolume(ctx context.Context, req *ControllerUnpublishVolumeRequest) (*ControllerUnpublishVolumeResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ControllerUnpublishVolume not implemented")
}
func (*UnimplementedControllerServer) ValidateVolumeCapabilities(ctx context.Context, req *ValidateVolumeCapabilitiesRequest) (*ValidateVolumeCapabilitiesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ValidateVolumeCapabilities not implemented")
}
func (*UnimplementedControllerServer) ListVolumes(ctx context.Context, req *ListVolumesRequest) (*ListVolumesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListVolumes not implemented")
}
func (*UnimplementedControllerServer) GetCapacity(ctx context.Context, req *GetCapacityRequest) (*GetCapacityResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCapacity not implemented")
}
func (*UnimplementedControllerServer) ControllerGetCapabilities(ctx context.Context, req *ControllerGetCapabilitiesRequest) (*ControllerGetCapabilitiesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ControllerGetCapabilities not implemented")
}
func (*UnimplementedControllerServer) CreateSnapshot(ctx context.Context, req *CreateSnapshotRequest) (*CreateSnapshotResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSnapshot not implemented")
}
func (*UnimplementedControllerServer) DeleteSnapshot(ctx context.Context, req *DeleteSnapshotRequest) (*DeleteSnapshotResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSnapshot not implemented")
}
func (*UnimplementedControllerServer) ListSnapshots(ctx context.Context, req *ListSnapshotsRequest) (*ListSnapshotsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSnapshots not implemented")
}
func (*UnimplementedControllerServer) ControllerExpandVolume(ctx context.Context, req *ControllerExpandVolumeRequest) (*ControllerExpandVolumeResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ControllerExpandVolume not implemented")
}

func RegisterControllerServer(s *grpc.Server, srv ControllerServer) {
	s.RegisterService(&_Controller_serviceDesc, srv)
}

func _Controller_CreateVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ControllerServer).CreateVolume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.v1.Controller/CreateVolume",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ControllerServer).CreateVolume(ctx, req.(*CreateVolumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Controller_DeleteVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ControllerServer).DeleteVolume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.v1.Controller/DeleteVolume",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ControllerServer).DeleteVolume(ctx, req.(*DeleteVolumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Controller_ControllerPublishVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ControllerPublishVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ControllerServer).ControllerPublishVolume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.v1.Controller/ControllerPublishVolume",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ControllerServer).ControllerPublishVolume(ctx, req.(*ControllerPublishVolumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Controller_ControllerUnpublishVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ControllerUnpublishVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ControllerServer).ControllerUnpublishVolume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.v1.Controller/ControllerUnpublishVolume",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ControllerServer).ControllerUnpublishVolume(ctx, req.(*ControllerUnpublishVolumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Controller_ValidateVolumeCapabilities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValidateVolumeCapabilitiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ControllerServer).ValidateVolumeCapabilities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.v1.Controller/ValidateVolumeCapabilities",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ControllerServer).ValidateVolumeCapabilities(ctx, req.(*ValidateVolumeCapabilitiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Controller_ListVolumes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVolumesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ControllerServer).ListVolumes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.v1.Controller/ListVolumes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ControllerServer).ListVolumes(ctx, req.(*ListVolumesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Controller_GetCapacity_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCapacityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ControllerServer).GetCapacity(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.v1.Controller/GetCapacity",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ControllerServer).GetCapacity(ctx, req.(*GetCapacityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Controller_ControllerGetCapabilities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ControllerGetCapabilitiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ControllerServer).ControllerGetCapabilities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.v1.Controller/ControllerGetCapabilities",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ControllerServer).ControllerGetCapabilities(ctx, req.(*ControllerGetCapabilitiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Controller_CreateSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ControllerServer).CreateSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.v1.Controller/CreateSnapshot",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ControllerServer).CreateSnapshot(ctx, req.(*CreateSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Controller_DeleteSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ControllerServer).DeleteSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.v1.Controller/DeleteSnapshot",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ControllerServer).DeleteSnapshot(ctx, req.(*DeleteSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Controller_ListSnapshots_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSnapshotsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ControllerServer).ListSnapshots(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.v1.Controller/ListSnapshots",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ControllerServer).ListSnapshots(ctx, req.(*ListSnapshotsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Controller_ControllerExpandVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ControllerExpandVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ControllerServer).ControllerExpandVolume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.v1.Controller/ControllerExpandVolume",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ControllerServer).ControllerExpandVolume(ctx, req.(*ControllerExpandVolumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Controller_serviceDesc = grpc.ServiceDesc{
	ServiceName: "csi.v1.Controller",
	HandlerType: (*ControllerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateVolume",
			Handler:    _Controller_CreateVolume_Handler,
		},
		{
			MethodName: "DeleteVolume",
			Handler:    _Controller_DeleteVolume_Handler,
		},
		{
			MethodName: "ControllerPublishVolume",
			Handler:    _Controller_ControllerPublishVolume_Handler,
		},
		{
			MethodName: "ControllerUnpublishVolume",
			Handler:    _Controller_ControllerUnpublishVolume_Handler,
		},
		{
			MethodName: "ValidateVolumeCapabilities",
			Handler:    _Controller_ValidateVolumeCapabilities_Handler,
		},
		{
			MethodName: "ListVolumes",
			Handler:    _Controller_ListVolumes_Handler,
		},
		{
			MethodName: "GetCapacity",
			Handler:    _Controller_GetCapacity_Handler,
		},
		{
			MethodName: "ControllerGetCapabilities",
			Handler:    _Controller_ControllerGetCapabilities_Handler,
		},
		{
			MethodName: "CreateSnapshot",
			Handler:    _Controller_CreateSnapshot_Handler,
		},
		{
			MethodName: "DeleteSnapshot",
			Handler:    _Controller_DeleteSnapshot_Handler,
		},
		{
			MethodName: "ListSnapshots",
			Handler:    _Controller_ListSnapshots_Handler,
		},
		{
			MethodName: "ControllerExpandVolume",
			Handler:    _Controller_ControllerExpandVolume_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "github.com/container-storage-interface/spec/csi.proto",
}

// NodeClient is the client API for Node service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type NodeClient interface {
	NodeStageVolume(ctx context.Context, in *NodeStageVolumeRequest, opts ...grpc.CallOption) (*NodeStageVolumeResponse, error)
	NodeUnstageVolume(ctx context.Context, in *NodeUnstageVolumeRequest, opts ...grpc.CallOption) (*NodeUnstageVolumeResponse, error)
	NodePublishVolume(ctx context.Context, in *NodePublishVolumeRequest, opts ...grpc.CallOption) (*NodePublishVolumeResponse, error)
	NodeUnpublishVolume(ctx context.Context, in *NodeUnpublishVolumeRequest, opts ...grpc.CallOption) (*NodeUnpublishVolumeResponse, error)
	NodeGetVolumeStats(ctx context.Context, in *NodeGetVolumeStatsRequest, opts ...grpc.CallOption) (*NodeGetVolumeStatsResponse, error)
	NodeExpandVolume(ctx context.Context, in *NodeExpandVolumeRequest, opts ...grpc.CallOption) (*NodeExpandVolumeResponse, error)
	NodeGetCapabilities(ctx context.Context, in *NodeGetCapabilitiesRequest, opts ...grpc.CallOption) (*NodeGetCapabilitiesResponse, error)
	NodeGetInfo(ctx context.Context, in *NodeGetInfoRequest, opts ...grpc.CallOption) (*NodeGetInfoResponse, error)
}

type nodeClient struct {
	cc *grpc.ClientConn
}

func NewNodeClient(cc *grpc.ClientConn) NodeClient {
	return &nodeClient{cc}
}

func (c *nodeClient) NodeStageVolume(ctx context.Context, in *NodeStageVolumeRequest, opts ...grpc.CallOption) (*NodeStageVolumeResponse, error) {
	out := new(NodeStageVolumeResponse)
	err := c.cc.Invoke(ctx, "/csi.v1.Node/NodeStageVolume", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeClient) NodeUnstageVolume(ctx context.Context, in *NodeUnstageVolumeRequest, opts ...grpc.CallOption) (*NodeUnstageVolumeResponse, error) {
	out := new(NodeUnstageVolumeResponse)
	err := c.cc.Invoke(ctx, "/csi.v1.Node/NodeUnstageVolume", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeClient) NodePublishVolume(ctx context.Context, in *NodePublishVolumeRequest, opts ...grpc.CallOption) (*NodePublishVolumeResponse, error) {
	out := new(NodePublishVolumeResponse)
	err := c.cc.Invoke(ctx, "/csi.v1.Node/NodePublishVolume", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeClient) NodeUnpublishVolume(ctx context.Context, in *NodeUnpublishVolumeRequest, opts ...grpc.CallOption) (*NodeUnpublishVolumeResponse, error) {
	out := new(NodeUnpublishVolumeResponse)
	err := c.cc.Invoke(ctx, "/csi.v1.Node/NodeUnpublishVolume", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeClient) NodeGetVolumeStats(ctx context.Context, in *NodeGetVolumeStatsRequest, opts ...grpc.CallOption) (*NodeGetVolumeStatsResponse, error) {
	out := new(NodeGetVolumeStatsResponse)
	err := c.cc.Invoke(ctx, "/csi.v1.Node/NodeGetVolumeStats", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeClient) NodeExpandVolume(ctx context.Context, in *NodeExpandVolumeRequest, opts ...grpc.CallOption) (*NodeExpandVolumeResponse, error) {
	out := new(NodeExpandVolumeResponse)
	err := c.cc.Invoke(ctx, "/csi.v1.Node/NodeExpandVolume", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeClient) NodeGetCapabilities(ctx context.Context, in *NodeGetCapabilitiesRequest, opts ...grpc.CallOption) (*NodeGetCapabilitiesResponse, error) {
	out := new(NodeGetCapabilitiesResponse)
	err := c.cc.Invoke(ctx, "/csi.v1.Node/NodeGetCapabilities", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeClient) NodeGetInfo(ctx context.Context, in *NodeGetInfoRequest, opts ...grpc.CallOption) (*NodeGetInfoResponse, error) {
	out := new(NodeGetInfoResponse)
	err := c.cc.Invoke(ctx, "/csi.v1.Node/NodeGetInfo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// NodeServer is the server API for Node service.
type NodeServer interface {
	NodeStageVolume(context.Context, *NodeStageVolumeRequest) (*NodeStageVolumeResponse, error)
	NodeUnstageVolume(context.Context, *NodeUnstageVolumeRequest) (*NodeUnstageVolumeResponse, error)
	NodePublishVolume(context.Context, *NodePublishVolumeRequest) (*NodePublishVolumeResponse, error)
	NodeUnpublishVolume(context.Context, *NodeUnpublishVolumeRequest) (*NodeUnpublishVolumeResponse, error)
	NodeGetVolumeStats(context.Context, *NodeGetVolumeStatsRequest) (*NodeGetVolumeStatsResponse, error)
	NodeExpandVolume(context.Context, *NodeExpandVolumeRequest) (*NodeExpandVolumeResponse, error)
	NodeGetCapabilities(context.Context, *NodeGetCapabilitiesRequest) (*NodeGetCapabilitiesResponse, error)
	NodeGetInfo(context.Context, *NodeGetInfoRequest) (*NodeGetInfoResponse, error)
}

// UnimplementedNodeServer can be embedded to have forward compatible implementations.
type UnimplementedNodeServer struct {
}

func (*UnimplementedNodeServer) NodeStageVolume(ctx context.Context, req *NodeStageVolumeRequest) (*NodeStageVolumeResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method NodeStageVolume not implemented")
}
func (*UnimplementedNodeServer) NodeUnstageVolume(ctx context.Context, req *NodeUnstageVolumeRequest) (*NodeUnstageVolumeResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method NodeUnstageVolume not implemented")
}
func (*UnimplementedNodeServer) NodePublishVolume(ctx context.Context, req *NodePublishVolumeRequest) (*NodePublishVolumeResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method NodePublishVolume not implemented")
}
func (*UnimplementedNodeServer) NodeUnpublishVolume(ctx context.Context, req *NodeUnpublishVolumeRequest) (*NodeUnpublishVolumeResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method NodeUnpublishVolume not implemented")
}
func (*UnimplementedNodeServer) NodeGetVolumeStats(ctx context.Context, req *NodeGetVolumeStatsRequest) (*NodeGetVolumeStatsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method NodeGetVolumeStats not implemented")
}
func (*UnimplementedNodeServer) NodeExpandVolume(ctx context.Context, req *NodeExpandVolumeRequest) (*NodeExpandVolumeResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method NodeExpandVolume not implemented")
}
func (*UnimplementedNodeServer) NodeGetCapabilities(ctx context.Context, req *NodeGetCapabilitiesRequest) (*NodeGetCapabilitiesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method NodeGetCapabilities not implemented")
}
func (*UnimplementedNodeServer) NodeGetInfo(ctx context.Context, req *NodeGetInfoRequest) (*NodeGetInfoResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method NodeGetInfo not implemented")
}

func RegisterNodeServer(s *grpc.Server, srv NodeServer) {
	s.RegisterService(&_Node_serviceDesc, srv)
}

func _Node_NodeStageVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NodeStageVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeServer).NodeStageVolume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.v1.Node/NodeStageVolume",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeServer).NodeStageVolume(ctx, req.(*NodeStageVolumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Node_NodeUnstageVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NodeUnstageVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeServer).NodeUnstageVolume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.v1.Node/NodeUnstageVolume",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeServer).NodeUnstageVolume(ctx, req.(*NodeUnstageVolumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Node_NodePublishVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NodePublishVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeServer).NodePublishVolume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.v1.Node/NodePublishVolume",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeServer).NodePublishVolume(ctx, req.(*NodePublishVolumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Node_NodeUnpublishVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NodeUnpublishVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeServer).NodeUnpublishVolume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.v1.Node/NodeUnpublishVolume",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeServer).NodeUnpublishVolume(ctx, req.(*NodeUnpublishVolumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Node_NodeGetVolumeStats_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NodeGetVolumeStatsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeServer).NodeGetVolumeStats(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.v1.Node/NodeGetVolumeStats",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeServer).NodeGetVolumeStats(ctx, req.(*NodeGetVolumeStatsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Node_NodeExpandVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NodeExpandVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeServer).NodeExpandVolume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.v1.Node/NodeExpandVolume",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeServer).NodeExpandVolume(ctx, req.(*NodeExpandVolumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Node_NodeGetCapabilities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NodeGetCapabilitiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeServer).NodeGetCapabilities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.v1.Node/NodeGetCapabilities",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeServer).NodeGetCapabilities(ctx, req.(*NodeGetCapabilitiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Node_NodeGetInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NodeGetInfoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeServer).NodeGetInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.v1.Node/NodeGetInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeServer).NodeGetInfo(ctx, req.(*NodeGetInfoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Node_serviceDesc = grpc.ServiceDesc{
	ServiceName: "csi.v1.Node",
	HandlerType: (*NodeServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "NodeStageVolume",
			Handler:    _Node_NodeStageVolume_Handler,
		},
		{
			MethodName: "NodeUnstageVolume",
			Handler:    _Node_NodeUnstageVolume_Handler,
		},
		{
			MethodName: "NodePublishVolume",
			Handler:    _Node_NodePublishVolume_Handler,
		},
		{
			MethodName: "NodeUnpublishVolume",
			Handler:    _Node_NodeUnpublishVolume_Handler,
		},
		{
			MethodName: "NodeGetVolumeStats",
			Handler:    _Node_NodeGetVolumeStats_Handler,
		},
		{
			MethodName: "NodeExpandVolume",
			Handler:    _Node_NodeExpandVolume_Handler,
		},
		{
			MethodName: "NodeGetCapabilities",
			Handler:    _Node_NodeGetCapabilities_Handler,
		},
		{
			MethodName: "NodeGetInfo",
			Handler:    _Node_NodeGetInfo_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "github.com/container-storage-interface/spec/csi.proto",
}
