/*
 * National Center for SuperComputing Applications, University of Illinois
 *
 * This NCSA software product is public domain software.  Permission
 * is hereby granted to do whatever you like with it. Should you wish
 * to make a contribution towards the production of this software, please
 * send us your comments about your experience with the software,  why
 * you liked or disliked it, how you use it, and most importantly, how it
 * helps your work. We will receive your comments at softdev@ncsa.uiuc.edu.
 *
 * Please send bug reports to bugs@ncsa.uiuc.edu
 *
 * Author: Eng-Whatt Toh, National Center for Supercomputing Applications
 *         ewtoh@ncsa.uiuc.edu
 */
#if ! defined(lint) && ! defined(LINT)
static char rcs_id[] = "$Id: gr_main.c,v 1.5 1994/01/04 16:42:06 gbourhis Exp $";
#endif

/*
 *	File:		gr_main.c
 *	Contents:	Main initialization/termination routines for graphics module
 *	$Log: gr_main.c,v $
 * Revision 1.5  1994/01/04  16:42:06  gbourhis
 * Add the -DTMIN command line arg.
 *
 * Revision 1.4  1993/10/28  20:49:42  gbourhis
 * Change the fallback resource for the font of List Widget.
 *
 */

#include "gr_com.h"
#include "gr_xwi.h"
#include "XDSicon.c"
#ifdef SIGCHLD
#undef SIGCHLD
#endif
#include <signal.h>

Widget		gr_topLevel;		/* Top Level Widget */
A_TopWind_t	gr_topWin;		/* Top Window */
char		*gr_palData;		/* Palette data */
char		gr_DirName[STRNG160];	/* Directory name */
char		gr_FileName[STRNG160];	/* File name */
A_Color_t	gr_color;		/* Color structure for palette */
A_Color_t	gr_colorSplit;		/* Color structure for split pal */
ApplicationData	gr_Data;		/* Resources for X DataSlice */
XEvent		report;


static  XtActionsRec gr_ActionsTable[] = {
	{"gr_FileDirReturn", gr_FileDirReturn},
	{"gr_FileSaveReturn", gr_FileSaveReturn},
};

static	XtResource	resources[] = {
	{ "adjustToggles","AdjustToggles", XtRBoolean, sizeof(Boolean),
	  XtOffset(ApplicationDataPtr, adjustToggles), XtRString, "FALSE"},
	{ "installCMap",  "InstallCmap",   XtRBoolean, sizeof(Boolean),
	  XtOffset(ApplicationDataPtr, installCMap), XtRString, "FALSE"},
	{ "inputFocus",   "inputFocus",    XtRBoolean, sizeof(Boolean),
	  XtOffset(ApplicationDataPtr, inputFocus), XtRString, "FALSE"},
	{ "useXImage",    "useXImage",     XtRBoolean, sizeof(Boolean),
	  XtOffset(ApplicationDataPtr, useXImage), XtRString, "FALSE"},
	{ "transpose",    "Transpose",     XtRBoolean, sizeof(Boolean),
	  XtOffset(ApplicationDataPtr, transpose), XtRString, "FALSE"},
	{ "paletteEditor",    "PaletteEditor",     XtRBoolean, sizeof(Boolean),
	  XtOffset(ApplicationDataPtr, paletteEditor), XtRString, "FALSE"},
};

static	XrmOptionDescRec	options[] = {
	{ "-adjustToggles","*adjustToggles",XrmoptionNoArg,"TRUE"},
	{ "-installCMap",  "*installCMap",  XrmoptionNoArg,"TRUE"},
	{ "-inputFocus",   "*inputFocus",   XrmoptionNoArg,"TRUE"},
	{ "-useXImage",    "*useXImage",    XrmoptionNoArg,"TRUE"},
	{ "-transpose",    "*transpose",    XrmoptionNoArg,"TRUE"},
	{ "-paletteEditor",    "*paletteEditor",    XrmoptionNoArg,"TRUE"},
};

/* gbourhis Jan 93: add fallback resources and an application
   context */
#ifdef XtSpecificationRelease
static char *fallback_resources[] = {
  "XDS*List.Font:	*-fixed-medium-r-normal--13-*",
  (char *)NULL
  };

static	XtAppContext app_context;
#endif

extern	void	gr_PalInit();
extern	void	gr_ImageDefCMap();
extern	void	gr_InitTopLevel();
extern	void	td_Terminate();

/*
 * This is called by the main init function to initialize all variables
 * and other stuff pertaining to the graphics module
 */
void
gr_Init(argc,argv)
int		argc;
char	*argv[];
{
	Arg		argList[2];
	Pixmap	iconPixmap;
	extern	void	gr_CatchInterrupt();
#ifdef DTMOK
	extern	char *outPortName;
#endif

	DBPRINTARG("GR_INIT: ac=%d \n", argc);
	{ int i; for(i=0;i<argc;i++) DBPRINT2ARGS(" av[%d] is [%s]\n", i, argv[i]); }
	gr_topLevel =
#ifdef XtSpecificationRelease
	  /* gbourhis Jan 93: use XtAppInitialize for the fallback resources */
	  XtAppInitialize(&app_context, "XDS",
			  options,XtNumber(options),
#if XtSpecificationRelease > 4
			  &argc,
#else
			  (Cardinal *)&argc,
#endif
			  argv, fallback_resources,
			  (ArgList)NULL, (Cardinal)0);
#else
	  XtInitialize(argv[0], "XDS",
			  options,XtNumber(options),&argc,argv);
#endif
#ifdef DTMOK
	if (argc > 2 && (!strcmp(argv[1], "-DTMOUT") ||
			 !strcmp(argv[1],"-dtmout"))) {
	  outPortName = argv[2]; argv += 2; argc -= 2;
	}
	if (argc > 2 && (!strcmp(argv[1], "-DTMIN") ||
			 !strcmp(argv[1],"-dtmin"))) {
	  if (DTM_setInPort(argv[2]))
	    fprintf(stderr, "invalid input port (%s), ignored.\n",
		    argv[2]);
	}
#endif
	if (argc==2) SETCOMMANDLINEFILE(argv[1]);

	XtGetApplicationResources(gr_topLevel, &gr_Data, resources,
		XtNumber(resources), NULL, 0);

	if (gr_Data.transpose)
	  printf("Automatic transposition of SDS\n");

#ifdef XtSpecificationRelease
	XtAppAddActions(app_context, gr_ActionsTable,
#else
	XtAddActions(gr_ActionsTable,
#endif
			XtNumber(gr_ActionsTable));

	if(USECOMMANDLINEFILE()) {
		 char notefile[200];
		 char *fname;
		 GETCOMMANDLINEFILE(&fname);
		 sprintf(notefile,"%s.note", fname);
	    gr_InitNotes(argv[0], gr_topLevel, notefile); /* jng  14-apr-92 */
		 }


	gr_InitTopLevel(argv[0],gr_topLevel,&gr_topWin);
	gr_topWin.fileWin = gr_InitFileLevel("XDSwindow",gr_topLevel);
	gr_topWin.numFileWins = 0;

	(*signal)(SIGINT,gr_CatchInterrupt);

	XtRealizeWidget(gr_topLevel);
	gr_FileHideLevel(gr_topWin.fileWin);

	gr_WidgetCursor(gr_topLevel,XC_draped_box);

	iconPixmap = XCreateBitmapFromData(XtDisplay(gr_topWin.shell),
		XtWindow(gr_topWin.shell), XDS_bits, XDS_width, XDS_height);
	XtSetArg(argList[0],XtNiconPixmap, iconPixmap);
	XtSetValues(gr_topLevel, argList, 1);

	gr_TextMsgOut("Product of National Center for Supercomputing Applications.\n");
	gr_TextMsgOut("Send bug reports to bugs@ncsa.uiuc.edu\n");

	gr_PalInit(gr_topWin.shell);
	gr_ImageDefCMap();

#ifdef XtSpecificationRelease
	gr_TextMsgOut("\nClick on one of the buttons to open a File Window...");
#else
	gr_TextMsgOut("\nClick on one of the buttons to open a File Window...\n");
#endif

	if (USECOMMANDLINEFILE()) {
		char * fname;
		int 	xsize, ysize, ispal;

		GETCOMMANDLINEFILE(&fname);

		if (! td_FileIsHdf(fname)) {
			printf(" [%s] is not a HDF file\n", fname); beep();
			exit(0); 
		}
		else if (td_HdfCheck(fname) != -1) {
			printf("THIS FILE [%s] IS A SDS..quit for now \n",
			       fname);
			gr_SDSLoad(NULL, gr_topWin.fileWin, NULL);
		}
		else if (td_HdfgetRasDims(fname, &xsize, &ysize, &ispal) > 0) {
			printf ("gr_main.c: calling aniload directly\n");
			gr_AniLoad(NULL, gr_topWin.fileWin, NULL);
		}
		else { 
			printf("This HDF file  has no rasters or sds. quitting.\n"); beep();
			exit(0); 
		}
	}
}


/*
 * Main event loop
 */
void
gr_ProcessLoop()
{
#ifdef XtSpecificationRelease
	XtAppMainLoop(app_context);
#else
	XtMainLoop();
#endif

	/*
	while (TRUE)
	{
		if (XtPending() == TRUE)
		{
			XEvent	report;

			XtNextEvent(&report);
			XtDispatchEvent(&report);
		}
	}
	*/
}


/*
 * Termination procedure.  Note that each termination call of a window
 * calls the termination procedures of all the child windows spawned by
 * it.
 */
void
gr_Terminate(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{

#ifdef XtSpecificationRelease
	gr_TextMsgSave();
	if (USECOMMANDLINEFILE()) /* save the notes */
	  gr_SaveNotes();	/* gbourhis, Feb 93 */
#endif

	/* Close File window if it is up */
	gr_DestroyFileLevel();

	/* Close all Boss windows.  When a boss dies, all his subordinates
	   gets killed too.  */

	while (gr_topWin.bossWin != NULL)
		gr_CloseBossLevel(gr_topWin.bossWin->shell,
			(caddr_t)gr_topWin.bossWin,(caddr_t)NULL);

	gr_Close_DTM();
	td_Terminate();
}


void
gr_CatchInterrupt(nargs,args)
int nargs;
char *args[];
{
	A_AniWind_t	*aniWin=gr_topWin.aniWin;

	while (aniWin != NULL)
	{
		if (aniWin->playStop == 0)
		{
			aniWin->playStop = 1;
			return;
		}
		aniWin = aniWin->next;
	}

	gr_TextMsgOut("X DataSlice is interrupted... goodbye.\n");
	gr_Terminate(gr_topWin.shell,(caddr_t)NULL,(caddr_t)NULL);
}
