/*
 * Copyright (c) 1992 Purdue University
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by Purdue University.  The name of the University may not be used
 * to endorse or promote products derived * from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 */

#include <stdio.h>
#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <sgtty.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/stream.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <net/if.h>
#include "dp_str.h"
#include "dpd.h"
#include "dp.h"

static int ppp_pid;
extern void hangup();

start_ppp(rp, tty, baud, passive)
REMOTE *rp;
char *tty;
int baud,
    passive;
{
    static char		WHERE[] = "start_ppp";
    char srcbuf[32], dstbuf[32], addrbuf[128],
	 unitbuf[16], baudbuf[8];
    char *cmds[24], **argv = cmds;

    (void)strcpy(srcbuf, inet_ntoa(rp->Address));
    (void)strcpy(dstbuf, inet_ntoa(rp->DstAddress));

    (void)sprintf(unitbuf, "%d", rp->Unit);
    (void)sprintf(addrbuf, "%s:%s", srcbuf, dstbuf);
    (void)sprintf(baudbuf, "%d", baud);

    *argv++ = PPP_PROG;
    if (log_level >= DLOG_DIAG)
	*argv++ = "-d";
    if (rp->PppArgs) {
	char **ap;
	for (ap = rp->PppArgs ; *ap ; )
	    *argv++ = *ap++;
    }
    if (passive)
	*argv++ = "-p";
    *argv++ = "-as";
    *argv++ = "0";
    *argv++ = "dialup";
    *argv++ = "unit";
    *argv++ = unitbuf;
    if (tty)
	*argv++ = tty;
    if (baud > 0)
	*argv++ = baudbuf;
    *argv++ = addrbuf;
    *argv++ = (char *)0;
    {
	char cmdbuf[512], *c = cmdbuf;
	*c++ = '"';
	for (argv = cmds ; *argv ; argv++) {
	    (void)sprintf(c, "%s%c", *argv, *(argv+1) ? ' ' : '"');
	    c += strlen(c);
	}
	d_log(DLOG_GENERAL, WHERE, "Executing: %s", cmdbuf);
    }

    if ((ppp_pid = fork()) == 0) {
	(void)execv(cmds[0], cmds);
	exit(128);
    }

    return ppp_pid;
}

void
collect_ppp(sig)
int sig;
{
    int wstatus;
    extern int errno;
    static char		WHERE[] = "collect_ppp";

    errno = 0;
    if (ppp_pid <= 0)
	return;

    if (waitpid(ppp_pid, &wstatus, sig ? WNOHANG : 0) < 0 ||
	WIFEXITED(wstatus) || WIFSIGNALED(wstatus)) {
	if (WIFEXITED(wstatus))
	    d_log(DLOG_DIAG, WHERE, "PPP exited with status %d",
		  WEXITSTATUS(wstatus));
	else if (WIFSIGNALED(wstatus))
	    d_log(DLOG_DIAG, WHERE, "PPP exited due to signal %d",
		  WTERMSIG(wstatus));
	else
	    d_log(DLOG_GENERAL, WHERE, "PPP wait terminated with error %d",
		  errno);
	ppp_pid = 0;
	if (sig)
	    hangup(sig);
    }
}

kill_ppp(sig)
int sig;
{
    if (ppp_pid > 0)
	(void)kill(ppp_pid, sig);
}
