#include <stdio.h>
#include <fcntl.h>
#include <errno.h>

#include <sys/file.h>
#include <sys/ioctl.h>
#include <sys/ctio.h>

char *argv0;

main(argc, argv)
int argc;
char **argv;
{
    int c, i;
    extern int optind;
    extern char *optarg;
    int baudext = -1;
    argv0 = *argv;
    while ((c = getopt(argc, argv, "yn10")) != EOF)
	switch (c) {
	 case 'y':
	 case '1':
	    baudext = 1;
	    break;
	 case 'n':
	 case '0':
	    baudext = 0;
	    break;
	}
    if (baudext < 0) {
	fprintf(stderr, "%s: can't read baud extension factor, must set using -y or -n");
	exit(1);
    }
    for (i = optind ; i < argc ; i++)
	ttyext(argv[i], baudext);
    exit(0);
}

char *concatlist[] = { "", "/dev/", "/dev/tty", (char *)0 };

ttyext(tty, ext)
char *tty;
{
    int f;
    char ttyname[128];
    char **cl;
    extern int erno;

    for (cl = concatlist ; *cl ; cl++) {
	(void)sprintf(ttyname, "%s%s", *cl, tty);

	if ((f = open(ttyname, O_RDWR|O_NDELAY)) < 0) {
	    if (errno == ENOENT)
		continue;
	    fprintf(stderr, "%s: ", argv0);
	    perror(ttyname);
	    return;
	}
	break;
    }
    if (!*cl) {
	fprintf(stderr, "%s: ", argv0);
	perror(tty);
	return;
    }
    if (ext >= 0) {
	if (ioctl(f, STSBAUDEXTEN, &ext) < 0) {
	    fprintf(stderr, "%s: %s: ", argv0, ttyname);
	    perror("Central Data Baud Extension ioctl failed");
	}
    }
    else {
	/*
	 * There should be a way to read the baud extension factor.
	 * With the current firmware, this is not possible.
	 */
    }
}
