#!/bin/sh
if [ $# -lt 3 ] ; then
    echo usage: $0 [-v] scriptfile outdev indev [baud]
    exit 1
fi
if [ $1 = "-v" ] ; then
    VERBOSE=-v
    SCRIPT=$2
    OUTDEV=$3
    INDEV=$4
    BAUD=$5
else
    VERBOSE=
    SCRIPT=$1
    OUTDEV=$2
    INDEV=$3
    BAUD=$4
fi
#
# Load in paths..
#
. /etc/dp.conf
#
# Set up a way to back out of this.
#
TTYTAB=/etc/ttytab
TTYTAB_BAK=$TTYTAB.$$
cp $TTYTAB $TTYTAB_BAK
trap "cp $TTYTAB_BAK $TTYTAB;rm $TTYTAB_BAK;kill -1 1;exit 2" 1 2 3 15
#
# Turn off getty, grab the port and set up the modem.
#
sed "/$INDEV/s/on/off/" < $TTYTAB_BAK > $TTYTAB
kill -1 1
sleep 2
if [ -n "$BAUD" ] ; then
    ${DPMODEM_DIR}/setmodem $VERBOSE $SCRIPT $OUTDEV $BAUD
else
    ${DPMODEM_DIR}/setmodem $VERBOSE $SCRIPT $OUTDEV
fi
#
# Restore things back to normal
#
cp $TTYTAB_BAK $TTYTAB
rm $TTYTAB_BAK
kill -1 1
exit 0
