#include <malloc.h>
#include <string.h>
#include <dirent.h>
#include <fcntl.h>
#include <stdlib.h>

#include <sys/file.h>

#if	0
#define	DEBUG
#endif

char maildir[] = "/var/spool/mqueue";

main()
{
    if (mail_to_go())
	start_sendmail();
    exit(0);
}

mail_to_go()
{
    DIR *d;
    struct dirent *de;
    int msg = 0;

    if (chdir(maildir) < 0) {
	perror(maildir);
	exit(1);
    }
    if ((d = opendir(".")) == NULL) {
	perror("opendir");
	exit(2);
    }
    while (!msg && (de = readdir(d)))
	if (strncmp(de->d_name, "qf", 2) == 0)
	    msg = msg_to_go(de->d_name);
    closedir(d);
    return msg;
}

msg_to_go(fn)
char *fn;
{
    int f,
	msg;
    if ((f = open(fn, O_RDONLY)) < 0)
	return 0;

    msg = flock(f, LOCK_SH|LOCK_NB) == 0;
    (void)close(f);

#ifdef	DEBUG
    (void)printf("%s: %s\n", fn, msg ? "needs sent" : "already locked");
#endif

    return msg;
}


start_sendmail()
{
#ifdef	DEBUG
    (void)printf("mail to go...\n");
#else
    execl("/usr/lib/sendmail", "sendmail", "-q", (char *)0);
#endif
}
