 #include <copyright.h>
#include <wattcp.h>
#include <elib.h>
#include <dos.h>

#pragma inline

#define noNEVILDEBUG

#define MAXBUFS        5  /* maximum number of Ethernet buffers */
#define BUFSIZE     1514  /* AU: was 1500 */

char au_monitor = 0;  /* AU: 1 to enable monitoring */

#define INT_FIRST 0x60
#define INT_LAST  0x80
#define PKT_LINE "PKT DRVR"
#define PD_DRIVER_INFO	0x01FF
#define PD_ACCESS 	0x0200
#define PD_RELEASE	0x0300
#define PD_SEND		0x0400
#define PD_GET_ADDRESS	0x0600
#define PD_RCV_MODE	0x1400  /* AU Monitor */
#define PM_UNICAST      2
#define PM_PROMISCUOUS  6
#define  CARRY 		1	     /* carry bit in flags register */

word _pktipofs = 0;			/* offset from header to start of pkt */
word pkt_interrupt;
word pkt_ip_type = 0x0008;		/* these are intelled values */
word pkt_arp_type = 0x0608;

byte pktbuf[MAXBUFS][ BUFSIZE + 2 ];	/* first byte is busy flag, 2nd spare */
word  pkt_ip_handle;
word  pkt_arp_handle;
byte eth_addr[ 6 ] ;
longword far *interrupts = 0L;


extern void _pktentry();
extern void _pktasminit( void far *, int, int );
extern int qcmp( void far *, void far *, int );


void pkt_rcv_mode(unsigned int handle, int mode)  /* AU Monitor */
{
   struct REGPACK regs;

   regs.r_ax = PD_RCV_MODE;
   regs.r_bx = handle;
   regs.r_cx = mode;
   intr( pkt_interrupt, &regs );
   if (regs.r_flags & CARRY) {
      outs("ERROR 0x");
      outhex( regs.r_dx >> 8 );
      outs(" setting receive mode\n\r" );
      exit(1);
      }
   }

pkt_init()
{
    struct REGPACK regs, regs2;
    char far *temp;
    int pd_type;	/* packet driver type */
    int class;
    word zero = 0;  /* AU */

/*    _pktasminit( pktbuf, MAXBUFS, BUFSIZE);  AU: not needed now */
    for (pkt_interrupt = INT_FIRST; pkt_interrupt <= INT_LAST; ++pkt_interrupt ) {
/*	temp = getvect( pkt_interrupt );  AU: redundant code! */
	temp = (char far *)(interrupts[ pkt_interrupt ]);
	if ( !qcmp( &(temp[3]), PKT_LINE, sizeof( PKT_LINE ))) {
	    break;
	}
    }
    if ( pkt_interrupt > INT_LAST ) {
	outs("NO PACKET DRIVER FOUND");
	return( 1 );
    }

    /* lets find out about the driver */
    regs.r_ax = PD_DRIVER_INFO;
    intr( pkt_interrupt, &regs );

    /* handle old versions, assume a class and just keep trying */
    if (regs.r_flags & CARRY ) {
	for ( class = 0; class < 2; ++class ) {
	    _pktdevclass = (class) ? PD_SLIP : PD_ETHER;

	    for (pd_type = 1; pd_type < 128; ++pd_type ) {
		regs.r_ax = PD_ACCESS | _pktdevclass;  /* ETH, SLIP */
		regs.r_bx = pd_type;		/* type */
		regs.r_dx = 0;			/* if number */
		regs.r_cx = sizeof( pkt_ip_type );
		regs.r_ds = FP_SEG( &pkt_ip_type );
		regs.r_si = FP_OFF( &pkt_ip_type );
        regs.r_es = FP_SEG( _pktentry);
		regs.r_di = FP_OFF( _pktentry);
		intr( pkt_interrupt, &regs );
		if ( ! (regs.r_flags & CARRY) ) break;
	    }

	    if (pd_type == 128 ) {
		outs("ERROR initializing packet driver\n\r");
		return( 1 );
	    }
	    /* we have found a working type, so kill it */
	    regs.r_bx = regs.r_ax;	/* handle */
	    regs.r_ax = PD_RELEASE;
	    intr( pkt_interrupt, &regs );
	}
    } else {
	pd_type = regs.r_dx;
	switch ( _pktdevclass = (regs.r_cx >> 8)) {
	    case PD_ETHER : _pktipofs = 14;

	    case PD_SLIP  : break;
	    default 	  : outs("ERROR only ethernet packet drivers allowed\n\r");
			    return( 1 );
	}
    }
    regs.r_ax = PD_ACCESS | _pktdevclass;
    regs.r_bx = 0xffff;  /* any type - was pd_type  type */
    regs.r_dx = 0;			/* if number */
   if (au_monitor) {
      regs.r_cx = 0;
      regs.r_ds = FP_SEG( &zero);
      regs.r_si = FP_OFF( &zero);
      }
   else {
      regs.r_cx = sizeof( pkt_ip_type );
      regs.r_ds = FP_SEG( &pkt_ip_type );
      regs.r_si = FP_OFF( &pkt_ip_type );
      }
    regs.r_es = FP_SEG( _pktentry);
    regs.r_di = FP_OFF( _pktentry);
    memcpy( &regs2, &regs, sizeof( regs ));
    regs2.r_si = FP_OFF( &pkt_arp_type );
    regs2.r_ds = FP_SEG( &pkt_arp_type );

    intr( pkt_interrupt, &regs );
    if ( regs.r_flags & CARRY ) {
	outs("ERROR 0x");
	outhex( regs.r_dx >> 8 );
	outs(" accessing packet driver for IP\n\r" );
	return( 1 );
    }
    pkt_ip_handle = regs.r_ax;

    /* get ethernet address */
    regs.r_ax = PD_GET_ADDRESS;
    regs.r_bx = pkt_ip_handle;
    regs.r_es = FP_SEG( eth_addr );
    regs.r_di = FP_OFF( eth_addr );
    regs.r_cx = sizeof( eth_addr );
    intr( pkt_interrupt, &regs );
    if ( regs.r_flags & CARRY ) {
	outs("ERROR reading ethernet address\n\r" );
	return( 1 );
    }

    if (au_monitor) {  /* AU Monitor */
       pkt_arp_handle = 0;
       pkt_rcv_mode(pkt_ip_handle, PM_PROMISCUOUS);
       }
    else if (_pktdevclass != PD_SLIP) {
	intr( pkt_interrupt, &regs2 );
	if ( regs2.r_flags & CARRY ) {
	    regs.r_ax = PD_RELEASE;
	    regs.r_bx = pkt_ip_handle;
	    intr( pkt_interrupt, &regs );

	    outs("ERROR 0x");
	    outhex( regs2.r_dx >> 8 );
	    outs(" accessing packet driver for ARP\n\r" );
	    return( 1 );
	}
	pkt_arp_handle = regs2.r_ax;
    }
    return( 0 );
}

pkt_release()
{
    struct REGPACK regs;
    int error;

    error = 0;

    if ( _pktdevclass != PD_SLIP && pkt_arp_handle ) {  /* AU Monitor */
	regs.r_ax = PD_RELEASE;
	regs.r_bx = pkt_arp_handle;
	intr( pkt_interrupt, &regs );
	if (regs.r_flags & CARRY ) {
	    outs("ERROR releasing packet driver for ARP\n\r" );
	    error = 1;
	}
    }

   if (au_monitor) pkt_rcv_mode(pkt_ip_handle, PM_UNICAST);  /* AU Monitor */
    regs.r_ax = PD_RELEASE;
    regs.r_bx = pkt_ip_handle;
    intr( pkt_interrupt, &regs );
    if (regs.r_flags & CARRY ) {
	    outs("ERROR releasing packet driver for IP\n\r" );
	error = 1;
    }

    return( error );
}

long npackets = 0, nbytes = 0,
   badpackets = 0,nobufpackets = 0;

static unsigned char *pbp = pktbuf;
static char ibuf = MAXBUFS;

unsigned char far *pkt_rcv_call1(handle, len)
unsigned int handle, len;
{
   int sibuf;
   if (len > BUFSIZE || len == 0) {
      ++badpackets;
      return (char far *) NULL;
      }
   if (!pbp[0]) {  /* Current buffer is free */
      pbp[0] = 2;  /* Waiting for 2nd interrupt */
      return (unsigned char far *)&pbp[2];
      }
   sibuf = ibuf;  /* Search for a free buffer */
   for (;;) {
      if (--ibuf != 0) pbp += (BUFSIZE+2);
      else {
         pbp = pktbuf;  ibuf = MAXBUFS;
         }
      if (!pbp[0]) {
         pbp[0] = 2;  /* Waiting for 2nd interrupt */
         return (unsigned char far *)&pbp[2];
         }
      if (ibuf == sibuf) break;
      }

   ++nobufpackets;  /* No free buffers */
   ++npackets;  nbytes += len;  /* Don't loose the counts */
   return (unsigned char far *) NULL;
   }

void pkt_rcv_call2(handle, len, buff)
unsigned int handle, len;
unsigned char far *buff;
{
   buff[-2] = 1;  /* Ready for tcp/ip */
   }

int pkt_send( char *buffer, int length )
{
    struct REGPACK regs;
    int retries;
    unsigned char au_save;

    retries = 5;
    while (retries--) {
	regs.r_ax = PD_SEND;
	regs.r_ds = FP_SEG( buffer );
	regs.r_si = FP_OFF( buffer );
	regs.r_cx = length;
	intr( pkt_interrupt, &regs );
	if ( regs.r_flags & CARRY )
	    continue;
      if (au_monitor)  /* Monitor transmitted packets as well as received */
	 au_send_mon(length, (unsigned char far *)buffer);
	 /* Default version in pcpkt.c, au_monitor user must link the
	    actual one (and the real pkt_rcv_call2) */
	return( 0 );  /* Sent OK */
    }
    return( 1 );  /* Failed to send */
}

/* return a buffer to the pool */
pkt_buf_wipe()
{
    memset( pktbuf, 0, sizeof( byte ) * MAXBUFS * (BUFSIZE+ 2));
}

#ifdef NEVILDEBUG
void print_pkt_hdr(char *msg, unsigned char *h)  /* !!! */
{
   int j;
   printf("%s:  %04x  %02x,%02x  ", msg, h, h[0],h[1]);
   for (j = 2; j != 7; ++j) printf("%02x-",h[j]);
   printf("%02x  ",h[7]);
   for (j = 8; j != 13; ++j) printf("%02x-",h[j]);
   printf("%02x  %02x%02x\n",h[13], h[14],h[15]);
   }
#endif

pkt_buf_release( char *ptr )
{
#ifdef NEVILDEBUG
print_pkt_hdr("Fin with",&ptr[-16]);
#endif
    *(ptr - (2 + 14)) = 0;
}
void * pkt_received()
{
    word i, old;
    word oldin, newin;	/* ip sequence numbers */

    /* check if there are any */
    old = oldin = 0xffff;

    for ( i = 0 ; i < MAXBUFS; ++i ) {
	if ( *pktbuf[i] != 1 ) continue;

    newin = *(word*)(&pktbuf[i][ _pktipofs + 4 + 2]);
	if ( newin <= oldin ) {
	    oldin = newin;
	    old = i;
	}
    }
#ifdef NEVILDEBUG
    if (old != -1) print_pkt_hdr("Received",&pktbuf[old][0]);
#endif
    return( (old == -1) ? NULL : &pktbuf[old][2] );
#ifdef OLD
    for (i=0; i < MAXBUFS; ++i) {
	if ( *pktbuf[i] == 1 ) {
	    *pktbuf[i] = 2;
	    return( &pktbuf[i][2] );
	}
    }
    return( 0 );
#endif OLD
}

void * _pkt_eth_init()
{
    if ( pkt_init() ) {
	outs("Program halted");
	exit( 1 );
    }
    return( eth_addr );
}

