#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

#ifdef XXYYZZ
int bit(int n, unsigned int v)  /* Returns bit n (from left) of v */
{
   while (n != 0) v <<= 1;
   return v & 0x8000;
   }
#endif

unsigned int bit_n[16] = {
   0x8000, 0x4000, 0x2000, 0x1000, 0x0800, 0x0400, 0x0200, 0x0100,
   0x0080, 0x0040, 0x0020, 0x0010, 0x0008, 0x0004, 0x0002, 0x0001 };

struct d_node {
   int test_bit;
   unsigned int node_value;
   unsigned int node_ix;
   struct d_node *zero_p,*one_p;
   };

void p_dtree(struct d_node *p, int n)
{
   int j;
   if (p->zero_p != NULL) p_dtree(p->zero_p, n+1);
   printf("%3d  ", n);
   for (j = 0; j != n; ++j) printf("   ");
   printf("v=%04x, tb=%d, ix=%d, zero=%d, one=%d\n",
      p->node_value,p->test_bit,p->node_ix,p->zero_p,p->one_p);
   if (p->one_p != NULL) p_dtree(p->one_p, n+1);
   }

struct d_node d_mem[500];  int n_nodes = 0;

struct d_node *new_d_node(void)
{
   struct d_node *p = &d_mem[n_nodes++];
   p->node_ix = n_nodes;
   p->zero_p = p->one_p = NULL;
   return p;
   }

struct d_node *dt = NULL;  /* The digital tree */

struct d_node *dstack[16];  int s_depth;
unsigned int search_mask, search_value;

void dtree(unsigned int v)  /* Search tree for v */
{                    /* Assumes there is always at least one node present */
   struct d_node *p;
   unsigned int b;
   search_mask = search_value = s_depth = 0; p = dt;
   for (;;) {
      dstack[s_depth++] = p;
      if (p->zero_p == NULL && p->one_p == NULL) return;
      b = bit_n[p->test_bit];
      search_mask |= b;
      if (b & v) {
	 search_value |= b;
	 if (p->one_p == NULL) return;
	 else p = p->one_p;
	 }
      else {
	 if (p->zero_p == NULL) return;
	 else p = p->zero_p;
	 }
      }
   }

void main()
{
   char input[80], *ip, c;
   int n1,n2;
   unsigned int v;
   struct d_node *p, *np;
   unsigned int b, dif;
   int j;
   for (;;) {
      gets(ip = input);
      while (isspace(*ip)) ++ip;
      if ((c = *ip) == 'q') exit(1);
      while (!isdigit(*ip)) ++ip;
      n1 = atoi(ip);
      while (isdigit(*ip)) ++ip;
      while (!isdigit(*ip)) ++ip;
      n2 = atoi(ip);
      v = (n1 << 8) | n2;
      printf("%c  %d.%d  %04x\n", c, n1,n2, v);
      if (dt == NULL) {  /* Empty tree */
	 dt = new_d_node();
	 dt->node_value = v;
	 }
      else {  /* Normal case */
	 dtree(v);  /* Search the tree */
printf("depth=%d\n", s_depth);
	 p = dstack[s_depth-1];
	 if (p->node_value == v)
	    printf("Exact match, node_ix=%d\n", p->node_ix);
	 else {  /* Partial match */
	    np = new_d_node();
	    np->node_value = v;
	    if (p->zero_p == NULL && p->one_p == NULL) {  /* Select bit */
	       dif = v ^ p->node_value;
	       for (j = 0; (dif & bit_n[j]) == 0; ++j) ;
	       p->test_bit = j;
printf("test_bit=%d\n", j);
	       }
	    b = bit_n[p->test_bit];
	    if (b & v) {
	       p->one_p = np;
	       }
	    else {
	       p->zero_p = np;
	       }
	    }
	 }
      p_dtree(dt,0);  /* Print the tree after adding a node */
      }
   }