/* 1030, Fri 18 Jul 94

   ETHER_UX.C:  Accounting Meter Ethernet Unix interface 

   Copyright (C) 1992-1994 by Nevil Brownlee,
   Computer Centre,  The University of Auckland */

#define noUX_TESTING

#include <sys/types.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <arpa/inet.h>

#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <fcntl.h>

#include <sys/time.h>
#include <sys/timeb.h>

#ifdef SUNOS
#include <stropts.h>
#endif

#define PKTSNAP
#include "ausnmp.h"
#include "pktsnap.h"

#define CHUNKSIZE  70000
#define SNAPSIZE   54L  /* Enough for all except CLNS (which needs 70) */

/* SNAP size currently set to 54 to sidestep a bug in Solaris 2.3, 
   which corrupts packets smaller than the SNAP size.  This bug is 
   fixed in Solaris 2.4; if you are using Solaris 2.4 or you should
   set SNAPSIZE to MXPKTHDRLEN.   Nevil, 12 Jul 94 */

extern unsigned int SampleRate;
unsigned int sample_count = 1;


#ifdef USE_NIT
#include <net/if.h>
#include <net/nit_if.h>
#include <net/nit_pf.h>
#include <net/nit_buf.h>

#define NIT_DEV "/dev/nit"

int init_interface()  /* Returns interface fd */
{
   u_long if_flags = NI_PROMISC | NI_LEN | NI_DROPS;
   u_long snaplen = MXPKTHDRLEN;
   u_long chunksize = CHUNKSIZE;
   char *device = "le0";

   int nit_fd;
   struct strioctl si;
   struct ifreq ifr;
   struct timeval timeout;
int r;  /* $$$ */
   nit_fd = open(NIT_DEV, O_RDONLY);
printf("nit_fd=%d\n", nit_fd);  /* $$$ */
   /* Arrange to get discrete messages from the stream. */
r = /* $$$ */
   ioctl(nit_fd, I_SRDOPT, (char *)RMSGD);
printf("SRDOPT: r=%d, errno=%d\n", r,errno);  /* $$$ */

   si.ic_timout = INFTIM;

   /* and configure the buffering module. */
r = /* $$$ */
   ioctl(nit_fd, I_PUSH, "nbuf");
printf("push nbuf: r=%d, errno=%d\n", r,errno);  /* $$$ */
   timeout.tv_sec = 0;
   timeout.tv_usec = 250000L;  /* 0.25 sec */
   si.ic_cmd = NIOCSTIME;
   si.ic_len = sizeof timeout;
   si.ic_dp = (char *)&timeout;
r = /* $$$ */
   ioctl(nit_fd, I_STR, (char *)&si);
printf("IOCSTIME: r=%d, errno=%d\n", r,errno);  /* $$$ */

   si.ic_cmd = NIOCSCHUNK;
   si.ic_len = sizeof chunksize;
   si.ic_dp = (char *)&chunksize;

r = /* $$$ */
   ioctl(nit_fd, I_STR, (char *)&si);
printf("IOCSCHUNK: r=%d, errno=%d\n", r,errno);  /* $$$ */

   /* Configure the nit device, binding it to the proper
      underlying interface, setting the snapshot length,
      and setting nit_if-level flags. */

   strcpy(ifr.ifr_name, device);
   si.ic_cmd = NIOCBIND;
   si.ic_len = sizeof ifr;
   si.ic_dp = (char *)&ifr;
r = /* $$$ */
   ioctl(nit_fd, I_STR, (char *)&si);
printf("IOCBIND: r=%d, errno=%d\n", r,errno);  /* $$$ */

   if (snaplen > 0) {
      si.ic_cmd = NIOCSSNAP;
      si.ic_len = sizeof snaplen;
      si.ic_dp = (char *)&snaplen;
r = /* $$$ */
      ioctl(nit_fd, I_STR, (char *)&si);
printf("IOCSSNAP: r=%d, errno=%d\n", r,errno);  /* $$$ */
      }

   if (if_flags != 0) {
      si.ic_cmd = NIOCSFLAGS;
      si.ic_len = sizeof if_flags;
      si.ic_dp = (char *)&if_flags;
r = /* $$$ */
      ioctl(nit_fd, I_STR, (char *)&si);
printf("IOCSFLAGS: r=%d, errno=%d\n", r,errno);  /* $$$ */
      }

   /* Flush the read queue, to get rid of anything that accumulated
      before the device reached its final configuration. */

/*   if (ioctl(nit_fd, I_FLUSH, (char *)FLUSHR) < 0) {  $$
*/   if ((r = ioctl(nit_fd, I_FLUSH, (char *)FLUSHR)) < 0) {
printf("FLUSH: r=%d, errno=%d\n", r,errno);  /* $$$ */
      close(nit_fd);
      printf("FLUSH failed\n");
      exit(1);
      }
   return nit_fd;
   }

unsigned char buf[CHUNKSIZE];

void interface_read(fd)
int fd;
{
    int cc;
    u_char *bp,*bufstop;
    struct pkt pp;

    cc = read(fd, buf, CHUNKSIZE);
    bp = buf;
    bufstop = buf+cc;
    while (bp < bufstop) {
	register u_char *cp = bp;
	struct nit_bufhdr *hdrp;
	struct nit_iflen *nlp;
	struct nit_ifdrops *drp;

	hdrp = (struct nit_bufhdr *)cp;  cp += sizeof *hdrp;
	drp = (struct nit_ifdrops *)cp;  cp += sizeof *drp;
        lostpackets += drp->nh_drops;
	nlp = (struct nit_iflen *)cp;  cp += sizeof *nlp;
        if (--sample_count == 0) {
           ++npackets;
           process_pkt(nlp->nh_pktlen,cp);
           sample_count = SampleRate;
           }

	bp += hdrp->nhb_totlen;
	}
   }
#endif


#ifdef USE_DLPI
#include	<sys/stream.h>
#include	<sys/stropts.h>
#include        <sys/signal.h>
#include	<sys/dlpi.h>
#include	<sys/bufmod.h>

/*
 * Maximum control/data buffer size for getmsg().
 */
#define		MAXDLBUF	8192

/*
 * Maximum number of seconds we'll wait for any
 * particular DLPI acknowledgment from the provider
 * after issuing a request.
 */
#define		MAXWAIT		15


dlattachreq(fd, ppa)
int	fd;
u_long	ppa;
{
	dl_attach_req_t	attach_req;
	struct	strbuf	ctl;
	int	flags;

	attach_req.dl_primitive = DL_ATTACH_REQ;
	attach_req.dl_ppa = ppa;

	ctl.maxlen = 0;
	ctl.len = sizeof (attach_req);
	ctl.buf = (char *) &attach_req;

	flags = 0;

	if (putmsg(fd, &ctl, (struct strbuf*) NULL, flags) < 0)
		syserr("dlattachreq:  putmsg");
}

dlpromisconreq(fd, level)
int	fd;
u_long	level;
{
	dl_promiscon_req_t	promiscon_req;
	struct	strbuf	ctl;
	int	flags;

	promiscon_req.dl_primitive = DL_PROMISCON_REQ;
	promiscon_req.dl_level = level;

	ctl.maxlen = 0;
	ctl.len = sizeof (promiscon_req);
	ctl.buf = (char *) &promiscon_req;

	flags = 0;
	if (putmsg(fd, &ctl, (struct strbuf*) NULL, flags) < 0)
		syserr("dlpromiscon:  putmsg");

}

dlbindreq(fd, sap, max_conind, service_mode, conn_mgmt, xidtest)
int	fd;
u_long	sap;
u_long	max_conind;
u_long	service_mode;
u_long	conn_mgmt;
u_long	xidtest;
{
	dl_bind_req_t	bind_req;
	struct	strbuf	ctl;
	int	flags;

	bind_req.dl_primitive = DL_BIND_REQ;
	bind_req.dl_sap = sap;
	bind_req.dl_max_conind = max_conind;
	bind_req.dl_service_mode = service_mode;
	bind_req.dl_conn_mgmt = conn_mgmt;
	bind_req.dl_xidtest_flg = xidtest;

	ctl.maxlen = 0;
	ctl.len = sizeof (bind_req);
	ctl.buf = (char *) &bind_req;

	flags = 0;

	if (putmsg(fd, &ctl, (struct strbuf*) NULL, flags) < 0)
		syserr("dlbindreq:  putmsg");
}

dlokack(fd, bufp)
int	fd;
char	*bufp;
{
	union	DL_primitives	*dlp;
	struct	strbuf	ctl;
	int	flags;

	ctl.maxlen = MAXDLBUF;
	ctl.len = 0;
	ctl.buf = bufp;

	strgetmsg(fd, &ctl, (struct strbuf*)NULL, &flags, "dlokack");

	dlp = (union DL_primitives *) ctl.buf;

	expecting(DL_OK_ACK, dlp);

	if (ctl.len < sizeof (dl_ok_ack_t))
		err("dlokack:  response ctl.len too short:  %d", ctl.len);

	if (flags != RS_HIPRI)
		err("dlokack:  DL_OK_ACK was not M_PCPROTO");

	if (ctl.len < sizeof (dl_ok_ack_t))
		err("dlokack:  short response ctl.len:  %d", ctl.len);
}

dlerrorack(fd, bufp)
int	fd;
char	*bufp;
{
	union	DL_primitives	*dlp;
	struct	strbuf	ctl;
	int	flags;

	ctl.maxlen = MAXDLBUF;
	ctl.len = 0;
	ctl.buf = bufp;

	strgetmsg(fd, &ctl, (struct strbuf*)NULL, &flags, "dlerrorack");

	dlp = (union DL_primitives *) ctl.buf;

	expecting(DL_ERROR_ACK, dlp);

	if (ctl.len < sizeof (dl_error_ack_t))
		err("dlerrorack:  response ctl.len too short:  %d", ctl.len);

	if (flags != RS_HIPRI)
		err("dlerrorack:  DL_OK_ACK was not M_PCPROTO");

	if (ctl.len < sizeof (dl_error_ack_t))
		err("dlerrorack:  short response ctl.len:  %d", ctl.len);
}

dlbindack(fd, bufp)
int	fd;
char	*bufp;
{
	union	DL_primitives	*dlp;
	struct	strbuf	ctl;
	int	flags;

	ctl.maxlen = MAXDLBUF;
	ctl.len = 0;
	ctl.buf = bufp;

	strgetmsg(fd, &ctl, (struct strbuf*)NULL, &flags, "dlbindack");

	dlp = (union DL_primitives *) ctl.buf;

	expecting(DL_BIND_ACK, dlp);

	if (flags != RS_HIPRI)
		err("dlbindack:  DL_OK_ACK was not M_PCPROTO");

	if (ctl.len < sizeof (dl_bind_ack_t))
		err("dlbindack:  short response ctl.len:  %d", ctl.len);
}

static void
sigalrm()
{
	(void) err("sigalrm:  TIMEOUT");
}

strgetmsg(fd, ctlp, datap, flagsp, caller)
int	fd;
struct	strbuf	*ctlp, *datap;
int	*flagsp;
char	*caller;
{
	int	rc;
	static	char	errmsg[80];

	/*
	 * Start timer.
	 */
	(void) signal(SIGALRM, sigalrm);
	if (alarm(MAXWAIT) < 0) {
		(void) sprintf(errmsg, "%s:  alarm", caller);
		syserr(errmsg);
	}

	/*
	 * Set flags argument and issue getmsg().
	 */
	*flagsp = 0;
	if ((rc = getmsg(fd, ctlp, datap, flagsp)) < 0) {
		(void) sprintf(errmsg, "%s:  getmsg", caller);
		syserr(errmsg);
	}

	/*
	 * Stop timer.
	 */
	if (alarm(0) < 0) {
		(void) sprintf(errmsg, "%s:  alarm", caller);
		syserr(errmsg);
	}

	/*
	 * Check for MOREDATA and/or MORECTL.
	 */
	if ((rc & (MORECTL | MOREDATA)) == (MORECTL | MOREDATA))
		err("%s:  MORECTL|MOREDATA", caller);
	if (rc & MORECTL)
		err("%s:  MORECTL", caller);
	if (rc & MOREDATA)
		err("%s:  MOREDATA", caller);

	/*
	 * Check for at least sizeof (long) control data portion.
	 */
	if (ctlp->len < sizeof (long))
		err("getmsg:  control portion length < sizeof (long):  %d", ctlp->len);
}

expecting(prim, dlp)
int	prim;
union	DL_primitives	*dlp;
{
	if (dlp->dl_primitive != (u_long)prim) {

                err("Didn't get expected dlpi result");
		exit(1);
	}
}

/*VARARGS1*/
err(fmt, a1, a2, a3, a4)
char	*fmt;
char	*a1, *a2, *a3, *a4;
{
	(void) fprintf(stderr, fmt, a1, a2, a3, a4);
	(void) fprintf(stderr, "\n");
	(void) exit(1);
}

syserr(s)
char	*s;
{
	(void) perror(s);
	exit(1);
}

strioctl(fd, cmd, timout, len, dp)
int	fd;
int	cmd;
int	timout;
int	len;
char	*dp;
{
	struct	strioctl	sioc;
	int	rc;

	sioc.ic_cmd = cmd;
	sioc.ic_timout = timout;
	sioc.ic_len = len;
	sioc.ic_dp = dp;
	rc = ioctl(fd, I_STR, &sioc);

	if (rc < 0)
		return (rc);
	else
		return (sioc.ic_len);
}

int init_interface()  /* Returns interface fd */
{

   long	buf[MAXDLBUF/sizeof(long)+1];

   char *device = "/dev/le";
   int ppa = 0;
   u_int chunksize = CHUNKSIZE;
   u_long snapsize = SNAPSIZE;
   struct timeval t;

   int if_fd;

   /* Open the device */
   if ((if_fd = open(device, 2)) < 0)
      syserr(device);

   /* Attach */
   dlattachreq(if_fd, ppa);
   dlokack(if_fd, buf);

   /* Enable promiscuous mode */
   dlpromisconreq(if_fd, DL_PROMISC_PHYS);
   dlokack(if_fd, buf);
   dlpromisconreq(if_fd, DL_PROMISC_SAP);
   dlokack(if_fd, buf);

   /* Bind */
   dlbindreq(if_fd, 0, 0, DL_CLDLS, 0, 0);
   dlbindack(if_fd, buf);

   /* Issue DLIOCRAW ioctl */
   if (strioctl(if_fd, DLIOCRAW, -1, 0, NULL) < 0)
      syserr("DLIOCRAW");

   /* Push and configure buffer module */
   if (ioctl(if_fd, I_PUSH, "bufmod") < 0)
      syserr("push bufmod");

   t.tv_sec = 0;
   t.tv_usec = 250000;	/* 0.25s */
   if (strioctl(if_fd, SBIOCSTIME, -1, sizeof (struct timeval), &t) < 0)
      syserr("SBIOCSTIME");
   if (strioctl(if_fd, SBIOCSCHUNK, -1, sizeof (u_int),	&chunksize) < 0)
      syserr("SBIOCSCHUNK");
   if (strioctl(if_fd, SBIOCSSNAP, -1, sizeof (u_long), &snapsize) < 0)
      syserr("SBIOCSSNAP");

   /* Flush the read side of the Stream */
   if (ioctl(if_fd, I_FLUSH, FLUSHR) < 0)
      syserr("I_FLUSH");

   return if_fd;
   }

unsigned long buf[CHUNKSIZE/sizeof(long)+1];
int bytes_left = 0;

void interface_read(fd)
int fd;
{
   struct strbuf data;
   struct sb_hdr *bp;
   unsigned char *p, *limp;
   int flags;

   data.buf = (char *)buf + bytes_left;
   data.maxlen = CHUNKSIZE-bytes_left;
   data.len = flags = 0;
   getmsg(fd, NULL, &data, &flags);
   data.len += bytes_left;
   p = (unsigned char *)buf;
   limp = p+data.len;
   for (;;) {
      bp = (struct sb_hdr *)p;
      if (p + bp->sbh_totlen > limp)
         break;  /* Only part of packet in buffer */
      lostpackets += bp->sbh_drops;
      if (bp->sbh_msglen != SNAPSIZE) {  /* Corrupted by bufmod */
         ++lostpackets;
         }
      else if (--sample_count == 0) {
         ++npackets;
         process_pkt(bp->sbh_origlen,
            (unsigned char *)p+ sizeof(struct sb_hdr));
         sample_count = SampleRate;
         }
      p+= bp->sbh_totlen;
      if (p == limp) break;  /* Buffer empty */
      }
   bytes_left = limp-p;  /* Save any part- packet left in the chunk */
   memmove(buf,p, bytes_left);
   }
#endif
