<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4 nowrap: */
// +----------------------------------------------------------------------+
// | ConPresso version 3                                                  |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2002 Bartels.Schoene GmbH & Co. KG., Muenster     |
// +----------------------------------------------------------------------+
// | This source file is subject to ConPresso license version 2002-11-16  |
// | that is bundled with this package in the files LICENSE_EN.TXT or     |
// | LICENSE_DE.TXT, and is available at through the world-wide-web at    |
// |    http: //www.conpresso.de/license/LICENSE_EN-2002-11-16.TXT or     |
// |    http: //www.conpresso.de/license/LICENSE_DE-2002-11-16.TXT        |
// | If you did not receive a copy of the ConPresso license and are       |
// | unable to obtain it through the world-wide-web, please send a note   |
// | to license@conpresso.de so we can mail you a copy immediately.       |
// +----------------------------------------------------------------------+
// | Authors: Thomas Walter <walter@bartels-schoene.de>                   |
// |          Tobias Musholt <musholt@bartels-schoene.de>                 |
// +----------------------------------------------------------------------+
//
// $Id: index2.php,v 1.6 2002/12/11 16:11:00 toby Exp $

    if ( $lang != '' ) {
        require("./lang/".$lang.".php");
    } else {
        require("./lang/deutsch.php");
    }


function endpage()
{
    // All settings that need to be transferred from page to page
    global $step, $verbose, $lang;
    // print("<input type=\"submit\" name=\"verbosity\" value=\"__Switch verbosity.\" />");
    print('<input type="hidden" name="step" value="'.$step.'" />');
    print('<input type="hidden" name="verbose" value="'.$verbose.'" />');
    print('<input type="hidden" name="lang" value="'.$lang.'" />');
    print('</form>');
    require("footer.php");
    print("</body>");
}

// set up some defaults
if (!isset($step)) $step = 1;
if (!isset($verbose)) $verbose = true;

if (isset($nextstep)) $step++;
if (isset($verbosity)) $verbose?$verbose=false:$verbose=true;

require("header.php");

// We shouldn't be here if file no $step doesn't exist, but check anyway
// at least it'll avoid an error-message
if (!file_exists("step".$step.".inc.php")) {
    print($LP_Huh);
    endpage();
    exit;
}

print("<form action=\"".$PHP_SELF."\" method=\"post\">");
require("step".$step.".inc.php");

if ($stepOK) {
    if (!file_exists("step".$step.".inc.php")) {
        endpage();
        exit;
    }

    if (file_exists("step".($step+1).".inc.php"))
        print("<input class=\"i0\" type=\"submit\" name=\"nextstep\" value=\"".$LP_Next."\">");
    endpage();
    exit;
}

print("<input class=\"i0\" type=\"submit\" name=\"retry\" value=\"".$LP_Next."\">");
endpage();
?>
