<?php
# vim: set expandtab tabstop=4 shiftwidth=4 nowrap: 
# ---------------------------------------------------------------------------
# ConPresso 3.x - Content Management
# ---------------------------------------------------------------------------
#       Datei/File:  /_content/clean.php
#    Beschr./Desc.:  Database-Cleanup
#    Firma/Company:  Bartels Schoene GmbH & Co. KG
#                    Corrensstr. 80, 48149 Muenster, Germany
#              URL:  www.conpresso.de | www.bartels-schoene.de 
#     Autor/Author:  Tobias Musholt - musholt@bartels-schoene.de
#        Co-Author:  Thomas 'Balu' Walter - walter@bartels-schoene.de 
#                    Stefan Heitmann - heitmann@bartels-schoene.de
#                    Steffen Schoene - schoene@bartels-schoene.de
#                    Ralf Margott - margott@bartels-schoene.de (grafic)
#   Lizenz/Licence:  LICENCE.txt
#  Erstellt/Create:  21-02-2002 - Tobias Musholt
# Aenderung/Change:  25-02-2002 - Tobias Musholt: insert this programhead
#
# ---------------------------------------------------------------------------
# Copyright (c) 2001 - Bartels Schoene GmbH & Co. KG - All rights reserved.
# ---------------------------------------------------------------------------

if (file_exists("../_cfg/const.php")) require("../_cfg/const.php");
else require("../_cfg/const.php.dist");


    require("../_include/header.php");
    require("../_include/category.inc.php");
    
    echo "<table width=\"".$WIDTH."\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\n";
    echo "<tr>\n";
    echo "<td class=\"header\">\n";
    echo "<b>".$LP_DB."</b>\n";
    echo "</td>\n";
    echo "</tr>\n";
    echo "<tr>\n";
    echo "<td class=\"text\"><br>\n";
    echo $LP_CleanText."<br><br>\n";
    echo "</td>\n";
    echo "</tr>\n";
    echo "</table><br>\n";

    if ( $id == 1 ) {
        $query = "SELECT kategorie FROM cpo_permission WHERE kategorie != '' ORDER BY kategorie";
        DEBUG(1, $query, __FILE__, __LINE__);   
        $db = new DB;
        $db->query($query);
    
        if ( $db->num_rows()>0 )
        { 
            while($db->next_record()):
                $kategorie = $db->v("kategorie");
                $kat_verz = strtolower($kategorie);
                $verzeichnis = is_dir ("../".$kat_verz);
                
                if ( $verzeichnis != 1 )
                {
                    $message .= $kat_verz." ... delete<br>";
                    $query = "DELETE FROM cpo_permission WHERE kategorie=\"".$kat_verz."\"";
                    DEBUG(1, $query, __FILE__, __LINE__);   
                    $db_2 = new DB;
                    $db_2->query($query); 
                    $query = "DELETE FROM cpo_images WHERE kategorie=\"".$kat_verz."\"";
                    DEBUG(1, $query, __FILE__, __LINE__);   
                    $db_2 = new DB;
                    $db_2->query($query); 
                    $query = "DELETE FROM cpo_files WHERE kategorie=\"".$kat_verz."\"";
                    DEBUG(1, $query, __FILE__, __LINE__);   
                    $db_2 = new DB;
                    $db_2->query($query); 
                    $query = "DELETE FROM cpo_news WHERE kategorie=\"".$kat_verz."\"";
                    DEBUG(1, $query, __FILE__, __LINE__);   
                    $db_2 = new DB;
                    $db_2->query($query); 
                    $query = "DELETE FROM cpo_rubric WHERE rubrik=\"".$kat_verz."\"";
                    DEBUG(1, $query, __FILE__, __LINE__);   
                    $db_2 = new DB;
                    $db_2->query($query); 
                    $query = "DELETE FROM cpo_tpl_assignment WHERE rubrik=\"".$kat_verz."\"";
                    DEBUG(1, $query, __FILE__, __LINE__);   
                    $db_2 = new DB;
                    $db_2->query($query); 
                }
            endwhile;
        } 

        $message = $LP_DB.": ".$LP_CleanLog;
        require("../_include/message.php");

        fkt_log($SID_login, $LOG_DB, $LP_CleanLog);

    }

    if ( $id == 2 ) {
        $query = "DELETE FROM cpo_block WHERE 1";
        DEBUG(1, $query, __FILE__, __LINE__);   
        $db = new DB;
          $db->query($query); 

        $message = $LP_DB.": ".$LP_CleanLog2;
        require("../_include/message.php");

        fkt_log($SID_login, $LOG_DB, $LP_CleanLog2);
    }
    
    if ( $id == 3 ) {

        $query = "SELECT article_nr FROM cpo_news WHERE artikel_archiv = '9'";
        DEBUG(1, $query, __FILE__, __LINE__);   
        $db = new DB;
        $db->query($query);
    
        if ( $db->num_rows()>0 )
        { 
            while($db->next_record()):
                $article_nr = $db->v("article_nr");
                $query = "DELETE FROM cpo_news WHERE article_nr = '".$article_nr."'";
                DEBUG(1, $query, __FILE__, __LINE__);   
                $db_2 = new DB;
                $db_2->query($query); 
            endwhile;
        } 

        $message = $LP_DB.": ".$LP_CleanLog3;
        require("../_include/message.php");

        fkt_log($SID_login, $LOG_DB, $LP_CleanLog3);
    }

        
    if ( $id == 4 ) {

        $query = "DELETE FROM cpo_news WHERE artikel_archiv = '5' OR artikel_archiv = '1'";
        DEBUG(1, $query, __FILE__, __LINE__);   
        $db = new DB;
        $db->query($query);

        $message = $LP_DB.": ".$LP_CleanLog4;
        require("../_include/message.php");

        fkt_log($SID_login, $LOG_DB, $LP_CleanLog4);
    }

    if ( $id == 5 ) {

        $datum = time()-2678400;
        
        $query = "DELETE FROM cpo_log WHERE datum < '".$datum."'";
        DEBUG(1, $query, __FILE__, __LINE__);   
        $db = new DB;
        $db->query($query);

        $message = $LP_DB.": ".$LP_CleanLog5;
        require("../_include/message.php");

        fkt_log($SID_login, $LOG_DB, $LP_CleanLog5);
    }

?>

    <table width="<?php echo $WIDTH ?>" border="0" cellpadding="3" cellspacing="2">
        <tr>
            <td colspan="2" bgcolor="<?php echo $color_tbg_dunkel; ?>" align="left" valign="middle" class="text">
                <b><?php echo $LP_DB ?></b>&nbsp;
            </td>
        </tr>
        <tr>
            <td width="30%" bgcolor="<?PHP echo $color_tbg_hell ?>" height="25" align="left" valign="middle" class="text"><?php echo $LP_Clean ?><br><img height="1" src="../_images/transparent.gif" alt="" border="0"><br></td>
            <td width="70%" bgcolor="<?PHP echo $color_data_hell ?>" align="left" valign="middle" class="text">
                <a href="clean.php?id=1" onClick="return confirm('<?php echo $LP_CleanOK ?>')">&raquo; <?php echo $LP_Run ?></a><?PHP help("SE020"); ?>
            </td>
        </tr>
        <tr>
            <td bgcolor="<?PHP echo $color_tbg_hell ?>" height="25" align="left" valign="middle" class="text"><?php echo $LP_Clean2 ?><br><img height="1" src="../_images/transparent.gif" alt="" border="0"><br></td>
            <td bgcolor="<?PHP echo $color_data_hell ?>" align="left" valign="middle" class="text">
                <a href="clean.php?id=2" onClick="return confirm('<?php echo $LP_CleanOK ?>')">&raquo; <?php echo $LP_Run ?></a><?PHP help("SE021"); ?>
            </td>
        </tr>
        <tr>
            <td bgcolor="<?PHP echo $color_tbg_hell ?>" height="25" align="left" valign="middle" class="text"><?php echo $LP_Clean3 ?><br><img height="1" src="../_images/transparent.gif" alt="" border="0"><br></td>
            <td bgcolor="<?PHP echo $color_data_hell ?>" align="left" valign="middle" class="text">
                <a href="clean.php?id=3" onClick="return confirm('<?php echo $LP_CleanOK ?>')">&raquo; <?php echo $LP_Run ?></a><?PHP help("SE022"); ?>
            </td>
        </tr>
        <tr>
            <td bgcolor="<?PHP echo $color_tbg_hell ?>" height="25" align="left" valign="middle" class="text"><?php echo $LP_Clean4 ?><br><img height="1" src="../_images/transparent.gif" alt="" border="0"><br></td>
            <td bgcolor="<?PHP echo $color_data_hell ?>" align="left" valign="middle" class="text">
                <a href="clean.php?id=4" onClick="return confirm('<?php echo $LP_CleanOK ?>')">&raquo; <?php echo $LP_Run ?></a><?PHP help("SE023"); ?>
            </td>
        </tr>
        <tr>
            <td bgcolor="<?PHP echo $color_tbg_hell ?>" height="25" align="left" valign="middle" class="text"><?php echo $LP_Clean5 ?><br><img height="1" src="../_images/transparent.gif" alt="" border="0"><br></td>
            <td bgcolor="<?PHP echo $color_data_hell ?>" align="left" valign="middle" class="text">
                <a href="clean.php?id=5" onClick="return confirm('<?php echo $LP_CleanOK ?>')">&raquo; <?php echo $LP_Run ?></a><?PHP help("SE024"); ?>
            </td>
        </tr>
    </table>    
<?php    
    
           
    // Untere Navigation
    require("../_include/footer.php");
?>
