//
//  XTParameterizedFont.m
//  TadsTerp
//
//  Created by Rune Berg on 18/08/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import "XTParameterizedFont.h"
#import "XTAllocDeallocCounter.h"


@implementation XTParameterizedFont

+ (id)fontWithName:(NSString *)name size:(CGFloat)size
{
	XTParameterizedFont *res = [XTParameterizedFont new];
	if (res != nil) {
		res.name = name;
		res.size = size;
	}
	return res;
}

OVERRIDE_ALLOC_FOR_COUNTER

OVERRIDE_DEALLOC_FOR_COUNTER

- (NSString *)description
{
	NSString *res = [NSString stringWithFormat:@"XTParameterizedFont name=\"%@\" size=%f",
					self.name, self.size];
	
	return res;
}

@end
