//
//  XTNotifications.m
//  XTads
//
//  Created by Rune Berg on 11/12/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import "XTNotifications.h"


@implementation XTNotifications

+ (void)notifyModalPanelOpened:(id)sender
{
	[[NSNotificationCenter defaultCenter] postNotificationName:XTadsNotifyModalPanelOpened object:sender];
}

+ (void)notifyModalPanelClosed:(id)sender
{
	[[NSNotificationCenter defaultCenter] postNotificationName:XTadsNotifyModalPanelClosed object:sender];
}

+ (void)notifyPrefsWindowClosed:(id)sender
{
	[[NSNotificationCenter defaultCenter] postNotificationName:XTadsNotifyPrefsWindowClosed object:self];
}

+ (void)notifyAboutWindowClosed:(id)sender
{
	[[NSNotificationCenter defaultCenter] postNotificationName:XTadsNotifyAboutWindowClosed object:self];
}

+ (void)notifyAboutTextLinkClicked:(id)sender linkText:(NSString *)linkText charIndex:(NSUInteger)charIndex;
{
	NSMutableDictionary *userInfo = [NSMutableDictionary dictionary];
	userInfo[XTadsNotificationUserInfoKeyLink] = linkText;
	userInfo[XTadsNotificationUserInfoKeyLinkCharIndex] = [NSNumber numberWithUnsignedInteger:charIndex];
	
	[[NSNotificationCenter defaultCenter] postNotificationName:XTadsNotifyTextLinkClicked
														object:sender
													  userInfo:userInfo];
}

+ (void)notifySetFocusToMainOutputView:(id)sender
{
	[[NSNotificationCenter defaultCenter] postNotificationName:XTadsNotifySetFocusToMainOutput object:sender];
}

@end
