//
//  XTFormattingSpecification.h
//  XTads
//
//  Created by Rune Berg on 02/06/2018.
//  Copyright © 2018 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "XTTextAlignMode.h"
//#import "XTOutputFormatterProtocol.h"
#import "XTTextTable.h"

@class XTHtmlTagA;
@class XTOutputFormatterProtocol;


@interface XTFormattingSpecification : NSObject

//TODO !!! tons more state - see CHtmlFontDesc, htmlsys.h l. 72

@property BOOL bold;
@property BOOL italic;
@property BOOL underline;
@property BOOL tt;
@property BOOL cite;
@property BOOL code;
@property BOOL em;
@property BOOL strong;
@property BOOL t2Hilite;
@property BOOL t2Italics;
@property NSInteger htmlSize;
@property NSArray *htmlFontFaceList;
@property NSString *fontColor;

//TODO !!! do these belong in this class? {
@property (weak) XTHtmlTagA *activeTagA;

@property (weak) XTTextTable *activeTextTable;
	//probably not right?
@property NSTextTableBlock *activeTextTableCell;
@property NSUInteger tableRowIndexPlusOne;
@property NSUInteger tableColumnIndexPlusOne;

@property NSUInteger listLevel;
@property BOOL inListItem;
@property BOOL inListItemAfterFirstParagraph;

@property NSUInteger blockquoteLevel;
// }

@property BOOL inAboutBox;

@property XTTextAlignMode textAlignMode;
	//TODO !!! not quite how html tads does it...
@property (readonly) NSString *textAlignModeAsString;

@property BOOL isInHeader;

@property BOOL hasRightAlignedTab;

+ (instancetype)specificationWithDefaults;

+ (instancetype)specificationFrom:(XTFormattingSpecification *)original;

- (NSInteger)getBaseHtmlSize;

- (void)resetForNextCommand;

@end
