//
//  XTRange.m
//  XTads
//
//  Created by Rune Berg on 14/09/2018.
//  Copyright © 2018 Rune Berg. All rights reserved.
//

#import "XTRange.h"
#import "XTAllocDeallocCounter.h"


@implementation XTRange

OVERRIDE_ALLOC_FOR_COUNTER
OVERRIDE_DEALLOC_FOR_COUNTER

+ (instancetype)rangeWithLocation:(NSUInteger)location length:(NSUInteger)length
{
	NSRange range = NSMakeRange(location, length);
	XTRange *rangeObj = [XTRange new];
	rangeObj.range = range;
	return rangeObj;
}

- (void)offsetLocationBy:(NSUInteger)offset
{
	self.range = NSMakeRange(self.range.location + offset, self.range.length);
}

@end
