//
//  XTHtmlTagHr.m
//  TadsTerp
//
//  Created by Rune Berg on 22/05/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import "XTHtmlTagHr.h"
#import "XTHtmlTag_private.h"
#import "XTBaseTextHandler.h"


@implementation XTHtmlTagHr

+ (NSString *)name
{
	return @"hr";
}

+ (BOOL)standalone
{
	return YES;
}

- (BOOL)blockLevel
{
	return YES;
}

- (void)format:(NSObject<XTOutputFormatterProtocol> *)formatter
   textHandler:(XTBaseTextHandler *)textHandler
{
	NSArray *formattedElements = [formatter handleHtmlTagHr:self];
	[textHandler receiveFormattedElements:formattedElements];
}

- (XTTextAlignMode)getTextAlignModeWithDefault:(XTTextAlignMode)defaultTextAlignMode
{
	XTTextAlignMode res = [super getTextAlignModeWithDefault:defaultTextAlignMode];

	if (res == XT_TEXT_ALIGN_JUSTIFY) {
		res = defaultTextAlignMode;
	}

	return res;
}

- (XTPair *)getWidthAsPercentageAndPoints
{
	NSNumber *widthAsPercentage = nil;
	NSNumber *widthAsPoints = nil;
	
	widthAsPercentage = [self attributeAsPercentage:@"width"];
	if (widthAsPercentage == nil) {
		widthAsPoints = [self attributeAsNumberWithOptionalSuffix:@"width"];
	}

	XTPair *res = [XTPair pairWithFirstObject:widthAsPercentage secondObject:widthAsPoints];
	return res;
}

@end
