#charset "us-ascii"
#include <advlite.h>

//Note: A few verbs are in other files, such as Photograph, which is
//in PDthings with the cell phone code.

//---------------------------------------------------------
// debugging actions
//---------------------------------------------------------

#ifdef __DEBUG

DefineIAction(Setup)
    execAction(cmd) {
        // playingCards.isFixed = nil;
        // tCheating.familiar = true;
        // monkeys.amenable = true;
        // me.knowsASL = true;
        // guardsGroup.startSurveillance();
        // joe.setState (joeNoPixies);
        // dragonTooth.isFixed = nil;
        // dragonTooth.imageNum = 5;
        // dragonTooth.carved = true;
        bianca.moveInto(behindCaboosePanel);
        me.virtuoso = true;
        "Setting things up for testing. ";
    }
;
VerbRule(Setup)
    'setup'
    : VerbProduction
    action = Setup
    verbPhrase = 'set/setting up stuff'
    missingQ = 'what, me worry'
;

DefineIAction(PowerOn)
    execAction(cmd) {
        junctionBox.isPowered = true;
        // dragonHead.showTeeth(true);
        "Turning on the power. ";
    }
;
VerbRule(PowerOn)
    'poweron'
    : VerbProduction
    action = PowerOn
    verbPhrase = 'turn/turning on the power'
    missingQ = 'what, me worry'
;

DefineIAction(PowerOff)
    execAction(cmd) {
        junctionBox.isPowered = nil;
        "Turning off the power. ";
    }
;
VerbRule(PowerOff)
    'poweroff'
    : VerbProduction
    action = PowerOff
    verbPhrase = 'turn/turning off the power'
    missingQ = 'would you like fries with that'
;

DefineIAction(Sesame)
    execAction (cmd) {
        for (local obj = firstObj(ShopDoorOutside) ; obj != nil ; obj = nextObj(obj, ShopDoorOutside))
        {
            obj.makeLocked(nil);
        }
        "All the shop doors are now magically unlocked! ";
    }
;
VerbRule(Sesame)
    'sesame'
    : VerbProduction
    action = Sesame
    verbPhrase = 'open/opening (what)'
;

#endif

DefineIAction(Xyzzy)
    execAction (cmd) {
        "Gesundheit! ";
    }
;
VerbRule(Xyzzy)
    'xyzzy'
    : VerbProduction
    action = Xyzzy
    verbPhrase = 'use/using the word \'xyzzy\''
;



//--------------------------------------------------------------------
// For the secret book, I hope:
//--------------------------------------------------------------------

DefineLiteralAction(TypeThatCodeOn)
    execAction(cmd) {
        if ((gPlayerChar.getOutermostRoom() != secretBook.getOutermostRoom()) || !secretBook.isOpen)
        {
            "There's nothing here to enter data on. ";
            abort;
        }
        // And now we know the data entry tablet is available:
        else {
            cmd.iobj = codeEntryTablet;
            TypeOn.exec(cmd);
        }
    }
;
VerbRule(TypeThatCodeOn)
    ('type' | 'enter') literalDobj
    : VerbProduction
    action = TypeThatCodeOn
    verbPhrase = 'type/typing what'
    missingQ = 'what do you want to type'
;

//--------------------------------------------------------------------
// Because players keep trying to spin the top:
//--------------------------------------------------------------------

DefineTAction(Spin);
VerbRule(Spin)
    'spin' singleDobj
    : VerbProduction
    action = Spin
    verbPhrase = 'spin/spinning (what)'
    missingQ = 'what do you want to spin'
;
modify Thing
    dobjFor(Spin) asDobjFor(Turn)
;

//--------------------------------------------------------------------
// Adding nice grammar for the motor in the pottery workshop:
//--------------------------------------------------------------------

DefineTAction(ScrewOn);

VerbRule(ScrewOn)
    (('screw' 'on' multiDobj) | ('screw' multiDobj ('back' | ) 'on'))
    : VerbProduction
    action = ScrewOn
    verbPhrase = 'screw/screwing on (what)'
    missingQ = 'what do you want to screw on'
;

modify Thing
    dobjFor(ScrewOn) {
        preCond = [touchObj]
        verify() { illogical ('{The subj dobj} {is} not in need of screwing back on. '); }
    }
;

// Amazingly, the library has no Start or Stop action. Also, there's a Follow
// action, but no StopFollowing action.

DefineTAction(Start);
VerbRule(Start)
    'start' singleDobj
    : VerbProduction
    action = Start
    verbPhrase = 'start/starting (what)'
    missingQ = 'what do you want to start'
;

DefineTAction(Stop);
VerbRule(Stop)
    'stop' singleDobj
    : VerbProduction
    action = Stop
    verbPhrase = 'stop/stopping (what)'
    missingQ = 'what do you want to stop'
;

// An alternative would be to make Start and Stop asDobjFor SwitchOn and SwitchOff.
modify Thing
    dobjFor(Start) {
        preCond = [touchObj]
        verify() { illogical ( '{The subj dobj} {is} not something you can start, or
            at least not with such a simple command. ' );
        }
    }
    dobjFor(Stop) {
        preCond = [touchObj]
        verify() { illogical ( '{The subj dobj} {is} not something you can stop,
            or at least not with such a simple command. ' );
        }
    }
;

// ------------------------------------------------------------------
// for Joe, a command:
// ------------------------------------------------------------------

DefineTAction(StopFollowing)
;
VerbRule(StopFollowing)
    'stop' 'following' singleDobj
    : VerbProduction
    action = StopFollowing
    verbPhrase = 'stop/stopping following'
    missingQ = 'who do you want to stop following'
;
modify Thing
    dobjFor(StopFollowing) {
        preCond = [objVisible]
        verify() { illogical ( 'You\'re not following {the dobj}. '); }
    }
;

//--------------------------------------------------------------------
// For commanding the monkeys -- utilizing code from the manual:
//--------------------------------------------------------------------

class SignTopic: TopicEntry
    includeInList = [&signList]
    notSensibleMsg = 'You make the ASL gesture for <q>' + matchPattern + ',</q> but nothing happens. '
;
    
DefineTopicAction(Sign)
    execAction(cmd){
       signManager.handleTopic(cmd.dobj.topicList);
    }
;

VerbRule(Sign)
    'sign' topicDobj
    : VerbProduction
    action = Sign
    verbPhrase = 'sign/signing (what)'
    missingQ = 'what did you want to sign'
;

signManager: PreinitObject, TopicDatabase
    execute() {        
        forEachInstance(Sign, new function(t) {
            if(t.location == self)
                addTopic(t);
        });
    }   
    handleTopic(top) {
        local match = getBestMatch(signList, top);
        if(match == nil) {
            if (me.hasSeen(monkeys)) say(noSignMsg);
            else say (noIdeaMsg);
        }
        else
            match.topicResponse();
    }
    
    signList = [tFollow, tWait, tStay, tPlay, tTake, tTakeInstruments]
    
    noSignMsg = 'You can\'t seem to remember the sign language gesture for that. '
    noIdeaMsg = 'Autographing miscellaneous things, even if you had a pen handy, wouldn\'t make
        much sense. '
;

tTake: SignTopic 'take'
     topicResponse() {
        if (!me.hasSeen(monkeys)) say (signManager.noIdeaMsg);
        else if (me.canSee(monkeys)) monkeys.signTake(); 
        else say (notSensibleMsg);
    }
;
tTakeInstruments: SignTopic 'take instruments'
     topicResponse() {
        if (!me.hasSeen(monkeys)) say (signManager.noIdeaMsg);
        else if (me.canSee(monkeys)) monkeys.signTake(); 
        else say (notSensibleMsg);
    }
;
tFollow: SignTopic 'follow'
    topicResponse() {
        if (!me.hasSeen(monkeys)) say (signManager.noIdeaMsg);
        else if (me.canSee(monkeys)) monkeys.signFollow(); 
        else say (notSensibleMsg);
    }
;
tWait: SignTopic 'wait'
    topicResponse() {
        if (!me.hasSeen(monkeys)) say (signManager.noIdeaMsg);
        else if (me.canSee(monkeys)) monkeys.signWait(); 
        else say (notSensibleMsg);
    }
;
tStay: SignTopic 'stay'
    topicResponse() {
        if (!me.hasSeen(monkeys)) say (signManager.noIdeaMsg);
        else if (me.canSee(monkeys)) monkeys.signWait(); 
        else say (notSensibleMsg);
    }
;
tPlay: SignTopic 'play'
    topicResponse() {
        if (!me.hasSeen(monkeys)) say (signManager.noIdeaMsg);
        else if (me.canSee(monkeys)) monkeys.signPlay(); 
        else say (notSensibleMsg);
    }
;

//tLearn: SignTopic 'learn'
//    topicResponse() {
//        if (!me.hasSeen(monkeys)) say (signManager.noIdeaMsg);
//        else if (me.canSee(monkeys)) monkeys.signLearn(); 
//        else say (notSensibleMsg);
//    }
//;

//--------------------------------------------------------------------
// For the seance:
//--------------------------------------------------------------------

VerbRule(Summon)
    'summon' singleDobj
    : VerbProduction
    action = Summon
    verbPhrase = 'summon/summoning (what)'
    missingQ = 'who do you want to summon'
;
DefineTAction(Summon);

modify Thing
    dobjFor(Summon) {
        verify() { illogical ( cannotBeSummonedMsg ); }
    }
    cannotBeSummonedMsg = 'You lack the magical ability to do that. '
;

// -------------------------------------------------------------------
// to retrieve or use the putter:
// -------------------------------------------------------------------

DefineTIAction(SlideInto);
VerbRule(SlideInto)
    'slide' singleDobj 'into' singleIobj
    : VerbProduction
    action = SlideInto
    verbPhrase = 'slide/sliding (what) (into what)'
    missingQ = 'what do you want to slide; what do you want to slide into that'
;
modify Thing
    dobjFor(SlideInto) {
        preCond = [objHeld]
        verify() { illogical ('You can\'t slide {the dobj} into anything. '); }
    }
    iobjFor(SlideInto) {
        preCond = [objVisible]
        verify() { illogical ('You can\'t slide things into {the iobj}. '); }
    }
;

DefineTAction(Putt);
VerbRule(Putt)
    'putt' singleDobj
    : VerbProduction
    action = Putt
    verbPhrase = 'putt/putting (what)'
    missingQ = 'what do you want to putt'
;
modify Thing
    dobjFor(Putt) {
        preCond = [objVisible]
        verify() {}
        check() {
            if (!putter.isIn(me)) "You have nothing to putt with. ";
            else "{The subj dobj} {are} not a golf ball. ";
        }
    }
;

//--------------------------------------------------------------------
// For opening the seed envelope:
//--------------------------------------------------------------------

DefineTAction(Tear);
VerbRule(Tear)
    ('tear' | 'rip') ('open' | ) singleDobj
    : VerbProduction
    action = Tear
    verbPhrase = 'tear/tearing (what)'
    missingQ = 'what do you want to tear'
;
modify Thing
    dobjFor(Tear) {
        preCond = [touchObj]
        verify() { illogical ( cannotBeTornMsg ); }
    }
    cannotBeTornMsg = '{The dobj} {are} not something that can be torn. '
;

//--------------------------------------------------------------------
// for sawing off the mummy's toe, and also for the sack of chow:
//--------------------------------------------------------------------

DefineTAction(Saw);
VerbRule(Saw)
    'saw' singleDobj
    : VerbProduction
    action = Saw
    verbPhrase = 'saw/sawing (what)'
    missingQ = 'what do you want to saw'
;

DefineTAction(SawOpen);
VerbRule(SawOpen)
    (('saw' singleDobj 'open') | ('saw' 'open' singleDobj))
    : VerbProduction
    action = SawOpen
    verbPhrase = 'saw/sawing open (what)'
    missingQ = 'what do you want to saw open'
;

modify Thing
    dobjFor(Saw) {
        preCond = [touchObj]
        verify() { illogical('{The subj dobj} {is} not in need of sawing. ');
        }
    }
    dobjFor(SawOpen) {
        preCond = [touchObj]
        verify() { illogical ('{The subj dobj} {is} not in need of being sawed open. '); }
    }
;

//--------------------------------------------------------------------
// for collecting the dirt with the armyHelmet:
//--------------------------------------------------------------------

DefineTIAction(ScoopWith);
VerbRule(ScoopWith)
    'scoop' ('up' | ) singleDobj ('with' | 'using' | 'into') singleIobj
    : VerbProduction
    action = ScoopWith
    verbPhrase = 'scoop/scooping up (what) (with what)'
    missingQ = 'what do you want to scoop; what do you want to scoop that with'
;
DefineTAction(Scoop);
VerbRule(Scoop)
    'scoop' ('up' | ) singleDobj
    : VerbProduction
    action = Scoop
    verbPhrase = 'scoop/scooping (what)'
    missingQ = 'what do you want to scoop'
;
modify Thing
    dobjFor(Scoop) {
        preCond = [touchObj]
        verify() {}
        check() {}
        action() { doInstead (Take, gDobj); }
    }
    dobjFor(ScoopWith) {
        preCond = [touchObj]
        verify() { illogical (cannotScoopMsg); }
    }
    iobjFor(ScoopWith) {
        preCond = [objVisible]
        verify() { illogical (cannotScoopWithMsg); }
    }
    cannotScoopMsg = '{The dobj} cannot be scooped up. '
    cannotScoopWithMsg = '{The iobj} cannot be used for scooping things. '
;

//--------------------------------------------------------------------
// For the cellPhone and idkCable:
//--------------------------------------------------------------------

DefineTIAction(HookTo);
VerbRule(HookTo)
    'hook' ('up' | ) singleDobj 'to' singleIobj
    : VerbProduction
    action = AttachTo
    verbPhrase = 'hook/hooking (what) (to what)'
    missingQ = 'what do you want to hook up; what do you want to hook up to that'
;

DefineTIAction(UnhookFrom);
VerbRule(UnhookFrom)
    'unhook' singleDobj 'from' singleIobj
    : VerbProduction
    action = DetachFrom
    verbPhrase = 'unhook/unhooking (what) (from what)'
    missingQ = 'what do you want to unhook; what do you want to unhook from that'
;    

DefineTAction(Unhook);
VerbRule(Unhook)
    'unhook' dobjList
    : VerbProduction
    action = Remove
    verbPhrase = 'unhook/unhooking (what)'
    missingQ = 'what do you want to unhook'
;

//-------------------------------------------------------------------------------
    // For the tank lid, some synonyms. For the octopus and the pixies, 'catch':
//-------------------------------------------------------------------------------
    
DefineTAction(Lift);
VerbRule(Lift)
    ('lift' | 'raise') singleDobj
    : VerbProduction
    action = Lift
    verbPhrase = 'lift/lifting (what)'
    missingQ = 'what do you want to lift'
;
modify Thing
    dobjFor(Lift) asDobjFor(Take)
;

DefineTAction(Catch);
VerbRule(Catch)
    ('catch' | 'capture') singleDobj
    : VerbProduction
    action = Catch
    verbPhrase = 'catch/catching (what)'
    missingQ = 'what do you want to catch'
;
modify Thing
    dobjFor(Catch) asDobjFor(Take)
;
DefineTIAction(CatchWith);
VerbRule(CatchWith)
    'catch' singleDobj ('with' | 'using' | 'in') singleIobj
    : VerbProduction
    action = CatchWith
    verbPhrase = 'catch/catching (what) (with what)'
    missingQ = 'what do you want to catch; what do you want to catch with that'
;
modify Thing
    dobjFor(CatchWith) {
        preCond = [objNotHeld]
        verify() { illogical ('{The subj dobj} is not in need of catching. '); }
    }
    iobjFor(CatchWith) {
        preCond = [objHeld]
        verify() { illogical ('{The subj iobj} can\'t be used for catching things. '); }
    }
;

// ------------------------------------------------------
// for the pixies and the eau, 'spray'
// ------------------------------------------------------

DefineTAction(Spray);
VerbRule(Spray)
    ('spray' | 'squirt' | 'spritz') singleDobj
    : VerbProduction
    action = Spray
    verbPhrase = 'spray/spraying (what)'
    missingQ = 'what do you want to spray'
;
DefineTIAction(SprayOn);
VerbRule(SprayOn)
    ('spray' | 'squirt' | 'spritz') singleDobj ('on' | 'onto') singleIobj
    : VerbProduction
    action = SprayOn
    verbPhrase = 'spray/spraying (what) (on what)'
    missingQ = 'what do you want to spray; what do you want to spray on that'
;
modify Thing
    dobjFor(Spray) {
        preCond = [objHeld]
        verify() { illogical ( '{The dobj} cannot be sprayed. ' );
        }
    }
    dobjFor(SprayOn) {
        preCond = [objHeld]
        verify() { illogical ( '{The dobj} cannot be sprayed on anything. ' );
        }
    }
    iobjFor(SprayOn) {
        verify() {
            illogical ( 'Spraying something on {the iobj} probably won\'t be very useful. ' );
        }
    }
;

//-------------------------------------------------------
// An extra way to get behind the stairs:
//-------------------------------------------------------

DefineTAction(GoBehind);
VerbRule(GoBehind)
    ('go' | 'steo') 'behind' singleDobj
    : VerbProduction
    action = GoBehind
    verbPhrase = 'go/going (behind what)'
    missingQ = 'what do you want to go behind'
;

modify Thing
    dobjFor(GoBehind) {
        preCond = [objVisible]
        verify() { illogical('There\'s probably no way to go behind {the dobj}. If you\'re
            convinced this isn\'t correct, you could try using a different command. ');
        }
    }
;

// ------------------------------------------------------
// for the cigar:
// ------------------------------------------------------

DefineTAction(Smoke);
VerbRule(Smoke)
    'smoke' singleDobj
    : VerbProduction
    action = Smoke
    verbPhrase = 'smoke/smoking (what)'
    missingQ = 'what do you want to smoke'
;
modify Thing
    dobjFor(Smoke) {
        verify() { illogical ('{The subj dobj} {is} not something you can smoke. '); }
    }
;

//-------------------------------------------------------
// Because the savvy player may try 'unclasp the book':
//-------------------------------------------------------

DefineTAction(Unclasp);
VerbRule(Unclasp)
    'unclasp' singleDobj
    : VerbProduction
    action = Unclasp
    verbPhrase = 'unclasp/unclasping (what)'
    missingQ = 'what do you want to unclasp'
;

modify Thing
    dobjFor(Unclasp) asDobjFor(Open)
;
            


// Probably not needed -- included here for archival purposes:

DefineIAction(UnclaspLiteral)
    execAction(cmd) {
        if (gPlayerChar.getOutermostRoom != rareBookShop) {
            "You mumble an obscure phrase from <i>Henry the Fourth, Part I.</i> Nothing happens. ";
            exit;
        }
        if (!shelfDoor.isOpen)
            "<<one of>>You utter a well-remembered phrase from <i>Henry the Fourth, Part I.</i> For a moment
            it seems the bust of Shakespeare might have heard you. Did its eyes flick in your direction?
            Or was that only a trick of the light? <<or>>Again you speak the phrase from <i>Henry
            the Fourth.</i> With a faint creaking noise, the bust of Shakespeare
            rotates a fraction of an inch in your direction. It definitely seems to recognize the
            phrase. <<or>>The bust of Shakespeare makes a faint mumbling noise, as if trying to
            speak. <<or>>Nothing happens. Possibly the bust of Shakespeare has given up on you. <<stopping>>";
        else
            "The bust of Shakespeare hums happily to itself as you repeat the sonorous phrase. ";
    }
;
VerbRule(UnclaspLiteral)
    'unclasp' 'a' 'secret' 'book'
    : VerbProduction
    action = UnclaspLiteral
    verbPhrase = 'unclasp/unclasping'
    missingQ = 'what did you want to unclasp'
;

//-------------------------------------------------------
// For the nightingale:
//-------------------------------------------------------

DefineTAction(WindUp);
VerbRule(WindUp)
    'wind' ('up' | ) singleDobj
    : VerbProduction
    action = WindUp
    verbPhrase = 'wind/winding up (what)'
    missingQ = 'what do you want to wind up'
;
DefineTIAction(WindUpWith);
VerbRule(WindUpWith)
    'wind' ('up' | ) singleDobj ('with' | 'using') singleIobj
    : VerbProduction
    action = WindUpWith
    verbPhrase = 'wind/winding up (what) (with what)'
    missingQ = 'what do you want to wind up; what do you want to wind up with that'
;
modify Thing
    dobjFor(WindUp) {
        preCond = [touchObj]
        verify() { illogical(cannotWindUpMsg); }
    }
    dobjFor(WindUpWith) {
        preCond = [touchObj]
        verify() { illogical(cannotWindUpMsg); }
    }
    iobjFor(WindUpWith) {
        preCond = [objHeld]
        verify() { 
            if (gIobj)
                illogical('{The iobj} cannot be used for winding things. ');
        }
    }
    cannotWindUpMsg = '{The dobj} {is} not something that can be wound up. '
;
    
//-------------------------------------------------------
// For the trumpet:
//-------------------------------------------------------

DefineTAction(Play);
VerbRule(Play)
    'play' singleDobj
    : VerbProduction
    action = Play
    verbPhrase = 'play/playing (what)'
    missingQ = 'what do you want to play'
;
modify Thing
    dobjFor(Play) {
        preCond = [objHeld]
        verify() {
            illogical ('{The subj dobj} {is} not a musical instrument. ');
        }
    }
;

//-------------------------------------------------------
// For the underside of the diorama:
//-------------------------------------------------------

DefineTAction(ReachInto);
VerbRule(ReachInto)
    ('reach' | ('put' 'hand')) ('in' | 'into' | 'through') singleDobj
    : VerbProduction
    action = ReachInto
    verbPhrase = 'reach/reaching into (what)'
    missingQ = 'what do you want to reach into'
;
modify Thing
    dobjFor(ReachInto) asDobjFor(Search)
;

//-------------------------------------------------------
// for the stepladder:
//-------------------------------------------------------

DefineTAction(Fold);
VerbRule(Fold)
    (('fold' ('up' | )| 'collapse')) singleDobj
    : VerbProduction
    action = Fold
    verbPhrase = 'fold/folding (what)'
    missingQ = 'what do you want to fold'
    dobjReply = singleNoun
;
DefineTAction(Unfold);
VerbRule(Unfold)
    'unfold' singleDobj
    : VerbProduction
    action = Unfold
    verbPhrase = 'unfold/unfolding (what)'
    missingQ = 'what do you want to unfold'
    dobjReply = singleNoun
;
modify Thing
    dobjFor(Fold) {
        preCond = [touchObj]
        check() {
            "{The subj dobj} {is} not something that can be folded. ";
        }
    }
    dobjFor(Unfold) {
        preCond = [touchObj]
        check() {
            "{The subj dobj} {is} not something that can be unfolded. ";
        }
    }
;

//------------------------------------------------------
// modifying LookIn to add 'look into', on account of
// the telescope and binoculars
//------------------------------------------------------

modify VerbRule(LookIn)
    ('look' | 'l') ('in' | 'inside' | 'into') multiDobj
    :
;

//-------------------------------------------------------
// adding 'ascend' and 'descend' to the library grammar:
//-------------------------------------------------------

modify VerbRule(ClimbUp)
    ((('climb' | 'go' | 'walk') ('up' | )) | 'ascend') singleDobj
    :
;

modify VerbRule(ClimbDown)
    ((('climb' | 'go' | 'walk') 'down') | 'descend') singleDobj
    :
;

//-------------------------------------------------------
// For the buttons in World Headquarters:
//-------------------------------------------------------

DefineTAction(Hold);
VerbRule(Hold)
    ('hold' | (('push' | 'press') 'and' 'hold')) singleDobj
    : VerbProduction
    action = Hold
    verbPhrase = 'hold/holding (what)'
    missingQ = 'what do you want to hold'
;
modify Thing
    dobjFor(Hold) asDobjFor(Take)
;

//-------------------------------------------------------
// For the brake lever in the Lamborghini:
//-------------------------------------------------------

DefineTAction(Release);
VerbRule(Release)
    'release' singleDobj
    : VerbProduction
    action = Release
    verbPhrase = 'release/releasing (what)'
    missingQ = 'what do you want to release'
;
modify Thing
    dobjFor(Release) {
        preCond = [touchObj]
        verify() {
            illogical ('{The subj dobj} {is} not confined, and thus not in need of release. ');
        }
    }
;

//-------------------------------------------------------
// For the HVAC switch:
//-------------------------------------------------------

DefineTAction(Oil);
VerbRule(Oil)
    ('oil' | 'lubricate') singleDobj
    : VerbProduction
    action = Oil
    verbPhrase = 'oil/oiling (what)'
    missingQ = 'what do you want to oil'
;
DefineTIAction(OilWith);
VerbRule(OilWith)
    ('oil' | 'lubricate') singleDobj 'with' singleIobj
    : VerbProduction
    action = OilWith
    verbPhrase = 'oil/oiling (what) (with what)'
    missingQ = 'what do you want to oil that with; what do you want to oil with that'
;
modify Thing
    dobjFor(Oil) {
        preCond = [touchObj]
        verify() { illogical ('{The subj dobj} {is} not something that can be oiled. ');
        }
    }
    //cannotOilMsg = '{The subj dobj} is not something that can be oiled. '
    dobjFor(OilWith) {
        preCond = [touchObj]
        verify() { illogical ('{The subj dobj} is not something that can be oiled. ');
        }
    }
    iobjFor(OilWith) {
        preCond = [objHeld]
        verify() { illogical ('{The subj iobj} cannot be used for lubricating things. ');
        }
    }
;

//-------------------------------------------------------
// For the army helmet and the fish:
//-------------------------------------------------------

DefineTAction(Fill);
VerbRule(Fill)
    'fill' singleDobj
    : VerbProduction
    action = Fill
    verbPhrase = 'fill/filling (what)'
    missingQ = 'what do you want to fill'
;
DefineTIAction(FillWith);
VerbRule(FillWith)
    'fill' singleDobj 'with' singleIobj
    : VerbProduction
    action = FillWith
    verbPhrase = 'fill/filling (what) (with what)'
    missingQ = 'what do you want to fill with that; what do you want to fill that with'
;
modify Thing
    dobjFor(Fill) {
        preCond = [touchObj]
        verify() {
            if (contType != In) illogical ('{The subj dobj} is not suitable for filling. ');
            else illogical ('To fill {the dobj}, just put things in it in the ordinary way. ');
        }
    }
    dobjFor(FillWith) {
        preCond = [touchObj]
        verify() {
            if (contType != In) illogical ('{The subj dobj} is not suitable for filling. ');
            else illogical ('To fill {the dobj}, just put things in it in the ordinary way. ');
        }
    }
    iobjFor(FillWith) {
        preCond = [touchObj]
        verify() {
            illogical ('{The subj iobj} {is} not suitable for filling things. ');
        }
    }
;
  
DefineTAction(Empty);
VerbRule(Empty)
    ('empty' | ('pour' 'out')) dobjList
    : VerbProduction
    action = Empty
    verbPhrase = 'empty/emptying (what)'
    missingQ = 'what do you want to empty'
;
modify Thing
    dobjFor(Empty) {
        preCond = [touchObj]
        verify() {
            if (contType != In) illogical ('{The subj dobj} {is} not something that can be emptied. ');
        }
    }
;
// This worries me. There can be invisible contents. But it seems to work with the purse
// and the makeup mirror.
modify Container
    dobjFor(Empty) {
        check() {
            if (contents.car() == nil) "There's nothing in {the dobj}. ";
        }
        action() {
            local loc = gPlayerChar.location.dropLocation;
            if (isOpenable && !isOpen) {
                makeOpen(true);
                "(First opening {the dobj}...) ";
            }
            while (contents.car())
                contents.car().moveInto(loc);
            "You summarily dump out everything in {the dobj}. ";
        }
    }
;

DefineTIAction(EmptyInto);
VerbRule(EmptyInto)
    'empty' singleDobj 'into' singleIobj
    : VerbProduction
    action = EmptyInto
    verbPhrase = 'empty/emptying (what) (into what)'
    missingQ = 'what do you want to empty into that; what do you want to empty that into'
;
DefineTIAction(EmptyOnto);
VerbRule(EmptyOnto)
    'empty' singleDobj 'onto' singleIobj
    : VerbProduction
    action = EmptyOnto
    verbPhrase = 'empty/emptying (what) (onto what)'
    missingQ = 'what do you want to empty onto that; what do you want to empty that onto'
;
modify Thing
    dobjFor(EmptyInto) asDobjFor(PourInto)
    iobjFor(EmptyInto) asIobjFor(PourInto)
    dobjFor(EmptyOnto) asDobjFor(PourOnto)
    iobjFor(EmptyOnto) asIobjFor(PourOnto)
;

//-------------------------------------------------------
// For the rope:
//-------------------------------------------------------

DefineTIAction(TieTo);
VerbRule(TieTo)
    'tie' singleDobj ('to' | 'around') singleIobj
    : VerbProduction
    action = TieTo
    verbPhrase = 'tie/tying (what) (to what)'
    missingQ = 'what do you want to tie to that; what do you want to tie that to'
;
modify Thing
    dobjFor(TieTo) {
        preCond = [objHeld]
        verify() { illogical ('{The subj dobj} can\'t be tied to anything. '); }
    }
    iobjFor(TieTo) {
        preCond = [objVisible]
        verify() { illogical ('Nothing can be tied to {the iobj}. '); }
    }
;

DefineTAction(Untie);
VerbRule(Untie)
    'untie' singleDobj
    : VerbProduction
    action = Untie
    verbPhrase = 'untie/untying (what)'
    missingQ = 'what do you want to untie'
;
modify Thing
    dobjFor (Untie) {
        preCond = [objVisible]
        verify () { illogical ( '{The subj dobj} {is} not tied to anything. '); }
    }
;
// Note: Need to add UntieFrom?
        

//-------------------------------------------------------
// For the Buddha statue:
//-------------------------------------------------------

DefineTIAction(ShineOn);
VerbRule(ShineOn)
    'shine' singleDobj ('at' | 'on') singleIobj
    : VerbProduction
    action = ShineOn
    verbPhrase = 'shine/shining (what) (on what)'
    missingQ = 'what do you want to shine on that; what do you want to shine that on'
;
modify Thing
    dobjFor(ShineOn) {
        preCond = [touchObj]
        verify() { illogical ('{The subj dobj} {is} not shining. ');
        }
    }
    iobjFor(ShineOn) {
        preCond = [objVisible]
        check() {
            "Shining {the dobj} on {the iobj} has no visible effect. ";
        }
    }
;

DefineTIAction(HoldIn);
VerbRule(HoldIn)
    ('hold' | 'position') singleDobj ('in' | 'under') singleIobj
    : VerbProduction
    action = HoldIn
    verbPhrase = 'hold/holding (what) (in what)'
    missingQ = 'what do you want to hold in that; what do you want to hold that in'
;
modify Thing
    dobjFor(HoldIn) {
        preCond = [touchObj]
        verify() {}
        check() {
            if (!gDobj.isIn(gIobj))
            "Holding {the dobj} in {the iobj} would be somewhat impractical. ";
        }
        action() {
            doInstead(Take, gDobj);
        }
    }
    iobjFor(HoldIn) {
        preCond = [objVisible]
        verify() {}
        check() {
            if (!gDobj.isIn(gIobj))
            "Holding {the dobj} in {the iobj} would be rather impractical. ";
        }
    }
;

DefineTIAction(AimAt);
VerbRule(AimAt)
    ('aim' | 'point' | 'direct') singleDobj ('at' | 'toward') singleIobj
    : VerbProduction
    action = AimAt
    verbPhrase = 'aim/aiming (what) (at what)'
    missingQ = 'what do you want to aim it at; what do you want to aim at that'
;
modify Thing
    dobjFor(AimAt) {
        preCond = [objHeld]
        verify() { illogical ('Pointing {the dobj} at {the iobj} would serve no
            immediate purpose. ');
        }
    }
    iobjFor(AimAt) {
        preCond = [objVisible]
        verify() { illogical ('Pointing {the dobj} at {the iobj} would serve no
            immediate purpose. ');
        }
    }
;

// And a bit more for the rolltop desk:

DefineTIAction(TouchWith);
VerbRule(TouchWith)
    'touch' singleDobj ('with' | 'using') singleIobj
    : VerbProduction
    action = TouchWith
    verbPhrase = 'touch/touching (what) (with what)'
    missingQ = 'what do you want to touch with it; what do you want to touch that with'
;
modify Thing
    dobjFor(TouchWith) {
        preCond = [objVisible]
        verify() {}
        check() { "Nothing obvious happens. "; }
    }
    iobjFor(TouchWith) {
        preCond = [objHeld]
        verify() {}
        check() { "Nothing obvious happens. "; }
    }
;

DefineTAction(Wave);
VerbRule(Wave)
    'wave' singleDobj
    : VerbProduction
    action = Wave
    verbPhrase = 'wave/waving (what)'
    missingQ = 'what do you want to wave'
;
DefineTIAction(WaveAt);
VerbRule(WaveAt)
    'wave' singleDobj 'at' singleIobj
    : VerbProduction
    action = WaveAt
    verbPhrase = 'wave/waving (what) (at what)'
    missingQ = 'what do you want to wave it at; what do you want to wave at that'
;
modify Thing
    dobjFor(Wave) {
        preCond = [objHeld]
        verify() {}
        check() {
            "You wave {the dobj} in the air for a moment. ";
        }
    }
    dobjFor(WaveAt) {
        preCond = [objHeld]
        verify() {}
        check() {
            "You wave {the dobj} in the air for a moment. ";
        }
    }
    iobjFor(WaveAt) {
        preCond = [objVisible]
        verify() {}
        check() {
            "Waving at {the iobj} has no obvious effect. ";
        }
    }
;

// ------------------------------------------------------
// because you have a phone:
// ------------------------------------------------------

DefineTAction(Call);
VerbRule(Call)
    ('call' | 'phone' | 'text') singleDobj
    : VerbProduction
    action = Call
    verbPhrase = 'call/calling someone'
    missingQ = 'who did you want to call'
;
modify Thing
    dobjFor(Call) {
        verify() {}
        check() {
            if (!cellPhone.isDirectlyIn(me)) "You don't seem to be holding your phone. ";
            else "Your phone isn't much good for making calls anymore. ";
        }
    }
;

// ------------------------------------------------------
// another useless verb:
// ------------------------------------------------------

DefineTAction(Ride);
VerbRule(Ride)
    ('ride' | 'mount') ('in' | 'on' |) singleDobj
    : VerbProduction
    action = Ride
    verbPhrase = 'ride/riding (what)'
    missingQ = 'what do you want to ride'
;
modify Thing
    dobjFor(Ride) {
        verify() { illogical ( '{The dobj} cannot be ridden. '); }
    }
;

// ------------------------------------------------------
// for the signet ring:
// ------------------------------------------------------

DefineTIAction(PressInto);
VerbRule(PressInto)
    'press' singleDobj ('in' | 'into' | 'onto' | 'on') singleIobj
    : VerbProduction
    action = PressInto
    verbPhrase = 'press/pressing (what) (into what)'
    missingQ = 'what do you want to press it into; what do you want to press into that'
;
modify Thing
    dobjFor(PressInto) {
        preCond = [objHeld]
        verify() { illogical ('Pressing {the dobj} into things would serve no obvious
            or immediate purpose. ');
        }
    }
    iobjFor(PressInto) {
        preCond = [objVisible]
        verify() { illogical ('Pressing things into {the iobj} would serve no obvious
            or immediate purpose. ');
        }
    }
;

// ------------------------------------------------------
// For the mummy, for fun:
// ------------------------------------------------------

DefineTAction(Unwrap);
VerbRule(Unwrap)
    'unwrap' singleDobj
    : VerbProduction
    action = Unwrap
    verbPhrase = 'unwrap/unwrapping (what)'
    missingQ = 'what do you want to unwrap'
;
modify Thing
    dobjFor(Unwrap) {
        preCond = [objVisible]
        verify() { illogical ( '{The dobj} is not in need of unwrapping. ' ); }
    }
;
        
//-------------------------------------------------------
// For crawling under the diorama:
//-------------------------------------------------------

DefineTAction(CrawlUnder);
VerbRule(CrawlUnder)
    ('crawl' | 'go' | 'get') 'under' singleDobj
    : VerbProduction
    action = CrawlUnder
    verbPhrase = 'crawl/crawling under (what)'
    missingQ = 'what do you want to crawl under'
;
modify Thing
    dobjFor(CrawlUnder) {
        preCond = [touchObj]
        verify() {
            if (isIn(gPlayerChar)) {
                if (!isWornBy(gPlayerChar)) illogical ('You can\'t very well get under
                    something while you\'re carrying it. ');
                else illogical ('You can\'t very well get under something while
                    you\'re wearing it. ');
            }
            else illogical ('{The subj dobj} is not something you can get under. ');
        }
    }
;

//----------------------------------------------------------------
// For the telescope, but really for anything:
//----------------------------------------------------------------

DefineTIAction (LookAtThrough);

VerbRule(LookAtThrough)
    ('examine' | 'inspect' | 'x' | 'look' 'at' | 'l' 'at' | 'watch') singleDobj ('through' | 'with' | 'using') singleIobj
    : VerbProduction
    action = LookAtThrough
    verbPhrase = 'examine/examining (what) (through what)'
    missingQ = 'what do you want to examine;what do you want to examine through that'
;
modify Thing
    dobjFor(LookAtThrough) {
        preCond = [objVisible]
        verify() {}
        check() {
            if (gIobj && !gIobj.isOptical) "Why not just look at {that dobj} in the usual way? ";
        }
    }
    iobjFor(LookAtThrough) {
        preCond = [objVisible]
        verify() { illogical ('{The subj iobj} {is} not an optical instrument. ');
        }
    }
;

// ------------------------------------------------------
// Because there's a pond:
// ------------------------------------------------------

DefineIAction(Swim)
    execAction (c) {
        "You didn\'t bring a swimsuit. ";
    }
;
VerbRule(Swim)
    'swim'
    : VerbProduction
    action = Swim
    verbPhrase = 'swim/swimming'
;

DefineTAction(SwimIn);
VerbRule(SwimIn)
    'swim' 'in' singleDobj
    : VerbProduction
    action = SwimIn
    verbPhrase = 'swim/swimming in (what)'
    missingQ = 'what do you want to swim in'
;

modify Thing
    dobjFor(SwimIn) {
        verify () { illogical ( '{The subj dobj} {is} not something you can swim in. ' ); }
    }
;

//-------------------------------------------------------
// For the Travel Guide:
//-------------------------------------------------------
// This may later become unnecessary, if I use the flexible
// ConsultTopic...

DefineLiteralAction(ReadLiteral)
    execAction(cmd) {
        if (travelGuide.isIn(gPlayerChar)) {
            doInstead(ReadLiteralIn, travelGuide, gLiteral);
        }
        else if (travelGuide.isIn(gPlayerChar.getOutermostRoom))
            "To read specific pages in the Travel Guide, you need to be holding it. ";
        else "It's not clear what you're trying to do. ";
    }
;
VerbRule(ReadLiteral)
    (('read' | 'consult' | ('turn' 'to') | ('look' ('up' | 'at'))) | (('x' | 'examine' | 'consult') 'page')) literalDobj
     : VerbProduction
     action = ReadLiteral
     verbPhrase = 'read/reading (what)'
     missingQ = 'what do you want to read'
;

DefineLiteralTAction(ReadLiteralIn);
VerbRule(ReadLiteralIn)
    ('read' | ('turn' 'to') | ('look' ('up' | 'at')) literalDobj 'in' singleIobj) |
    ('open' singleDobj 'to' literalIobj)
    : VerbProduction
    action = ReadLiteralIn
    verbPhrase = 'read/reading (what) (in what)'
    missingQ = 'what do you want to read; what do you want to read that in'
    iobjReply = singleNoun
    // priority = 60 // Probably useful, not sure why....
;
modify Thing
    dobjFor (ReadLiteralIn) {
        verify() { }
        check() {
            "Nothing is written in {the iobj}. ";
        }
    }
;

//-------------------------------------------------------
// For the beauty parlor:
//-------------------------------------------------------

DefineTAction(KnockOn);
VerbRule(KnockOn)
    ('knock' | 'pound' | 'tap') ('on' | 'at') singleDobj
    : VerbProduction
    action = KnockOn
    verbPhrase = 'knock/knocking (on what)'
    missingQ = 'what did you want to knock on'
;
modify Thing
    dobjFor(KnockOn) {
        preCond = [touchObj]
        action() {
            "You tap gently on {the dobj}, but nothing happens. ";
        }
    }
;
modify Actor
    dobjFor(KnockOn) {
        check() {
            "That would hardly be polite. ";
        }
    }
;
DefineIAction(Knock)
    execAction(cmd) {
        "You'll need to say what you want to knock on. ";
    }
;
VerbRule(Knock)
    'knock'
    : VerbProduction
    action = Knock
    verbPhrase = 'knock/knocking'
    missingQ = 'what did you want to knock on'
;

//-------------------------------------------------------
// For the ocelot, and probably for other things:
//-------------------------------------------------------

DefineTAction(Pat);
VerbRule(Pat)
    ('pat' | 'pet') singleDobj
    : VerbProduction
    action = Pat
    verbPhrase = 'pat/patting (what)'
    missingQ = 'what did you want to pat'
;
modify Thing
    dobjFor(Pat) asDobjFor(Feel)
;

//-------------------------------------------------------
// For the dart and StunGums:
//-------------------------------------------------------

DefineTAction(Stab);
VerbRule(Stab)
    'stab' singleDobj
    : VerbProduction
    action = Stab
    verbPhrase = 'stab/stabbing (what)'
    missingQ = 'what did you want to stab'
;
modify Thing
    dobjFor(Stab) {
        preCond = [touchObj]
        verify() {
            illogical ('{The subj dobj} {is} not something that\'s in need
                of stabbing. ');
        }
    }
;

DefineTIAction(JabWith);
VerbRule(JabWith)
    ('jab' | 'poke' | 'stab') singleDobj 'with' singleIobj
    : VerbProduction
    action = JabWith
    verbPhrase = 'jab/jabbing (what) (with what)'
    missingQ = 'what did you want to jab with that; what did you want to jab'
;

DefineTIAction(JabInto);
VerbRule(JabInto)
    ('jab' | 'poke' | 'jam' | 'stuff' | 'stab') singleDobj ('in' | 'into' | 'through') singleIobj
    : VerbProduction
    action = JabInto
    verbPhrase = 'jab/jabbing (what) (into what)'
    missingQ = 'what did you want to jab; what did you want to jab that into'
;

modify Thing
    dobjFor(JabInto) asDobjFor(PutIn)
    iobjFor(JabInto) asIobjFor(PutIn)
    dobjFor(JabWith) {
        preCond = [touchObj]
        verify() {
            illogical ('Poking holes in {the dobj} is unlikely to be productive. ');
        }
    }
    iobjFor(JabWith) {
        preCond = [objHeld]
        verify() {
            illogical ('{The subj iobj} {has} no suitable sharp point with which to
                jab anything. ');
        }
    }
    // we'll also override the library code, to allow the dart to disappear:
    iobjFor(ThrowAt) {
        preCond = [objVisible]
        verify() {
            if(!canThrowAtMe)
                illogical(cannotThrowAtMsg);
            if(gDobj == self)
                illogical(cannotThrowAtSelfMsg);
        }
        action() {            
            if (gDobj.isDirectlyIn(gPlayerChar))
                gDobj.actionMoveInto(getOutermostRoom.dropLocation);
        }
        report(){
            local obj = gActionListObj;
            gMessageParams(obj);
            DMsg(throw at, '{The subj obj} narrowly miss{es/ed} {the iobj} and land{s/ed}
                harmlessly on the ground. ');            
        }
    }
;

// ------------------------------------------------------------
// Because there are cars in the game:
// ------------------------------------------------------------
DefineTAction(Drive);
VerbRule(Drive)
    'drive' singleDobj
    : VerbProduction
    action = Drive
    verbPhrase = 'drive/driving (what)'
    missingQ = 'what do you want to drive'
;
modify Thing
    dobjFor(Drive) {
        preCond = [touchObj]
        verify() { illogical ( '{The subj dobj} {is} not something you can drive. ' ); }
    }
;

// ------------------------------------------------------------
// Helper grammar for the Octagonal Room:
// ------------------------------------------------------------

DefineTAction(ExitVia);
VerbRule(ExitVia)
    ('exit' | 'leave') ('via' | 'through') singleDobj
    : VerbProduction
    action = ExitVia
    verbPhrase = 'leave/leaving via (what)'
    missingQ = 'what do you want to leave through'
;
modify Thing
    dobjFor(ExitVia) asDobjFor(GoThrough)
;


//------------------------------------------------------------------
// For the famous rope trick:
//------------------------------------------------------------------

DefineTAction(Lower);
VerbRule(Lower)
    ('lower' | 'dangle') singleDobj
    : VerbProduction
    action = Lower
    verbPhrase = 'lower/lowering (what)'
    missingQ = 'what do you want to lower'
;

DefineTIAction(LowerOver);
VerbRule(LowerOver)
    ('lower' | 'drop' | 'extend' | 'dangle' | 'throw') singleDobj ('over' | 'down' | ('off' 'of')) singleIobj
    : VerbProduction
    action = LowerOver
    verbPhrase = 'lower/lowering (what) (down what)'
    missingQ = 'what do you want to lower; what do you want to lower that over'
;
modify Thing
    dobjFor(Lower) {
        preCond = [touchObj]
        verify() { illogical ( '{The dobj} can\'t get any lower. ' ); }
    }
    dobjFor(LowerOver) {
        preCond = [touchObj]
        verify() { illogical('That action doesn\'t seem sensible. ');
        }
    }
    iobjFor(LowerOver) {
        preCond = [objVisible]
        verify() { illogical('That action doesn\'t seem sensible. ');
        }
    }
;

//------------------------------------------------------------------
// For picking the marigolds, but can also be used with the harp:
//------------------------------------------------------------------

DefineTAction(Pick);
VerbRule(Pick)
    ('pick' | 'pluck') singleDobj : VerbProduction
    action = Pick
    verbPhrase = 'pick/picking (what)'
    missingQ = 'what do you want to pick'
;
modify Thing
    dobjFor(Pick) asDobjFor(Take)
;

//-------------------------------------------------------
// For getting the pizza and beer:
//-------------------------------------------------------

DefineTIAction(GetWith);
VerbRule(GetWith)
    ('get' | 'take' | 'drag' | 'retrieve' | 'grab' | ('pick' 'up')) singleDobj ('with' | 'using') singleIobj
    : VerbProduction
    action = GetWith
    verbPhrase = 'get/getting (what) (using what)'
    missingQ = 'what do you want to get {it} with; what do you want to get using {that iobj}'
;
modify Thing
    outOfReach = nil
    isGrabber = nil
    dobjFor(GetWith) {
        preCond = [objVisible]
        verify() {
            if (isDirectlyIn(gPlayerChar)) illogical ('You\'re already holding {him dobj}. ');
            else if (!outOfReach) illogical ('You could just try picking {him dobj} up. ');
        }
    }
    iobjFor(GetWith) {
        preCond = [objHeld]
        verify() {
            if (gIobj && (gIobj == gPlayerChar)) illogical ('No need to get fancy. Just try
                picking it up. ');
            else if (!isGrabber) illogical ('You can\'t pick up things with {that iobj}. ');
        }
    }
;

//-------------------------------------------------------
// For the cloak:
//-------------------------------------------------------

DefineTAction(CutUp);
VerbRule(CutUp)
    (('cut' | 'slice' | 'snip') ('up' | 'apart') singleDobj) | (('cut' | 'slice' | 'snip') singleDobj ('up' | 'apart'))
    : VerbProduction
    action = CutUp
    verbPhrase = 'cut/cutting up (what)'
    missingQ = 'what do you want to cut'
;

DefineTIAction(CutUpWith);
VerbRule(CutUpWith)
    (('cut' | 'slice' | 'snip') ('up' | 'apart') singleDobj ('with' | 'using') singleIobj) | (('cut' | 'slice' | 'snip') singleDobj ('up' | 'apart') ('with' | 'using') singleIobj)
    : VerbProduction
    action = CutUpWith
    verbPhrase = 'cut/cutting up (what) (with what)'
    missingQ = 'what do you want to cut {it} with; what do you want to cut using (that iobj}'
;
modify Thing
    dobjFor(CutUp) {
        verify() { illogical ('{The subj dobj} {is} not in need of cutting up. ');
        }
    }
    dobjFor(CutUpWith) {
        verify() { illogical ('{The subj dobj} {is} not in need of cutting up. ');
        }
    }
    iobjFor(CutUpWith) {
        verify() { illogical ( '{The iobj} can\'t be used for cutting things up. '); }
    }
;


//-------------------------------------------------------
// Principally for the screwdriver:
//-------------------------------------------------------

DefineTAction(Pry);
VerbRule(Pry)
    'pry' ('up' | 'open' | ) singleDobj
    : VerbProduction
    action = Pry
    verbPhrase = 'pry/prying (what)'
    missingQ = 'what do you want to pry'
;
DefineTIAction(PryWith);
VerbRule(PryWith)
    ('pry' | 'prize') ('open' | 'up' | ) singleDobj ('open' | ) ('with' | 'using') singleIobj
    : VerbProduction
    action = PryWith
    verbPhrase = 'pry/prying (what) (with what)'
    missingQ = 'what do you want to pry {it} with ; what do you want to pry with {that iobj}'
;
DefineTIAction(OpenWith);
VerbRule(OpenWith)
    'open' ('up' | ) singleDobj ('with' | 'using') singleIobj
    : VerbProduction
    action = OpenWith
    verbPhrase = 'open/opening (what) (with what)'
    missingQ = 'what do you want to open {it} with; what do you want to open with {that iobj}'
;
modify Thing
    dobjFor(Pry) asDobjFor(Open)
    dobjFor(PryWith) asDobjFor(OpenWith)
    dobjFor(OpenWith) {
        preCond = [touchObj]
        verify() { illogical ('{The dobj} cannot be opened using {the iobj}. '); }
    }
    iobjFor(PryWith) asIobjFor(OpenWith)
    iobjFor(OpenWith) {
        preCond = [objHeld]
        verify() { illogical ('{The iobj} cannot be used for opening things. '); }
    }
;

// for fixing the square multipin connector:

DefineTAction(Straighten);
VerbRule(Straighten)
    ('straighten' | 'unbend') singleDobj
    : VerbProduction
    action = Straighten
    verbPhrase = 'straighten/straightening (what)'
    missingQ = 'what do you want to straighten'
;
DefineTIAction(StraightenWith);
VerbRule(StraightenWith)
    ('straighten' | 'unbend') singleDobj ('with' | 'using') singleIobj
    : VerbProduction
    action = StraightenWith
    verbPhrase = 'straighten/straightening (what) (with what)'
    missingQ = 'what do you want to straighten {it} with ; what do you want to straighten with {that iobj}'
;

modify Thing
    dobjFor(Straighten) {
        preCond = [touchObj]
        verify() {illogical ('{The subj dobj} {is} not in need of straightening. '); }
    }
    dobjFor(StraightenWith) {
        preCond = [touchObj]
        verify() {illogical ('{The subj dobj} {is} not in need of straightening. '); }
    }
    iobjFor(StraightenWith) {
        preCond = [objHeld]
        verify() {illogical ('{The subj iobj} can\'t be used for straightening things. '); }
    }
;

// for using the screwdriver in the elevator:

DefineTAction(Tighten);
VerbRule(Tighten)
    'tighten' singleDobj
    : VerbProduction
    action = Tighten
    verbPhrase = 'tighten/tightening (what)'
    missingQ = 'what do you want to tighten'
;
DefineTAction(Loosen);
VerbRule(Loosen)
    'loosen' singleDobj
    : VerbProduction
    action = Loosen
    verbPhrase = 'loosen/loosening (what)'
    missingQ = 'what do you want to loosen'
;
DefineTIAction(TightenWith);
VerbRule(TightenWith)
    'tighten' singleDobj ('with' | 'using') singleIobj
    : VerbProduction
    action = TightenWith
    verbPhrase = 'tighten/tightening (what) (with what)'
    missingQ = 'what do you want to tighten {it} with ; what do you want to tighten with {that iobj}'
;
DefineTIAction(LoosenWith);
VerbRule(LoosenWith)
    'loosen' singleDobj ('with' | 'using') singleIobj
    : VerbProduction
    action = LoosenWith
    verbPhrase = 'loosen/loosening (what) (with what)'
    missingQ = 'what do you want to loosen {it} with ; what do you want to loosen with {that iobj}'
;
modify Thing
    dobjFor(Tighten) {
        preCond = [touchObj]
        verify() { illogical ('{The subj dobj} {is} not something that can be tightened. '); }
    }
    dobjFor(Loosen) {
        preCond = [touchObj]
        verify() { illogical ('{The subj dobj} {is} not something that can be loosened. '); }
    }
    dobjFor(TightenWith) {
        preCond = [touchObj]
        verify() { illogical ('{The subj dobj} cannot be tightened using {that iobj}. '); }
    }
    iobjFor(TightenWith) {
        preCond = [objHeld]
        verify() { illogical ('{The subj iobj} cannot be used for tightening things. '); }
    }
    dobjFor(LoosenWith) {
        preCond = [touchObj]
        verify() { illogical ('{The subj dobj} cannot be loosened using {that iobj}. '); }
    }
    iobjFor(LoosenWith) {
        preCond = [objHeld]
        verify() { illogical ('{The subj iobj} cannot be used for loosening things. '); }
    }
;
        
// Note that BlowInto doesn't include grammar for 'blow on'.

DefineTAction(BlowInto);
VerbRule(BlowInto)
    'blow' ('in' | 'into' | ) singleDobj
    : VerbProduction
    action = BlowInto
    verbPhrase = 'blow/blowing on (what)'
    missingQ = 'what did you want to blow into'
;

DefineTIAction(BlowAt);
VerbRule(BlowAt)
    ('blow' | 'shoot') singleDobj 'at' singleIobj
    : VerbProduction
    action = BlowAt
    verbPhrase = 'blow/blowing (what) (at what)'
    missingQ = 'what do you want to blow {it} at ; what do you want to blow at {that iobj}'
;
        
modify Thing
    dobjFor(BlowAt) {
        verify() { illogical ( '{The dobj} cannot be blown at anything. '); }
    }
    iobjFor(BlowAt) {
        verify() { illogical ( '{The subj iobj} {is} not a suitable target for that action. '); }
    }
    dobjFor(BlowInto) {
        preCond = [touchObj]
        verify() {
            illogical ('This action is unlikely to be useful. ');
        }
    }
;

/*

DefineTAction(Tilt);
VerbRule(Tilt)
    ('tilt' | 'angle') singleDobj
    : TiltAction
    verbPhrase = 'tilt/tilting (what)'
;
modify Thing
    dobjFor(Tilt) {
        verify() {
            illogical ('{The dobj/he} cannot be tilted. ');
        }
    }
;

// The library doesn't define 'say goodbye to Bob', though it does define 'say hello to Bob'.
DefineTAction(GoodbyeTo);
    
VerbRule(GoodbyeTo)
    ('say' | 'bid') ('goodbye' | 'good-bye' | 'good' 'bye' | 'bye' | 'adieu') 'to' singleDobj
    : GoodbyeToAction
    verbPhrase = 'say/saying goodbye ro (what)'
;
modify Thing
    dobjFor(GoodbyeTo) {
        check() {
            if (!ofKind(Actor)) failCheck ('You can<./s>t say goodbye to something you
                were never talking to. ');
        }
        action() {
            gIssuingActor.sayGoodbye(gActor);
        }
    }
;
   
*/