#charset "us-ascii"
#include <advlite.h>

inanimateBianca: Fixture 'slim white mannequin{xzxzxzxz};; dummy; it her' @hotRags
    "The mannequin is a lot like the others --- graceful of
    limb and entirely motionless. What distinguishes this one from the others,
    aside from the fact that she seems to be able to remain upright without
    benefit of a pedestal or stand, is that every time your back is turned,
    she seems to edge closer to you. "
    cannotTakeMsg = 'You have no pressing need for a mannequin. '
    cannotMoveMsg = 'If you push her, she\'s bound to fall right over. '
;

// Description will need to be changed.

bianca: Actor 'mannequin; slim white; dummy; it her'
    "The mannequin moves in a slow, deliberate, slightly gawky way, as if she\'s not too sure
    about this locomotion business. <<if (promDress.isIn(bianca))>>She\'s wearing the teal prom dress, damn
    it!<<end>> "
    // We're including a specific 'found' property, because hasSeen has to be true
    // from the moment she snatches the dress, even though the actual bianca object
    // was never in scope, so that you can tell Joe about her. 'found' will help
    // differentiate Joe's dialog response, in case he's still there while you're
    // conversing with her. This may not be needed, but you could conceivably have
    // your conversation with her, then go back to where Joe is hanging out, and
    // ask him to help you again. Better is if he just vanishes from the game when
    // he has done his job.
    // found = nil
    refuseCommandMsg = '<q>You\'re not the boss of me!</q> she replies. '
    globalParamName = 'bianca'
    giveName {
        addVocab ('Bianca');
        proper = true;
    }
    // The wizard's initial big speech needs to change based on whether you have found
    // Bianca and heard her demand for the soldier:
    soldierMentioned = nil
    mentionSoldier() { soldierMentioned = true; }
    
    // Having her run off takes care of the nasty possibility that the player might
    // just walk away. This dialog could possibly be used in the behindCaboosePanel
    // room, but she won't be there until you get there with Joe....
    dressGrab: StopEventList { [
        'You make a grab for the dress, and the mannequin dodges away deftly. ',
        
        'You\'re tempted to simply wrestle her for the dress ... but then
        it would get torn, and Sam would be devastated. <q>Look, I really need that
        dress,</q> you say, trying to remain calm. <q>What good is it going
        to do you?</q>
        <.p><q>That\'s none of your business,</q> she replies. <q>It\'s mine now.</q> ',
        
        '<q>Please, <i>please,</i> can I have that dress?</q> You\'re a little embarrassed
        to be pleading with a mannequin, but what other choice do you have?
        <.p><q>Not a chance,</q> she replies brusquely.
        <.p>You wave your arms. <q>There are lots of other dresses in the shop!</q>
        <.p><q>I like <i>this</i> one,</q> she insists. ',
        
        'Grabbing the dress is not going to work, that\'s obvious. You\'ll have to figure
        out a way to get it away from her. Maybe she\'d trade it for something that
        she wants even more. But what would that be??? '
    ] }
    // In the discovery method, you have led Joe into hotRags, inanimateBianca is
    // gone, and he has the dowsing rod, but nothing else
    // has happened yet. There are two possible endings to this scene, because he
    // may or may not have already helped you in world headquarters. So....
    discovered = nil
    discovery() {
        discovered = true;
        moveInto(behindCaboosePanel);
        me.moveInto(behindCaboosePanel);
        if (safeDoor.isOpen) joe.moveInto(nil);
            else joe.moveInto(footOfPole);
        joe.stopFollowing();
        caboosePanelCabooseSide.moveInto(chartreuseCaboose);
        caboosePanelMirrorSide.makeOpen(true);
        chartreuseCaboose.west = caboosePanelCabooseSide;
        dowsingAch.awardPointsOnce();
        "{The joe} waves his dowsing rod this way and that. <q>You said she headed off
        over there?</q> he says, pointing the rod at the entrance to the dressing rooms.
        <q>The stick says so. Let's give it a try.</q> He ambles into the dressing rooms,
        and you follow. The mirrors seem not to confuse him at all. Step by step he
        moves confidently along, sometimes waiting a moment or two for the dowsing rod
        to twitch.<.p>
        After a few twists and turns, you arrive in a little room with a low bench
        and a wooden panel in the east wall. And there on the bench is the mannequin!
        Wearing the prom dress! And sulking.
        <.p><q>You found me,</q> she says. <q>Congratulations, I guess. But what happens
        now? I'm not gonna give up this beautiful dress! Don't even think about trying
        to take it away from me. I'd only give it up if---</q> She pauses and rubs her
        slim white fingers on her flawless cheek. <q>Unless, I guess maybe if you could
        make me into a real human woman, not just a half-alive <i>thing</i>.</q>
        <.p><q>But how could I possibly do that?</q> you protest. <q>I don't even know
        how you got the way you are now! It seems impossible!</q>
        <.p><q>It was that wizard. <<tWizard.makeFamiliar()>>I know it was. He messed it up. Have you seen those
        little guys in the plant store? Have you noticed how the wooden Indian isn't just
        all wood? And that handsome soldier upstairs! <<mentionSoldier()>>I could go for a guy like that.
        I mean, if I was human and he was too.</q>
        <.p>She nods firmly. <q>So that's the deal. If you can get the stupid little
        wizard to finish the job, make me <i>and</i> the soldier human, I'll give you
        the dress. How's that? Fair? Do we have a deal?</q>
        <.p><q>I guess,</q> you say. <q>I'll try,
        anyhow. <<if (zarbolphung.isIn(nil))>>I don't even know what wizard you're talking
        about, but maybe I can find him and ask him to help. <<end>>And you'll stay put
        until I find him and work out how to get him to do it? I wouldn't want to have to
        ask {the joe} to help me find you again.</q>
        <.p><q>Sure.</q> She taps on the wooden panel. <q>You don't even have to go through
        the rooms with all the mirrors. Right through here is the night club. I took a
        peek a little while ago. See?</q> She pops the wooden panel
        open<<if (!caboosePanelMirrorSide.hasBeenOpened)>>. Sure enough ---
        through there you can see what looks very much like the interior of the Chartreuse
        Caboose.<<else>>, and you catch a glimpse of the interior of the Chartreuse Caboose.<<end>>
        <.p>{The joe} has observed this conversation silently. <q>So I guess you
        don't need me no more right now,</q> he says. <q>Catch you later.</q> He climbs
        out through the panel into the nightclub. You hear him whistle in surprise.
        <q>Wouldja look at that? A mirror ball!</q> ";  
    }
    
    phantomBiancaDaemonID = nil
    startPhantomBiancaDaemon() {
        if (phantomBiancaDaemonID == nil)
            phantomBiancaDaemonID = new Daemon(bianca, &phantomBianca, 1);
    }
    stopPhantomBiancaDaemon() {
        if (phantomBiancaDaemonID != nil) {
            phantomBiancaDaemonID.removeEvent();
            phantomBiancaDaemonID = nil;
        }
    }
    phantomBianca {
        local rm = gPlayerChar.getOutermostRoom();
        if (!rm.ofKind(mirrorRoom)) return;
        // If joe has already found her for you, she's not trotting
        // around in the maze:
        if (bianca.discovered) return;
        local rnd = rand(4);
        local sel = rand(6);
        if (rnd == 2) {
            switch(sel) {
            case 0: "The mannequin <<one of>>dashes past you<<or>>appears momentarily in
                one of the mirrors<<or>>pokes her head into the room, sticks out her
                tongue, and then runs off<<at random>><<one of>>, giggling<<or>>, laughing<<at random>>. ";
                break;
            case 1: "You catch a glimpse of the furtive mannequin in one of the
                mirrors, but when you turn to look, she's gone. ";
                break;
            case 2:
                "The mannequin <<one of>>strolls<<or>>saunters<<or>>stalks<<at random>> past
                you with great dignity, but she's gone before you can react. ";
                break;
            case 3:
                "You hear the mannequin giggling somewhere nearby, but you can't
                quite tell where the sound is coming from. ";
                break;
            case 4:
                "Just for a moment, three of the mirrors all reflect the image of the
                mannequin as she twirls festively in the prom dress --- but then the
                image is gone. ";
                break;
            default:
                "You hear footsteps. It could only be the fugitive mannequin. But where
                is she? ";
            }
        }
    }
;

+ biancaDefiant : ActorState
    specialDesc = "<<bianca.proper ? 'Bianca' : 'The mischievous mannequin' >> is standing here, haughty and
        poised.<<if (promDress.isIn(bianca))>> Admittedly, she does look quite chic in the prom dress.<<end>> "
    stateDesc = "She\'s <<varyingActivity.doScript()>>. "
    isInitState = true
    varyingActivity: ShuffledEventList { [
        'examining herself proudly in a mirror',
        'smoothing the prom dress over her torso and smirking at you',
        'glaring at you defiantly',
        'gazing off into space',
        'fluffing her hair',
        'examining her fingers',
        'smiling vaguely',
        'humming a tuneless little tune'
    ] }
;

++ AskTopic, StopEventList @bianca
    [ {: "<q>I don\'t see why you should care,</q> she says. <q>I do have a name,
        in case you\'re interested.<<bianca.giveName>> It\'s Bianca. I chose it myself.</q> " },
        '<q>You\'re just full of questions, aren\'t you? Go away.</q> '
    ]
;

++ AskTellTopic [tSamantha, promDress]
    "<q>I really need that dress,</q> you tell her. <q>It\'s for my daughter. For her
    senior prom.</q>
    </p><q><i>I\'ve</i> never had a senior prom,</q> she says wistfully. <q>Just once I\'d
    like to dance with a handsome soldier. Is that so much to want?</q> "
;

++ AskTellTopic @tWizard
    "<q>What can you tell me about this wizard?</q> you ask.
    <.p><q>I don\'t know very much,</q> she admits. <q>Hardly anything. He\'s around
    sometimes. There\'s a fat woman who I think is a friend of his. You could ask her.</q> "
;

// We need to lead her into the Caboose, but perhaps an ordinary follow state is not needed
// and not safe.
++ AskTellTopic @ajou
    topicResponse() {
        if ((ajou.getOutermostRoom == chartreuseCaboose) &&
            (bianca.getOutermostRoom == chartreuseCaboose))
            "<q>Yes, we\'re here,</q> she replies. <q>I guess we have to wait until
            the wizard is ready.</q> ";
        else if (ajou.getOutermostRoom == chartreuseCaboose) {
            "<q>The handsome soldier is waiting for you in the nightclub,</q> you tell her.
            <.p>Her eyes light up. (Not literally.) <q>Do you mean it? Did you tell him about
            me? Maybe I can dance with him, do you think?</q> She steps through the panel
            into the Chartreuse Caboose, and you follow her.<.p> ";
            bianca.moveInto(chartreuseCaboose);
            me.moveInto(chartreuseCaboose);
            chartreuseCaboose.lookAroundWithin();
        }
        else {
            "<q>I saw that handsome wooden soldier upstairs,</q> you tell her.
            <.p><q>Don't try to trick me,</q> she says. <q>I'm not going anywhere.
            I won't take another step until he's right next door in the nightclub
            waiting to dance with me. And that's final!</q> She folds her arms across
            her chest and glares at you. ";
        }
    }
;

++ CommandTopic @Follow
    topicResponse() {
        if (ajou.getOutermostRoom == chartreuseCaboose) {
            "<q>The handsome soldier is waiting for you in the nightclub,</q> you tell her.
            <.p>Her eyes light up. (Not literally.) <q>Do you mean it? Did you tell him about
            me? Maybe I can dance with him, do you think?</q> She steps through the panel
            into the Chartreuse Caboose, and you follow her.<.p> ";
            bianca.moveInto(chartreuseCaboose);
            me.moveInto(chartreuseCaboose);
            chartreuseCaboose.lookAroundWithin();
        }
        else {
            "<q>I saw that handsome wooden soldier upstairs,</q> you tell her.
            <.p><q>Don't try to trick me,</q> she says. <q>I'm not going anywhere.
            I won't take another step until he's right next door in the nightclub
            waiting to dance with me. And that's final!</q> She folds her arms across
            her chest and glares at you. ";
        }
    }
;
