/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.zmpp.encoding.ZsciiEncoding;
import org.zmpp.io.IOSystem;
import org.zmpp.io.InputStream;

public class FileInputStream
implements InputStream {
    private IOSystem iosys;
    private ZsciiEncoding encoding;
    private Reader filereader;
    private BufferedReader input;

    public FileInputStream(IOSystem iOSystem, ZsciiEncoding zsciiEncoding) {
        this.iosys = iOSystem;
        this.encoding = zsciiEncoding;
    }

    public void cancelInput() {
    }

    public short getZsciiChar(boolean bl) {
        this.checkForReader();
        if (this.input != null) {
            try {
                char c;
                if (this.input.ready() && this.encoding.isConvertableToZscii(c = (char)this.input.read())) {
                    return this.encoding.getZsciiChar(c);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return 0;
    }

    public void close() {
        if (this.input != null) {
            try {
                this.input.close();
                this.input = null;
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
        }
        if (this.filereader != null) {
            try {
                this.filereader.close();
                this.filereader = null;
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
        }
    }

    private void checkForReader() {
        if (this.filereader == null) {
            this.filereader = this.iosys.getInputStreamReader();
            this.input = new BufferedReader(this.filereader);
        }
    }
}

