#charset "us-ascii"
#include <advlite.h>

DefineIAction(Nonvisual)
    execAction(cmd) {
        me.visual = nil;
        "Setting up to remove ASCII graphics. ";
    }
;
VerbRule(Nonvisual)
    'nonvisual'
    : VerbProduction
    action = Nonvisual
    verbPhrase = 'remove/removing ASCII graphics'
    missingQ = 'what, me worry'
;

DefineIAction(Visual)
    execAction(cmd) {
        if (me.visual) "The game is already set up to use ASCII graphics. ";
        else {
            me.visual = true;
            "Restoring the ASCII graphics. ";
        }
    }
;
VerbRule(Visual)
    'visual'
    : VerbProduction
    action = Visual
    verbPhrase = 'restore/restoring ASCII graphics'
    missingQ = 'what, me worry'
;

DefineIAction(Details)
    execAction(cmd) {
        "This game includes a full context-sensitive hint system,
        so if you get totally stuck, the HINT command is your friend. If you keep your eyes
        open, though, you\'ll notice many clues within the game itself about what you might
        want to do.
        <.p>The command WALKTHRU will
        explain how to access a simplified, chapter-by-chapter text description of the entire game. 
        Players who are new to interactive fiction can read a robust description of how it works
        using the INSTRUCTIONS command. Other useful commands include ABOUT, CREDITS, HELP, and
        LEARN MORE.
        <.p>This game includes quite a lot of things you can carry around, and also a player\'s
        carryall to make this easier. The downside is that the command TAKE ALL can produce
        results that are messy and potentially confusing as things are automatically shuffled
        in and out of the carryall. TAKE ALL is allowed as a command, because
        most players like it, but please be advised that it\'s best used sparingly. The same
        consideration applies to PUT ALL IN BAG. You\'ll be happier if you avoid using
        this command.
        <.p>When an object has fulfilled its purpose and is
        no longer needed, you\'ll find that it\'s automatically
        tossed aside when you pass through a central area. You can still pick it up if you
        like, but there shouldn\'t be any reason to do so. The purpose of this automatic
        utility is to make the rather long list of things you may be carrying more manageable.
        <.p>Those who prefer not to draw their own map can download a zip file containing
        maps and a step-by-step walkthrough from www.musicwords.net/if/Prom_Dress_Extras.zip. ";
    }
;
VerbRule(Details)
    ('details' | 'detail' | ('learn' 'details'))
    : VerbProduction
    action = Details
    verbPhrase = 'learn/learning the details'
    missingQ = 'learn details about what'
;

DefineIAction(LearnMore)
    execAction(cmd) {    
        "In 1999, I released my first text adventure game, <q>Not Just an Ordinary Ballerina.</q> That
        game was written in Inform 6, which at the time was pretty much state-of-the-art. After that
        I took a break from writing interactive fiction. By the time I returned to IF, the
        Inform 6 source code for <q>Ballerina</q> was long gone. (Stupid author!) One of my testers for a
        more recent game had the idea of porting <q>Ballerina</q> to Inform 7. Nothing came of that, but
        his experiments suggested
        to me that it might be an interesting and worthwhile project to recode the game from the ground up, making
        a few modest improvements as I went along.<.p>
        
        But why limit myself to minor tweaks? Why not create a whole new game
        with essentially the same setting and a similar premise? The game you're now looking at arose from
        that masochistic impulse. (And in case you're wondering, yes, the intro of the new game refers
        specifically to the old one.)<.p>
        
        You don't have to have played <q>Ballerina</q> in order to enjoy <q>Prom Dress.</q> But if
        you've done so, you'll find that many of the locations are familiar (though none is identical).
        A few of the puzzles are related to or elaborations of puzzles found in the earlier game, so if
        you've played it you may have two or three ideas about what's what. Most of the puzzles are
        entirely new, however.<.p>
        
        If you should spot anything that looks like a bug, I'd appreciate it (and other players would
        too!) if you'd copy a big chunk of the output and email it to me at midiguru23@sbcglobal.net.
        The game has been extensively tested, but that doesn't mean it's entirely free of bugs. ";
    }
;
VerbRule(LearnMore)
    ('learn' 'more')
    : VerbProduction
    action = LearnMore
    verbPhrase = 'learn/learning more'
    missingQ = 'learn more about what'
;

modify helpMessage
    printMsg {
        "There are two minor uses of ASCII graphics in this game. Visually
        impaired users can use the utility command NONVISUAL (that's N O N
        V I S U A L, all one word) to replace those graphic elements with
        words. To return to the standard output format, use the command
        VISUAL.<.p>
        
        A variety of helpful information, including a full set of
        hints, is to be found in this software
        edition of <q>The Only Possible Prom Dress.</q> If you're planning to rate
        the game in the IFComp and want to adhere to the two-hour time limit,
        you may find that you'll have a better idea of the scope of the game if you avail
        yourself of a few of the hints.
        (Type HINT.) The section headed <q>In the Beginning</q> will help you
        unfold more of the story in a reasonable amount of time.<.p>
        
        If you're having trouble navigating, you may want to download the maps.
        A mostly complete (but intentionally not quite perfect) set of maps is available from
        www.musicwords.net/if/Prom_Dress_Extras.zip. The download file also includes a
        complete step-by-step walkthrough of the entire game.<.p>
        
        <<if defined(Instructions)>>If you\'re new to interactive fiction, you
        can type INSTRUCTIONS at the prompt for a full explanation of how to
        interact with the software and the story. For<<else>>For<<end>> a brief
        introduction to playing this type of game, type INTRO or SAMPLE
        to show a short sample transcript. ";
        if(versionInfo.propDefined(&showAbout, PropDefDirectly))
        "For more information specific to this game, type ABOUT.<.p>
        If you'd like a walkthrough of the entire game, type WALKTHRU or
        WALKTHROUGH.
        <.p><b>Be warned:</b> There are several ways to lose the game --- that is,
        to reach an unwinnable condition. You will usually be able to UNDO your way out
        of the bad ending, but no guarantees.
        It's a good idea to save your game after you accomplish something significant or
        before you try something risky. Use the SAVE command for this. Later you can reload your saved game
        using the RESTORE command. ";
    }
;

// ------------------------------------------------------------------------------------------
// walkthrough
// ------------------------------------------------------------------------------------------

VerbRule(Walkthru)
    'walkthrough' | 'walkthru'
    : VerbProduction
    action = Walkthru
    verbPhrase = 'walk/walking through the game'
    missingQ = 'what did you want to do'
;

DefineIAction(Walkthru)
    execAction(cmd) {
        "The full (and annotated) move-by-move walkthrough for <q>The Only Possible Prom Dress</q> is available as part of
        a separate download
        (www.musicwords.net/if/Prom_Dress_Extras.zip). The download also contains a map of Stufftown.
        The map is not guaranteed to be correct or complete --- a couple of rooms are
        missing (on purpose). Some players prefer to make their own
        maps, but the one in the zip file will at least steer you around Stufftown very
        conveniently.<.p>
        A descriptive overview of how to proceed through the story --- not a full walkthrough, but
        perhaps helpful --- is embedded in the game software itself. The story can be thought of
        as taking place in 15 chapters, which you can read using the commands WALK1, WALK2, etc.,
        up through WALK15.<.p>
        There are many possible routes through the game. This set of chapters describes only one
        of the possible routes. What's worse, it assumes you already know why you're doing certain
        obscure things. But it's better than nothing, right?<.p>
        The first four chapters need to be carried out in order, although
        there's one three-part side puzzle that you could solve even before you've made it through
        Chapter 1. Once you've got those basics out of the way, the story opens up, becoming much
        more broad and nonlinear, so you can choose whatever route you fancy. ";
    }
;

VerbRule(WalkOne)
    'walk1'
    : VerbProduction
    action = WalkOne
    verbPhrase = 'walk/walking through the game'
    missingQ = 'what did you want to do'
;
VerbRule(WalkTwo)
    'walk2'
    : VerbProduction
    action = WalkTwo
    verbPhrase = 'walk/walking through the game'
    missingQ = 'what did you want to do'
;
VerbRule(WalkThree)
    'walk3'
    : VerbProduction
    action = WalkThree
    verbPhrase = 'walk/walking through the game'
    missingQ = 'what did you want to do'
;
VerbRule(WalkFour)
    'walk4'
    : VerbProduction
    action = WalkFour
    verbPhrase = 'walk/walking through the game'
    missingQ = 'what did you want to do'
;
VerbRule(WalkFive)
    'walk5'
    : VerbProduction
    action = WalkFive
    verbPhrase = 'walk/walking through the game'
    missingQ = 'what did you want to do'
;
VerbRule(WalkSix)
    'walk6'
    : VerbProduction
    action = WalkSix
    verbPhrase = 'walk/walking through the game'
    missingQ = 'what did you want to do'
;
VerbRule(WalkSeven)
    'walk7'
    : VerbProduction
    action = WalkSeven
    verbPhrase = 'walk/walking through the game'
    missingQ = 'what did you want to do'
;
VerbRule(WalkEight)
    'walk8'
    : VerbProduction
    action = WalkEight
    verbPhrase = 'walk/walking through the game'
    missingQ = 'what did you want to do'
;
VerbRule(WalkNine)
    'walk9'
    : VerbProduction
    action = WalkNine
    verbPhrase = 'walk/walking through the game'
    missingQ = 'what did you want to do'
;
VerbRule(WalkTen)
    'walk10'
    : VerbProduction
    action = WalkTen
    verbPhrase = 'walk/walking through the game'
    missingQ = 'what did you want to do'
;
VerbRule(WalkEleven)
    'walk11'
    : VerbProduction
    action = WalkEleven
    verbPhrase = 'walk/walking through the game'
    missingQ = 'what did you want to do'
;
VerbRule(WalkTwelve)
    'walk12'
    : VerbProduction
    action = WalkTwelve
    verbPhrase = 'walk/walking through the game'
    missingQ = 'what did you want to do'
;
VerbRule(WalkThirteen)
    'walk13'
    : VerbProduction
    action = WalkThirteen
    verbPhrase = 'walk/walking through the game'
    missingQ = 'what did you want to do'
;
VerbRule(WalkFourteen)
    'walk14'
    : VerbProduction
    action = WalkFourteen
    verbPhrase = 'walk/walking through the game'
    missingQ = 'what did you want to do'
;
VerbRule(WalkFifteen)
    'walk15'
    : VerbProduction
    action = WalkFifteen
    verbPhrase = 'walk/walking through the game'
    missingQ = 'what did you want to do'
;
DefineIAction(WalkOne)
    execAction(cmd) {
        "Take a close look at Stufftown. Proceed south and get the stuff that's in the trash
        can. Then go into Stufftown, into the west side of the arcade, and knock on the window
        of the beauty parlor.
        While you're in the beauty parlor, may as well grab the nail polish. Betsy will
        follow you downstairs. After releasing the octopus, go back up to the Security Office
        and tell the guards about the octopus. While they're out of the room, take a look
        at the corkboard and then grab the key. ";
    }
;
DefineIAction(WalkTwo)
    execAction(cmd) {
        "Your next challenge is to get rid of Betsy. Go across the arched passage and into
        the smoke shop. Grab some matches and some cigarettes. Then go back to the beauty
        parlor and put them on the shelf in the closet. (You might want to make a side trip
        to the tacky lounge before or after you do this.) Tell Betsy about what's in the closet. She
        will go in to sneak a smoke, so you can lock her in the closet (cruel, but necessary). ";
    }
;
DefineIAction(WalkThree)
    execAction(cmd) {
        "In Chapter 3, you'll be restoring the electrical power to various devices in Stufftown. To do
        this, you'll need to use the master key to enter a couple of shops, but be careful
        not to enter the wrong ones! You're going to need a screwdriver and a connector cable.
        The cable is in the lamp store (Light Fantastic), and the screwdriver is
        in a utility closet in the stairwell. The only safe way to enter the stairwell is
        through the leather goods shop (Asteroid Belt). Exit the stairwell on the roof and
        head back down to the area behind the building. Open the box, fix the cable using the screwdriver, and
        enter the correct code using the switches. There's a clue to the correct code,
        in the crumpled note in the shopping bag. Still confused? Try converting hexadecimal to binary. ";
    }
;
DefineIAction(WalkFour)
    execAction(cmd) {
        "In Chapter 4, you'll sabotage the security guards' monitor screen so they can't see what
        you're up to. In order to do this, you'll need to get them out of the room. You can go into
        the snack bar (out front, off of the patio), but you can't reach the stuff that's in the
        freezer. There's a long implement in the billiard room off of the pub, but you can't get
        there through the pub. You'll have to go through the pottery shop, and to get through the
        interior room off of the pottery shop you'll have to shut off the HVAC machine. It's down
        on the lower level. Oil the switch and switch it off. (If you switched it off earlier, switch
        it on and then back off.) Now you can get the snooker bridge
        from the billiard room, retrieve the beer and pizza in the snack bar, and give the beer
        and pizza to the guards. They will go on their afternoon break, leaving you free to mess
        with the monitor to your heart's content. After manipulating its controls so that all 16
        screens show reruns of <i>Law & Order,</i>, the finishing touch is to pour the fast-drying
        nail polish on the control panel so they can't reset the screens. ";
    }
;
DefineIAction(WalkFive)
    execAction(cmd) {
        "In Chapter 5 you can grab almost everything portable that's in Stufftown, in no particular
        order. Here, I'll follow the process described in the downloadable walkthrough
        (www.musicwords.net/if/Prom_Dress_Extras.zip). First, sabotage the Lamborghini. Then
        go up onto the loading dock and into the shipping department. Get the stuff there and
        use the card to activate the door in the hallway. Go around to the front of Stufftown
        to get the rope and the Easter egg, then retrieve the matches from the closet in the
        beauty parlor.<.p>
        When you go down to the fashion boutique on the lower level and try to leave with the
        prom dress, you'll discover the true depth of your problem. But when the mannequin runs off,
        she knocks over the bowl of combs, so you can get the key, unlock the display case, and
        grab that boring perfume. Next, head out back and get the stuff that's backstage in
        the wardrobe closet. Also, there's a golf ball nearby. You're going to need that. ";
    }
;
DefineIAction(WalkSix)
    execAction(cmd) {
        "In Chapter 6, the homeless man will help you. Give him the shoes. He will now follow you
        upstairs to Stuff World Headquarters, where you can tell Flogg and Grabby about the
        Lamborghini. You need the homeless man, because Flogg and Grabby don't actually trust
        one another. The only way to open the office safe is for each of them to press the button
        under his desk at the same time. The homeless man will hold one button while you press the
        other.<.p>
        After searching the safe, go downstairs and get rid of Joe's pixies for him. This is a complicated
        procedure, but it's explained in the Hints. Use the rope to climb down the cliff and get the
        forked stick. (Yes, it's a dowsing rod.) With the stick, Joe can find his way through the
        mirror maze in the boutique, so now you can find the mannequin and learn what she wants.<.p>
        Use your phone to take a photo of her. You're going to need it. ";
    }
;
DefineIAction(WalkSeven)
    execAction(cmd) {
        "For a couple of the upcoming challenges you're going to need a wagon, so in Chapter 7 it's
        time to visit the toy store. Get the ladder from the lamp store, take it into the restroom,
        and climb up to the damaged hallway. After solving the pushbutton puzzle and going into
        the toy store, you can befriend the purple dinosaur using the jellybeans from the
        Easter egg. (Opening the Easter egg is explained in the hints.)<.p>
        Now the dinosaur will let you ride in the Virtual Capsule. Be sure to take notes on anything
        that looks like a clue. After the ride, get the dinosaur to help you move the boxes so
        you can pull the wagon out of the store. (You can't very well pull it down the ladder.) ";
    }
;
DefineIAction(WalkEight)
    execAction(cmd) {
        "Chapter 8 is a bit of a grab bag. Take the wagon downstairs in the elevator to get
        the pterodactyl chow. While you're there, get the coin from the mynah's cage. (The key
        for winding up the nightingale is in the Easter egg.) Get the rest of the stuff from
        downstairs, including Sir Ralph's book, the tattered cloak, and the items in the rolltop desk.
        If you have everything, you're ready to tackle the Octagonal Room. ";
    }
;
DefineIAction(WalkNine)
    execAction(cmd) {
        "In the Octagonal Room, you'll need to visit the jewel-encrusted grotto, the secluded lair
        of the gerbils and marionettes, the balcony, and the garden. While you\'re on the balcony,
        take a look at the card players through the telescope. (This is an essential step.)
        When you get to the garden, give the harp to the angel
        and take the crystal ball. Tell the card players what you saw through the telescope while
        you were on the balcony and then take the cards. Now you're ready to head up to the roof
        (still in the Octagonal Room). Instructions on how to use the controls in the Octagonal Room
        are in the built-in hints. ";
    }
;
DefineIAction(WalkTen)
    execAction(cmd) {
        "Dump the pterodactyl chow into the trough. The wizard will tell you what he needs in order to
        solve your problem, so give him the crystal ball. Then take the wagon back down to the center of
        the arcade; you'll need it later. You're still short a couple of gold coins. You can get one
        by crawling under the diorama; the other is in the easter egg. ";
    }
;
DefineIAction(WalkEleven)
    execAction(cmd) {
        "Give the cards to the fortune teller. She will suggest a seance, so tell her to summon the ghost.
        Now you know what page to read in the ghost's book. If you haven't already gotten the pill
        from the dentist's office, the box of wine, the piece of bamboo, the bottle of BioBGone,
        and the envelope of vine seeds, now's the time to do so.<.p>
        Go up to the miniature golf course on the roof, retrieve the putter from the shed using the
        knitting needle, and knock the dragon's tooth loose with the golf ball. Back downstairs, you
        need to cheer up the art dealer, so bring him the singing fish from the pet store, using the
        army helmet to carry the fish and the water, and dump the fish and water into the weird
        birdbath. Now the dealer will tell you something useful about the paintings, and also allow
        you in the back room, where you'll find a paintbrush.<.p>
        Head up to the scrimshaw shop, feed your five gold coins into the machine, and carve the
        correct carving into the tooth, based on what the art dealer told you. Take the tooth to
        the bartender. He will offer to trade it for the signed photo of your choice. And because
        the fortune teller has already mentioned monkeys to you, the photo of Jane Goodall would
        be a good bet. ";
    }
;
DefineIAction(WalkTwelve)
    execAction(cmd) {
        "Having read the correct page in Sir Ralph's book, you know what code to use in the TARZAN
        in order to get to the jungle. Tame the ocelot using the bamboo (which you've cleaned using
        the knitting needle), the dart from the billiard room, and the StunGums from the dentist's
        office. Beyond the ocelot you'll find no apparent way forward, but the stone Buddha will
        open a path when you use the mirror in your purse to shine a sunbeam onto his jewel.<.p>
        To recruit the monkeys, you need to show them the Goodall photo and then speak to them using
        ASL. You learned ASL instantly by taking the little white pill in the dentist's office, so now
        you can SIGN FOLLOW or SIGN WAIT, for instance.<.p>
        Lead them back to Stufftown, up to the music store, where they'll pick up band instruments,
        and then down to the video psychologist's office. Play them the
        DVD you found behind the piano in the music store. Now you have a dance band. As a side benefit,
        you also know how to play the trumpet. Lead the monkeys to the Chartreuse Caboose and
        sign to them to wait there. ";
    }
;
DefineIAction(WalkThirteen)
    execAction(cmd) {
        "Your two tasks in Chapter 13 are to get the mirror ball spinning and invite the handsome
        wooden soldier downstairs to the Chartreuse Caboose. The mirror ball is in the Caboose, but
        it's connected to the potter's wheel in the pottery store. Repair the wheel using the belt
        from the leather goods store and fuel the motor with the box of wine.<.p>
        To get the soldier to follow you, you need to play the trumpet to wake him up and then show
        him a document that tells him you're his commanding officer. The document needs a wax seal,
        and to put the seal on it you need to get the signet ring out from under the grate in the
        patio. Killing the green ooze with the BioBGone and opening the grate with the screwdriver
        should be easy enough. Use the matches and the candle to put a blob of wax on the parchment
        you found in the rolltop desk, and then press the signet ring into the wax. When you show
        the document to the soldier, he can be commanded to follow you downstairs to the Caboose. ";
    }
;
DefineIAction(WalkFourteen)
    execAction(cmd) {
        "Chapter 14 is about acquiring the toe of a mummy. Put the large pot from the pottery store
        in the wagon, pull the wagon out behind Stufftown to the patch of bare dirt, and use the helmet
        to scoop dirt into the pot. Pull the wagon back to the elevator and use the screwdriver to
        loosen the elevator control plate. Push the plate down. Now the bottom button will take
        you to the area of the crypt.<.p>
        Grab the mallet and bang three times on the lid of the sarcophagus. Put the seeds into the
        pot and pour MiraklGro on them. The vine will wrap up the mummy so he can't evade you while
        you saw off his toe using the saw you found in the store that's under reconstruction. ";
    }
;
DefineIAction(WalkFifteen)
    execAction(cmd) {
        "Your only remaining challenge is to forge some fake identity papers for the new humans.
        The Identikit machine is in the secret room behind the bookstore. To open the secret door
        you'll need to have worked out the marquee jumble; there's a clue in the snack bar that
        will help with this. Touch the bust of Shakespeare, enter the code in the secret book,
        and proceed into the printery. Attach your camera to the machine so that the photos of
        Bianca and the lieutenant can be uploaded. Then enter the code you learned by observing
        the signs in the Virtual Capsule.<.p>
        The machine will spit out the folders. Take them upstairs to where the wizard is waiting
        in the fortune teller's establishment. Give him everything. He will escort you to the
        night club, and if anything isn't ready, he'll tell you about it. If you've followed along
        without error, Bianca should be waiting behind the panel to the west of the night club.
        Tell her about the lieutenant, and you're finished! ";
    }
;
