# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class CheckNameRequest(_serialization.Model):
    """The result returned from a database check name availability request.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Resource name. Required.
    :vartype name: str
    :ivar type: The type of resource, for instance Microsoft.DigitalTwins/digitalTwinsInstances.
     Required. Default value is "Microsoft.DigitalTwins/digitalTwinsInstances".
    :vartype type: str
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True, "constant": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    type = "Microsoft.DigitalTwins/digitalTwinsInstances"

    def __init__(self, *, name: str, **kwargs):
        """
        :keyword name: Resource name. Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class CheckNameResult(_serialization.Model):
    """The result returned from a check name availability request.

    :ivar name_available: Specifies a Boolean value that indicates if the name is available.
    :vartype name_available: bool
    :ivar message: Message indicating an unavailable name due to a conflict, or a description of
     the naming rules that are violated.
    :vartype message: str
    :ivar reason: Message providing the reason why the given name is invalid. Known values are:
     "Invalid" and "AlreadyExists".
    :vartype reason: str or ~azure.mgmt.digitaltwins.v2020_12_01.models.Reason
    """

    _attribute_map = {
        "name_available": {"key": "nameAvailable", "type": "bool"},
        "message": {"key": "message", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(
        self,
        *,
        name_available: Optional[bool] = None,
        message: Optional[str] = None,
        reason: Optional[Union[str, "_models.Reason"]] = None,
        **kwargs
    ):
        """
        :keyword name_available: Specifies a Boolean value that indicates if the name is available.
        :paramtype name_available: bool
        :keyword message: Message indicating an unavailable name due to a conflict, or a description of
         the naming rules that are violated.
        :paramtype message: str
        :keyword reason: Message providing the reason why the given name is invalid. Known values are:
         "Invalid" and "AlreadyExists".
        :paramtype reason: str or ~azure.mgmt.digitaltwins.v2020_12_01.models.Reason
        """
        super().__init__(**kwargs)
        self.name_available = name_available
        self.message = message
        self.reason = reason


class ConnectionProperties(_serialization.Model):
    """The properties of a private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: The provisioning state. Known values are: "Pending", "Approved",
     "Rejected", and "Disconnected".
    :vartype provisioning_state: str or
     ~azure.mgmt.digitaltwins.v2020_12_01.models.ConnectionPropertiesProvisioningState
    :ivar private_endpoint:
    :vartype private_endpoint:
     ~azure.mgmt.digitaltwins.v2020_12_01.models.ConnectionPropertiesPrivateEndpoint
    :ivar group_ids: The list of group ids for the private endpoint connection.
    :vartype group_ids: list[str]
    :ivar private_link_service_connection_state:
    :vartype private_link_service_connection_state:
     ~azure.mgmt.digitaltwins.v2020_12_01.models.ConnectionPropertiesPrivateLinkServiceConnectionState
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "private_endpoint": {"key": "privateEndpoint", "type": "ConnectionPropertiesPrivateEndpoint"},
        "group_ids": {"key": "groupIds", "type": "[str]"},
        "private_link_service_connection_state": {
            "key": "privateLinkServiceConnectionState",
            "type": "ConnectionPropertiesPrivateLinkServiceConnectionState",
        },
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["_models.ConnectionPropertiesPrivateEndpoint"] = None,
        group_ids: Optional[List[str]] = None,
        private_link_service_connection_state: Optional[
            "_models.ConnectionPropertiesPrivateLinkServiceConnectionState"
        ] = None,
        **kwargs
    ):
        """
        :keyword private_endpoint:
        :paramtype private_endpoint:
         ~azure.mgmt.digitaltwins.v2020_12_01.models.ConnectionPropertiesPrivateEndpoint
        :keyword group_ids: The list of group ids for the private endpoint connection.
        :paramtype group_ids: list[str]
        :keyword private_link_service_connection_state:
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.digitaltwins.v2020_12_01.models.ConnectionPropertiesPrivateLinkServiceConnectionState
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.private_endpoint = private_endpoint
        self.group_ids = group_ids
        self.private_link_service_connection_state = private_link_service_connection_state


class PrivateEndpoint(_serialization.Model):
    """The private endpoint property of a private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None


class ConnectionPropertiesPrivateEndpoint(PrivateEndpoint):
    """ConnectionPropertiesPrivateEndpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)


class ConnectionState(_serialization.Model):
    """The current state of a private endpoint connection.

    All required parameters must be populated in order to send to Azure.

    :ivar status: The status of a private endpoint connection. Required. Known values are:
     "Pending", "Approved", "Rejected", and "Disconnected".
    :vartype status: str or
     ~azure.mgmt.digitaltwins.v2020_12_01.models.PrivateLinkServiceConnectionStatus
    :ivar description: The description for the current state of a private endpoint connection.
     Required.
    :vartype description: str
    :ivar actions_required: Actions required for a private endpoint connection.
    :vartype actions_required: str
    """

    _validation = {
        "status": {"required": True},
        "description": {"required": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "actions_required": {"key": "actionsRequired", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Union[str, "_models.PrivateLinkServiceConnectionStatus"],
        description: str,
        actions_required: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword status: The status of a private endpoint connection. Required. Known values are:
         "Pending", "Approved", "Rejected", and "Disconnected".
        :paramtype status: str or
         ~azure.mgmt.digitaltwins.v2020_12_01.models.PrivateLinkServiceConnectionStatus
        :keyword description: The description for the current state of a private endpoint connection.
         Required.
        :paramtype description: str
        :keyword actions_required: Actions required for a private endpoint connection.
        :paramtype actions_required: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class ConnectionPropertiesPrivateLinkServiceConnectionState(ConnectionState):
    """ConnectionPropertiesPrivateLinkServiceConnectionState.

    All required parameters must be populated in order to send to Azure.

    :ivar status: The status of a private endpoint connection. Required. Known values are:
     "Pending", "Approved", "Rejected", and "Disconnected".
    :vartype status: str or
     ~azure.mgmt.digitaltwins.v2020_12_01.models.PrivateLinkServiceConnectionStatus
    :ivar description: The description for the current state of a private endpoint connection.
     Required.
    :vartype description: str
    :ivar actions_required: Actions required for a private endpoint connection.
    :vartype actions_required: str
    """

    _validation = {
        "status": {"required": True},
        "description": {"required": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "actions_required": {"key": "actionsRequired", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Union[str, "_models.PrivateLinkServiceConnectionStatus"],
        description: str,
        actions_required: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword status: The status of a private endpoint connection. Required. Known values are:
         "Pending", "Approved", "Rejected", and "Disconnected".
        :paramtype status: str or
         ~azure.mgmt.digitaltwins.v2020_12_01.models.PrivateLinkServiceConnectionStatus
        :keyword description: The description for the current state of a private endpoint connection.
         Required.
        :paramtype description: str
        :keyword actions_required: Actions required for a private endpoint connection.
        :paramtype actions_required: str
        """
        super().__init__(status=status, description=description, actions_required=actions_required, **kwargs)


class DigitalTwinsResource(_serialization.Model):
    """The common properties of a DigitalTwinsInstance.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar location: The resource location. Required.
    :vartype location: str
    :ivar tags: The resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: The managed identity for the DigitalTwinsInstance.
    :vartype identity: ~azure.mgmt.digitaltwins.v2020_12_01.models.DigitalTwinsIdentity
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True, "pattern": r"^(?!-)[A-Za-z0-9-]{3,63}(?<!-)$"},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "DigitalTwinsIdentity"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.DigitalTwinsIdentity"] = None,
        **kwargs
    ):
        """
        :keyword location: The resource location. Required.
        :paramtype location: str
        :keyword tags: The resource tags.
        :paramtype tags: dict[str, str]
        :keyword identity: The managed identity for the DigitalTwinsInstance.
        :paramtype identity: ~azure.mgmt.digitaltwins.v2020_12_01.models.DigitalTwinsIdentity
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags
        self.identity = identity


class DigitalTwinsDescription(DigitalTwinsResource):  # pylint: disable=too-many-instance-attributes
    """The description of the DigitalTwins service.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar location: The resource location. Required.
    :vartype location: str
    :ivar tags: The resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: The managed identity for the DigitalTwinsInstance.
    :vartype identity: ~azure.mgmt.digitaltwins.v2020_12_01.models.DigitalTwinsIdentity
    :ivar created_time: Time when DigitalTwinsInstance was created.
    :vartype created_time: ~datetime.datetime
    :ivar last_updated_time: Time when DigitalTwinsInstance was updated.
    :vartype last_updated_time: ~datetime.datetime
    :ivar provisioning_state: The provisioning state. Known values are: "Provisioning", "Deleting",
     "Updating", "Succeeded", "Failed", "Canceled", "Deleted", "Warning", "Suspending", "Restoring",
     and "Moving".
    :vartype provisioning_state: str or
     ~azure.mgmt.digitaltwins.v2020_12_01.models.ProvisioningState
    :ivar host_name: Api endpoint to work with DigitalTwinsInstance.
    :vartype host_name: str
    :ivar private_endpoint_connections:
    :vartype private_endpoint_connections:
     list[~azure.mgmt.digitaltwins.v2020_12_01.models.PrivateEndpointConnection]
    :ivar public_network_access: Public network access for the DigitalTwinsInstance. Known values
     are: "Enabled" and "Disabled".
    :vartype public_network_access: str or
     ~azure.mgmt.digitaltwins.v2020_12_01.models.PublicNetworkAccess
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True, "pattern": r"^(?!-)[A-Za-z0-9-]{3,63}(?<!-)$"},
        "type": {"readonly": True},
        "location": {"required": True},
        "created_time": {"readonly": True},
        "last_updated_time": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "host_name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "DigitalTwinsIdentity"},
        "created_time": {"key": "properties.createdTime", "type": "iso-8601"},
        "last_updated_time": {"key": "properties.lastUpdatedTime", "type": "iso-8601"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "host_name": {"key": "properties.hostName", "type": "str"},
        "private_endpoint_connections": {
            "key": "properties.privateEndpointConnections",
            "type": "[PrivateEndpointConnection]",
        },
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.DigitalTwinsIdentity"] = None,
        private_endpoint_connections: Optional[List["_models.PrivateEndpointConnection"]] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        **kwargs
    ):
        """
        :keyword location: The resource location. Required.
        :paramtype location: str
        :keyword tags: The resource tags.
        :paramtype tags: dict[str, str]
        :keyword identity: The managed identity for the DigitalTwinsInstance.
        :paramtype identity: ~azure.mgmt.digitaltwins.v2020_12_01.models.DigitalTwinsIdentity
        :keyword private_endpoint_connections:
        :paramtype private_endpoint_connections:
         list[~azure.mgmt.digitaltwins.v2020_12_01.models.PrivateEndpointConnection]
        :keyword public_network_access: Public network access for the DigitalTwinsInstance. Known
         values are: "Enabled" and "Disabled".
        :paramtype public_network_access: str or
         ~azure.mgmt.digitaltwins.v2020_12_01.models.PublicNetworkAccess
        """
        super().__init__(location=location, tags=tags, identity=identity, **kwargs)
        self.created_time = None
        self.last_updated_time = None
        self.provisioning_state = None
        self.host_name = None
        self.private_endpoint_connections = private_endpoint_connections
        self.public_network_access = public_network_access


class DigitalTwinsDescriptionListResult(_serialization.Model):
    """A list of DigitalTwins description objects with a next link.

    :ivar next_link: The link used to get the next page of DigitalTwins description objects.
    :vartype next_link: str
    :ivar value: A list of DigitalTwins description objects.
    :vartype value: list[~azure.mgmt.digitaltwins.v2020_12_01.models.DigitalTwinsDescription]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[DigitalTwinsDescription]"},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["_models.DigitalTwinsDescription"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link used to get the next page of DigitalTwins description objects.
        :paramtype next_link: str
        :keyword value: A list of DigitalTwins description objects.
        :paramtype value: list[~azure.mgmt.digitaltwins.v2020_12_01.models.DigitalTwinsDescription]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class ExternalResource(_serialization.Model):
    """Definition of a resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: Extension resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True, "pattern": r"^(?![0-9]+$)(?!-)[a-zA-Z0-9-]{2,49}[a-zA-Z0-9]$"},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class DigitalTwinsEndpointResource(ExternalResource):
    """DigitalTwinsInstance endpoint resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: Extension resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar properties: DigitalTwinsInstance endpoint resource properties. Required.
    :vartype properties:
     ~azure.mgmt.digitaltwins.v2020_12_01.models.DigitalTwinsEndpointResourceProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True, "pattern": r"^(?![0-9]+$)(?!-)[a-zA-Z0-9-]{2,49}[a-zA-Z0-9]$"},
        "type": {"readonly": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "DigitalTwinsEndpointResourceProperties"},
    }

    def __init__(self, *, properties: "_models.DigitalTwinsEndpointResourceProperties", **kwargs):
        """
        :keyword properties: DigitalTwinsInstance endpoint resource properties. Required.
        :paramtype properties:
         ~azure.mgmt.digitaltwins.v2020_12_01.models.DigitalTwinsEndpointResourceProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class DigitalTwinsEndpointResourceListResult(_serialization.Model):
    """A list of DigitalTwinsInstance Endpoints with a next link.

    :ivar next_link: The link used to get the next page of DigitalTwinsInstance Endpoints.
    :vartype next_link: str
    :ivar value: A list of DigitalTwinsInstance Endpoints.
    :vartype value: list[~azure.mgmt.digitaltwins.v2020_12_01.models.DigitalTwinsEndpointResource]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[DigitalTwinsEndpointResource]"},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["_models.DigitalTwinsEndpointResource"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link used to get the next page of DigitalTwinsInstance Endpoints.
        :paramtype next_link: str
        :keyword value: A list of DigitalTwinsInstance Endpoints.
        :paramtype value:
         list[~azure.mgmt.digitaltwins.v2020_12_01.models.DigitalTwinsEndpointResource]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class DigitalTwinsEndpointResourceProperties(_serialization.Model):
    """Properties related to Digital Twins Endpoint.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    EventGrid, EventHub, ServiceBus

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar endpoint_type: The type of Digital Twins endpoint. Required. Known values are:
     "EventHub", "EventGrid", and "ServiceBus".
    :vartype endpoint_type: str or ~azure.mgmt.digitaltwins.v2020_12_01.models.EndpointType
    :ivar provisioning_state: The provisioning state. Known values are: "Provisioning", "Deleting",
     "Succeeded", "Failed", "Canceled", "Deleted", "Warning", "Suspending", "Restoring", "Moving",
     and "Disabled".
    :vartype provisioning_state: str or
     ~azure.mgmt.digitaltwins.v2020_12_01.models.EndpointProvisioningState
    :ivar created_time: Time when the Endpoint was added to DigitalTwinsInstance.
    :vartype created_time: ~datetime.datetime
    :ivar authentication_type: Specifies the authentication type being used for connecting to the
     endpoint. Known values are: "KeyBased" and "IdentityBased".
    :vartype authentication_type: str or
     ~azure.mgmt.digitaltwins.v2020_12_01.models.AuthenticationType
    :ivar dead_letter_secret: Dead letter storage secret for key-based authentication. Will be
     obfuscated during read.
    :vartype dead_letter_secret: str
    :ivar dead_letter_uri: Dead letter storage URL for identity-based authentication.
    :vartype dead_letter_uri: str
    """

    _validation = {
        "endpoint_type": {"required": True},
        "provisioning_state": {"readonly": True},
        "created_time": {"readonly": True},
    }

    _attribute_map = {
        "endpoint_type": {"key": "endpointType", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "created_time": {"key": "createdTime", "type": "iso-8601"},
        "authentication_type": {"key": "authenticationType", "type": "str"},
        "dead_letter_secret": {"key": "deadLetterSecret", "type": "str"},
        "dead_letter_uri": {"key": "deadLetterUri", "type": "str"},
    }

    _subtype_map = {"endpoint_type": {"EventGrid": "EventGrid", "EventHub": "EventHub", "ServiceBus": "ServiceBus"}}

    def __init__(
        self,
        *,
        authentication_type: Optional[Union[str, "_models.AuthenticationType"]] = None,
        dead_letter_secret: Optional[str] = None,
        dead_letter_uri: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword authentication_type: Specifies the authentication type being used for connecting to
         the endpoint. Known values are: "KeyBased" and "IdentityBased".
        :paramtype authentication_type: str or
         ~azure.mgmt.digitaltwins.v2020_12_01.models.AuthenticationType
        :keyword dead_letter_secret: Dead letter storage secret for key-based authentication. Will be
         obfuscated during read.
        :paramtype dead_letter_secret: str
        :keyword dead_letter_uri: Dead letter storage URL for identity-based authentication.
        :paramtype dead_letter_uri: str
        """
        super().__init__(**kwargs)
        self.endpoint_type: Optional[str] = None
        self.provisioning_state = None
        self.created_time = None
        self.authentication_type = authentication_type
        self.dead_letter_secret = dead_letter_secret
        self.dead_letter_uri = dead_letter_uri


class DigitalTwinsIdentity(_serialization.Model):
    """The managed identity for the DigitalTwinsInstance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of Managed Identity used by the DigitalTwinsInstance. Only SystemAssigned
     is supported. Known values are: "None" and "SystemAssigned".
    :vartype type: str or ~azure.mgmt.digitaltwins.v2020_12_01.models.DigitalTwinsIdentityType
    :ivar principal_id: The object id of the Managed Identity Resource. This will be sent to the RP
     from ARM via the x-ms-identity-principal-id header in the PUT request if the resource has a
     systemAssigned(implicit) identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id of the Managed Identity Resource. This will be sent to the RP
     from ARM via the x-ms-client-tenant-id header in the PUT request if the resource has a
     systemAssigned(implicit) identity.
    :vartype tenant_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(self, *, type: Optional[Union[str, "_models.DigitalTwinsIdentityType"]] = None, **kwargs):
        """
        :keyword type: The type of Managed Identity used by the DigitalTwinsInstance. Only
         SystemAssigned is supported. Known values are: "None" and "SystemAssigned".
        :paramtype type: str or ~azure.mgmt.digitaltwins.v2020_12_01.models.DigitalTwinsIdentityType
        """
        super().__init__(**kwargs)
        self.type = type
        self.principal_id = None
        self.tenant_id = None


class DigitalTwinsPatchDescription(_serialization.Model):
    """The description of the DigitalTwins service.

    :ivar tags: Instance patch properties.
    :vartype tags: dict[str, str]
    :ivar identity: The managed identity for the DigitalTwinsInstance.
    :vartype identity: ~azure.mgmt.digitaltwins.v2020_12_01.models.DigitalTwinsIdentity
    :ivar properties: Properties for the DigitalTwinsInstance.
    :vartype properties: ~azure.mgmt.digitaltwins.v2020_12_01.models.DigitalTwinsPatchProperties
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "DigitalTwinsIdentity"},
        "properties": {"key": "properties", "type": "DigitalTwinsPatchProperties"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.DigitalTwinsIdentity"] = None,
        properties: Optional["_models.DigitalTwinsPatchProperties"] = None,
        **kwargs
    ):
        """
        :keyword tags: Instance patch properties.
        :paramtype tags: dict[str, str]
        :keyword identity: The managed identity for the DigitalTwinsInstance.
        :paramtype identity: ~azure.mgmt.digitaltwins.v2020_12_01.models.DigitalTwinsIdentity
        :keyword properties: Properties for the DigitalTwinsInstance.
        :paramtype properties: ~azure.mgmt.digitaltwins.v2020_12_01.models.DigitalTwinsPatchProperties
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.identity = identity
        self.properties = properties


class DigitalTwinsPatchProperties(_serialization.Model):
    """The properties of a DigitalTwinsInstance.

    :ivar public_network_access: Public network access for the DigitalTwinsInstance. Known values
     are: "Enabled" and "Disabled".
    :vartype public_network_access: str or
     ~azure.mgmt.digitaltwins.v2020_12_01.models.PublicNetworkAccess
    """

    _attribute_map = {
        "public_network_access": {"key": "publicNetworkAccess", "type": "str"},
    }

    def __init__(self, *, public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None, **kwargs):
        """
        :keyword public_network_access: Public network access for the DigitalTwinsInstance. Known
         values are: "Enabled" and "Disabled".
        :paramtype public_network_access: str or
         ~azure.mgmt.digitaltwins.v2020_12_01.models.PublicNetworkAccess
        """
        super().__init__(**kwargs)
        self.public_network_access = public_network_access


class ErrorDefinition(_serialization.Model):
    """Error definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Service specific error code which serves as the substatus for the HTTP error code.
    :vartype code: str
    :ivar message: Description of the error.
    :vartype message: str
    :ivar details: Internal error details.
    :vartype details: list[~azure.mgmt.digitaltwins.v2020_12_01.models.ErrorDefinition]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "details": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDefinition]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.details = None


class ErrorResponse(_serialization.Model):
    """Error response.

    :ivar error: Error description.
    :vartype error: ~azure.mgmt.digitaltwins.v2020_12_01.models.ErrorDefinition
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDefinition"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDefinition"] = None, **kwargs):
        """
        :keyword error: Error description.
        :paramtype error: ~azure.mgmt.digitaltwins.v2020_12_01.models.ErrorDefinition
        """
        super().__init__(**kwargs)
        self.error = error


class EventGrid(DigitalTwinsEndpointResourceProperties):
    """Properties related to EventGrid.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar endpoint_type: The type of Digital Twins endpoint. Required. Known values are:
     "EventHub", "EventGrid", and "ServiceBus".
    :vartype endpoint_type: str or ~azure.mgmt.digitaltwins.v2020_12_01.models.EndpointType
    :ivar provisioning_state: The provisioning state. Known values are: "Provisioning", "Deleting",
     "Succeeded", "Failed", "Canceled", "Deleted", "Warning", "Suspending", "Restoring", "Moving",
     and "Disabled".
    :vartype provisioning_state: str or
     ~azure.mgmt.digitaltwins.v2020_12_01.models.EndpointProvisioningState
    :ivar created_time: Time when the Endpoint was added to DigitalTwinsInstance.
    :vartype created_time: ~datetime.datetime
    :ivar authentication_type: Specifies the authentication type being used for connecting to the
     endpoint. Known values are: "KeyBased" and "IdentityBased".
    :vartype authentication_type: str or
     ~azure.mgmt.digitaltwins.v2020_12_01.models.AuthenticationType
    :ivar dead_letter_secret: Dead letter storage secret for key-based authentication. Will be
     obfuscated during read.
    :vartype dead_letter_secret: str
    :ivar dead_letter_uri: Dead letter storage URL for identity-based authentication.
    :vartype dead_letter_uri: str
    :ivar topic_endpoint: EventGrid Topic Endpoint. Required.
    :vartype topic_endpoint: str
    :ivar access_key1: EventGrid secondary accesskey. Will be obfuscated during read. Required.
    :vartype access_key1: str
    :ivar access_key2: EventGrid secondary accesskey. Will be obfuscated during read.
    :vartype access_key2: str
    """

    _validation = {
        "endpoint_type": {"required": True},
        "provisioning_state": {"readonly": True},
        "created_time": {"readonly": True},
        "topic_endpoint": {"required": True},
        "access_key1": {"required": True},
    }

    _attribute_map = {
        "endpoint_type": {"key": "endpointType", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "created_time": {"key": "createdTime", "type": "iso-8601"},
        "authentication_type": {"key": "authenticationType", "type": "str"},
        "dead_letter_secret": {"key": "deadLetterSecret", "type": "str"},
        "dead_letter_uri": {"key": "deadLetterUri", "type": "str"},
        "topic_endpoint": {"key": "TopicEndpoint", "type": "str"},
        "access_key1": {"key": "accessKey1", "type": "str"},
        "access_key2": {"key": "accessKey2", "type": "str"},
    }

    def __init__(
        self,
        *,
        topic_endpoint: str,
        access_key1: str,
        authentication_type: Optional[Union[str, "_models.AuthenticationType"]] = None,
        dead_letter_secret: Optional[str] = None,
        dead_letter_uri: Optional[str] = None,
        access_key2: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword authentication_type: Specifies the authentication type being used for connecting to
         the endpoint. Known values are: "KeyBased" and "IdentityBased".
        :paramtype authentication_type: str or
         ~azure.mgmt.digitaltwins.v2020_12_01.models.AuthenticationType
        :keyword dead_letter_secret: Dead letter storage secret for key-based authentication. Will be
         obfuscated during read.
        :paramtype dead_letter_secret: str
        :keyword dead_letter_uri: Dead letter storage URL for identity-based authentication.
        :paramtype dead_letter_uri: str
        :keyword topic_endpoint: EventGrid Topic Endpoint. Required.
        :paramtype topic_endpoint: str
        :keyword access_key1: EventGrid secondary accesskey. Will be obfuscated during read. Required.
        :paramtype access_key1: str
        :keyword access_key2: EventGrid secondary accesskey. Will be obfuscated during read.
        :paramtype access_key2: str
        """
        super().__init__(
            authentication_type=authentication_type,
            dead_letter_secret=dead_letter_secret,
            dead_letter_uri=dead_letter_uri,
            **kwargs
        )
        self.endpoint_type: str = "EventGrid"
        self.topic_endpoint = topic_endpoint
        self.access_key1 = access_key1
        self.access_key2 = access_key2


class EventHub(DigitalTwinsEndpointResourceProperties):
    """Properties related to EventHub.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar endpoint_type: The type of Digital Twins endpoint. Required. Known values are:
     "EventHub", "EventGrid", and "ServiceBus".
    :vartype endpoint_type: str or ~azure.mgmt.digitaltwins.v2020_12_01.models.EndpointType
    :ivar provisioning_state: The provisioning state. Known values are: "Provisioning", "Deleting",
     "Succeeded", "Failed", "Canceled", "Deleted", "Warning", "Suspending", "Restoring", "Moving",
     and "Disabled".
    :vartype provisioning_state: str or
     ~azure.mgmt.digitaltwins.v2020_12_01.models.EndpointProvisioningState
    :ivar created_time: Time when the Endpoint was added to DigitalTwinsInstance.
    :vartype created_time: ~datetime.datetime
    :ivar authentication_type: Specifies the authentication type being used for connecting to the
     endpoint. Known values are: "KeyBased" and "IdentityBased".
    :vartype authentication_type: str or
     ~azure.mgmt.digitaltwins.v2020_12_01.models.AuthenticationType
    :ivar dead_letter_secret: Dead letter storage secret for key-based authentication. Will be
     obfuscated during read.
    :vartype dead_letter_secret: str
    :ivar dead_letter_uri: Dead letter storage URL for identity-based authentication.
    :vartype dead_letter_uri: str
    :ivar connection_string_primary_key: PrimaryConnectionString of the endpoint for key-based
     authentication. Will be obfuscated during read.
    :vartype connection_string_primary_key: str
    :ivar connection_string_secondary_key: SecondaryConnectionString of the endpoint for key-based
     authentication. Will be obfuscated during read.
    :vartype connection_string_secondary_key: str
    :ivar endpoint_uri: The URL of the EventHub namespace for identity-based authentication. It
     must include the protocol sb://.
    :vartype endpoint_uri: str
    :ivar entity_path: The EventHub name in the EventHub namespace for identity-based
     authentication.
    :vartype entity_path: str
    """

    _validation = {
        "endpoint_type": {"required": True},
        "provisioning_state": {"readonly": True},
        "created_time": {"readonly": True},
    }

    _attribute_map = {
        "endpoint_type": {"key": "endpointType", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "created_time": {"key": "createdTime", "type": "iso-8601"},
        "authentication_type": {"key": "authenticationType", "type": "str"},
        "dead_letter_secret": {"key": "deadLetterSecret", "type": "str"},
        "dead_letter_uri": {"key": "deadLetterUri", "type": "str"},
        "connection_string_primary_key": {"key": "connectionStringPrimaryKey", "type": "str"},
        "connection_string_secondary_key": {"key": "connectionStringSecondaryKey", "type": "str"},
        "endpoint_uri": {"key": "endpointUri", "type": "str"},
        "entity_path": {"key": "entityPath", "type": "str"},
    }

    def __init__(
        self,
        *,
        authentication_type: Optional[Union[str, "_models.AuthenticationType"]] = None,
        dead_letter_secret: Optional[str] = None,
        dead_letter_uri: Optional[str] = None,
        connection_string_primary_key: Optional[str] = None,
        connection_string_secondary_key: Optional[str] = None,
        endpoint_uri: Optional[str] = None,
        entity_path: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword authentication_type: Specifies the authentication type being used for connecting to
         the endpoint. Known values are: "KeyBased" and "IdentityBased".
        :paramtype authentication_type: str or
         ~azure.mgmt.digitaltwins.v2020_12_01.models.AuthenticationType
        :keyword dead_letter_secret: Dead letter storage secret for key-based authentication. Will be
         obfuscated during read.
        :paramtype dead_letter_secret: str
        :keyword dead_letter_uri: Dead letter storage URL for identity-based authentication.
        :paramtype dead_letter_uri: str
        :keyword connection_string_primary_key: PrimaryConnectionString of the endpoint for key-based
         authentication. Will be obfuscated during read.
        :paramtype connection_string_primary_key: str
        :keyword connection_string_secondary_key: SecondaryConnectionString of the endpoint for
         key-based authentication. Will be obfuscated during read.
        :paramtype connection_string_secondary_key: str
        :keyword endpoint_uri: The URL of the EventHub namespace for identity-based authentication. It
         must include the protocol sb://.
        :paramtype endpoint_uri: str
        :keyword entity_path: The EventHub name in the EventHub namespace for identity-based
         authentication.
        :paramtype entity_path: str
        """
        super().__init__(
            authentication_type=authentication_type,
            dead_letter_secret=dead_letter_secret,
            dead_letter_uri=dead_letter_uri,
            **kwargs
        )
        self.endpoint_type: str = "EventHub"
        self.connection_string_primary_key = connection_string_primary_key
        self.connection_string_secondary_key = connection_string_secondary_key
        self.endpoint_uri = endpoint_uri
        self.entity_path = entity_path


class GroupIdInformation(_serialization.Model):
    """The group information for creating a private endpoint on Digital Twin.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar properties: Required.
    :vartype properties: ~azure.mgmt.digitaltwins.v2020_12_01.models.GroupIdInformationProperties
    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    """

    _validation = {
        "properties": {"required": True},
        "name": {"readonly": True, "pattern": r"^(?![0-9]+$)(?!-)[a-zA-Z0-9-]{2,49}[a-zA-Z0-9]$"},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "GroupIdInformationProperties"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        properties: "_models.GroupIdInformationProperties",
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        **kwargs
    ):
        """
        :keyword properties: Required.
        :paramtype properties: ~azure.mgmt.digitaltwins.v2020_12_01.models.GroupIdInformationProperties
        :keyword id: The resource identifier.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.id = id
        self.name = None
        self.type = None


class GroupIdInformationPropertiesAutoGenerated(_serialization.Model):
    """The properties for a group information object.

    :ivar group_id: The group id.
    :vartype group_id: str
    :ivar required_members: The required members for a specific group id.
    :vartype required_members: list[str]
    :ivar required_zone_names: The required DNS zones for a specific group id.
    :vartype required_zone_names: list[str]
    """

    _attribute_map = {
        "group_id": {"key": "groupId", "type": "str"},
        "required_members": {"key": "requiredMembers", "type": "[str]"},
        "required_zone_names": {"key": "requiredZoneNames", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        group_id: Optional[str] = None,
        required_members: Optional[List[str]] = None,
        required_zone_names: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword group_id: The group id.
        :paramtype group_id: str
        :keyword required_members: The required members for a specific group id.
        :paramtype required_members: list[str]
        :keyword required_zone_names: The required DNS zones for a specific group id.
        :paramtype required_zone_names: list[str]
        """
        super().__init__(**kwargs)
        self.group_id = group_id
        self.required_members = required_members
        self.required_zone_names = required_zone_names


class GroupIdInformationProperties(GroupIdInformationPropertiesAutoGenerated):
    """GroupIdInformationProperties.

    :ivar group_id: The group id.
    :vartype group_id: str
    :ivar required_members: The required members for a specific group id.
    :vartype required_members: list[str]
    :ivar required_zone_names: The required DNS zones for a specific group id.
    :vartype required_zone_names: list[str]
    """

    _attribute_map = {
        "group_id": {"key": "groupId", "type": "str"},
        "required_members": {"key": "requiredMembers", "type": "[str]"},
        "required_zone_names": {"key": "requiredZoneNames", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        group_id: Optional[str] = None,
        required_members: Optional[List[str]] = None,
        required_zone_names: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword group_id: The group id.
        :paramtype group_id: str
        :keyword required_members: The required members for a specific group id.
        :paramtype required_members: list[str]
        :keyword required_zone_names: The required DNS zones for a specific group id.
        :paramtype required_zone_names: list[str]
        """
        super().__init__(
            group_id=group_id, required_members=required_members, required_zone_names=required_zone_names, **kwargs
        )


class GroupIdInformationResponse(_serialization.Model):
    """The available private link resources for a Digital Twin.

    :ivar value: The list of available private link resources for a Digital Twin.
    :vartype value: list[~azure.mgmt.digitaltwins.v2020_12_01.models.GroupIdInformation]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[GroupIdInformation]"},
    }

    def __init__(self, *, value: Optional[List["_models.GroupIdInformation"]] = None, **kwargs):
        """
        :keyword value: The list of available private link resources for a Digital Twin.
        :paramtype value: list[~azure.mgmt.digitaltwins.v2020_12_01.models.GroupIdInformation]
        """
        super().__init__(**kwargs)
        self.value = value


class Operation(_serialization.Model):
    """DigitalTwins service REST API operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Operation name: {provider}/{resource}/{read | write | action | delete}.
    :vartype name: str
    :ivar display: Operation properties display.
    :vartype display: ~azure.mgmt.digitaltwins.v2020_12_01.models.OperationDisplay
    :ivar origin: The intended executor of the operation.
    :vartype origin: str
    :ivar is_data_action: If the operation is a data action (for data plane rbac).
    :vartype is_data_action: bool
    """

    _validation = {
        "name": {"readonly": True},
        "origin": {"readonly": True},
        "is_data_action": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs):
        """
        :keyword display: Operation properties display.
        :paramtype display: ~azure.mgmt.digitaltwins.v2020_12_01.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.display = display
        self.origin = None
        self.is_data_action = None


class OperationDisplay(_serialization.Model):
    """The object that represents the operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: Service provider: Microsoft DigitalTwins.
    :vartype provider: str
    :ivar resource: Resource Type: DigitalTwinsInstances.
    :vartype resource: str
    :ivar operation: Name of the operation.
    :vartype operation: str
    :ivar description: Friendly description for the operation,.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of DigitalTwins service operations. It contains a list of operations and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar next_link: The link used to get the next page of DigitalTwins description objects.
    :vartype next_link: str
    :ivar value: A list of DigitalTwins operations supported by the Microsoft.DigitalTwins resource
     provider.
    :vartype value: list[~azure.mgmt.digitaltwins.v2020_12_01.models.Operation]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[Operation]"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: The link used to get the next page of DigitalTwins description objects.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = None


class PrivateEndpointConnection(_serialization.Model):
    """The private endpoint connection of a Digital Twin.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar properties: Required.
    :vartype properties:
     ~azure.mgmt.digitaltwins.v2020_12_01.models.PrivateEndpointConnectionProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True, "pattern": r"^(?![0-9]+$)(?!-)[a-zA-Z0-9-]{2,49}[a-zA-Z0-9]$"},
        "type": {"readonly": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "PrivateEndpointConnectionProperties"},
    }

    def __init__(self, *, properties: "_models.PrivateEndpointConnectionProperties", **kwargs):
        """
        :keyword properties: Required.
        :paramtype properties:
         ~azure.mgmt.digitaltwins.v2020_12_01.models.PrivateEndpointConnectionProperties
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.properties = properties


class PrivateEndpointConnectionProperties(ConnectionProperties):
    """PrivateEndpointConnectionProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: The provisioning state. Known values are: "Pending", "Approved",
     "Rejected", and "Disconnected".
    :vartype provisioning_state: str or
     ~azure.mgmt.digitaltwins.v2020_12_01.models.ConnectionPropertiesProvisioningState
    :ivar private_endpoint:
    :vartype private_endpoint:
     ~azure.mgmt.digitaltwins.v2020_12_01.models.ConnectionPropertiesPrivateEndpoint
    :ivar group_ids: The list of group ids for the private endpoint connection.
    :vartype group_ids: list[str]
    :ivar private_link_service_connection_state:
    :vartype private_link_service_connection_state:
     ~azure.mgmt.digitaltwins.v2020_12_01.models.ConnectionPropertiesPrivateLinkServiceConnectionState
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "private_endpoint": {"key": "privateEndpoint", "type": "ConnectionPropertiesPrivateEndpoint"},
        "group_ids": {"key": "groupIds", "type": "[str]"},
        "private_link_service_connection_state": {
            "key": "privateLinkServiceConnectionState",
            "type": "ConnectionPropertiesPrivateLinkServiceConnectionState",
        },
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["_models.ConnectionPropertiesPrivateEndpoint"] = None,
        group_ids: Optional[List[str]] = None,
        private_link_service_connection_state: Optional[
            "_models.ConnectionPropertiesPrivateLinkServiceConnectionState"
        ] = None,
        **kwargs
    ):
        """
        :keyword private_endpoint:
        :paramtype private_endpoint:
         ~azure.mgmt.digitaltwins.v2020_12_01.models.ConnectionPropertiesPrivateEndpoint
        :keyword group_ids: The list of group ids for the private endpoint connection.
        :paramtype group_ids: list[str]
        :keyword private_link_service_connection_state:
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.digitaltwins.v2020_12_01.models.ConnectionPropertiesPrivateLinkServiceConnectionState
        """
        super().__init__(
            private_endpoint=private_endpoint,
            group_ids=group_ids,
            private_link_service_connection_state=private_link_service_connection_state,
            **kwargs
        )


class PrivateEndpointConnectionsResponse(_serialization.Model):
    """The available private link connections for a Digital Twin.

    :ivar value: The list of available private link connections for a Digital Twin.
    :vartype value: list[~azure.mgmt.digitaltwins.v2020_12_01.models.PrivateEndpointConnection]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateEndpointConnection]"},
    }

    def __init__(self, *, value: Optional[List["_models.PrivateEndpointConnection"]] = None, **kwargs):
        """
        :keyword value: The list of available private link connections for a Digital Twin.
        :paramtype value: list[~azure.mgmt.digitaltwins.v2020_12_01.models.PrivateEndpointConnection]
        """
        super().__init__(**kwargs)
        self.value = value


class ServiceBus(DigitalTwinsEndpointResourceProperties):
    """Properties related to ServiceBus.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar endpoint_type: The type of Digital Twins endpoint. Required. Known values are:
     "EventHub", "EventGrid", and "ServiceBus".
    :vartype endpoint_type: str or ~azure.mgmt.digitaltwins.v2020_12_01.models.EndpointType
    :ivar provisioning_state: The provisioning state. Known values are: "Provisioning", "Deleting",
     "Succeeded", "Failed", "Canceled", "Deleted", "Warning", "Suspending", "Restoring", "Moving",
     and "Disabled".
    :vartype provisioning_state: str or
     ~azure.mgmt.digitaltwins.v2020_12_01.models.EndpointProvisioningState
    :ivar created_time: Time when the Endpoint was added to DigitalTwinsInstance.
    :vartype created_time: ~datetime.datetime
    :ivar authentication_type: Specifies the authentication type being used for connecting to the
     endpoint. Known values are: "KeyBased" and "IdentityBased".
    :vartype authentication_type: str or
     ~azure.mgmt.digitaltwins.v2020_12_01.models.AuthenticationType
    :ivar dead_letter_secret: Dead letter storage secret for key-based authentication. Will be
     obfuscated during read.
    :vartype dead_letter_secret: str
    :ivar dead_letter_uri: Dead letter storage URL for identity-based authentication.
    :vartype dead_letter_uri: str
    :ivar primary_connection_string: PrimaryConnectionString of the endpoint for key-based
     authentication. Will be obfuscated during read.
    :vartype primary_connection_string: str
    :ivar secondary_connection_string: SecondaryConnectionString of the endpoint for key-based
     authentication. Will be obfuscated during read.
    :vartype secondary_connection_string: str
    :ivar endpoint_uri: The URL of the ServiceBus namespace for identity-based authentication. It
     must include the protocol sb://.
    :vartype endpoint_uri: str
    :ivar entity_path: The ServiceBus Topic name for identity-based authentication.
    :vartype entity_path: str
    """

    _validation = {
        "endpoint_type": {"required": True},
        "provisioning_state": {"readonly": True},
        "created_time": {"readonly": True},
    }

    _attribute_map = {
        "endpoint_type": {"key": "endpointType", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "created_time": {"key": "createdTime", "type": "iso-8601"},
        "authentication_type": {"key": "authenticationType", "type": "str"},
        "dead_letter_secret": {"key": "deadLetterSecret", "type": "str"},
        "dead_letter_uri": {"key": "deadLetterUri", "type": "str"},
        "primary_connection_string": {"key": "primaryConnectionString", "type": "str"},
        "secondary_connection_string": {"key": "secondaryConnectionString", "type": "str"},
        "endpoint_uri": {"key": "endpointUri", "type": "str"},
        "entity_path": {"key": "entityPath", "type": "str"},
    }

    def __init__(
        self,
        *,
        authentication_type: Optional[Union[str, "_models.AuthenticationType"]] = None,
        dead_letter_secret: Optional[str] = None,
        dead_letter_uri: Optional[str] = None,
        primary_connection_string: Optional[str] = None,
        secondary_connection_string: Optional[str] = None,
        endpoint_uri: Optional[str] = None,
        entity_path: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword authentication_type: Specifies the authentication type being used for connecting to
         the endpoint. Known values are: "KeyBased" and "IdentityBased".
        :paramtype authentication_type: str or
         ~azure.mgmt.digitaltwins.v2020_12_01.models.AuthenticationType
        :keyword dead_letter_secret: Dead letter storage secret for key-based authentication. Will be
         obfuscated during read.
        :paramtype dead_letter_secret: str
        :keyword dead_letter_uri: Dead letter storage URL for identity-based authentication.
        :paramtype dead_letter_uri: str
        :keyword primary_connection_string: PrimaryConnectionString of the endpoint for key-based
         authentication. Will be obfuscated during read.
        :paramtype primary_connection_string: str
        :keyword secondary_connection_string: SecondaryConnectionString of the endpoint for key-based
         authentication. Will be obfuscated during read.
        :paramtype secondary_connection_string: str
        :keyword endpoint_uri: The URL of the ServiceBus namespace for identity-based authentication.
         It must include the protocol sb://.
        :paramtype endpoint_uri: str
        :keyword entity_path: The ServiceBus Topic name for identity-based authentication.
        :paramtype entity_path: str
        """
        super().__init__(
            authentication_type=authentication_type,
            dead_letter_secret=dead_letter_secret,
            dead_letter_uri=dead_letter_uri,
            **kwargs
        )
        self.endpoint_type: str = "ServiceBus"
        self.primary_connection_string = primary_connection_string
        self.secondary_connection_string = secondary_connection_string
        self.endpoint_uri = endpoint_uri
        self.entity_path = entity_path
