# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from typing import Optional
from typing_extensions import Literal

from ..._models import BaseModel
from .beta_cache_creation import BetaCacheCreation

__all__ = ["BetaMessageIterationUsage"]


class BetaMessageIterationUsage(BaseModel):
    """Token usage for a sampling iteration."""

    cache_creation: Optional[BetaCacheCreation] = None
    """Breakdown of cached tokens by TTL"""

    cache_creation_input_tokens: int
    """The number of input tokens used to create the cache entry."""

    cache_read_input_tokens: int
    """The number of input tokens read from the cache."""

    input_tokens: int
    """The number of input tokens which were used."""

    output_tokens: int
    """The number of output tokens which were used."""

    type: Literal["message"]
    """Usage for a sampling iteration"""
