/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.math.BigInteger;

public final class BigInt {
    private byte[] places;
    private static final String digits = "0123456789abcdef";

    public BigInt(byte[] byArray) {
        this.places = byArray;
    }

    public BigInt(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if ((byArray[0] & 0x80) != 0) {
            throw new IllegalArgumentException("negative BigInteger");
        }
        if (byArray[0] != 0) {
            this.places = byArray;
            return;
        }
        this.places = new byte[byArray.length - 1];
        int n = 1;
        while (n < byArray.length) {
            this.places[n - 1] = byArray[n];
            ++n;
        }
    }

    public BigInt(int n) {
        if (n < 256) {
            this.places = new byte[1];
            this.places[0] = (byte)n;
            return;
        }
        if (n < 65536) {
            this.places = new byte[2];
            this.places[0] = (byte)n;
            this.places[1] = (byte)(n >> 8);
            return;
        }
        if (n < 0x1000000) {
            this.places = new byte[3];
            this.places[0] = (byte)n;
            this.places[1] = (byte)(n >> 8);
            this.places[2] = (byte)(n >> 16);
            return;
        }
        this.places = new byte[4];
        this.places[0] = (byte)n;
        this.places[1] = (byte)(n >> 8);
        this.places[2] = (byte)(n >> 16);
        this.places[3] = (byte)(n >> 24);
    }

    public int toInt() {
        if (this.places.length > 4) {
            throw new NumberFormatException("BigInt.toLong, too big");
        }
        int n = 0;
        int n2 = 0;
        while (n < this.places.length) {
            n2 <<= 8;
            n2 += 0xFF & this.places[n];
            ++n;
        }
        return n2;
    }

    public String toString() {
        return this.hexify();
    }

    public BigInteger toBigInteger() {
        return new BigInteger(1, this.places);
    }

    public byte[] toByteArray() {
        return this.places;
    }

    private String hexify() {
        StringBuffer stringBuffer = new StringBuffer(this.places.length * 2);
        stringBuffer.append("    ");
        int n = 0;
        while (n < this.places.length) {
            stringBuffer.append(digits.charAt(this.places[n] >> 4 & 0xF));
            stringBuffer.append(digits.charAt(this.places[n] & 0xF));
            if ((n + 1) % 32 == 0) {
                if (n + 1 != this.places.length) {
                    stringBuffer.append("\n    ");
                }
            } else if ((n + 1) % 4 == 0) {
                stringBuffer.append(' ');
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof BigInt) {
            return this.equals((BigInt)object);
        }
        return false;
    }

    public boolean equals(BigInt bigInt) {
        BigInteger bigInteger = new BigInteger(1, this.toByteArray());
        BigInteger bigInteger2 = new BigInteger(1, bigInt.toByteArray());
        return bigInteger.equals(bigInteger2);
    }
}

