/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.dgc.DGC;
import java.rmi.dgc.Lease;
import java.rmi.dgc.VMID;
import java.rmi.server.LogStream;
import java.rmi.server.ObjID;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sun.rmi.transport.DGCImpl;
import sun.rmi.transport.Endpoint;
import sun.rmi.transport.LiveRef;
import sun.rmi.transport.LocateDGC;
import sun.rmi.transport.RMIThread;
import sun.rmi.transport.Utils;

final class DGCClient
implements Runnable {
    private static final long leaseValue = DGCClient.getLong("java.rmi.dgc.leaseValue", 600000L);
    private static Object lock = new Object();
    private static Hashtable countTable = new Hashtable();
    private static Hashtable leaseTable = new Hashtable();
    private static Hashtable cleanTable = new Hashtable();
    private static Vector unrefList = new Vector();
    private static boolean leaseTableModified;
    private static VMID vmid;
    private static long nextSequenceNum;
    private static Thread cleaner;
    private static Thread leasee;

    private static long getLong(String string, long l) {
        return Utils.getLong(string, l);
    }

    private DGCClient() {
    }

    static void referenced(LiveRef[] liveRefArray) throws RemoteException {
        Object object = lock;
        synchronized (object) {
            Object object2;
            Object object3;
            LeaseTableEntry leaseTableEntry;
            Endpoint endpoint = liveRefArray[0].getEndpoint();
            if (DGCImpl.logLevel >= 20) {
                LogStream.log("dgc").println("DGCClient.referenced:endpoint =" + endpoint);
            }
            if ((leaseTableEntry = (LeaseTableEntry)leaseTable.get(endpoint)) == null) {
                leaseTableEntry = new LeaseTableEntry(endpoint);
                leaseTable.put(endpoint, leaseTableEntry);
                if (DGCImpl.logLevel >= 20) {
                    LogStream.log("dgc").println("DGCClient.referenced: added Endpoint =" + endpoint + "to the leaseTable" + "LeaseTableEntry =" + leaseTableEntry);
                }
                if (leasee == null) {
                    leasee = RMIThread.newThread(new LeaseRenewer(), "LeaseRenewer", true);
                    leasee.start();
                }
                if (cleaner == null) {
                    cleaner = RMIThread.newThread(new DGCClient(), "Cleaner", true);
                    cleaner.start();
                }
            }
            if (DGCImpl.logLevel >= 20) {
                LogStream.log("dgc").println("DGCClient.referenced: leaseTableEntry" + leaseTableEntry);
            }
            Vector vector = new Vector();
            int n = 0;
            while (n < liveRefArray.length) {
                ObjID objID;
                object3 = (CountTableEntry)countTable.get(liveRefArray[n]);
                if (object3 == null) {
                    object2 = liveRefArray[n].copy();
                    objID = ((LiveRef)object2).getObjID();
                    object3 = new CountTableEntry();
                    countTable.put(object2, object3);
                    if (DGCImpl.logLevel >= 20) {
                        LogStream.log("dgc").println("DGCClient.referenced:  Added LiveRef = " + liveRefArray[n] + "ObjID = " + objID + " to the countTable. " + "CountTableEntry = " + object3);
                    }
                } else {
                    objID = liveRefArray[n].getObjID();
                }
                if (!leaseTableEntry.objIdList.contains(objID)) {
                    leaseTableEntry.objIdList.addElement(objID);
                    vector.addElement(liveRefArray[n]);
                    if (DGCImpl.logLevel >= 20) {
                        LogStream.log("dgc").println("DGCClient.referenced: added ref = " + liveRefArray[n] + " to the dirtyRefList" + " and added ObjID = " + objID + " to objIdList");
                    }
                }
                liveRefArray[n].counted();
                ++object3.refCount;
                if (DGCImpl.logLevel >= 20) {
                    LogStream.log("dgc").println("DGCClient.referenced: leaseTableEntry" + leaseTableEntry);
                }
                ++n;
            }
            if (vector.isEmpty()) {
                if (DGCImpl.logLevel >= 20) {
                    LogStream.log("dgc").println("DGCClient.referenced: No dirty calls necessary -- returning.");
                }
                Object var2_9 = null;
                return;
            }
            object3 = DGCClient.getObjIdArray(vector);
            object2 = null;
            try {
                object2 = LocateDGC.getDGC(endpoint);
            }
            catch (RemoteException remoteException) {}
            try {
                if (DGCImpl.logLevel >= 20) {
                    LogStream.log("dgc").println("DGCClient.referenced: making dirty call...");
                }
                Lease lease = object2.dirty((ObjID[])object3, DGCClient.getNextSequenceNum(), new Lease(vmid, leaseValue));
                long l = System.currentTimeMillis();
                vmid = lease.getVMID();
                if (DGCImpl.logLevel >= 20) {
                    LogStream.log("dgc").println("DGCClient.referenced: New lease -- vmid = " + lease.getVMID() + "duration = " + lease.getValue());
                }
                DGCClient.setUpLeasing(leaseTableEntry, l, lease);
            }
            catch (RemoteException remoteException) {
                if (DGCImpl.logLevel >= 10) {
                    LogStream.log("dgc").println("DGCClient.referenced: dirty call failed");
                }
                DGCClient.scheduleClean(object3, endpoint, true);
                DGCClient.cleanUpCountTable(vector);
                throw remoteException;
            }
            return;
        }
    }

    private static void setUpLeasing(LeaseTableEntry leaseTableEntry, long l, Lease lease) {
        long l2 = leaseTableEntry.renewTime == 0L ? 0L : leaseTableEntry.lease.getValue();
        long l3 = lease.getValue();
        long l4 = l + DGCClient.getRenewTime(l3);
        leaseTableEntry.lease = lease;
        if (DGCImpl.logLevel >= 20) {
            LogStream.log("dgc").println("DGCClient.setUpLeasing: old lease length = " + l2 + " new lease length = " + l3 + " current time = " + l);
        }
        if (l3 < l2 || leaseTableEntry.renewTime == 0L) {
            leaseTableEntry.renewTime = l4;
            leaseTableModified = true;
            lock.notifyAll();
            if (DGCImpl.logLevel >= 20) {
                LogStream.log("dgc").println("DGCClient.setUpLeasing: notifyAll called on leasing thread.");
                return;
            }
        } else {
            leaseTableEntry.renewTime = l4;
        }
    }

    private static long getRenewTime(long l) {
        return (long)(0.5 * (double)l);
    }

    static void referenced(LiveRef liveRef) throws RemoteException {
        LiveRef[] liveRefArray = new LiveRef[]{liveRef};
        DGCClient.referenced(liveRefArray);
    }

    private static void cleanUpCountTable(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            countTable.remove((LiveRef)vector.elementAt(n));
            ++n;
        }
    }

    static void unreferenced(LiveRef liveRef) {
        Vector vector = unrefList;
        synchronized (vector) {
            unrefList.addElement(liveRef);
            unrefList.notifyAll();
            return;
        }
    }

    private static synchronized long getNextSequenceNum() {
        return nextSequenceNum++;
    }

    private static void handleDecrements() {
        int n;
        int n2 = 128;
        Object object = null;
        Object[] objectArray = new LiveRef[n2];
        int n3 = 0;
        Object object2 = unrefList;
        synchronized (object2) {
            n3 = unrefList.size();
            if (n3 == 0) {
                Object var5_5 = null;
                return;
            }
            if (n3 <= n2) {
                unrefList.copyInto(objectArray);
                unrefList.removeAllElements();
            } else {
                n3 = n2;
                n = 0;
                n = 0;
                while (n < n2) {
                    objectArray[n] = (LiveRef)unrefList.elementAt(n);
                    ++n;
                }
                n = 0;
                while (n < n2) {
                    unrefList.removeElementAt(0);
                    ++n;
                }
            }
        }
        object2 = lock;
        synchronized (object2) {
            n = 0;
            while (n < n3) {
                object = objectArray[n];
                CountTableEntry countTableEntry = (CountTableEntry)countTable.get(object);
                if (countTableEntry != null) {
                    Endpoint endpoint = ((LiveRef)object).getEndpoint();
                    ObjID objID = ((LiveRef)object).getObjID();
                    --countTableEntry.refCount;
                    if (countTableEntry.refCount == 0) {
                        LeaseTableEntry leaseTableEntry;
                        if (DGCImpl.logLevel >= 20) {
                            LogStream.log("dgc").println("DGCClient.handleDecrements: ObjID = " + ((LiveRef)object).getObjID() + " refCount == 0");
                        }
                        if ((leaseTableEntry = (LeaseTableEntry)leaseTable.get(endpoint)) != null) {
                            leaseTableEntry.objIdList.removeElement(objID);
                            if (leaseTableEntry.objIdList.isEmpty()) {
                                leaseTable.remove(endpoint);
                                leaseTableModified = true;
                                if (DGCImpl.logLevel >= 20) {
                                    LogStream.log("dgc").println("DGCClient.handleDecrement: Removing ep = " + endpoint + " from the leaseTable.");
                                }
                            }
                        }
                        DGCClient.scheduleClean((LiveRef)object, false);
                        countTable.remove(object);
                    }
                }
                ++n;
            }
            return;
        }
    }

    private static void scheduleClean(ObjID[] objIDArray, Endpoint endpoint, boolean bl) {
        long l = DGCClient.getNextSequenceNum();
        if (objIDArray == null) {
            return;
        }
        CleanRequest cleanRequest = (CleanRequest)cleanTable.get(endpoint);
        if (cleanRequest == null) {
            cleanRequest = new CleanRequest(objIDArray, endpoint, l, bl);
            cleanTable.put(endpoint, cleanRequest);
            return;
        }
        cleanRequest.objIdArray = DGCClient.mergeObjIdArrays(cleanRequest.objIdArray, objIDArray);
        cleanRequest.strong = bl;
    }

    private static ObjID[] mergeObjIdArrays(ObjID[] objIDArray, ObjID[] objIDArray2) {
        ObjID[] objIDArray3;
        if (objIDArray.length == 0 && objIDArray2.length == 0) {
            objIDArray3 = null;
        } else if (objIDArray.length == 0) {
            objIDArray3 = objIDArray2;
        } else if (objIDArray2.length == 0) {
            objIDArray3 = objIDArray;
        } else {
            int n = objIDArray.length + objIDArray2.length;
            objIDArray3 = new ObjID[n];
            System.arraycopy(objIDArray, 0, objIDArray3, 0, objIDArray.length);
            System.arraycopy(objIDArray2, 0, objIDArray3, objIDArray.length, objIDArray2.length);
        }
        return objIDArray3;
    }

    private static void scheduleClean(LiveRef liveRef, boolean bl) {
        Endpoint endpoint = liveRef.getEndpoint();
        ObjID objID = liveRef.getObjID();
        ObjID[] objIDArray = new ObjID[]{objID};
        DGCClient.scheduleClean(objIDArray, endpoint, bl);
    }

    /*
     * Exception decompiling
     */
    private static void sendCleans() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[UNCONDITIONALDOLOOP]], but top level block is 8[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void run() {
        while (true) {
            long l = DGCClient.getLong("sun.rmi.transport.cleanInterval", 180000L);
            System.runFinalization();
            Vector vector = unrefList;
            synchronized (vector) {
                if (unrefList.isEmpty()) {
                    try {
                        unrefList.wait(l);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            DGCClient.handleDecrements();
            DGCClient.sendCleans();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean doRenewal() {
        LeaseTableEntry leaseTableEntry = null;
        boolean bl = true;
        Object object = lock;
        synchronized (object) {
            do {
                if ((leaseTableEntry = DGCClient.getNextRenewal()) == null) {
                    leasee = null;
                    return false;
                }
                if (DGCImpl.logLevel >= 10) {
                    LogStream.log("dgc").println("DGCClient.doRenewal: next lease to renew has Endpoint = " + leaseTableEntry.ep + "renewTime = " + leaseTableEntry.renewTime);
                }
                while (true) {
                    long l = System.currentTimeMillis();
                    long l2 = leaseTableEntry.renewTime - l;
                    long l3 = l + l2;
                    if (l2 > 0L) {
                        if (DGCImpl.logLevel >= 10) {
                            LogStream.log("dgc").println("DGCClient.doRenewal:  Waiting for " + l2 + "milliseconds");
                        }
                        try {
                            lock.wait(l2);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    l = System.currentTimeMillis();
                    if (leaseTableModified) {
                        leaseTableEntry = DGCClient.getNextRenewal();
                        leaseTableModified = false;
                        if (leaseTableEntry == null) {
                            leasee = null;
                            return false;
                        }
                        if (DGCImpl.logLevel < 10) continue;
                        LogStream.log("dgc").println("DGCClient.doRenewal: next lease to renew has Endpoint = " + leaseTableEntry.ep + "renewTime = " + leaseTableEntry.renewTime);
                        continue;
                    }
                    if (l >= l3) break;
                }
                if (leaseTableEntry == null) continue;
                bl = DGCClient.renewLeases(leaseTableEntry);
            } while (bl);
            return bl;
        }
    }

    private static LeaseTableEntry getNextRenewal() {
        Enumeration enumeration = leaseTable.elements();
        long l = Long.MAX_VALUE;
        LeaseTableEntry leaseTableEntry = null;
        while (enumeration.hasMoreElements()) {
            LeaseTableEntry leaseTableEntry2 = (LeaseTableEntry)enumeration.nextElement();
            if (leaseTableEntry2.renewTime >= l) continue;
            l = leaseTableEntry2.renewTime;
            leaseTableEntry = leaseTableEntry2;
        }
        return leaseTableEntry;
    }

    static boolean renewLeases(LeaseTableEntry leaseTableEntry) {
        Endpoint endpoint = leaseTableEntry.ep;
        DGC dGC = null;
        Object[] objectArray = null;
        int n = 0;
        try {
            try {
                dGC = LocateDGC.getDGC(endpoint);
            }
            catch (RemoteException remoteException) {}
            if (leaseTableEntry == null) {
                Thread.currentThread().getName();
            }
            Serializable serializable = leaseTableEntry.objIdList;
            synchronized (serializable) {
                n = leaseTableEntry.objIdList.size();
                objectArray = new ObjID[n];
                leaseTableEntry.objIdList.copyInto(objectArray);
            }
            if (DGCImpl.logLevel >= 10) {
                LogStream.log("dgc").println("DGCClient.renewLeases: Renewing " + n + " leases for Endpoint = " + endpoint);
            }
            serializable = dGC.dirty((ObjID[])objectArray, DGCClient.getNextSequenceNum(), new Lease(vmid, leaseValue));
            vmid = ((Lease)serializable).getVMID();
            long l = System.currentTimeMillis();
            if (DGCImpl.logLevel >= 20) {
                LogStream.log("dgc").println("DGCClient.renew:eases: New lease -- vmid = " + ((Lease)serializable).getVMID() + "duration = " + ((Lease)serializable).getValue());
                LogStream.log("dgc").println("DGCClient.renewLeases: *Renewed the leases for the following ObjID's*");
                int n2 = 0;
                while (n2 < n) {
                    LogStream.log("dgc").println("DGCClient.renewLeases: ObjID #" + n2 + " = " + objectArray[n2]);
                    ++n2;
                }
            }
            DGCClient.setUpLeasing(leaseTableEntry, l, (Lease)serializable);
        }
        catch (RemoteException remoteException) {
            leaseTable.remove(endpoint);
        }
        if (leaseTable.isEmpty()) {
            leasee = null;
            return false;
        }
        return true;
    }

    private static ObjID[] getObjIdArray(Vector vector) {
        ObjID[] objIDArray = null;
        objIDArray = new ObjID[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            objIDArray[n] = ((LiveRef)vector.elementAt(n)).getObjID();
            ++n;
        }
        return objIDArray;
    }

    static {
        vmid = VMID.isUnique() ? new VMID() : null;
        nextSequenceNum = Long.MIN_VALUE;
        cleaner = null;
        leasee = null;
    }

    private static final class CountTableEntry {
        int refCount;

        CountTableEntry() {
        }
    }

    private static final class CleanRequest {
        ObjID[] objIdArray;
        Endpoint ep;
        long sequenceNum;
        boolean strong;

        public CleanRequest(LiveRef liveRef, long l, boolean bl) {
            this.ep = liveRef.getEndpoint();
            this.strong = bl;
            this.sequenceNum = l;
            ObjID[] objIDArray = new ObjID[]{liveRef.getObjID()};
            this.objIdArray = objIDArray;
        }

        public CleanRequest(ObjID[] objIDArray, Endpoint endpoint, long l, boolean bl) {
            this.sequenceNum = l;
            this.objIdArray = objIDArray;
            this.strong = bl;
            this.ep = endpoint;
        }

        public boolean equals(Object object) {
            if (object != null && object instanceof CleanRequest) {
                CleanRequest cleanRequest = (CleanRequest)object;
                if (cleanRequest.objIdArray.length != this.objIdArray.length) {
                    return false;
                }
                if (this.sequenceNum != cleanRequest.sequenceNum || this.strong != cleanRequest.strong || !cleanRequest.ep.equals(this.ep)) {
                    return false;
                }
                int n = 0;
                while (n < this.objIdArray.length) {
                    if (!this.objIdArray[n].equals(cleanRequest.objIdArray[n])) {
                        return false;
                    }
                    ++n;
                }
                return true;
            }
            return false;
        }
    }

    private static final class LeaseTableEntry {
        public long renewTime;
        public Endpoint ep;
        public Vector objIdList = new Vector();
        public Lease lease;

        public LeaseTableEntry(Endpoint endpoint) {
            this.ep = endpoint;
        }
    }

    private static class LeaseRenewer
    implements Runnable {
        public void run() {
            boolean bl;
            if (DGCImpl.logLevel >= 10) {
                LogStream.log("dgc").println("LeaseRenewer.run: Lease renewing thread starting up.");
            }
            while (bl = DGCClient.doRenewal()) {
            }
        }

        LeaseRenewer() {
        }
    }
}

