/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Writer;

public class BufferedWriter
extends Writer {
    private Writer out;
    private char[] cb;
    private int nChars;
    private int nextChar;
    private static int defaultCharBufferSize = 8192;
    private String lineSeparator;

    public BufferedWriter(Writer writer) {
        this(writer, defaultCharBufferSize);
    }

    public BufferedWriter(Writer writer, int n) {
        super(writer);
        if (n <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.out = writer;
        this.cb = new char[n];
        this.nChars = n;
        this.nextChar = 0;
        this.lineSeparator = System.getProperty("line.separator");
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException("Stream closed");
        }
    }

    void flushBuffer() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.out == null) {
                throw new IOException("Stream closed");
            }
            if (this.nextChar == 0) {
                Object var2_2 = null;
                return;
            }
            this.out.write(this.cb, 0, this.nextChar);
            this.nextChar = 0;
            return;
        }
    }

    public void write(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.out == null) {
                throw new IOException("Stream closed");
            }
            if (this.nextChar >= this.nChars) {
                this.flushBuffer();
            }
            this.cb[this.nextChar++] = (char)n;
            return;
        }
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.out == null) {
                throw new IOException("Stream closed");
            }
            if (n2 >= this.nChars) {
                this.flushBuffer();
                this.out.write(cArray, n, n2);
                Object var5_5 = null;
                return;
            }
            int n3 = n;
            int n4 = n + n2;
            while (n3 < n4) {
                int n5 = this.nChars - this.nextChar;
                int n6 = n4 - n3;
                n5 = n5 <= n6 ? n5 : n6;
                System.arraycopy(cArray, n3, this.cb, this.nextChar, n5);
                n3 += n5;
                this.nextChar += n5;
                if (this.nextChar < this.nChars) continue;
                this.flushBuffer();
            }
            return;
        }
    }

    public void write(String string, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.out == null) {
                throw new IOException("Stream closed");
            }
            int n3 = n;
            int n4 = n + n2;
            while (n3 < n4) {
                int n5 = this.nChars - this.nextChar;
                int n6 = n4 - n3;
                n5 = n5 <= n6 ? n5 : n6;
                string.getChars(n3, n3 + n5, this.cb, this.nextChar);
                n3 += n5;
                this.nextChar += n5;
                if (this.nextChar < this.nChars) continue;
                this.flushBuffer();
            }
            return;
        }
    }

    public void newLine() throws IOException {
        this.write(this.lineSeparator);
    }

    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.flushBuffer();
            this.out.flush();
            return;
        }
    }

    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.out == null) {
                Object var2_2 = null;
                return;
            }
            this.flushBuffer();
            this.out.close();
            this.out = null;
            this.cb = null;
            return;
        }
    }
}

