/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.lang.reflect.Method;

public class PropertyDescriptor
extends FeatureDescriptor {
    private Class propertyType;
    private Method readMethod;
    private Method writeMethod;
    private boolean bound;
    private boolean constrained;
    private Class propertyEditorClass;

    public PropertyDescriptor(String string, Class clazz) throws IntrospectionException {
        this.setName(string);
        String string2 = this.capitalize(string);
        this.writeMethod = Introspector.findMethod(clazz, "set" + string2, 1);
        if (this.writeMethod.getParameterTypes()[0] == Boolean.TYPE) {
            try {
                this.readMethod = Introspector.findMethod(clazz, "is" + string2, 0);
            }
            catch (Exception exception) {}
        }
        if (this.readMethod == null) {
            this.readMethod = Introspector.findMethod(clazz, "get" + string2, 0);
        }
        this.findPropertyType();
    }

    public PropertyDescriptor(String string, Class clazz, String string2, String string3) throws IntrospectionException {
        this.setName(string);
        this.readMethod = Introspector.findMethod(clazz, string2, 0);
        this.writeMethod = Introspector.findMethod(clazz, string3, 1);
        this.findPropertyType();
    }

    public PropertyDescriptor(String string, Method method, Method method2) throws IntrospectionException {
        this.setName(string);
        this.readMethod = method;
        this.writeMethod = method2;
        this.findPropertyType();
    }

    public Class getPropertyType() {
        return this.propertyType;
    }

    public Method getReadMethod() {
        return this.readMethod;
    }

    public Method getWriteMethod() {
        return this.writeMethod;
    }

    public boolean isBound() {
        return this.bound;
    }

    public void setBound(boolean bl) {
        this.bound = bl;
    }

    public boolean isConstrained() {
        return this.constrained;
    }

    public void setConstrained(boolean bl) {
        this.constrained = bl;
    }

    public void setPropertyEditorClass(Class clazz) {
        this.propertyEditorClass = clazz;
    }

    public Class getPropertyEditorClass() {
        return this.propertyEditorClass;
    }

    PropertyDescriptor(PropertyDescriptor propertyDescriptor, PropertyDescriptor propertyDescriptor2) {
        super(propertyDescriptor, propertyDescriptor2);
        this.readMethod = propertyDescriptor.readMethod;
        this.propertyType = propertyDescriptor.propertyType;
        if (propertyDescriptor2.readMethod != null) {
            this.readMethod = propertyDescriptor2.readMethod;
        }
        this.writeMethod = propertyDescriptor.writeMethod;
        if (propertyDescriptor2.writeMethod != null) {
            this.writeMethod = propertyDescriptor2.writeMethod;
        }
        this.propertyEditorClass = propertyDescriptor.propertyEditorClass;
        if (propertyDescriptor2.propertyEditorClass != null) {
            this.propertyEditorClass = propertyDescriptor2.propertyEditorClass;
        }
        this.bound = propertyDescriptor.bound | propertyDescriptor2.bound;
        this.constrained = propertyDescriptor.constrained | propertyDescriptor2.constrained;
        try {
            this.findPropertyType();
            return;
        }
        catch (IntrospectionException introspectionException) {
            throw new Error("PropertyDescriptor: internal error while merging PDs");
        }
    }

    private void findPropertyType() throws IntrospectionException {
        this.propertyType = null;
        if (this.readMethod != null) {
            if (this.readMethod.getParameterTypes().length != 0) {
                throw new IntrospectionException("bad read method arg count");
            }
            this.propertyType = this.readMethod.getReturnType();
            if (this.propertyType == Void.TYPE) {
                throw new IntrospectionException("read method " + this.readMethod.getName() + " returns void");
            }
        }
        if (this.writeMethod != null) {
            Class[] classArray = this.writeMethod.getParameterTypes();
            if (classArray.length != 1) {
                throw new IntrospectionException("bad write method arg count");
            }
            if (this.propertyType != null && this.propertyType != classArray[0]) {
                throw new IntrospectionException("type mismatch between read and write methods");
            }
            this.propertyType = classArray[0];
            return;
        }
    }

    private String capitalize(String string) {
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toUpperCase(cArray[0]);
        return new String(cArray);
    }
}

