#############################################################
#
# usbutils
#
#############################################################

ifneq ($(USE_CVS), true)
USBUTILS_SOURCE:=usbutils.tar.gz
USBUTILS_CAT:=zcat
endif

USBUTILS_DIR:=$(BUILD_DIR)/usbutils
USBUTILS_BINARY:=usbutils
USBUTILS_TARGET_BINARY:=usr/bin/usbutils

ifneq ($(USE_CVS),true)
$(DL_DIR)/$(USBUTILS_SOURCE):

usbutils-source: $(DL_DIR)/$(USBUTILS_SOURCE)
else
usbutils-source:
endif

USBUTILS_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d usbutils $(CVS_TAG) $(CVS_PREFIX)usbutils

usbutils-checkout:
	@$(USBUTILS_CVSCO)

$(USBUTILS_DIR)/.unpacked: $(DL_DIR)/$(USBUTILS_SOURCE)
ifneq ($(USE_CVS), true)
	$(USBUTILS_CAT) $(DL_DIR)/$(USBUTILS_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(USBUTILS_CVSCO)
endif
	-cat $(SOURCE_DIR)/usbutils.patch | patch -p0 -d $(USBUTILS_DIR)
	cp $(SOURCE_DIR)/config.sub $(USBUTILS_DIR)
	touch  $(USBUTILS_DIR)/.unpacked

$(USBUTILS_DIR)/.configured: $(USBUTILS_DIR)/.unpacked
	cd $(USBUTILS_DIR); \
        rm -rf config.cache; \
	$(TARGET_CONFIGURE_OPTS) \
	  CFLAGS="$(TARGET_CFLAGS)" \
	  ./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/bin \
		--sbindir=/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share/misc \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info
	touch $(USBUTILS_DIR)/.configured

$(USBUTILS_DIR)/$(USBUTILS_BINARY): $(USBUTILS_DIR)/.configured
	$(MAKE) $(TARGET_CONFIGURE_OPTS) -C $(USBUTILS_DIR)

$(TARGET_DIR)/$(USBUTILS_TARGET_BINARY): $(USBUTILS_DIR)/$(USBUTILS_BINARY)
	$(MAKE) DESTDIR=$(TARGET_DIR) -C $(USBUTILS_DIR) install

usbutils: uclibc $(TARGET_DIR)/$(USBUTILS_TARGET_BINARY)

usbutils-clean:
	$(MAKE) DESTDIR=$(TARGET_DIR) CC=$(TARGET_CC) -C $(USBUTILS_DIR) uninstall
	-$(MAKE) -C $(USBUTILS_DIR) clean

usbutils-dirclean:
	rm -rf $(USBUTILS_DIR)

