#############################################################
#
# sysvinit
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
SYSVINIT_SOURCE:=sysvinit.tar.gz
SYSVINIT_SITE:=ftp://ftp.gnu.org/gnu/sysvinit
SYSVINIT_CAT:=zcat
endif

SYSVINIT_DIR:=$(BUILD_DIR)/sysvinit
SYSVINIT_BINARY:=src/init
SYSVINIT_TARGET_BINARY:=sbin/init

SYSVINIT_SBINPROGS:=halt init killall5 last lastb mesg runlevel shutdown sulogin reboot poweroff pidof
SYSVINIT_BINPROGS:=utmpdump wall

ifneq ($(USE_CVS),true)
sysvinit-fetch:
	 $(WGET) -P $(DL_DIR) $(SYSVINIT_SITE)/$(SYSVINIT_SOURCE)

sysvinit-source: $(DL_DIR)/$(SYSVINIT_SOURCE)
else
sysvinit-source:
endif

SYSVINIT_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d sysvinit $(CVS_TAG) $(CVS_PREFIX)sysvinit

sysvinit-checkout:
	@$(SYSVINIT_CVSCO)

$(SYSVINIT_DIR)/.unpacked: $(DL_DIR)/$(SYSVINIT_SOURCE)
ifneq ($(USE_CVS),true)
	$(SYSVINIT_CAT) $(DL_DIR)/$(SYSVINIT_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(SYSVINIT_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(SYSVINIT_DIR)/
	touch $(SYSVINIT_DIR)/.unpacked

$(SYSVINIT_DIR)/$(SYSVINIT_BINARY): $(SYSVINIT_DIR)/.unpacked
	$(MAKE) CC=$(TARGET_CC) CC_FOR_BUILD=$(HOSTCC) -C $(SYSVINIT_DIR)/src

$(TARGET_DIR)/$(SYSVINIT_TARGET_BINARY): $(SYSVINIT_DIR)/$(SYSVINIT_BINARY)
	$(MAKE) \
		BIN_OWNER=$(shell id -u) \
		BIN_GROUP=$(shell id -g) \
		MANDIR=/usr/man \
		ROOT=$(TARGET_DIR) \
		-C $(SYSVINIT_DIR)/src install
	-rm -f $(TARGET_DIR)/bin/pidof
	ln -s killall5 $(TARGET_DIR)/sbin/pidof
	install -d $(DOC_DIR)/doc/sysvinit
	@for f in COPYRIGHT README ; do \
		install -m0644 $(SYSVINIT_DIR)/$$f $(DOC_DIR)/doc/sysvinit/$$f ;\
	done

sysvinit: uclibc $(TARGET_DIR)/$(SYSVINIT_TARGET_BINARY)

sysvinit-clean:
	-for f in $(SYSVINIT_SBINPROGS) ; do \
		rm -f $(TARGET_DIR)/sbin/$$f || : ;\
	done
	-for f in $(SYSVINIT_BINPROGS) ; do \
		rm -f $(TARGET_DIR)/usr/bin/$$f || : ;\
	done
	-rm -f $(TARGET_DIR)/usr/man/man1/sysvinit.1
	-rm -rf $(DOC_DIR)/doc/sysvinit
	-$(MAKE) -C $(SYSVINIT_DIR)/src clean

sysvinit-dirclean:
	rm -rf $(SYSVINIT_DIR)
endif

