#############################################################
#
# shadow-utils
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
SHADOW-UTILS_SOURCE:=shadow-utils.tar.gz
SHADOW-UTILS_SITE:=ftp://ftp.gnu.org/gnu/shadow-utils
SHADOW-UTILS_CAT:=zcat
endif

SHADOW-UTILS_DIR:=$(BUILD_DIR)/shadow-utils
SHADOW-UTILS_BINARY:=src/useradd
SHADOW-UTILS_TARGET_BINARY:=usr/sbin/useradd

ifneq ($(USE_CVS),true)
shadow-utils-fetch:
	 $(WGET) -P $(DL_DIR) $(SHADOW-UTILS_SITE)/$(SHADOW-UTILS_SOURCE)

shadow-utils-source: $(DL_DIR)/$(SHADOW-UTILS_SOURCE)
else
shadow-utils-source:
endif

SHADOW-UTILS_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d shadow-utils $(CVS_TAG) $(CVS_PREFIX)shadow-utils

shadow-utils-checkout:
	@$(SHADOW-UTILS_CVSCO)

$(SHADOW-UTILS_DIR)/.unpacked: $(DL_DIR)/$(SHADOW-UTILS_SOURCE)
ifneq ($(USE_CVS),true)
	$(SHADOW-UTILS_CAT) $(DL_DIR)/$(SHADOW-UTILS_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(SHADOW-UTILS_CVSCO)
endif
	touch $(SHADOW-UTILS_DIR)/.unpacked

$(SHADOW-UTILS_DIR)/.configured: $(SHADOW-UTILS_DIR)/.unpacked
	(cd $(SHADOW-UTILS_DIR); rm -rf config.cache; \
		aclocal ; automake -a ; autoconf ; \
		ac_cv_func_setpgrp_void=no \
		$(TARGET_CONFIGURE_OPTS) \
		./configure \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--target=$(GNU_TARGET_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		$(DISABLE_NLS) \
		--disable-desrpc \
		--enable-shadowgrp \
		--with-libcrack \
		--with-libcrypt \
		--without-libpam \
		--disable-shared \
	);
	touch $(SHADOW-UTILS_DIR)/.configured

$(SHADOW-UTILS_DIR)/$(SHADOW-UTILS_BINARY): $(SHADOW-UTILS_DIR)/.configured
	$(MAKE) -C $(SHADOW-UTILS_DIR)

$(TARGET_DIR)/$(SHADOW-UTILS_TARGET_BINARY): $(SHADOW-UTILS_DIR)/$(SHADOW-UTILS_BINARY)
	$(MAKE) DESTDIR=$(TARGET_DIR) -C $(SHADOW-UTILS_DIR) install
	@echo "FIXME: strip the rest of the binaries, not just useradd"
	$(STRIP) $(TARGET_DIR)/$(SHADOW-UTILS_TARGET_BINARY)
	install -m0644 $(SHADOW-UTILS_DIR)/etc/login.defs.redhat $(TARGET_DIR)/etc/login.defs
	install -d $(DOC_DIR)/doc/shadow-utils
	@for f in doc/HOWTO doc/LICENSE doc/README.linux README ; do \
		install -m0644 $(SHADOW-UTILS_DIR)/$$f $(DOC_DIR)/doc/shadow-utils/`basename $$f` ;\
	done

shadow-utils: uclibc cracklib $(TARGET_DIR)/$(SHADOW-UTILS_TARGET_BINARY)

shadow-utils-clean:
	-$(MAKE) DESTDIR=$(TARGET_DIR) -C $(SHADOW-UTILS_DIR) uninstall
	-rm -f $(TARGET_DIR)/etc/login.defs
	-rm -rf $(DOC_DIR)/doc/shadow-utils
	-$(MAKE) -C $(SHADOW-UTILS_DIR) clean

shadow-utils-dirclean:
	rm -rf $(SHADOW-UTILS_DIR)
endif

