#############################################################
#
# rdate
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
RDATE_SOURCE:=rdate.tar.gz
RDATE_SITE:=ftp://ftp.gnu.org/gnu/rdate
RDATE_CAT:=zcat
endif

RDATE_DIR:=$(BUILD_DIR)/rdate
RDATE_BINARY:=rdate
RDATE_TARGET_BINARY:=usr/bin/rdate

ifneq ($(USE_CVS),true)
rdate-fetch:
	 $(WGET) -P $(DL_DIR) $(RDATE_SITE)/$(RDATE_SOURCE)

rdate-source: $(DL_DIR)/$(RDATE_SOURCE)
else
rdate-source:
endif

RDATE_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d rdate $(CVS_TAG) $(CVS_PREFIX)rdate

rdate-checkout:
	@$(RDATE_CVSCO)

$(RDATE_DIR)/.unpacked: $(DL_DIR)/$(RDATE_SOURCE)
ifneq ($(USE_CVS),true)
	$(RDATE_CAT) $(DL_DIR)/$(RDATE_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(RDATE_CVSCO)
endif
	touch $(RDATE_DIR)/.unpacked

$(RDATE_DIR)/$(RDATE_BINARY): $(RDATE_DIR)/.unpacked
	$(MAKE) CFLAGS="$(TARGET_CFLAGS)" CC=$(TARGET_CC) -C $(RDATE_DIR)

$(TARGET_DIR)/$(RDATE_TARGET_BINARY): $(RDATE_DIR)/$(RDATE_BINARY)
	$(MAKE) prefix=$(TARGET_DIR)/usr -C $(RDATE_DIR) install
	$(STRIP) $(TARGET_DIR)/$(RDATE_TARGET_BINARY)
	install -d $(DOC_DIR)/doc/rdate
	install -m0644 $(RDATE_DIR)/COPYING $(DOC_DIR)/doc/rdate/COPYING

rdate: uclibc $(TARGET_DIR)/$(RDATE_TARGET_BINARY)

rdate-clean:
	-rm -f $(TARGET_DIR)/$(RDATE_TARGET_BINARY)
	-rm -f $(TARGET_DIR)/usr/share/man/man1/rdate.1
	-rm -rf $(DOC_DIR)/doc/rdate
	-$(MAKE) -C $(RDATE_DIR) clean

rdate-dirclean:
	rm -rf $(RDATE_DIR)
endif

