#############################################################
#
# boa
#
#############################################################
ifneq ($(USE_CVS),true)

BOA_VERSION=0.94.13
BOA_SOURCE=boa.tar.gz
BOA_SITE=http://www.boa.org/
endif

BOA_DIR:=$(BUILD_DIR)/boa
BOA_WORKDIR=$(BUILD_DIR)/boa_workdir

ifeq ($(USE_GLIBC),true)
BOA_DEPS:=initscripts
else
BOA_DEPS:=
endif

ifneq ($(USE_CVS),true)
boa-fetch:
	$(WGET) -P $(DL_DIR) $(BOA_SITE)/$(BOA_SOURCE)
endif

BOA_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d boa $(CVS_TAG) $(CVS_PREFIX)boa

boa-checkout:
	@$(BOA_CVSCO)
$(BOA_DIR)/.unpacked:	$(DL_DIR)/$(BOA_SOURCE)
ifneq ($(USE_CVS),true)
	gzip -d -c $(DL_DIR)/$(BOA_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(BOA_CVSCO)
endif
	touch $(BOA_DIR)/.unpacked

$(BOA_WORKDIR)/Makefile: $(BOA_DIR)/.unpacked
	rm -f $(BOA_WORKDIR)/Makefile
	mkdir -p $(BOA_WORKDIR)
	(cd $(BOA_WORKDIR) && CONFIG_SITE=$(SOURCE_DIR)/boa-config.site-$(ARCH) \
		CFLAGS="$(TARGET_CFLAGS) -I$(BOA_DIR)/src" \
		CC=$(TARGET_CC) $(BOA_DIR)/src/configure)
	touch $(BOA_WORKDIR)/.depend
        
$(BOA_WORKDIR)/boa $(BOA_WORKDIR)/boa_indexer:	$(BOA_WORKDIR)/Makefile
	rm -f $@
	$(MAKE) VPATH=$(BOA_DIR)/src/ -C $(BOA_WORKDIR)

$(BOA_WORKDIR)/.installed: $(BOA_WORKDIR)/boa $(BOA_WORKDIR)/boa_indexer
	mkdir -p $(TARGET_DIR)/usr/sbin
	install -m0755 $(BOA_WORKDIR)/boa $(TARGET_DIR)/usr/sbin/boa
	mkdir -p $(TARGET_DIR)/usr/lib/boa
	install -m0755 $(BOA_WORKDIR)/boa_indexer $(TARGET_DIR)/usr/lib/boa/boa_indexer
	[ -d $(TARGET_DIR)/etc/boa ] || mkdir $(TARGET_DIR)/etc/boa
	install -m0644 $(SOURCE_DIR)/boa.conf $(TARGET_DIR)/etc/boa
	if [ -d $(TARGET_DIR)/etc/rc.d/init.d ]; then \
		install -m0755 $(BOA_DIR)/contrib/redhat/boa.init \
			$(TARGET_DIR)/etc/rc.d/init.d/boa ; \
	fi
	install -m0644 $(SOURCE_DIR)/mime.types $(TARGET_DIR)/etc/mime.types
	$(STRIP) $(TARGET_DIR)/usr/sbin/boa $(TARGET_DIR)/usr/lib/boa/boa_indexer
	[ -d $(TARGET_DIR)/var/log/boa ] || mkdir $(TARGET_DIR)/var/log/boa
	$(MAKE) -C $(BOA_DIR)/docs
	install -m0644 $(BOA_DIR)/docs/boa.8 $(TARGET_DIR)/usr/man/man8/boa.8
	mkdir -p $(DOC_DIR)/doc/boa/html
	install -m0644 $(BOA_DIR)/docs/*.html $(BOA_DIR)/docs/*.png $(DOC_DIR)/doc/boa/html/
	install -m0644 $(BOA_DIR)/docs/boa.txt $(DOC_DIR)/doc/boa/
	install -m0644 $(BOA_DIR)/CREDITS $(DOC_DIR)/doc/boa/
	install -m0644 $(BOA_DIR)/README $(DOC_DIR)/doc/boa/
	install -m0644 $(BOA_DIR)/Gnu_License $(DOC_DIR)/doc/boa/
	touch $(BOA_WORKDIR)/.installed

boa:	uclibc $(BOA_DEPS) $(BOA_WORKDIR)/.installed

boa-source: $(DL_DIR)/$(BOA_SOURCE)

boa-clean:
	@if [ -d $(BOA_WORKDIR)/Makefile ] ; then \
		$(MAKE) -C $(BOA_WORKDIR) clean ; \
	fi;
	-rm -rf $(TARGET_DIR)/etc/boa
	-rm -f $(TARGET_DIR)/usr/sbin/boa
	-rm -rf $(TARGET_DIR)/usr/lib/boa
	-rm -rf $(DOC_DIR)/doc/boa

boa-dirclean:
	rm -rf $(BOA_DIR) $(BOA_WORKDIR)

