#############################################################
#
# ash
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
ASH_SOURCE:=ash.tar.gz
ASH_SITE:=ftp://ftp.gnu.org/gnu/ash
ASH_CAT:=zcat
endif

ASH_DIR:=$(BUILD_DIR)/ash
ASH_BINARY:=sh
ASH_TARGET_BINARY:=bin/ash

ifneq ($(USE_CVS),true)
ash-source: $(DL_DIR)/$(ASH_SOURCE)
else
ash-source:
endif

ASH_DEBUG:= -O0 -g

ASH_CFLAGS:= -DBSD=1 \
	     -DSMALL \
	     -D_GNU_SOURCE \
	     -DGLOB_BROKEN \
	     -D__COPYRIGHT\(x\)= \
	     -D__RCSID\(x\)= \
	     -D_DIAGASSERT\(x\)= \
	     -I. -I./bltin \
	     $(ASH_DEBUG)

ASH_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d ash $(CVS_TAG) $(CVS_PREFIX)ash

ash-checkout: 
	@$(ASH_CVSCO)

$(ASH_DIR)/.unpacked: $(DL_DIR)/$(ASH_SOURCE)
ifneq ($(USE_CVS),true)
	$(ASH_CAT) $(DL_DIR)/$(ASH_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(ASH_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(ASH_DIR)/
	ln -s /usr/bin/install $(ASH_DIR)/install-sh || :
	touch $(ASH_DIR)/.unpacked

$(ASH_DIR)/$(ASH_BINARY): $(ASH_DIR)/.unpacked
	$(MAKE) CFLAGS="$(TARGET_CFLAGS) $(ASH_CFLAGS)" CC=$(TARGET_CC) CC_FOR_BUILD=$(HOSTCC) -C $(ASH_DIR)

$(TARGET_DIR)/$(ASH_TARGET_BINARY): $(ASH_DIR)/$(ASH_BINARY)
	rm -f $(TARGET_DIR)/bin/ash*
	install -m0755 $(ASH_DIR)/$(ASH_BINARY) $(TARGET_DIR)/$(ASH_TARGET_BINARY)
	$(STRIP) $(TARGET_DIR)/$(ASH_TARGET_BINARY)
	install -m0644 $(ASH_DIR)/sh.1 $(TARGET_DIR)/usr/man/man1/ash.1
	install -d $(DOC_DIR)/doc/ash

ash: uclibc flex $(TARGET_DIR)/$(ASH_TARGET_BINARY)

ash-clean:
	-rm -f $(TARGET_DIR)/$(ASH_TARGET_BINARY)
	-rm -f $(TARGET_DIR)/usr/man/man1/ash.1
	-rm -rf $(DOC_DIR)/doc/ash
	-$(MAKE) -C $(ASH_DIR) clean

ash-dirclean:
	rm -rf $(ASH_DIR)

ash-fetch:
	 $(WGET) -P $(DL_DIR) $(ASH_SITE)/$(ASH_SOURCE)

endif

