
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <UnitsMethods.hxx>
#include <UnitsMethods_LengthUnit.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_UnitsMethods(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("UnitsMethods"));
py::object klass;

//Python trampoline classes

// classes

    // Class UnitsMethods from ./opencascade/UnitsMethods.hxx
    klass = m.attr("UnitsMethods");

    // default constructor
    register_default_constructor<UnitsMethods , shared_ptr<UnitsMethods>>(m,"UnitsMethods");

    // nested enums

    static_cast<py::class_<UnitsMethods , shared_ptr<UnitsMethods>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("GetLengthFactorValue_s",
                    (Standard_Real (*)( const Standard_Integer  ) ) static_cast<Standard_Real (*)( const Standard_Integer  ) >(&UnitsMethods::GetLengthFactorValue),
                    R"#(Returns value of unit encoded by parameter theUnit (integer value denoting unit, as described in IGES standard) in millimeters by default)#"  , py::arg("theUnit")
          )
        .def_static("GetCasCadeLengthUnit_s",
                    (Standard_Real (*)( const UnitsMethods_LengthUnit  ) ) static_cast<Standard_Real (*)( const UnitsMethods_LengthUnit  ) >(&UnitsMethods::GetCasCadeLengthUnit),
                    R"#(Returns value of current internal unit for CASCADE in millemeters by default)#"  , py::arg("theBaseUnit")=static_cast<const UnitsMethods_LengthUnit>(UnitsMethods_LengthUnit_Millimeter)
          )
        .def_static("SetCasCadeLengthUnit_s",
                    (void (*)( const Standard_Real ,  const UnitsMethods_LengthUnit  ) ) static_cast<void (*)( const Standard_Real ,  const UnitsMethods_LengthUnit  ) >(&UnitsMethods::SetCasCadeLengthUnit),
                    R"#(Sets value of current internal unit for CASCADE)#"  , py::arg("theUnitValue"),  py::arg("theBaseUnit")=static_cast<const UnitsMethods_LengthUnit>(UnitsMethods_LengthUnit_Millimeter)
          )
        .def_static("SetCasCadeLengthUnit_s",
                    (void (*)( const Standard_Integer  ) ) static_cast<void (*)( const Standard_Integer  ) >(&UnitsMethods::SetCasCadeLengthUnit),
                    R"#(Sets value of current internal unit for CASCADE by parameter theUnit (integer value denoting unit, as described in IGES standard))#"  , py::arg("theUnit")
          )
        .def_static("GetLengthUnitScale_s",
                    (Standard_Real (*)( const UnitsMethods_LengthUnit ,  const UnitsMethods_LengthUnit  ) ) static_cast<Standard_Real (*)( const UnitsMethods_LengthUnit ,  const UnitsMethods_LengthUnit  ) >(&UnitsMethods::GetLengthUnitScale),
                    R"#(Returns the scale factor for switch from first given unit to second given unit)#"  , py::arg("theFromUnit"),  py::arg("theToUnit")
          )
        .def_static("GetLengthUnitByFactorValue_s",
                    (UnitsMethods_LengthUnit (*)( const Standard_Real ,  const UnitsMethods_LengthUnit  ) ) static_cast<UnitsMethods_LengthUnit (*)( const Standard_Real ,  const UnitsMethods_LengthUnit  ) >(&UnitsMethods::GetLengthUnitByFactorValue),
                    R"#(Returns the enumeration corresponding to the given scale factor)#"  , py::arg("theFactorValue"),  py::arg("theBaseUnit")=static_cast<const UnitsMethods_LengthUnit>(UnitsMethods_LengthUnit_Millimeter)
          )
        .def_static("DumpLengthUnit_s",
                    (Standard_CString (*)( const Standard_Real ,  const UnitsMethods_LengthUnit  ) ) static_cast<Standard_CString (*)( const Standard_Real ,  const UnitsMethods_LengthUnit  ) >(&UnitsMethods::DumpLengthUnit),
                    R"#(Returns string name for the given scale factor)#"  , py::arg("theScaleFactor"),  py::arg("theBaseUnit")=static_cast<const UnitsMethods_LengthUnit>(UnitsMethods_LengthUnit_Millimeter)
          )
        .def_static("DumpLengthUnit_s",
                    (Standard_CString (*)( const UnitsMethods_LengthUnit  ) ) static_cast<Standard_CString (*)( const UnitsMethods_LengthUnit  ) >(&UnitsMethods::DumpLengthUnit),
                    R"#(Returns string for the given value of LengthUnit)#"  , py::arg("theUnit")
          )
        .def_static("LengthUnitFromString_s",
                    (UnitsMethods_LengthUnit (*)( Standard_CString ,  const Standard_Boolean  ) ) static_cast<UnitsMethods_LengthUnit (*)( Standard_CString ,  const Standard_Boolean  ) >(&UnitsMethods::LengthUnitFromString),
                    R"#(Make conversion of given string to value of LengthUnit)#"  , py::arg("theStr"),  py::arg("theCaseSensitive")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

// functions
// ./opencascade/UnitsMethods.hxx
// ./opencascade/UnitsMethods_LengthUnit.hxx

// Additional functions

// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
