
// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;


// Standard Handle
#include <Standard_Handle.hxx>

// user-defined inclusion per module before includes

// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Message_ProgressRange.hxx>
#include <RWGltf_GltfOStreamWriter.hxx>
#include <RWGltf_GltfMaterialMap.hxx>
#include <RWGltf_GltfSceneNodeMap.hxx>
#include <TDocStd_Document.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <RWGltf_GltfPrimArrayData.hxx>
#include <RWGltf_MaterialMetallicRoughness.hxx>
#include <RWGltf_MaterialCommon.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <RWGltf_GltfOStreamWriter.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Image_Texture.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <RWGltf_GltfLatePrimitiveArray.hxx>
#include <RWGltf_GltfPrimArrayData.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <RWGltf_CafReader.hxx>
#include <RWGltf_CafWriter.hxx>
#include <RWGltf_ConfigurationNode.hxx>
#include <RWGltf_DracoParameters.hxx>
#include <RWGltf_GltfAccessor.hxx>
#include <RWGltf_GltfAccessorCompType.hxx>
#include <RWGltf_GltfAccessorLayout.hxx>
#include <RWGltf_GltfAlphaMode.hxx>
#include <RWGltf_GltfArrayType.hxx>
#include <RWGltf_GltfBufferView.hxx>
#include <RWGltf_GltfBufferViewTarget.hxx>
#include <RWGltf_GltfFace.hxx>
#include <RWGltf_GltfJsonParser.hxx>
#include <RWGltf_GltfLatePrimitiveArray.hxx>
#include <RWGltf_GltfMaterialMap.hxx>
#include <RWGltf_GltfOStreamWriter.hxx>
#include <RWGltf_GltfPrimArrayData.hxx>
#include <RWGltf_GltfPrimitiveMode.hxx>
#include <RWGltf_GltfRootElement.hxx>
#include <RWGltf_GltfSceneNodeMap.hxx>
#include <RWGltf_MaterialCommon.hxx>
#include <RWGltf_MaterialMetallicRoughness.hxx>
#include <RWGltf_Provider.hxx>
#include <RWGltf_TriangulationReader.hxx>
#include <RWGltf_WriterTrsfFormat.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module
#include <istream>
#include <DE_ConfigurationContext.hxx>
#include <XSControl_WorkSession.hxx>
using std::basic_istream;
using rapidjson::BasicOStreamWrapper;

// Module definiiton
void register_RWGltf_enums(py::module &main_module) {


py::module m = main_module.def_submodule("RWGltf", R"#()#");

// user-defined inclusion per module in the body

// enums
    py::enum_<RWGltf_GltfRootElement>(m, "RWGltf_GltfRootElement",R"#(Root elements within glTF JSON document.)#")
        .value("RWGltf_GltfRootElement_Asset",RWGltf_GltfRootElement::RWGltf_GltfRootElement_Asset)
        .value("RWGltf_GltfRootElement_Scenes",RWGltf_GltfRootElement::RWGltf_GltfRootElement_Scenes)
        .value("RWGltf_GltfRootElement_Scene",RWGltf_GltfRootElement::RWGltf_GltfRootElement_Scene)
        .value("RWGltf_GltfRootElement_Nodes",RWGltf_GltfRootElement::RWGltf_GltfRootElement_Nodes)
        .value("RWGltf_GltfRootElement_Meshes",RWGltf_GltfRootElement::RWGltf_GltfRootElement_Meshes)
        .value("RWGltf_GltfRootElement_Accessors",RWGltf_GltfRootElement::RWGltf_GltfRootElement_Accessors)
        .value("RWGltf_GltfRootElement_BufferViews",RWGltf_GltfRootElement::RWGltf_GltfRootElement_BufferViews)
        .value("RWGltf_GltfRootElement_Buffers",RWGltf_GltfRootElement::RWGltf_GltfRootElement_Buffers)
        .value("RWGltf_GltfRootElement_NB_MANDATORY",RWGltf_GltfRootElement::RWGltf_GltfRootElement_NB_MANDATORY)
        .value("RWGltf_GltfRootElement_Animations",RWGltf_GltfRootElement::RWGltf_GltfRootElement_Animations)
        .value("RWGltf_GltfRootElement_Materials",RWGltf_GltfRootElement::RWGltf_GltfRootElement_Materials)
        .value("RWGltf_GltfRootElement_Programs",RWGltf_GltfRootElement::RWGltf_GltfRootElement_Programs)
        .value("RWGltf_GltfRootElement_Samplers",RWGltf_GltfRootElement::RWGltf_GltfRootElement_Samplers)
        .value("RWGltf_GltfRootElement_Shaders",RWGltf_GltfRootElement::RWGltf_GltfRootElement_Shaders)
        .value("RWGltf_GltfRootElement_Skins",RWGltf_GltfRootElement::RWGltf_GltfRootElement_Skins)
        .value("RWGltf_GltfRootElement_Techniques",RWGltf_GltfRootElement::RWGltf_GltfRootElement_Techniques)
        .value("RWGltf_GltfRootElement_Textures",RWGltf_GltfRootElement::RWGltf_GltfRootElement_Textures)
        .value("RWGltf_GltfRootElement_Images",RWGltf_GltfRootElement::RWGltf_GltfRootElement_Images)
        .value("RWGltf_GltfRootElement_ExtensionsUsed",RWGltf_GltfRootElement::RWGltf_GltfRootElement_ExtensionsUsed)
        .value("RWGltf_GltfRootElement_ExtensionsRequired",RWGltf_GltfRootElement::RWGltf_GltfRootElement_ExtensionsRequired)
        .value("RWGltf_GltfRootElement_NB",RWGltf_GltfRootElement::RWGltf_GltfRootElement_NB).export_values();
    py::enum_<RWGltf_GltfBufferViewTarget>(m, "RWGltf_GltfBufferViewTarget",R"#(Low-level glTF enumeration defining BufferView target.)#")
        .value("RWGltf_GltfBufferViewTarget_UNKNOWN",RWGltf_GltfBufferViewTarget::RWGltf_GltfBufferViewTarget_UNKNOWN)
        .value("RWGltf_GltfBufferViewTarget_ARRAY_BUFFER",RWGltf_GltfBufferViewTarget::RWGltf_GltfBufferViewTarget_ARRAY_BUFFER)
        .value("RWGltf_GltfBufferViewTarget_ELEMENT_ARRAY_BUFFER",RWGltf_GltfBufferViewTarget::RWGltf_GltfBufferViewTarget_ELEMENT_ARRAY_BUFFER).export_values();
    py::enum_<RWGltf_GltfAlphaMode>(m, "RWGltf_GltfAlphaMode",R"#(Low-level glTF enumeration defining Alpha Mode.)#")
        .value("RWGltf_GltfAlphaMode_Opaque",RWGltf_GltfAlphaMode::RWGltf_GltfAlphaMode_Opaque)
        .value("RWGltf_GltfAlphaMode_Mask",RWGltf_GltfAlphaMode::RWGltf_GltfAlphaMode_Mask)
        .value("RWGltf_GltfAlphaMode_Blend",RWGltf_GltfAlphaMode::RWGltf_GltfAlphaMode_Blend).export_values();
    py::enum_<RWGltf_GltfArrayType>(m, "RWGltf_GltfArrayType",R"#(Low-level glTF enumeration defining Array type.)#")
        .value("RWGltf_GltfArrayType_UNKNOWN",RWGltf_GltfArrayType::RWGltf_GltfArrayType_UNKNOWN)
        .value("RWGltf_GltfArrayType_Indices",RWGltf_GltfArrayType::RWGltf_GltfArrayType_Indices)
        .value("RWGltf_GltfArrayType_Position",RWGltf_GltfArrayType::RWGltf_GltfArrayType_Position)
        .value("RWGltf_GltfArrayType_Normal",RWGltf_GltfArrayType::RWGltf_GltfArrayType_Normal)
        .value("RWGltf_GltfArrayType_Color",RWGltf_GltfArrayType::RWGltf_GltfArrayType_Color)
        .value("RWGltf_GltfArrayType_TCoord0",RWGltf_GltfArrayType::RWGltf_GltfArrayType_TCoord0)
        .value("RWGltf_GltfArrayType_TCoord1",RWGltf_GltfArrayType::RWGltf_GltfArrayType_TCoord1)
        .value("RWGltf_GltfArrayType_Joint",RWGltf_GltfArrayType::RWGltf_GltfArrayType_Joint)
        .value("RWGltf_GltfArrayType_Weight",RWGltf_GltfArrayType::RWGltf_GltfArrayType_Weight).export_values();
    py::enum_<RWGltf_GltfAccessorLayout>(m, "RWGltf_GltfAccessorLayout",R"#(Low-level glTF enumeration defining Accessor layout. Similar to Graphic3d_TypeOfData but does not define actual type and includes matrices.)#")
        .value("RWGltf_GltfAccessorLayout_UNKNOWN",RWGltf_GltfAccessorLayout::RWGltf_GltfAccessorLayout_UNKNOWN)
        .value("RWGltf_GltfAccessorLayout_Scalar",RWGltf_GltfAccessorLayout::RWGltf_GltfAccessorLayout_Scalar)
        .value("RWGltf_GltfAccessorLayout_Vec2",RWGltf_GltfAccessorLayout::RWGltf_GltfAccessorLayout_Vec2)
        .value("RWGltf_GltfAccessorLayout_Vec3",RWGltf_GltfAccessorLayout::RWGltf_GltfAccessorLayout_Vec3)
        .value("RWGltf_GltfAccessorLayout_Vec4",RWGltf_GltfAccessorLayout::RWGltf_GltfAccessorLayout_Vec4)
        .value("RWGltf_GltfAccessorLayout_Mat2",RWGltf_GltfAccessorLayout::RWGltf_GltfAccessorLayout_Mat2)
        .value("RWGltf_GltfAccessorLayout_Mat3",RWGltf_GltfAccessorLayout::RWGltf_GltfAccessorLayout_Mat3)
        .value("RWGltf_GltfAccessorLayout_Mat4",RWGltf_GltfAccessorLayout::RWGltf_GltfAccessorLayout_Mat4).export_values();
    py::enum_<RWGltf_WriterTrsfFormat>(m, "RWGltf_WriterTrsfFormat",R"#(Transformation format.)#")
        .value("RWGltf_WriterTrsfFormat_Compact",RWGltf_WriterTrsfFormat::RWGltf_WriterTrsfFormat_Compact)
        .value("RWGltf_WriterTrsfFormat_Mat4",RWGltf_WriterTrsfFormat::RWGltf_WriterTrsfFormat_Mat4)
        .value("RWGltf_WriterTrsfFormat_TRS",RWGltf_WriterTrsfFormat::RWGltf_WriterTrsfFormat_TRS).export_values();
    m.attr("RWGltf_WriterTrsfFormat_LOWER") = py::cast(int(RWGltf_WriterTrsfFormat_LOWER));
    m.attr("RWGltf_WriterTrsfFormat_UPPER") = py::cast(int(RWGltf_WriterTrsfFormat_UPPER));
    py::enum_<RWGltf_GltfPrimitiveMode>(m, "RWGltf_GltfPrimitiveMode",R"#(Low-level glTF enumeration defining Primitive type. Similar to Graphic3d_TypeOfData but does not define actual type and includes matrices.)#")
        .value("RWGltf_GltfPrimitiveMode_UNKNOWN",RWGltf_GltfPrimitiveMode::RWGltf_GltfPrimitiveMode_UNKNOWN)
        .value("RWGltf_GltfPrimitiveMode_Points",RWGltf_GltfPrimitiveMode::RWGltf_GltfPrimitiveMode_Points)
        .value("RWGltf_GltfPrimitiveMode_Lines",RWGltf_GltfPrimitiveMode::RWGltf_GltfPrimitiveMode_Lines)
        .value("RWGltf_GltfPrimitiveMode_LineLoop",RWGltf_GltfPrimitiveMode::RWGltf_GltfPrimitiveMode_LineLoop)
        .value("RWGltf_GltfPrimitiveMode_LineStrip",RWGltf_GltfPrimitiveMode::RWGltf_GltfPrimitiveMode_LineStrip)
        .value("RWGltf_GltfPrimitiveMode_Triangles",RWGltf_GltfPrimitiveMode::RWGltf_GltfPrimitiveMode_Triangles)
        .value("RWGltf_GltfPrimitiveMode_TriangleStrip",RWGltf_GltfPrimitiveMode::RWGltf_GltfPrimitiveMode_TriangleStrip)
        .value("RWGltf_GltfPrimitiveMode_TriangleFan",RWGltf_GltfPrimitiveMode::RWGltf_GltfPrimitiveMode_TriangleFan).export_values();
    py::enum_<RWGltf_GltfAccessorCompType>(m, "RWGltf_GltfAccessorCompType",R"#(Low-level glTF enumeration defining Accessor component type.)#")
        .value("RWGltf_GltfAccessorCompType_UNKNOWN",RWGltf_GltfAccessorCompType::RWGltf_GltfAccessorCompType_UNKNOWN)
        .value("RWGltf_GltfAccessorCompType_Int8",RWGltf_GltfAccessorCompType::RWGltf_GltfAccessorCompType_Int8)
        .value("RWGltf_GltfAccessorCompType_UInt8",RWGltf_GltfAccessorCompType::RWGltf_GltfAccessorCompType_UInt8)
        .value("RWGltf_GltfAccessorCompType_Int16",RWGltf_GltfAccessorCompType::RWGltf_GltfAccessorCompType_Int16)
        .value("RWGltf_GltfAccessorCompType_UInt16",RWGltf_GltfAccessorCompType::RWGltf_GltfAccessorCompType_UInt16)
        .value("RWGltf_GltfAccessorCompType_UInt32",RWGltf_GltfAccessorCompType::RWGltf_GltfAccessorCompType_UInt32)
        .value("RWGltf_GltfAccessorCompType_Float32",RWGltf_GltfAccessorCompType::RWGltf_GltfAccessorCompType_Float32).export_values();

//Python trampoline classes

// pre-register typdefs+classes (topologically sorted)
    py::class_<RWGltf_DracoParameters , shared_ptr<RWGltf_DracoParameters>  >(m,"RWGltf_DracoParameters",R"#(Draco compression parameters)#");
    py::class_<RWGltf_GltfAccessor , shared_ptr<RWGltf_GltfAccessor>  >(m,"RWGltf_GltfAccessor",R"#(Low-level glTF data structure defining Accessor.)#");
    py::class_<RWGltf_GltfBufferView , shared_ptr<RWGltf_GltfBufferView>  >(m,"RWGltf_GltfBufferView",R"#(Low-level glTF data structure defining BufferView.)#");
    py::class_<RWGltf_GltfJsonParser , shared_ptr<RWGltf_GltfJsonParser>  >(m,"RWGltf_GltfJsonParser",R"#(INTERNAL tool for parsing glTF document (JSON structure).)#");
    py::class_<RWGltf_GltfPrimArrayData , shared_ptr<RWGltf_GltfPrimArrayData>  >(m,"RWGltf_GltfPrimArrayData",R"#(An element within primitive array - vertex attribute or element indexes.)#");
    py::class_<RWGltf_CafReader ,opencascade::handle<RWGltf_CafReader>  >(m,"RWGltf_CafReader",R"#(The glTF (GL Transmission Format) mesh reader into XDE document.)#");
    py::class_<RWGltf_CafWriter ,opencascade::handle<RWGltf_CafWriter>  , Standard_Transient >(m,"RWGltf_CafWriter",R"#(glTF writer context from XCAF document.)#");
    py::class_<RWGltf_ConfigurationNode ,opencascade::handle<RWGltf_ConfigurationNode>  , DE_ConfigurationNode >(m,"RWGltf_ConfigurationNode",R"#(The purpose of this class is to configure the transfer process for glTF format Stores the necessary settings for RWGltf_Provider. Configures and creates special provider to transfer glTF files.)#");
    py::class_<RWGltf_GltfFace ,opencascade::handle<RWGltf_GltfFace>  , Standard_Transient >(m,"RWGltf_GltfFace",R"#(Low-level glTF data structure holding single Face (one primitive array) definition.)#");
    py::class_<RWGltf_GltfLatePrimitiveArray ,opencascade::handle<RWGltf_GltfLatePrimitiveArray>  >(m,"RWGltf_GltfLatePrimitiveArray",R"#(Mesh data wrapper for delayed primitive array loading from glTF file.)#");
    py::class_<RWGltf_GltfMaterialMap ,opencascade::handle<RWGltf_GltfMaterialMap>  >(m,"RWGltf_GltfMaterialMap",R"#(Material manager for exporting into glTF format.)#");
    py::class_<RWGltf_GltfOStreamWriter , shared_ptr<RWGltf_GltfOStreamWriter>  >(m,"RWGltf_GltfOStreamWriter",R"#(rapidjson::Writer wrapper for forward declaration.)#");
    py::class_<RWGltf_GltfSceneNodeMap , shared_ptr<RWGltf_GltfSceneNodeMap>  >(m,"RWGltf_GltfSceneNodeMap",R"#(Indexed map of scene nodes with custom search algorithm.)#");
    py::class_<RWGltf_MaterialCommon ,opencascade::handle<RWGltf_MaterialCommon>  , Standard_Transient >(m,"RWGltf_MaterialCommon",R"#(glTF 1.0 format common (obsolete) material definition.)#");
    py::class_<RWGltf_MaterialMetallicRoughness ,opencascade::handle<RWGltf_MaterialMetallicRoughness>  , Standard_Transient >(m,"RWGltf_MaterialMetallicRoughness",R"#(glTF 2.0 format PBR material definition.)#");
    py::class_<RWGltf_Provider ,opencascade::handle<RWGltf_Provider>  , DE_Provider >(m,"RWGltf_Provider",R"#(The class to transfer glTF files. Reads and Writes any glTF files into/from OCCT. Each operation needs configuration node.)#");
    py::class_<RWGltf_TriangulationReader ,opencascade::handle<RWGltf_TriangulationReader>  >(m,"RWGltf_TriangulationReader",R"#(RWMesh_TriangulationReader implementation creating Poly_Triangulation.)#");

};

// user-defined post-inclusion per module

// user-defined post
