# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import msrest.serialization


class CapabilityInformation(msrest.serialization.Model):
    """Subscription-level properties and limits for Data Lake Store.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar subscription_id: The subscription credentials that uniquely identifies the subscription.
    :vartype subscription_id: str
    :ivar state: The subscription state. Possible values include: "Registered", "Suspended",
     "Deleted", "Unregistered", "Warned".
    :vartype state: str or ~azure.mgmt.datalake.store.models.SubscriptionState
    :ivar max_account_count: The maximum supported number of accounts under this subscription.
    :vartype max_account_count: int
    :ivar account_count: The current number of accounts under this subscription.
    :vartype account_count: int
    :ivar migration_state: The Boolean value of true or false to indicate the maintenance state.
    :vartype migration_state: bool
    """

    _validation = {
        'subscription_id': {'readonly': True},
        'state': {'readonly': True},
        'max_account_count': {'readonly': True},
        'account_count': {'readonly': True},
        'migration_state': {'readonly': True},
    }

    _attribute_map = {
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'max_account_count': {'key': 'maxAccountCount', 'type': 'int'},
        'account_count': {'key': 'accountCount', 'type': 'int'},
        'migration_state': {'key': 'migrationState', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CapabilityInformation, self).__init__(**kwargs)
        self.subscription_id = None
        self.state = None
        self.max_account_count = None
        self.account_count = None
        self.migration_state = None


class CheckNameAvailabilityParameters(msrest.serialization.Model):
    """Data Lake Store account name availability check parameters.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The Data Lake Store name to check availability for.
    :type name: str
    :ivar type: Required. The resource type. Note: This should not be set by the user, as the
     constant value is Microsoft.DataLakeStore/accounts. Default value:
     "Microsoft.DataLakeStore/accounts".
    :vartype type: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "Microsoft.DataLakeStore/accounts"

    def __init__(
        self,
        **kwargs
    ):
        super(CheckNameAvailabilityParameters, self).__init__(**kwargs)
        self.name = kwargs['name']


class CreateDataLakeStoreAccountParameters(msrest.serialization.Model):
    """CreateDataLakeStoreAccountParameters.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. The resource location.
    :type location: str
    :param tags: A set of tags. The resource tags.
    :type tags: dict[str, str]
    :param identity: The Key Vault encryption identity, if any.
    :type identity: ~azure.mgmt.datalake.store.models.EncryptionIdentity
    :param default_group: The default owner group for all new folders and files created in the Data
     Lake Store account.
    :type default_group: str
    :param encryption_config: The Key Vault encryption configuration.
    :type encryption_config: ~azure.mgmt.datalake.store.models.EncryptionConfig
    :param encryption_state: The current state of encryption for this Data Lake Store account.
     Possible values include: "Enabled", "Disabled".
    :type encryption_state: str or ~azure.mgmt.datalake.store.models.EncryptionState
    :param firewall_rules: The list of firewall rules associated with this Data Lake Store account.
    :type firewall_rules:
     list[~azure.mgmt.datalake.store.models.CreateFirewallRuleWithAccountParameters]
    :param virtual_network_rules: The list of virtual network rules associated with this Data Lake
     Store account.
    :type virtual_network_rules:
     list[~azure.mgmt.datalake.store.models.CreateVirtualNetworkRuleWithAccountParameters]
    :param firewall_state: The current state of the IP address firewall for this Data Lake Store
     account. Possible values include: "Enabled", "Disabled".
    :type firewall_state: str or ~azure.mgmt.datalake.store.models.FirewallState
    :param firewall_allow_azure_ips: The current state of allowing or disallowing IPs originating
     within Azure through the firewall. If the firewall is disabled, this is not enforced. Possible
     values include: "Enabled", "Disabled".
    :type firewall_allow_azure_ips: str or
     ~azure.mgmt.datalake.store.models.FirewallAllowAzureIpsState
    :param trusted_id_providers: The list of trusted identity providers associated with this Data
     Lake Store account.
    :type trusted_id_providers:
     list[~azure.mgmt.datalake.store.models.CreateTrustedIdProviderWithAccountParameters]
    :param trusted_id_provider_state: The current state of the trusted identity provider feature
     for this Data Lake Store account. Possible values include: "Enabled", "Disabled".
    :type trusted_id_provider_state: str or
     ~azure.mgmt.datalake.store.models.TrustedIdProviderState
    :param new_tier: The commitment tier to use for next month. Possible values include:
     "Consumption", "Commitment_1TB", "Commitment_10TB", "Commitment_100TB", "Commitment_500TB",
     "Commitment_1PB", "Commitment_5PB".
    :type new_tier: str or ~azure.mgmt.datalake.store.models.TierType
    """

    _validation = {
        'location': {'required': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'EncryptionIdentity'},
        'default_group': {'key': 'properties.defaultGroup', 'type': 'str'},
        'encryption_config': {'key': 'properties.encryptionConfig', 'type': 'EncryptionConfig'},
        'encryption_state': {'key': 'properties.encryptionState', 'type': 'str'},
        'firewall_rules': {'key': 'properties.firewallRules', 'type': '[CreateFirewallRuleWithAccountParameters]'},
        'virtual_network_rules': {'key': 'properties.virtualNetworkRules', 'type': '[CreateVirtualNetworkRuleWithAccountParameters]'},
        'firewall_state': {'key': 'properties.firewallState', 'type': 'str'},
        'firewall_allow_azure_ips': {'key': 'properties.firewallAllowAzureIps', 'type': 'str'},
        'trusted_id_providers': {'key': 'properties.trustedIdProviders', 'type': '[CreateTrustedIdProviderWithAccountParameters]'},
        'trusted_id_provider_state': {'key': 'properties.trustedIdProviderState', 'type': 'str'},
        'new_tier': {'key': 'properties.newTier', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CreateDataLakeStoreAccountParameters, self).__init__(**kwargs)
        self.location = kwargs['location']
        self.tags = kwargs.get('tags', None)
        self.identity = kwargs.get('identity', None)
        self.default_group = kwargs.get('default_group', None)
        self.encryption_config = kwargs.get('encryption_config', None)
        self.encryption_state = kwargs.get('encryption_state', None)
        self.firewall_rules = kwargs.get('firewall_rules', None)
        self.virtual_network_rules = kwargs.get('virtual_network_rules', None)
        self.firewall_state = kwargs.get('firewall_state', None)
        self.firewall_allow_azure_ips = kwargs.get('firewall_allow_azure_ips', None)
        self.trusted_id_providers = kwargs.get('trusted_id_providers', None)
        self.trusted_id_provider_state = kwargs.get('trusted_id_provider_state', None)
        self.new_tier = kwargs.get('new_tier', None)


class CreateFirewallRuleWithAccountParameters(msrest.serialization.Model):
    """The parameters used to create a new firewall rule while creating a new Data Lake Store account.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The unique name of the firewall rule to create.
    :type name: str
    :param start_ip_address: Required. The start IP address for the firewall rule. This can be
     either ipv4 or ipv6. Start and End should be in the same protocol.
    :type start_ip_address: str
    :param end_ip_address: Required. The end IP address for the firewall rule. This can be either
     ipv4 or ipv6. Start and End should be in the same protocol.
    :type end_ip_address: str
    """

    _validation = {
        'name': {'required': True},
        'start_ip_address': {'required': True},
        'end_ip_address': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'start_ip_address': {'key': 'properties.startIpAddress', 'type': 'str'},
        'end_ip_address': {'key': 'properties.endIpAddress', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CreateFirewallRuleWithAccountParameters, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.start_ip_address = kwargs['start_ip_address']
        self.end_ip_address = kwargs['end_ip_address']


class CreateOrUpdateFirewallRuleParameters(msrest.serialization.Model):
    """The parameters used to create a new firewall rule.

    All required parameters must be populated in order to send to Azure.

    :param start_ip_address: Required. The start IP address for the firewall rule. This can be
     either ipv4 or ipv6. Start and End should be in the same protocol.
    :type start_ip_address: str
    :param end_ip_address: Required. The end IP address for the firewall rule. This can be either
     ipv4 or ipv6. Start and End should be in the same protocol.
    :type end_ip_address: str
    """

    _validation = {
        'start_ip_address': {'required': True},
        'end_ip_address': {'required': True},
    }

    _attribute_map = {
        'start_ip_address': {'key': 'properties.startIpAddress', 'type': 'str'},
        'end_ip_address': {'key': 'properties.endIpAddress', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CreateOrUpdateFirewallRuleParameters, self).__init__(**kwargs)
        self.start_ip_address = kwargs['start_ip_address']
        self.end_ip_address = kwargs['end_ip_address']


class CreateOrUpdateTrustedIdProviderParameters(msrest.serialization.Model):
    """The parameters used to create a new trusted identity provider.

    All required parameters must be populated in order to send to Azure.

    :param id_provider: Required. The URL of this trusted identity provider.
    :type id_provider: str
    """

    _validation = {
        'id_provider': {'required': True},
    }

    _attribute_map = {
        'id_provider': {'key': 'properties.idProvider', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CreateOrUpdateTrustedIdProviderParameters, self).__init__(**kwargs)
        self.id_provider = kwargs['id_provider']


class CreateOrUpdateVirtualNetworkRuleParameters(msrest.serialization.Model):
    """The parameters used to create a new virtual network rule.

    All required parameters must be populated in order to send to Azure.

    :param subnet_id: Required. The resource identifier for the subnet.
    :type subnet_id: str
    """

    _validation = {
        'subnet_id': {'required': True},
    }

    _attribute_map = {
        'subnet_id': {'key': 'properties.subnetId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CreateOrUpdateVirtualNetworkRuleParameters, self).__init__(**kwargs)
        self.subnet_id = kwargs['subnet_id']


class CreateTrustedIdProviderWithAccountParameters(msrest.serialization.Model):
    """The parameters used to create a new trusted identity provider while creating a new Data Lake Store account.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The unique name of the trusted identity provider to create.
    :type name: str
    :param id_provider: Required. The URL of this trusted identity provider.
    :type id_provider: str
    """

    _validation = {
        'name': {'required': True},
        'id_provider': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id_provider': {'key': 'properties.idProvider', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CreateTrustedIdProviderWithAccountParameters, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.id_provider = kwargs['id_provider']


class CreateVirtualNetworkRuleWithAccountParameters(msrest.serialization.Model):
    """The parameters used to create a new virtual network rule while creating a new Data Lake Store account.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The unique name of the virtual network rule to create.
    :type name: str
    :param subnet_id: Required. The resource identifier for the subnet.
    :type subnet_id: str
    """

    _validation = {
        'name': {'required': True},
        'subnet_id': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'subnet_id': {'key': 'properties.subnetId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CreateVirtualNetworkRuleWithAccountParameters, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.subnet_id = kwargs['subnet_id']


class Resource(msrest.serialization.Model):
    """The resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar location: The resource location.
    :vartype location: str
    :ivar tags: A set of tags. The resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'tags': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = None
        self.tags = None


class DataLakeStoreAccount(Resource):
    """Data Lake Store account information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar location: The resource location.
    :vartype location: str
    :ivar tags: A set of tags. The resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: The Key Vault encryption identity, if any.
    :vartype identity: ~azure.mgmt.datalake.store.models.EncryptionIdentity
    :ivar account_id: The unique identifier associated with this Data Lake Store account.
    :vartype account_id: str
    :ivar provisioning_state: The provisioning status of the Data Lake Store account. Possible
     values include: "Failed", "Creating", "Running", "Succeeded", "Patching", "Suspending",
     "Resuming", "Deleting", "Deleted", "Undeleting", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.datalake.store.models.DataLakeStoreAccountStatus
    :ivar state: The state of the Data Lake Store account. Possible values include: "Active",
     "Suspended".
    :vartype state: str or ~azure.mgmt.datalake.store.models.DataLakeStoreAccountState
    :ivar creation_time: The account creation time.
    :vartype creation_time: ~datetime.datetime
    :ivar last_modified_time: The account last modified time.
    :vartype last_modified_time: ~datetime.datetime
    :ivar endpoint: The full CName endpoint for this account.
    :vartype endpoint: str
    :ivar default_group: The default owner group for all new folders and files created in the Data
     Lake Store account.
    :vartype default_group: str
    :ivar encryption_config: The Key Vault encryption configuration.
    :vartype encryption_config: ~azure.mgmt.datalake.store.models.EncryptionConfig
    :ivar encryption_state: The current state of encryption for this Data Lake Store account.
     Possible values include: "Enabled", "Disabled".
    :vartype encryption_state: str or ~azure.mgmt.datalake.store.models.EncryptionState
    :ivar encryption_provisioning_state: The current state of encryption provisioning for this Data
     Lake Store account. Possible values include: "Creating", "Succeeded".
    :vartype encryption_provisioning_state: str or
     ~azure.mgmt.datalake.store.models.EncryptionProvisioningState
    :ivar firewall_rules: The list of firewall rules associated with this Data Lake Store account.
    :vartype firewall_rules: list[~azure.mgmt.datalake.store.models.FirewallRule]
    :ivar virtual_network_rules: The list of virtual network rules associated with this Data Lake
     Store account.
    :vartype virtual_network_rules: list[~azure.mgmt.datalake.store.models.VirtualNetworkRule]
    :ivar firewall_state: The current state of the IP address firewall for this Data Lake Store
     account. Possible values include: "Enabled", "Disabled".
    :vartype firewall_state: str or ~azure.mgmt.datalake.store.models.FirewallState
    :ivar firewall_allow_azure_ips: The current state of allowing or disallowing IPs originating
     within Azure through the firewall. If the firewall is disabled, this is not enforced. Possible
     values include: "Enabled", "Disabled".
    :vartype firewall_allow_azure_ips: str or
     ~azure.mgmt.datalake.store.models.FirewallAllowAzureIpsState
    :ivar trusted_id_providers: The list of trusted identity providers associated with this Data
     Lake Store account.
    :vartype trusted_id_providers: list[~azure.mgmt.datalake.store.models.TrustedIdProvider]
    :ivar trusted_id_provider_state: The current state of the trusted identity provider feature for
     this Data Lake Store account. Possible values include: "Enabled", "Disabled".
    :vartype trusted_id_provider_state: str or
     ~azure.mgmt.datalake.store.models.TrustedIdProviderState
    :ivar new_tier: The commitment tier to use for next month. Possible values include:
     "Consumption", "Commitment_1TB", "Commitment_10TB", "Commitment_100TB", "Commitment_500TB",
     "Commitment_1PB", "Commitment_5PB".
    :vartype new_tier: str or ~azure.mgmt.datalake.store.models.TierType
    :ivar current_tier: The commitment tier in use for the current month. Possible values include:
     "Consumption", "Commitment_1TB", "Commitment_10TB", "Commitment_100TB", "Commitment_500TB",
     "Commitment_1PB", "Commitment_5PB".
    :vartype current_tier: str or ~azure.mgmt.datalake.store.models.TierType
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'tags': {'readonly': True},
        'identity': {'readonly': True},
        'account_id': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'state': {'readonly': True},
        'creation_time': {'readonly': True},
        'last_modified_time': {'readonly': True},
        'endpoint': {'readonly': True},
        'default_group': {'readonly': True},
        'encryption_config': {'readonly': True},
        'encryption_state': {'readonly': True},
        'encryption_provisioning_state': {'readonly': True},
        'firewall_rules': {'readonly': True},
        'virtual_network_rules': {'readonly': True},
        'firewall_state': {'readonly': True},
        'firewall_allow_azure_ips': {'readonly': True},
        'trusted_id_providers': {'readonly': True},
        'trusted_id_provider_state': {'readonly': True},
        'new_tier': {'readonly': True},
        'current_tier': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'EncryptionIdentity'},
        'account_id': {'key': 'properties.accountId', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'endpoint': {'key': 'properties.endpoint', 'type': 'str'},
        'default_group': {'key': 'properties.defaultGroup', 'type': 'str'},
        'encryption_config': {'key': 'properties.encryptionConfig', 'type': 'EncryptionConfig'},
        'encryption_state': {'key': 'properties.encryptionState', 'type': 'str'},
        'encryption_provisioning_state': {'key': 'properties.encryptionProvisioningState', 'type': 'str'},
        'firewall_rules': {'key': 'properties.firewallRules', 'type': '[FirewallRule]'},
        'virtual_network_rules': {'key': 'properties.virtualNetworkRules', 'type': '[VirtualNetworkRule]'},
        'firewall_state': {'key': 'properties.firewallState', 'type': 'str'},
        'firewall_allow_azure_ips': {'key': 'properties.firewallAllowAzureIps', 'type': 'str'},
        'trusted_id_providers': {'key': 'properties.trustedIdProviders', 'type': '[TrustedIdProvider]'},
        'trusted_id_provider_state': {'key': 'properties.trustedIdProviderState', 'type': 'str'},
        'new_tier': {'key': 'properties.newTier', 'type': 'str'},
        'current_tier': {'key': 'properties.currentTier', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataLakeStoreAccount, self).__init__(**kwargs)
        self.identity = None
        self.account_id = None
        self.provisioning_state = None
        self.state = None
        self.creation_time = None
        self.last_modified_time = None
        self.endpoint = None
        self.default_group = None
        self.encryption_config = None
        self.encryption_state = None
        self.encryption_provisioning_state = None
        self.firewall_rules = None
        self.virtual_network_rules = None
        self.firewall_state = None
        self.firewall_allow_azure_ips = None
        self.trusted_id_providers = None
        self.trusted_id_provider_state = None
        self.new_tier = None
        self.current_tier = None


class DataLakeStoreAccountBasic(Resource):
    """Basic Data Lake Store account information, returned on list calls.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar location: The resource location.
    :vartype location: str
    :ivar tags: A set of tags. The resource tags.
    :vartype tags: dict[str, str]
    :ivar account_id: The unique identifier associated with this Data Lake Store account.
    :vartype account_id: str
    :ivar provisioning_state: The provisioning status of the Data Lake Store account. Possible
     values include: "Failed", "Creating", "Running", "Succeeded", "Patching", "Suspending",
     "Resuming", "Deleting", "Deleted", "Undeleting", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.datalake.store.models.DataLakeStoreAccountStatus
    :ivar state: The state of the Data Lake Store account. Possible values include: "Active",
     "Suspended".
    :vartype state: str or ~azure.mgmt.datalake.store.models.DataLakeStoreAccountState
    :ivar creation_time: The account creation time.
    :vartype creation_time: ~datetime.datetime
    :ivar last_modified_time: The account last modified time.
    :vartype last_modified_time: ~datetime.datetime
    :ivar endpoint: The full CName endpoint for this account.
    :vartype endpoint: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'tags': {'readonly': True},
        'account_id': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'state': {'readonly': True},
        'creation_time': {'readonly': True},
        'last_modified_time': {'readonly': True},
        'endpoint': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'account_id': {'key': 'properties.accountId', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'endpoint': {'key': 'properties.endpoint', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataLakeStoreAccountBasic, self).__init__(**kwargs)
        self.account_id = None
        self.provisioning_state = None
        self.state = None
        self.creation_time = None
        self.last_modified_time = None
        self.endpoint = None


class DataLakeStoreAccountListResult(msrest.serialization.Model):
    """Data Lake Store account list information response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The results of the list operation.
    :vartype value: list[~azure.mgmt.datalake.store.models.DataLakeStoreAccountBasic]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DataLakeStoreAccountBasic]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataLakeStoreAccountListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class DataLakeStoreAccountPropertiesBasic(msrest.serialization.Model):
    """The basic account specific properties that are associated with an underlying Data Lake Store account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar account_id: The unique identifier associated with this Data Lake Store account.
    :vartype account_id: str
    :ivar provisioning_state: The provisioning status of the Data Lake Store account. Possible
     values include: "Failed", "Creating", "Running", "Succeeded", "Patching", "Suspending",
     "Resuming", "Deleting", "Deleted", "Undeleting", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.datalake.store.models.DataLakeStoreAccountStatus
    :ivar state: The state of the Data Lake Store account. Possible values include: "Active",
     "Suspended".
    :vartype state: str or ~azure.mgmt.datalake.store.models.DataLakeStoreAccountState
    :ivar creation_time: The account creation time.
    :vartype creation_time: ~datetime.datetime
    :ivar last_modified_time: The account last modified time.
    :vartype last_modified_time: ~datetime.datetime
    :ivar endpoint: The full CName endpoint for this account.
    :vartype endpoint: str
    """

    _validation = {
        'account_id': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'state': {'readonly': True},
        'creation_time': {'readonly': True},
        'last_modified_time': {'readonly': True},
        'endpoint': {'readonly': True},
    }

    _attribute_map = {
        'account_id': {'key': 'accountId', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'creation_time': {'key': 'creationTime', 'type': 'iso-8601'},
        'last_modified_time': {'key': 'lastModifiedTime', 'type': 'iso-8601'},
        'endpoint': {'key': 'endpoint', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataLakeStoreAccountPropertiesBasic, self).__init__(**kwargs)
        self.account_id = None
        self.provisioning_state = None
        self.state = None
        self.creation_time = None
        self.last_modified_time = None
        self.endpoint = None


class DataLakeStoreAccountProperties(DataLakeStoreAccountPropertiesBasic):
    """Data Lake Store account properties information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar account_id: The unique identifier associated with this Data Lake Store account.
    :vartype account_id: str
    :ivar provisioning_state: The provisioning status of the Data Lake Store account. Possible
     values include: "Failed", "Creating", "Running", "Succeeded", "Patching", "Suspending",
     "Resuming", "Deleting", "Deleted", "Undeleting", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.datalake.store.models.DataLakeStoreAccountStatus
    :ivar state: The state of the Data Lake Store account. Possible values include: "Active",
     "Suspended".
    :vartype state: str or ~azure.mgmt.datalake.store.models.DataLakeStoreAccountState
    :ivar creation_time: The account creation time.
    :vartype creation_time: ~datetime.datetime
    :ivar last_modified_time: The account last modified time.
    :vartype last_modified_time: ~datetime.datetime
    :ivar endpoint: The full CName endpoint for this account.
    :vartype endpoint: str
    :ivar default_group: The default owner group for all new folders and files created in the Data
     Lake Store account.
    :vartype default_group: str
    :ivar encryption_config: The Key Vault encryption configuration.
    :vartype encryption_config: ~azure.mgmt.datalake.store.models.EncryptionConfig
    :ivar encryption_state: The current state of encryption for this Data Lake Store account.
     Possible values include: "Enabled", "Disabled".
    :vartype encryption_state: str or ~azure.mgmt.datalake.store.models.EncryptionState
    :ivar encryption_provisioning_state: The current state of encryption provisioning for this Data
     Lake Store account. Possible values include: "Creating", "Succeeded".
    :vartype encryption_provisioning_state: str or
     ~azure.mgmt.datalake.store.models.EncryptionProvisioningState
    :ivar firewall_rules: The list of firewall rules associated with this Data Lake Store account.
    :vartype firewall_rules: list[~azure.mgmt.datalake.store.models.FirewallRule]
    :ivar virtual_network_rules: The list of virtual network rules associated with this Data Lake
     Store account.
    :vartype virtual_network_rules: list[~azure.mgmt.datalake.store.models.VirtualNetworkRule]
    :ivar firewall_state: The current state of the IP address firewall for this Data Lake Store
     account. Possible values include: "Enabled", "Disabled".
    :vartype firewall_state: str or ~azure.mgmt.datalake.store.models.FirewallState
    :ivar firewall_allow_azure_ips: The current state of allowing or disallowing IPs originating
     within Azure through the firewall. If the firewall is disabled, this is not enforced. Possible
     values include: "Enabled", "Disabled".
    :vartype firewall_allow_azure_ips: str or
     ~azure.mgmt.datalake.store.models.FirewallAllowAzureIpsState
    :ivar trusted_id_providers: The list of trusted identity providers associated with this Data
     Lake Store account.
    :vartype trusted_id_providers: list[~azure.mgmt.datalake.store.models.TrustedIdProvider]
    :ivar trusted_id_provider_state: The current state of the trusted identity provider feature for
     this Data Lake Store account. Possible values include: "Enabled", "Disabled".
    :vartype trusted_id_provider_state: str or
     ~azure.mgmt.datalake.store.models.TrustedIdProviderState
    :ivar new_tier: The commitment tier to use for next month. Possible values include:
     "Consumption", "Commitment_1TB", "Commitment_10TB", "Commitment_100TB", "Commitment_500TB",
     "Commitment_1PB", "Commitment_5PB".
    :vartype new_tier: str or ~azure.mgmt.datalake.store.models.TierType
    :ivar current_tier: The commitment tier in use for the current month. Possible values include:
     "Consumption", "Commitment_1TB", "Commitment_10TB", "Commitment_100TB", "Commitment_500TB",
     "Commitment_1PB", "Commitment_5PB".
    :vartype current_tier: str or ~azure.mgmt.datalake.store.models.TierType
    """

    _validation = {
        'account_id': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'state': {'readonly': True},
        'creation_time': {'readonly': True},
        'last_modified_time': {'readonly': True},
        'endpoint': {'readonly': True},
        'default_group': {'readonly': True},
        'encryption_config': {'readonly': True},
        'encryption_state': {'readonly': True},
        'encryption_provisioning_state': {'readonly': True},
        'firewall_rules': {'readonly': True},
        'virtual_network_rules': {'readonly': True},
        'firewall_state': {'readonly': True},
        'firewall_allow_azure_ips': {'readonly': True},
        'trusted_id_providers': {'readonly': True},
        'trusted_id_provider_state': {'readonly': True},
        'new_tier': {'readonly': True},
        'current_tier': {'readonly': True},
    }

    _attribute_map = {
        'account_id': {'key': 'accountId', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'creation_time': {'key': 'creationTime', 'type': 'iso-8601'},
        'last_modified_time': {'key': 'lastModifiedTime', 'type': 'iso-8601'},
        'endpoint': {'key': 'endpoint', 'type': 'str'},
        'default_group': {'key': 'defaultGroup', 'type': 'str'},
        'encryption_config': {'key': 'encryptionConfig', 'type': 'EncryptionConfig'},
        'encryption_state': {'key': 'encryptionState', 'type': 'str'},
        'encryption_provisioning_state': {'key': 'encryptionProvisioningState', 'type': 'str'},
        'firewall_rules': {'key': 'firewallRules', 'type': '[FirewallRule]'},
        'virtual_network_rules': {'key': 'virtualNetworkRules', 'type': '[VirtualNetworkRule]'},
        'firewall_state': {'key': 'firewallState', 'type': 'str'},
        'firewall_allow_azure_ips': {'key': 'firewallAllowAzureIps', 'type': 'str'},
        'trusted_id_providers': {'key': 'trustedIdProviders', 'type': '[TrustedIdProvider]'},
        'trusted_id_provider_state': {'key': 'trustedIdProviderState', 'type': 'str'},
        'new_tier': {'key': 'newTier', 'type': 'str'},
        'current_tier': {'key': 'currentTier', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataLakeStoreAccountProperties, self).__init__(**kwargs)
        self.default_group = None
        self.encryption_config = None
        self.encryption_state = None
        self.encryption_provisioning_state = None
        self.firewall_rules = None
        self.virtual_network_rules = None
        self.firewall_state = None
        self.firewall_allow_azure_ips = None
        self.trusted_id_providers = None
        self.trusted_id_provider_state = None
        self.new_tier = None
        self.current_tier = None


class EncryptionConfig(msrest.serialization.Model):
    """The encryption configuration for the account.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of encryption configuration being used. Currently the only
     supported types are 'UserManaged' and 'ServiceManaged'. Possible values include: "UserManaged",
     "ServiceManaged".
    :type type: str or ~azure.mgmt.datalake.store.models.EncryptionConfigType
    :param key_vault_meta_info: The Key Vault information for connecting to user managed encryption
     keys.
    :type key_vault_meta_info: ~azure.mgmt.datalake.store.models.KeyVaultMetaInfo
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'key_vault_meta_info': {'key': 'keyVaultMetaInfo', 'type': 'KeyVaultMetaInfo'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EncryptionConfig, self).__init__(**kwargs)
        self.type = kwargs['type']
        self.key_vault_meta_info = kwargs.get('key_vault_meta_info', None)


class EncryptionIdentity(msrest.serialization.Model):
    """The encryption identity properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of encryption being used. Currently the only supported type is
     'SystemAssigned'. Default value: "SystemAssigned".
    :vartype type: str
    :ivar principal_id: The principal identifier associated with the encryption.
    :vartype principal_id: str
    :ivar tenant_id: The tenant identifier associated with the encryption.
    :vartype tenant_id: str
    """

    _validation = {
        'type': {'required': True, 'constant': True},
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    type = "SystemAssigned"

    def __init__(
        self,
        **kwargs
    ):
        super(EncryptionIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None


class SubResource(msrest.serialization.Model):
    """The resource model definition for a nested resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class FirewallRule(SubResource):
    """Data Lake Store firewall rule information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar start_ip_address: The start IP address for the firewall rule. This can be either ipv4 or
     ipv6. Start and End should be in the same protocol.
    :vartype start_ip_address: str
    :ivar end_ip_address: The end IP address for the firewall rule. This can be either ipv4 or
     ipv6. Start and End should be in the same protocol.
    :vartype end_ip_address: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'start_ip_address': {'readonly': True},
        'end_ip_address': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'start_ip_address': {'key': 'properties.startIpAddress', 'type': 'str'},
        'end_ip_address': {'key': 'properties.endIpAddress', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FirewallRule, self).__init__(**kwargs)
        self.start_ip_address = None
        self.end_ip_address = None


class FirewallRuleListResult(msrest.serialization.Model):
    """Data Lake Store firewall rule list information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The results of the list operation.
    :vartype value: list[~azure.mgmt.datalake.store.models.FirewallRule]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[FirewallRule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FirewallRuleListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class KeyVaultMetaInfo(msrest.serialization.Model):
    """Metadata information used by account encryption.

    All required parameters must be populated in order to send to Azure.

    :param key_vault_resource_id: Required. The resource identifier for the user managed Key Vault
     being used to encrypt.
    :type key_vault_resource_id: str
    :param encryption_key_name: Required. The name of the user managed encryption key.
    :type encryption_key_name: str
    :param encryption_key_version: Required. The version of the user managed encryption key.
    :type encryption_key_version: str
    """

    _validation = {
        'key_vault_resource_id': {'required': True},
        'encryption_key_name': {'required': True},
        'encryption_key_version': {'required': True},
    }

    _attribute_map = {
        'key_vault_resource_id': {'key': 'keyVaultResourceId', 'type': 'str'},
        'encryption_key_name': {'key': 'encryptionKeyName', 'type': 'str'},
        'encryption_key_version': {'key': 'encryptionKeyVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(KeyVaultMetaInfo, self).__init__(**kwargs)
        self.key_vault_resource_id = kwargs['key_vault_resource_id']
        self.encryption_key_name = kwargs['encryption_key_name']
        self.encryption_key_version = kwargs['encryption_key_version']


class NameAvailabilityInformation(msrest.serialization.Model):
    """Data Lake Store account name availability result information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name_available: The Boolean value of true or false to indicate whether the Data Lake
     Store account name is available or not.
    :vartype name_available: bool
    :ivar reason: The reason why the Data Lake Store account name is not available, if
     nameAvailable is false.
    :vartype reason: str
    :ivar message: The message describing why the Data Lake Store account name is not available, if
     nameAvailable is false.
    :vartype message: str
    """

    _validation = {
        'name_available': {'readonly': True},
        'reason': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NameAvailabilityInformation, self).__init__(**kwargs)
        self.name_available = None
        self.reason = None
        self.message = None


class Operation(msrest.serialization.Model):
    """An available operation for Data Lake Store.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation.
    :vartype name: str
    :param display: The display information for the operation.
    :type display: ~azure.mgmt.datalake.store.models.OperationDisplay
    :ivar origin: The intended executor of the operation. Possible values include: "user",
     "system", "user,system".
    :vartype origin: str or ~azure.mgmt.datalake.store.models.OperationOrigin
    """

    _validation = {
        'name': {'readonly': True},
        'origin': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.display = kwargs.get('display', None)
        self.origin = None


class OperationDisplay(msrest.serialization.Model):
    """The display information for a particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The resource provider of the operation.
    :vartype provider: str
    :ivar resource: The resource type of the operation.
    :vartype resource: str
    :ivar operation: A friendly name of the operation.
    :vartype operation: str
    :ivar description: A friendly description of the operation.
    :vartype description: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(msrest.serialization.Model):
    """The list of available operations for Data Lake Store.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The results of the list operation.
    :vartype value: list[~azure.mgmt.datalake.store.models.Operation]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class TrustedIdProvider(SubResource):
    """Data Lake Store trusted identity provider information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar id_provider: The URL of this trusted identity provider.
    :vartype id_provider: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'id_provider': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'id_provider': {'key': 'properties.idProvider', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TrustedIdProvider, self).__init__(**kwargs)
        self.id_provider = None


class TrustedIdProviderListResult(msrest.serialization.Model):
    """Data Lake Store trusted identity provider list information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The results of the list operation.
    :vartype value: list[~azure.mgmt.datalake.store.models.TrustedIdProvider]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TrustedIdProvider]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TrustedIdProviderListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class UpdateDataLakeStoreAccountParameters(msrest.serialization.Model):
    """Data Lake Store account information to update.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param default_group: The default owner group for all new folders and files created in the Data
     Lake Store account.
    :type default_group: str
    :param encryption_config: Used for rotation of user managed Key Vault keys. Can only be used to
     rotate a user managed encryption Key Vault key.
    :type encryption_config: ~azure.mgmt.datalake.store.models.UpdateEncryptionConfig
    :param firewall_rules: The list of firewall rules associated with this Data Lake Store account.
    :type firewall_rules:
     list[~azure.mgmt.datalake.store.models.UpdateFirewallRuleWithAccountParameters]
    :param virtual_network_rules: The list of virtual network rules associated with this Data Lake
     Store account.
    :type virtual_network_rules:
     list[~azure.mgmt.datalake.store.models.UpdateVirtualNetworkRuleWithAccountParameters]
    :param firewall_state: The current state of the IP address firewall for this Data Lake Store
     account. Disabling the firewall does not remove existing rules, they will just be ignored until
     the firewall is re-enabled. Possible values include: "Enabled", "Disabled".
    :type firewall_state: str or ~azure.mgmt.datalake.store.models.FirewallState
    :param firewall_allow_azure_ips: The current state of allowing or disallowing IPs originating
     within Azure through the firewall. If the firewall is disabled, this is not enforced. Possible
     values include: "Enabled", "Disabled".
    :type firewall_allow_azure_ips: str or
     ~azure.mgmt.datalake.store.models.FirewallAllowAzureIpsState
    :param trusted_id_providers: The list of trusted identity providers associated with this Data
     Lake Store account.
    :type trusted_id_providers:
     list[~azure.mgmt.datalake.store.models.UpdateTrustedIdProviderWithAccountParameters]
    :param trusted_id_provider_state: The current state of the trusted identity provider feature
     for this Data Lake Store account. Disabling trusted identity provider functionality does not
     remove the providers, they will just be ignored until this feature is re-enabled. Possible
     values include: "Enabled", "Disabled".
    :type trusted_id_provider_state: str or
     ~azure.mgmt.datalake.store.models.TrustedIdProviderState
    :param new_tier: The commitment tier to use for next month. Possible values include:
     "Consumption", "Commitment_1TB", "Commitment_10TB", "Commitment_100TB", "Commitment_500TB",
     "Commitment_1PB", "Commitment_5PB".
    :type new_tier: str or ~azure.mgmt.datalake.store.models.TierType
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'default_group': {'key': 'properties.defaultGroup', 'type': 'str'},
        'encryption_config': {'key': 'properties.encryptionConfig', 'type': 'UpdateEncryptionConfig'},
        'firewall_rules': {'key': 'properties.firewallRules', 'type': '[UpdateFirewallRuleWithAccountParameters]'},
        'virtual_network_rules': {'key': 'properties.virtualNetworkRules', 'type': '[UpdateVirtualNetworkRuleWithAccountParameters]'},
        'firewall_state': {'key': 'properties.firewallState', 'type': 'str'},
        'firewall_allow_azure_ips': {'key': 'properties.firewallAllowAzureIps', 'type': 'str'},
        'trusted_id_providers': {'key': 'properties.trustedIdProviders', 'type': '[UpdateTrustedIdProviderWithAccountParameters]'},
        'trusted_id_provider_state': {'key': 'properties.trustedIdProviderState', 'type': 'str'},
        'new_tier': {'key': 'properties.newTier', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UpdateDataLakeStoreAccountParameters, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.default_group = kwargs.get('default_group', None)
        self.encryption_config = kwargs.get('encryption_config', None)
        self.firewall_rules = kwargs.get('firewall_rules', None)
        self.virtual_network_rules = kwargs.get('virtual_network_rules', None)
        self.firewall_state = kwargs.get('firewall_state', None)
        self.firewall_allow_azure_ips = kwargs.get('firewall_allow_azure_ips', None)
        self.trusted_id_providers = kwargs.get('trusted_id_providers', None)
        self.trusted_id_provider_state = kwargs.get('trusted_id_provider_state', None)
        self.new_tier = kwargs.get('new_tier', None)


class UpdateEncryptionConfig(msrest.serialization.Model):
    """The encryption configuration used to update a user managed Key Vault key.

    :param key_vault_meta_info: The updated Key Vault key to use in user managed key rotation.
    :type key_vault_meta_info: ~azure.mgmt.datalake.store.models.UpdateKeyVaultMetaInfo
    """

    _attribute_map = {
        'key_vault_meta_info': {'key': 'keyVaultMetaInfo', 'type': 'UpdateKeyVaultMetaInfo'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UpdateEncryptionConfig, self).__init__(**kwargs)
        self.key_vault_meta_info = kwargs.get('key_vault_meta_info', None)


class UpdateFirewallRuleParameters(msrest.serialization.Model):
    """The parameters used to update a firewall rule.

    :param start_ip_address: The start IP address for the firewall rule. This can be either ipv4 or
     ipv6. Start and End should be in the same protocol.
    :type start_ip_address: str
    :param end_ip_address: The end IP address for the firewall rule. This can be either ipv4 or
     ipv6. Start and End should be in the same protocol.
    :type end_ip_address: str
    """

    _attribute_map = {
        'start_ip_address': {'key': 'properties.startIpAddress', 'type': 'str'},
        'end_ip_address': {'key': 'properties.endIpAddress', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UpdateFirewallRuleParameters, self).__init__(**kwargs)
        self.start_ip_address = kwargs.get('start_ip_address', None)
        self.end_ip_address = kwargs.get('end_ip_address', None)


class UpdateFirewallRuleWithAccountParameters(msrest.serialization.Model):
    """The parameters used to update a firewall rule while updating a Data Lake Store account.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The unique name of the firewall rule to update.
    :type name: str
    :param start_ip_address: The start IP address for the firewall rule. This can be either ipv4 or
     ipv6. Start and End should be in the same protocol.
    :type start_ip_address: str
    :param end_ip_address: The end IP address for the firewall rule. This can be either ipv4 or
     ipv6. Start and End should be in the same protocol.
    :type end_ip_address: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'start_ip_address': {'key': 'properties.startIpAddress', 'type': 'str'},
        'end_ip_address': {'key': 'properties.endIpAddress', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UpdateFirewallRuleWithAccountParameters, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.start_ip_address = kwargs.get('start_ip_address', None)
        self.end_ip_address = kwargs.get('end_ip_address', None)


class UpdateKeyVaultMetaInfo(msrest.serialization.Model):
    """The Key Vault update information used for user managed key rotation.

    :param encryption_key_version: The version of the user managed encryption key to update through
     a key rotation.
    :type encryption_key_version: str
    """

    _attribute_map = {
        'encryption_key_version': {'key': 'encryptionKeyVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UpdateKeyVaultMetaInfo, self).__init__(**kwargs)
        self.encryption_key_version = kwargs.get('encryption_key_version', None)


class UpdateTrustedIdProviderParameters(msrest.serialization.Model):
    """The parameters used to update a trusted identity provider.

    :param id_provider: The URL of this trusted identity provider.
    :type id_provider: str
    """

    _attribute_map = {
        'id_provider': {'key': 'properties.idProvider', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UpdateTrustedIdProviderParameters, self).__init__(**kwargs)
        self.id_provider = kwargs.get('id_provider', None)


class UpdateTrustedIdProviderWithAccountParameters(msrest.serialization.Model):
    """The parameters used to update a trusted identity provider while updating a Data Lake Store account.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The unique name of the trusted identity provider to update.
    :type name: str
    :param id_provider: The URL of this trusted identity provider.
    :type id_provider: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id_provider': {'key': 'properties.idProvider', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UpdateTrustedIdProviderWithAccountParameters, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.id_provider = kwargs.get('id_provider', None)


class UpdateVirtualNetworkRuleParameters(msrest.serialization.Model):
    """The parameters used to update a virtual network rule.

    :param subnet_id: The resource identifier for the subnet.
    :type subnet_id: str
    """

    _attribute_map = {
        'subnet_id': {'key': 'properties.subnetId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UpdateVirtualNetworkRuleParameters, self).__init__(**kwargs)
        self.subnet_id = kwargs.get('subnet_id', None)


class UpdateVirtualNetworkRuleWithAccountParameters(msrest.serialization.Model):
    """The parameters used to update a virtual network rule while updating a Data Lake Store account.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The unique name of the virtual network rule to update.
    :type name: str
    :param subnet_id: The resource identifier for the subnet.
    :type subnet_id: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'subnet_id': {'key': 'properties.subnetId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UpdateVirtualNetworkRuleWithAccountParameters, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.subnet_id = kwargs.get('subnet_id', None)


class Usage(msrest.serialization.Model):
    """Describes the Resource Usage.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar unit: Gets the unit of measurement. Possible values include: "Count", "Bytes", "Seconds",
     "Percent", "CountsPerSecond", "BytesPerSecond".
    :vartype unit: str or ~azure.mgmt.datalake.store.models.UsageUnit
    :ivar id: Resource identifier.
    :vartype id: str
    :ivar current_value: Gets the current count of the allocated resources in the subscription.
    :vartype current_value: int
    :ivar limit: Gets the maximum count of the resources that can be allocated in the subscription.
    :vartype limit: int
    :ivar name: Gets the name of the type of usage.
    :vartype name: ~azure.mgmt.datalake.store.models.UsageName
    """

    _validation = {
        'unit': {'readonly': True},
        'id': {'readonly': True},
        'current_value': {'readonly': True},
        'limit': {'readonly': True},
        'name': {'readonly': True},
    }

    _attribute_map = {
        'unit': {'key': 'unit', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'int'},
        'limit': {'key': 'limit', 'type': 'int'},
        'name': {'key': 'name', 'type': 'UsageName'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Usage, self).__init__(**kwargs)
        self.unit = None
        self.id = None
        self.current_value = None
        self.limit = None
        self.name = None


class UsageListResult(msrest.serialization.Model):
    """The response from the List Usages operation.

    :param value: Gets or sets the list of Storage Resource Usages.
    :type value: list[~azure.mgmt.datalake.store.models.Usage]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Usage]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UsageListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class UsageName(msrest.serialization.Model):
    """The usage names that can be used.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Gets a string describing the resource name.
    :vartype value: str
    :ivar localized_value: Gets a localized string describing the resource name.
    :vartype localized_value: str
    """

    _validation = {
        'value': {'readonly': True},
        'localized_value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UsageName, self).__init__(**kwargs)
        self.value = None
        self.localized_value = None


class VirtualNetworkRule(SubResource):
    """Data Lake Store virtual network rule information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar subnet_id: The resource identifier for the subnet.
    :vartype subnet_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'subnet_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'subnet_id': {'key': 'properties.subnetId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkRule, self).__init__(**kwargs)
        self.subnet_id = None


class VirtualNetworkRuleListResult(msrest.serialization.Model):
    """Data Lake Store virtual network rule list information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The results of the list operation.
    :vartype value: list[~azure.mgmt.datalake.store.models.VirtualNetworkRule]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualNetworkRule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkRuleListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None
